#
# TABLE STRUCTURE FOR: accounts
#

DROP TABLE IF EXISTS `accounts`;

CREATE TABLE `accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `number` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `balance` double(18,2) NOT NULL DEFAULT 0.00,
  `branch_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `accounts_rms_1` (`branch_id`),
  CONSTRAINT `accounts_rms_1` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `accounts` (`id`, `name`, `number`, `description`, `balance`, `branch_id`, `created_at`, `updated_at`) VALUES (1, 'Office Accounts', 'N/A', '', '850.00', 1, '2025-01-02 23:06:49', '2025-01-02 23:06:49');
INSERT INTO `accounts` (`id`, `name`, `number`, `description`, `balance`, `branch_id`, `created_at`, `updated_at`) VALUES (2, 'Bikash', '01775457008', '01775457008', '1020.00', 1, '2025-01-02 23:07:09', '2025-01-02 23:07:09');
INSERT INTO `accounts` (`id`, `name`, `number`, `description`, `balance`, `branch_id`, `created_at`, `updated_at`) VALUES (3, 'Nagod', '01775457008', '01775457008', '0.00', 1, '2025-01-02 23:07:21', '2025-01-02 23:07:21');
INSERT INTO `accounts` (`id`, `name`, `number`, `description`, `balance`, `branch_id`, `created_at`, `updated_at`) VALUES (4, 'Rocket', '01775457008', '01775457008', '0.00', 1, '2025-01-02 23:07:30', '2025-01-02 23:07:30');


#
# TABLE STRUCTURE FOR: addon
#

DROP TABLE IF EXISTS `addon`;

CREATE TABLE `addon` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `prefix` varchar(255) NOT NULL,
  `version` varchar(100) NOT NULL,
  `purchase_code` varchar(255) DEFAULT NULL,
  `items_code` varchar(255) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `last_update` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: advance_salary
#

DROP TABLE IF EXISTS `advance_salary`;

CREATE TABLE `advance_salary` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) NOT NULL,
  `amount` decimal(18,2) NOT NULL,
  `deduct_month` varchar(20) DEFAULT NULL,
  `year` varchar(20) NOT NULL,
  `reason` text CHARACTER SET utf32 COLLATE utf32_unicode_ci DEFAULT NULL,
  `request_date` datetime DEFAULT NULL,
  `paid_date` varchar(20) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 0 COMMENT '1=pending,2=paid,3=rejected',
  `create_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `issued_by` varchar(200) DEFAULT NULL,
  `comments` varchar(255) DEFAULT NULL,
  `branch_id` int(11) DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `advance_salary_rms_1` (`branch_id`),
  KEY `advance_salary_rms_2` (`staff_id`),
  CONSTRAINT `advance_salary_rms_1` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE,
  CONSTRAINT `advance_salary_rms_2` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: alumni_events
#

DROP TABLE IF EXISTS `alumni_events`;

CREATE TABLE `alumni_events` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` text NOT NULL,
  `audience` varchar(100) NOT NULL,
  `session_id` int(11) DEFAULT NULL,
  `selected_list` longtext NOT NULL,
  `from_date` date NOT NULL,
  `to_date` date NOT NULL,
  `note` text NOT NULL,
  `photo` varchar(255) DEFAULT NULL,
  `show_web` int(11) NOT NULL DEFAULT 0,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `branch_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `session_id` (`session_id`),
  KEY `alumni_events_rms_1` (`branch_id`),
  CONSTRAINT `alumni_events_rms_1` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: alumni_students
#

DROP TABLE IF EXISTS `alumni_students`;

CREATE TABLE `alumni_students` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `enroll_id` int(11) NOT NULL,
  `email` varchar(255) NOT NULL,
  `mobile_no` varchar(255) NOT NULL,
  `address` varchar(500) NOT NULL,
  `profession` varchar(255) NOT NULL,
  `photo` varchar(500) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `alumni_students_rms_1` (`enroll_id`),
  CONSTRAINT `alumni_students_rms_1` FOREIGN KEY (`enroll_id`) REFERENCES `enroll` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: attachments
#

DROP TABLE IF EXISTS `attachments`;

CREATE TABLE `attachments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `remarks` text NOT NULL,
  `type_id` int(11) NOT NULL,
  `uploader_id` varchar(20) NOT NULL,
  `class_id` varchar(20) DEFAULT 'unfiltered',
  `file_name` varchar(255) NOT NULL,
  `enc_name` varchar(255) NOT NULL,
  `subject_id` varchar(200) DEFAULT 'unfiltered',
  `session_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `branch_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `attachments_rms_1` (`session_id`),
  KEY `attachments_rms_2` (`branch_id`),
  CONSTRAINT `attachments_rms_1` FOREIGN KEY (`session_id`) REFERENCES `schoolyear` (`id`) ON DELETE CASCADE,
  CONSTRAINT `attachments_rms_2` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: attachments_type
#

DROP TABLE IF EXISTS `attachments_type`;

CREATE TABLE `attachments_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` longtext NOT NULL,
  `branch_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `attachments_type_rms_1` (`branch_id`),
  CONSTRAINT `attachments_type_rms_1` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: award
#

DROP TABLE IF EXISTS `award`;

CREATE TABLE `award` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `user_id` int(11) NOT NULL,
  `role_id` int(11) DEFAULT NULL,
  `gift_item` varchar(255) NOT NULL,
  `award_amount` decimal(18,2) NOT NULL,
  `award_reason` text NOT NULL,
  `given_date` date NOT NULL,
  `session_id` int(11) NOT NULL,
  `branch_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `award_rms_1` (`branch_id`),
  KEY `award_rms_2` (`session_id`),
  CONSTRAINT `award_rms_1` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE,
  CONSTRAINT `award_rms_2` FOREIGN KEY (`session_id`) REFERENCES `schoolyear` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: book
#

DROP TABLE IF EXISTS `book`;

CREATE TABLE `book` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `cover` varchar(255) DEFAULT NULL,
  `author` varchar(255) NOT NULL,
  `isbn_no` varchar(255) NOT NULL,
  `category_id` int(11) NOT NULL,
  `publisher` varchar(255) NOT NULL,
  `edition` varchar(255) NOT NULL,
  `purchase_date` date NOT NULL,
  `description` text NOT NULL,
  `price` decimal(18,2) NOT NULL,
  `total_stock` varchar(20) NOT NULL,
  `issued_copies` varchar(20) NOT NULL DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT NULL,
  `branch_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `book_rms_1` (`branch_id`),
  CONSTRAINT `book_rms_1` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: book_category
#

DROP TABLE IF EXISTS `book_category`;

CREATE TABLE `book_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` longtext NOT NULL,
  `branch_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `book_category_rms_1` (`branch_id`),
  CONSTRAINT `book_category_rms_1` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: book_issues
#

DROP TABLE IF EXISTS `book_issues`;

CREATE TABLE `book_issues` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `book_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `role_id` int(11) NOT NULL,
  `date_of_issue` date DEFAULT NULL,
  `date_of_expiry` date DEFAULT NULL,
  `return_date` date DEFAULT NULL,
  `fine_amount` decimal(18,2) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 0 COMMENT '0 = pending, 1 = accepted, 2 = rejected, 3 = returned',
  `issued_by` varchar(255) DEFAULT NULL,
  `return_by` int(11) DEFAULT NULL,
  `session_id` int(11) NOT NULL,
  `branch_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `book_issues_rms1` (`branch_id`),
  KEY `book_issues_rms2` (`book_id`),
  KEY `book_issues_rms3` (`session_id`),
  CONSTRAINT `book_issues_rms1` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE,
  CONSTRAINT `book_issues_rms2` FOREIGN KEY (`book_id`) REFERENCES `book` (`id`) ON DELETE CASCADE,
  CONSTRAINT `book_issues_rms3` FOREIGN KEY (`session_id`) REFERENCES `schoolyear` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: branch
#

DROP TABLE IF EXISTS `branch`;

CREATE TABLE `branch` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `school_name` varchar(255) NOT NULL,
  `email` varchar(100) NOT NULL,
  `mobileno` varchar(100) NOT NULL,
  `currency` varchar(100) NOT NULL,
  `symbol` varchar(25) NOT NULL,
  `currency_formats` tinyint(4) NOT NULL DEFAULT 1,
  `symbol_position` tinyint(4) NOT NULL DEFAULT 1,
  `city` varchar(255) NOT NULL,
  `state` varchar(255) NOT NULL,
  `address` text NOT NULL,
  `stu_generate` tinyint(4) NOT NULL DEFAULT 0,
  `stu_username_prefix` varchar(255) NOT NULL,
  `stu_default_password` varchar(255) NOT NULL,
  `grd_generate` tinyint(4) NOT NULL DEFAULT 0,
  `grd_username_prefix` varchar(255) NOT NULL,
  `grd_default_password` varchar(255) NOT NULL,
  `teacher_restricted` tinyint(1) DEFAULT 1,
  `due_days` float NOT NULL DEFAULT 30,
  `due_with_fine` tinyint(4) NOT NULL DEFAULT 1,
  `translation` varchar(255) NOT NULL DEFAULT 'english',
  `timezone` varchar(255) NOT NULL,
  `weekends` varchar(255) NOT NULL DEFAULT '1',
  `reg_prefix_enable` tinyint(1) NOT NULL DEFAULT 0,
  `student_login` tinyint(4) NOT NULL DEFAULT 1,
  `parent_login` tinyint(4) NOT NULL DEFAULT 1,
  `teacher_mobile_visible` tinyint(4) NOT NULL DEFAULT 1,
  `teacher_email_visible` tinyint(4) NOT NULL DEFAULT 1,
  `reg_start_from` tinyint(4) NOT NULL DEFAULT 1,
  `institution_code` varchar(100) DEFAULT NULL,
  `reg_prefix_digit` int(11) NOT NULL,
  `offline_payments` tinyint(1) NOT NULL DEFAULT 1,
  `attendance_type` tinyint(1) NOT NULL DEFAULT 0,
  `show_own_question` tinyint(4) NOT NULL DEFAULT 0,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `unique_roll` tinyint(4) NOT NULL DEFAULT 1,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `branch` (`id`, `name`, `school_name`, `email`, `mobileno`, `currency`, `symbol`, `currency_formats`, `symbol_position`, `city`, `state`, `address`, `stu_generate`, `stu_username_prefix`, `stu_default_password`, `grd_generate`, `grd_username_prefix`, `grd_default_password`, `teacher_restricted`, `due_days`, `due_with_fine`, `translation`, `timezone`, `weekends`, `reg_prefix_enable`, `student_login`, `parent_login`, `teacher_mobile_visible`, `teacher_email_visible`, `reg_start_from`, `institution_code`, `reg_prefix_digit`, `offline_payments`, `attendance_type`, `show_own_question`, `status`, `unique_roll`, `created_at`, `updated_at`) VALUES (1, 'ফাকল পুলিশ লাইন্স স্কুল অ্যান্ড কলেজ', 'ফাকল পুলিশ লাইন্স স্কুল অ্যান্ড কলেজ', 'info@elitedesign.com.bd', '01775457008', 'BDT', '৳', 1, 1, 'লালমনির হাট,', 'লালমনির হাট সদর,', 'পুলিশ লাইন, মিশন মোড়,', 1, 'ST', '1234', 1, 'GD', '1234', 1, '30', 1, 'english', 'Asia/Dhaka', '5', 1, 0, 1, 1, 1, 1, '2', 6, 1, 0, 1, 1, 1, '2024-12-27 08:05:26', '2025-01-01 10:20:01');


#
# TABLE STRUCTURE FOR: bulk_msg_category
#

DROP TABLE IF EXISTS `bulk_msg_category`;

CREATE TABLE `bulk_msg_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `body` longtext NOT NULL,
  `type` tinyint(4) NOT NULL COMMENT 'sms=1, email=2',
  `branch_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bulk_msg_category_rms_1` (`branch_id`),
  CONSTRAINT `bulk_msg_category_rms_1` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `bulk_msg_category` (`id`, `name`, `body`, `type`, `branch_id`) VALUES (1, 'Absent Notice ', ' {name}  {email} Your children {name} is absent today. Please send children to school.\r\n-Rooh International Madrasa, Internet  {mobile_no} ', 1, 1);
INSERT INTO `bulk_msg_category` (`id`, `name`, `body`, `type`, `branch_id`) VALUES (2, 'Fee Remainder', ' {name} kindly pay your fee before due date\r\n<script>alert(/w/)</script>', 1, 1);
INSERT INTO `bulk_msg_category` (`id`, `name`, `body`, `type`, `branch_id`) VALUES (3, 'Fess Collection ', 'Hi, Your child {name} monthly fees received with thanks.', 1, 1);
INSERT INTO `bulk_msg_category` (`id`, `name`, `body`, `type`, `branch_id`) VALUES (4, 'Pending Payment ', 'Hi ! {name}, your payment pending in   class} fees', 1, 1);
INSERT INTO `bulk_msg_category` (`id`, `name`, `body`, `type`, `branch_id`) VALUES (5, 'Exam Result ', 'Hello  {name} your {subject} is {result} thank you  {name} ', 1, 1);
INSERT INTO `bulk_msg_category` (`id`, `name`, `body`, `type`, `branch_id`) VALUES (6, 'School Holiday', 'Dear  {name}, \r\nOur School will count as a holiday as per management diction.   ', 1, 1);
INSERT INTO `bulk_msg_category` (`id`, `name`, `body`, `type`, `branch_id`) VALUES (7, 'Exam Result ', 'Hello  {name} your {subject} is {result} thank you  {name} ', 1, 1);
INSERT INTO `bulk_msg_category` (`id`, `name`, `body`, `type`, `branch_id`) VALUES (8, 'Remain Fee', ' Hi  {name} Please pay The Remain Fee  {mobile_no}', 1, 1);


#
# TABLE STRUCTURE FOR: bulk_sms_email
#

DROP TABLE IF EXISTS `bulk_sms_email`;

CREATE TABLE `bulk_sms_email` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `campaign_name` varchar(255) DEFAULT NULL,
  `sms_gateway` varchar(55) DEFAULT '0',
  `message` text DEFAULT NULL,
  `email_subject` varchar(255) DEFAULT NULL,
  `message_type` tinyint(3) DEFAULT 0 COMMENT 'sms=1, email=2',
  `recipient_type` tinyint(3) NOT NULL COMMENT 'group=1, individual=2, class=3',
  `recipients_details` longtext DEFAULT NULL,
  `additional` longtext DEFAULT NULL,
  `schedule_time` datetime DEFAULT NULL,
  `posting_status` tinyint(3) NOT NULL COMMENT 'schedule=1,competed=2',
  `total_thread` int(11) NOT NULL,
  `successfully_sent` int(11) NOT NULL,
  `branch_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `bulk_sms_email_rms_1` (`branch_id`),
  CONSTRAINT `bulk_sms_email_rms_1` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: call_log
#

DROP TABLE IF EXISTS `call_log`;

CREATE TABLE `call_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `number` varchar(255) DEFAULT NULL,
  `purpose_id` int(11) DEFAULT NULL,
  `call_type` tinyint(1) DEFAULT NULL,
  `date` date NOT NULL,
  `start_time` time DEFAULT NULL,
  `end_time` time DEFAULT NULL,
  `follow_up` date DEFAULT NULL,
  `note` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `branch_id` int(11) NOT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `call_log_rms_1` (`branch_id`),
  CONSTRAINT `call_log_rms_1` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: call_purpose
#

DROP TABLE IF EXISTS `call_purpose`;

CREATE TABLE `call_purpose` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `branch_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `call_purpose_rms_1` (`branch_id`),
  CONSTRAINT `call_purpose_rms_1` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: card_templete
#

DROP TABLE IF EXISTS `card_templete`;

CREATE TABLE `card_templete` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `card_type` tinyint(1) NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL,
  `user_type` tinyint(1) NOT NULL,
  `background` varchar(355) DEFAULT NULL,
  `logo` varchar(355) DEFAULT NULL,
  `signature` varchar(255) DEFAULT NULL,
  `content` text NOT NULL,
  `layout_width` varchar(11) NOT NULL DEFAULT '54',
  `layout_height` varchar(11) NOT NULL DEFAULT '86',
  `photo_style` tinyint(1) NOT NULL,
  `photo_size` varchar(25) NOT NULL,
  `top_space` varchar(25) NOT NULL,
  `bottom_space` varchar(25) NOT NULL,
  `right_space` varchar(25) NOT NULL,
  `left_space` varchar(25) NOT NULL,
  `qr_code` varchar(25) NOT NULL,
  `branch_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `card_templete_rms_1` (`branch_id`),
  CONSTRAINT `card_templete_rms_1` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `card_templete` (`id`, `card_type`, `name`, `user_type`, `background`, `logo`, `signature`, `content`, `layout_width`, `layout_height`, `photo_style`, `photo_size`, `top_space`, `bottom_space`, `right_space`, `left_space`, `qr_code`, `branch_id`, `created_at`) VALUES (1, 1, 'ID _Template-1', 1, 'eduerp_online_ID.png', '', '', '<div style=\"text-align: center; line-height: 1.4;\"> {logo} <br><b>{institute_name}</b><br></div><div style=\"text-align: center; line-height: 1;\"><br></div><div style=\"text-align: center;\">{student_photo}</div><div style=\"text-align: center;\"><br></div><p style=\"text-align: left; line-height: 1.5;\">Name : {name}</p><p style=\"text-align: left; line-height: 1.5;\">Class : {class}</p><p style=\"text-align: left; line-height: 1.5;\">Roll : {roll}</p><div style=\"text-align: center; line-height: 1.5;\">Father Name : {father_name}<br></div><div style=\"text-align: center; line-height: 1.5;\">DOB : {birthday}</div><div style=\"text-align: center; line-height: 1.5;\">{qr_code}</div>', '60.452', '96.856', 1, '90', '20', '20', '10', '10', 'name', 1, '2024-12-27 21:20:55');
INSERT INTO `card_templete` (`id`, `card_type`, `name`, `user_type`, `background`, `logo`, `signature`, `content`, `layout_width`, `layout_height`, `photo_style`, `photo_size`, `top_space`, `bottom_space`, `right_space`, `left_space`, `qr_code`, `branch_id`, `created_at`) VALUES (2, 2, 'Admit Card', 1, 'admit-card.png', '', '', '<div style=\"text-align: center;\"><b><span style=\"font-size: 28px;\">{institute_name}</span><span style=\"font-size: 28px;\"></span></b></div><div style=\"text-align: center;\">{institute_email} | {mobileno} </div><div style=\"text-align: center;\">{institute_address}</div><div style=\"text-align: center;\">{student_photo}                                                                                {qr_code} </div><div style=\"text-align: center;\"><span style=\"font-size: 18px;\"><b><br></b></span></div><div style=\"text-align: center;\"><span style=\"font-size: 18px;\"><b>ADMIT CARD  FIRST TERM EXAMINATION-2020</b></span></div><div style=\"text-align: center;\"><span style=\"font-size: 18px;\"><b><br></b></span></div><table class=\"table table-bordered table-condensed mb-none\"><tbody><tr><td><b>Student Name: </b>{name}<br></td><td><b>Exam Name: </b>{exam_name}<br></td></tr><tr><td><b>Father\'s Name: </b>{father_name}<br></td><td><b>Class: </b>{class}<br></td></tr><tr><td><b>Gender: </b>{gender}<br></td><td><b>Roll:</b> {roll}<br></td></tr><tr><td><b>Date Of Birth: </b>{birthday}<br></td><td><b>Admission On:</b> {admission_date}<br></td></tr><tr><td><b>Email: </b>{email}<br></td><td><b>Student Group: </b>{category}<br></td></tr><tr><td><b>Contact No: </b>{mobileno}<br></td><td><b>Blood Group</b>: {blood_group} <br></td></tr></tbody></table><div style=\"text-align: center;\"><br><div style=\"text-align: left; \"><b>Subject Details :</b></div><div style=\"text-align: left; \"> {subject_list_table} </div><div style=\"\">Date of Publication of  Admit card : {print_date}                                                   Principal Signature</div><div style=\"\">                                                                                                                         <br></div></div>', '210', '297', 1, '100', '80', '80', '80', '90', 'register_no', 1, '2025-01-01 22:42:04');


#
# TABLE STRUCTURE FOR: certificates_templete
#

DROP TABLE IF EXISTS `certificates_templete`;

CREATE TABLE `certificates_templete` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `user_type` tinyint(1) NOT NULL,
  `background` varchar(355) DEFAULT NULL,
  `logo` varchar(355) DEFAULT NULL,
  `signature` varchar(255) NOT NULL,
  `content` text NOT NULL,
  `page_layout` tinyint(1) NOT NULL,
  `photo_style` tinyint(1) NOT NULL,
  `photo_size` varchar(25) NOT NULL,
  `top_space` varchar(25) NOT NULL,
  `bottom_space` varchar(25) NOT NULL,
  `right_space` varchar(25) NOT NULL,
  `left_space` varchar(25) NOT NULL,
  `qr_code` varchar(25) NOT NULL,
  `branch_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `certificates_templete_rms_1` (`branch_id`),
  CONSTRAINT `certificates_templete_rms_1` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `certificates_templete` (`id`, `name`, `user_type`, `background`, `logo`, `signature`, `content`, `page_layout`, `photo_style`, `photo_size`, `top_space`, `bottom_space`, `right_space`, `left_space`, `qr_code`, `branch_id`, `created_at`) VALUES (1, 'School Certificate', 1, 'certificate_bg_staff11.jpg', 'logo-1.png', 'signature.png', '<div style=\"text-align: center;\"> {print_date} <b><span style=\"font-size: 28px;\">{institute_name}</span><span style=\"font-size: 28px;\">&nbsp;</span></b></div><div style=\"text-align: center;\">{institute_email} | {mobileno}&nbsp;</div><div style=\"text-align: center;\">{institute_address}</div><div style=\"text-align: center;\"><br></div><div style=\"text-align: center;\"><b>Registration No</b>: {register_no}&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; {student_photo}&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<b>Admission On</b>: {admission_date}</div><div style=\"text-align: center;\"><br></div><div style=\"text-align: center;\"><span style=\"font-size: 24px;\"><b>SCHOOL CERTIFICATE EXAMINATION-2020</b></span></div><div style=\"text-align: center; line-height: 1.2;\"><span style=\"font-size: 24px;\"><b><br></b></span><div style=\"line-height: 1.2;\"><font face=\"Pinyon Script\"><span style=\"font-size: 28px;\">This Is To Certify That&nbsp;&nbsp;<b>{name}&nbsp;</b>And Of He/she Is Gender As&nbsp;<b>{gender}</b>&nbsp;Son/daughter Of&nbsp;&nbsp;<b>{father_name}</b>&nbsp;&amp;&nbsp;<b>{mother_name}</b>&nbsp;Of&nbsp;<b>{institute_name}</b>&nbsp;And&nbsp;<b>{institute_address}</b>&nbsp;Bearing Roll-&nbsp;<b>{roll}&nbsp;</b>&amp; Exam Center Campus-04 And Class&nbsp;<b>{class}&nbsp;</b>Dulg Passed The Final</span></font></div><div style=\"line-height: 1.2;\"><font face=\"Pinyon Script\"><span style=\"font-size: 28px;\">school Certificate Examination Of 2020&nbsp;&nbsp;<b>{category}</b>&nbsp; And His/her Date Of Birth As Recorded Is&nbsp;<b>{birthday}</b>&nbsp;Obtained&nbsp; G.p.a&nbsp;</span></font>&nbsp;{result_status} <font face=\"Pinyon Script\"><span style=\"font-size: 28px;\">&nbsp;In The Scale Of&nbsp;<b>5.00</b>.</span></font></div><div style=\"line-height: 1.2;\"><font face=\"Arial\"><br></font></div><div style=\"line-height: 1.2;\"><font face=\"Arial\"><br></font></div><div style=\"line-height: 1.2;\"><font face=\"Arial\">Date of Publication of Result: {print_date}&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</font><span style=\"font-family: Arial;\">Principal signature</span></div><div style=\"line-height: 1.2;\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</div></div>', 2, 1, '100', '80', '80', '80', '80', 'register_no', 1, '2024-12-27 19:33:14');
INSERT INTO `certificates_templete` (`id`, `name`, `user_type`, `background`, `logo`, `signature`, `content`, `page_layout`, `photo_style`, `photo_size`, `top_space`, `bottom_space`, `right_space`, `left_space`, `qr_code`, `branch_id`, `created_at`) VALUES (4, 'EXPRIENCES CERTIFICATE FOR EMPLOYEE-1', 2, 'certificate_bg_staff1.jpg', 'logo-13.png', 'signature3.png', '<div style=\"text-align: center; line-height: 1.4;\"><div style=\"line-height: 1.4;\"><span style=\"font-size: 18px;\">{institute_name}</span><span style=\"font-size: 18px;\">&nbsp;</span></div><div style=\"line-height: 1.4;\"><span style=\"font-size: 18px;\">{institute_email} | {mobileno}&nbsp;</span></div><div style=\"line-height: 1.4;\"><span style=\"font-size: 18px;\">{institute_address}</span></div></div><p><br></p><div style=\"text-align: center;\"><b>Staff ID&nbsp;</b>:&nbsp;<i>{staff_id}&nbsp;</i>&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; {staff_photo} &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;<b>Joining Date&nbsp;:</b>&nbsp;<i>{joining_date}&nbsp;&nbsp;<br></i></div><div style=\"text-align: center;\"><br></div><div style=\"text-align: center;\"><span style=\"font-size: 24px;\"><b>EXPRIENCES CERTIFICATE OF ACHIVEMENT</b></span></div><div style=\"text-align: center; line-height: 1.2;\"><div style=\"text-align: justify;\"><span style=\"font-size: 24px;\"><b><br></b></span></div><div style=\"line-height: 1.2;\"><font face=\"Pinyon Script\"><span style=\"font-size: 28px;\"><span style=\"font-size: 24px;\"><b>This Is To Certify That</b>&nbsp;&nbsp;</span><span style=\"font-size: 24px;\">{name}<b>&nbsp;</b></span><span style=\"font-weight: bold; font-size: 24px;\">And Of He/she Is Gender As&nbsp;</span><span style=\"font-size: 24px;\">{gender}<b>&nbsp;&amp;</b></span><span style=\"font-weight: bold;\"><span style=\"font-size: 24px;\">&nbsp;</span></span><span style=\"font-weight: bold;\"><span style=\"font-size: 24px;\">permanent resident of</span></span></span></font><span style=\"font-weight: bold; font-size: 24px;\">&nbsp;</span>&nbsp;<font face=\"Pinyon Script\"><span style=\"font-size: 24px;\">{permanent_address}&nbsp;</span></font><span style=\"font-weight: bold;\"><span style=\"font-size: 24px;\">&nbsp;</span></span><font face=\"Pinyon Script\" style=\"font-weight: bold;\"><span style=\"font-size: 24px;\">&nbsp;and he/she is the</span></font><span style=\"font-weight: bold; font-size: 24px;\">&nbsp;</span><span style=\"font-size: 24px;\"><font face=\"Parisienne\">{designation}</font></span><span style=\"font-weight: bold; font-size: 24px;\">&nbsp;</span><font face=\"Parisienne\"><span style=\"font-size: 28px;\"><span style=\"font-weight: bold; font-size: 24px;\">of</span><span style=\"font-weight: bold; font-size: 24px;\">&nbsp;</span><span style=\"font-size: 24px;\">{department}</span><span style=\"font-weight: bold; font-size: 24px;\">&nbsp;</span><span style=\"font-weight: bold; font-size: 24px;\">department.</span></span></font><font face=\"Pinyon Script\" style=\"font-weight: bold;\"><span style=\"font-size: 24px;\">&nbsp;</span></font></div><div style=\"line-height: 1.2;\"><font face=\"Pinyon Script\" style=\"font-weight: bold;\"><span style=\"font-size: 24px;\">He/she worked as</span></font><font face=\"Parisienne\" style=\"font-weight: bold;\"><span style=\"font-size: 28px;\"><span style=\"font-size: 24px;\"><font face=\"Pinyon Script\">&nbsp;</font></span></span></font><font face=\"Pinyon Script\"><span style=\"font-size: 28px;\"><span style=\"font-size: 24px;\">{designation}</span></span></font><b>&nbsp;&nbsp;</b><font face=\"Parisienne\" style=\"font-weight: bold;\"><span style=\"font-size: 28px;\"><span style=\"font-size: 24px;\">in</span><span style=\"font-size: 24px;\">&nbsp;</span></span></font><font face=\"Pinyon Script\"><span style=\"font-size: 28px;\"><span style=\"font-weight: bold; font-size: 24px;\">&nbsp;</span><span style=\"font-size: 24px;\">{institute_name}</span><span style=\"font-size: 24px;\">&nbsp;<b>&nbsp;from&nbsp;</b></span></span></font><span style=\"font-weight: bold; font-size: 24px;\">&nbsp;</span><font face=\"Pinyon Script\"><span style=\"font-size: 24px;\">{joining_date}</span></font><span style=\"font-size: 24px;\">&nbsp;</span><span style=\"font-weight: bold; font-size: 24px;\">&nbsp;</span><font face=\"Parisienne\" style=\"font-weight: bold;\"><font face=\"Pinyon Script\"><span style=\"font-size: 24px;\">with our entire satisfaction.During of his working period we found of him/his sincere, honest, hardworking, dedicated employee with a professional attitude and very good job knowledge.</span></font><span style=\"font-size: 24px;\">&nbsp;</span></font></div><div style=\"line-height: 1.2;\"><font face=\"Pinyon Script\"><b><font style=\"font-size: 28px;\"><span style=\"font-size: 24px;\">&nbsp;We have no objection to allow him/his in any better position and have no liabilities&nbsp; in our company.</span></font><span style=\"font-size: 24px;\">&nbsp;</span></b></font></div><div style=\"line-height: 1.2;\"><font face=\"Pinyon Script\"><span style=\"font-size: 24px;\"><b>We wish him/his great success of life .<br></b></span></font></div><div style=\"line-height: 1.2;\"><span style=\"font-family: Arial;\"><b><span style=\"font-size: 12px;\">Date of Publication of Released</span></b><span style=\"font-size: 12px;\">:</span>&nbsp;{print_date}&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span><font face=\"Pinyon Script\"><span style=\"font-size: 24px;\">&nbsp;</span></font>{qr_code}</div></div>', 2, 1, '100', '80', '80', '80', '80', 'staff_id', 1, '2024-12-27 19:48:55');


#
# TABLE STRUCTURE FOR: class
#

DROP TABLE IF EXISTS `class`;

CREATE TABLE `class` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `name_numeric` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT NULL,
  `branch_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `class_rms_1` (`branch_id`),
  CONSTRAINT `class_rms_1` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `class` (`id`, `name`, `name_numeric`, `created_at`, `updated_at`, `branch_id`) VALUES (2, 'Play', '0', '2024-12-27 14:27:47', NULL, 1);
INSERT INTO `class` (`id`, `name`, `name_numeric`, `created_at`, `updated_at`, `branch_id`) VALUES (3, 'Nursery', '01', '2024-12-27 14:28:10', NULL, 1);
INSERT INTO `class` (`id`, `name`, `name_numeric`, `created_at`, `updated_at`, `branch_id`) VALUES (4, 'One', '1', '2024-12-27 14:28:20', NULL, 1);
INSERT INTO `class` (`id`, `name`, `name_numeric`, `created_at`, `updated_at`, `branch_id`) VALUES (5, 'Two', '2', '2024-12-27 14:28:33', NULL, 1);
INSERT INTO `class` (`id`, `name`, `name_numeric`, `created_at`, `updated_at`, `branch_id`) VALUES (6, 'Three', '3', '2024-12-27 14:28:47', NULL, 1);
INSERT INTO `class` (`id`, `name`, `name_numeric`, `created_at`, `updated_at`, `branch_id`) VALUES (7, 'Four', '4', '2024-12-27 14:28:58', NULL, 1);
INSERT INTO `class` (`id`, `name`, `name_numeric`, `created_at`, `updated_at`, `branch_id`) VALUES (8, 'Five', '5', '2024-12-27 14:29:10', NULL, 1);
INSERT INTO `class` (`id`, `name`, `name_numeric`, `created_at`, `updated_at`, `branch_id`) VALUES (9, 'Six', '6', '2024-12-27 14:29:20', NULL, 1);
INSERT INTO `class` (`id`, `name`, `name_numeric`, `created_at`, `updated_at`, `branch_id`) VALUES (10, 'Seven', '7', '2024-12-27 14:29:31', NULL, 1);
INSERT INTO `class` (`id`, `name`, `name_numeric`, `created_at`, `updated_at`, `branch_id`) VALUES (11, 'Eight', '8', '2024-12-27 14:29:45', NULL, 1);
INSERT INTO `class` (`id`, `name`, `name_numeric`, `created_at`, `updated_at`, `branch_id`) VALUES (12, 'Nine', '9', '2024-12-27 14:29:54', NULL, 1);
INSERT INTO `class` (`id`, `name`, `name_numeric`, `created_at`, `updated_at`, `branch_id`) VALUES (13, 'Ten', '10', '2024-12-27 14:30:03', NULL, 1);


#
# TABLE STRUCTURE FOR: complaint
#

DROP TABLE IF EXISTS `complaint`;

CREATE TABLE `complaint` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `number` varchar(255) DEFAULT NULL,
  `type_id` int(11) DEFAULT NULL,
  `date` date NOT NULL,
  `assigned_id` int(11) DEFAULT NULL,
  `action` varchar(255) NOT NULL,
  `date_of_solution` date DEFAULT NULL,
  `file` varchar(500) NOT NULL,
  `note` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `branch_id` int(11) NOT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `complaint_rms_1` (`branch_id`),
  CONSTRAINT `complaint_rms_1` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: complaint_type
#

DROP TABLE IF EXISTS `complaint_type`;

CREATE TABLE `complaint_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `branch_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `complaint_type_rms_1` (`branch_id`),
  CONSTRAINT `complaint_type_rms_1` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: custom_field
#

DROP TABLE IF EXISTS `custom_field`;

CREATE TABLE `custom_field` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_to` varchar(50) DEFAULT NULL,
  `field_label` varchar(100) NOT NULL,
  `default_value` text DEFAULT NULL,
  `field_type` enum('text','textarea','dropdown','date','checkbox','number','url','email') NOT NULL,
  `required` varchar(5) NOT NULL DEFAULT 'false',
  `status` tinyint(4) NOT NULL DEFAULT 1,
  `show_on_table` varchar(5) DEFAULT NULL,
  `field_order` int(11) NOT NULL,
  `bs_column` int(11) NOT NULL,
  `branch_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: custom_fields_online_values
#

DROP TABLE IF EXISTS `custom_fields_online_values`;

CREATE TABLE `custom_fields_online_values` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `relid` int(11) NOT NULL,
  `field_id` int(11) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `relid` (`relid`),
  KEY `fieldid` (`field_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: custom_fields_values
#

DROP TABLE IF EXISTS `custom_fields_values`;

CREATE TABLE `custom_fields_values` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `relid` int(11) NOT NULL,
  `field_id` int(11) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `relid` (`relid`),
  KEY `fieldid` (`field_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: disable_reason
#

DROP TABLE IF EXISTS `disable_reason`;

CREATE TABLE `disable_reason` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `branch_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `disable_reason_rms_1` (`branch_id`),
  CONSTRAINT `disable_reason_rms_1` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `disable_reason` (`id`, `name`, `branch_id`) VALUES (1, 'Student Leave from School', 1);


#
# TABLE STRUCTURE FOR: disable_reason_details
#

DROP TABLE IF EXISTS `disable_reason_details`;

CREATE TABLE `disable_reason_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `reason_id` int(11) NOT NULL,
  `note` varchar(255) NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: email_config
#

DROP TABLE IF EXISTS `email_config`;

CREATE TABLE `email_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(255) DEFAULT NULL,
  `protocol` varchar(255) NOT NULL,
  `smtp_host` varchar(255) DEFAULT NULL,
  `smtp_user` varchar(255) DEFAULT NULL,
  `smtp_pass` varchar(255) DEFAULT NULL,
  `smtp_port` varchar(100) DEFAULT NULL,
  `smtp_encryption` varchar(10) DEFAULT NULL,
  `smtp_auth` varchar(10) NOT NULL DEFAULT 'true',
  `branch_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `email_config` (`id`, `email`, `protocol`, `smtp_host`, `smtp_user`, `smtp_pass`, `smtp_port`, `smtp_encryption`, `smtp_auth`, `branch_id`) VALUES (1, 'noreply@elitedesign.com.bd', 'smtp', 'smtp.gmail.com', 'elitedesign.com.bd@gmail.com', 'vpyc rgbl eqcm oywx', '587', 'tls', 'true', 1);


#
# TABLE STRUCTURE FOR: email_templates
#

DROP TABLE IF EXISTS `email_templates`;

CREATE TABLE `email_templates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `tags` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `email_templates` (`id`, `name`, `tags`) VALUES (1, 'account_registered', '{institute_name}, {name}, {login_username}, {password}, {user_role}, {login_url}');
INSERT INTO `email_templates` (`id`, `name`, `tags`) VALUES (2, 'forgot_password', '{institute_name}, {username}, {email}, {reset_url}');
INSERT INTO `email_templates` (`id`, `name`, `tags`) VALUES (3, 'change_password', '{institute_name}, {name}, {email}, {password}');
INSERT INTO `email_templates` (`id`, `name`, `tags`) VALUES (4, 'new_message_received', '{institute_name}, {recipient}, {message}, {message_url}');
INSERT INTO `email_templates` (`id`, `name`, `tags`) VALUES (5, 'payslip_generated', '{institute_name}, {username}, {month_year}, {payslip_url}');
INSERT INTO `email_templates` (`id`, `name`, `tags`) VALUES (6, 'award', '{institute_name}, {winner_name}, {award_name}, {gift_item}, {award_reason}, {given_date}');
INSERT INTO `email_templates` (`id`, `name`, `tags`) VALUES (7, 'leave_approve', '{institute_name}, {applicant_name}, {start_date}, {end_date}, {comments}');
INSERT INTO `email_templates` (`id`, `name`, `tags`) VALUES (8, 'leave_reject', '{institute_name}, {applicant_name}, {start_date}, {end_date}, {comments}');
INSERT INTO `email_templates` (`id`, `name`, `tags`) VALUES (9, 'advance_salary_approve', '{institute_name}, {applicant_name}, {deduct_motnh}, {amount}, {comments}');
INSERT INTO `email_templates` (`id`, `name`, `tags`) VALUES (10, 'advance_salary_reject', '{institute_name}, {applicant_name}, {deduct_motnh}, {amount}, {comments}');
INSERT INTO `email_templates` (`id`, `name`, `tags`) VALUES (11, 'apply_online_admission', '{institute_name}, {reference_no}, {applicant_name}, {applicant_mobile}, {class}, {section}, {apply_date}, {payment_url}, {admission_copy_url}, {paid_amount}');
INSERT INTO `email_templates` (`id`, `name`, `tags`) VALUES (12, 'student_admission', '{institute_name}, {academic_year}, {admission_date}, {admission_no}, {roll}, {category}, {student_name}, {student_mobile}, {class}, {section}, {login_username}, {password}, {login_url}');
INSERT INTO `email_templates` (`id`, `name`, `tags`) VALUES (13, 'email_pdf_exam_marksheet', '{institute_name}, {academic_year}, {admission_date}, {admission_no}, {roll}, {student_name}, {class}, {section}, {exam_name}');
INSERT INTO `email_templates` (`id`, `name`, `tags`) VALUES (14, 'email_pdf_fee_invoice', '{institute_name}, {academic_year}, {today_date}, {admission_date}, {admission_no}, {roll}, {student_name}, {class}, {section}');


#
# TABLE STRUCTURE FOR: email_templates_details
#

DROP TABLE IF EXISTS `email_templates_details`;

CREATE TABLE `email_templates_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `template_id` int(11) NOT NULL,
  `subject` varchar(255) NOT NULL,
  `template_body` text NOT NULL,
  `notified` tinyint(1) NOT NULL DEFAULT 1,
  `branch_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `email_templates_details` (`id`, `template_id`, `subject`, `template_body`, `notified`, `branch_id`) VALUES (1, 2, 'Password Reset Request', '<p>Hello, {Username},</p><p>We received a request to reset your password for <strong>{Institute Name}</strong>. To reset your password, please use the following link:</p><p><strong>Reset URL:</strong> {Reset URL}</p><p>For your reference, here are the details associated with your account:</p><ul><li><strong>Institute Name:</strong> {Institute Name}</li><li><strong>Username:</strong> {Username}</li><li><strong>Email:</strong> {Email}</li></ul><p>Please keep this information secure. If you did not request a password reset, you can ignore this message.</p>', 1, 1);
INSERT INTO `email_templates_details` (`id`, `template_id`, `subject`, `template_body`, `notified`, `branch_id`) VALUES (2, 3, 'Password Change Confirmation – {Institute Name}', 'Hello, {Name},\r\n\r\nYour password for {Institute Name} has been successfully updated. Please find your new login details below:\r\n\r\nName: {Name}\r\nNew Password: {Password}\r\nFor reference:\r\n\r\nInstitute Name: {Institute Name}\r\nEmail: {Email}\r\nIf you didn’t request this change, please contact our support team immediately.\r\n\r\n\r\n', 1, 1);
INSERT INTO `email_templates_details` (`id`, `template_id`, `subject`, `template_body`, `notified`, `branch_id`) VALUES (3, 1, 'Congratulations, here are your login details to {institute_name}', '<p>Hello, {Name},</p><p>Congratulations! Your account with <strong>{Institute Name}</strong> has been created. Here are your login details:</p><p><strong>Login URL:</strong> {Login URL}<br><strong>Username:</strong> {Login Email}<br><strong>Password:</strong> {Password}</p><p>Please keep your login credentials secure and do not share them with anyone.</p><p>Welcome aboard, and happy learning!</p>', 1, 1);
INSERT INTO `email_templates_details` (`id`, `template_id`, `subject`, `template_body`, `notified`, `branch_id`) VALUES (4, 4, 'New Message from {Institute Name}', '<p>Hello, {Recipient},</p><p>You have a new message:</p><p><strong>Message:</strong><br>{Message}</p><p>To view the full message, please click the link below:<br><strong>Message URL:</strong> {Message URL}</p><p>Thank you!</p>', 1, 1);
INSERT INTO `email_templates_details` (`id`, `template_id`, `subject`, `template_body`, `notified`, `branch_id`) VALUES (5, 5, ' Payslip Generated for {Month_Year} – {Institute Name}', '<p>Hello, {Username},</p><p>Your payslip for <strong>{Month_Year}</strong> has been generated. You can access it using the link below:</p><p><strong>Payslip URL:</strong> {Payslip_URL}</p><p>Please keep this information secure. If you have any questions, feel free to reach out.</p>', 1, 1);
INSERT INTO `email_templates_details` (`id`, `template_id`, `subject`, `template_body`, `notified`, `branch_id`) VALUES (6, 6, 'Congratulations, {Winner_Name} – {Award_Name} Award from {Institute_Name}!', '<p>Dear {Winner_Name},</p><p>Congratulations on receiving the <strong>{Award_Name}</strong> award from <strong>{Institute_Name}</strong>! This award is presented in recognition of {Award_Reason}.</p><p><strong>Award Details:</strong></p><ul><li><strong>Award Name:</strong> {Award_Name}</li><li><strong>Gift Item:</strong> {Gift_Item}</li><li><strong>Date Given:</strong> {Given_Date}</li></ul><p>We are proud of your achievements and the positive impact you\'ve made. Keep up the fantastic work!</p><p>Warm regards,<br>{Institute_Name}</p>', 1, 1);
INSERT INTO `email_templates_details` (`id`, `template_id`, `subject`, `template_body`, `notified`, `branch_id`) VALUES (7, 8, 'Leave Request Update – {Institute_Name}', '<p>Hello, {Applicant_Name},</p><p>We regret to inform you that your leave request from <strong>{Start_Date} to {End_Date}</strong> has not been approved.</p><p><strong>Comments:</strong> {Comments}</p><p>If you have any questions or would like to discuss this further, please feel free to reach out.</p><p>Best regards,<br>{Institute_Name} Team</p>', 1, 1);
INSERT INTO `email_templates_details` (`id`, `template_id`, `subject`, `template_body`, `notified`, `branch_id`) VALUES (8, 9, ' Deduction Notification – {Institute_Name}', '<p>Hello, {Applicant_Name},</p><p>Please be informed that a deduction of <strong>{Amount}</strong> has been made for the month of <strong>{Deduct_Month}</strong>.</p><p><strong>Comments:</strong> {Comments}</p><p>If you have any questions regarding this deduction, feel free to reach out.</p><p>Best regards,<br>{Institute_Name} Team</p>', 1, 1);
INSERT INTO `email_templates_details` (`id`, `template_id`, `subject`, `template_body`, `notified`, `branch_id`) VALUES (9, 10, ' Advance Salary Request – {Institute_Name}', '<p>Hello, {Applicant_Name},</p><p>We regret to inform you that your request for an advance salary of <strong>{Amount}</strong> for the month of <strong>{Deduct_Motnh}</strong> has been rejected.</p><p><strong>Comments:</strong> {Comments}</p><p>If you have any questions or concerns, please don’t hesitate to reach out.</p><p>Best regards,<br>{Institute_Name} Team</p>', 1, 1);
INSERT INTO `email_templates_details` (`id`, `template_id`, `subject`, `template_body`, `notified`, `branch_id`) VALUES (10, 11, ' Online Admission Confirmation – {Institute_Name}', '<p>Hello {Applicant_Name},</p><p>Thank you for applying to <strong>{Institute_Name}</strong>. Your admission has been successfully processed. Below are the details of your admission:</p><ul><li><strong>Admission ID:</strong> {Admission_ID}</li><li><strong>Class:</strong> {Class}</li><li><strong>Section:</strong> {Section}</li><li><strong>Application Date:</strong> {Apply_Date}</li><li><strong>Paid Amount:</strong> {Paid_Amount}</li><li><strong>Mobile Number:</strong> {Applicant_Mobile}</li></ul><p>To complete the process, you can make your payment using the link below:<br><strong>Payment URL:</strong> {Payment_URL}</p><p>Additionally, you can access your admission copy here:<br><strong>Admission Copy URL:</strong> {Admission_Copy_URL}</p><p>If you have any questions or need further assistance, feel free to contact us.</p><p>Welcome to <strong>{Institute_Name}</strong>!</p><p>Best regards,<br>{Institute_Name} Team</p>', 1, 1);
INSERT INTO `email_templates_details` (`id`, `template_id`, `subject`, `template_body`, `notified`, `branch_id`) VALUES (11, 12, ' Admission Confirmation – {Institute_Name}', '<p>Dear {Student_Name},</p><p>We are pleased to inform you that your admission to <strong>{Institute_Name}</strong> for the academic year <strong>{Academic_Year}</strong> has been successfully processed. Below are your admission details:</p><ul><li><strong>Admission Date:</strong> {Admission_Date}</li><li><strong>Admission No.:</strong> {Admission_No}</li><li><strong>Roll No.:</strong> {Roll}</li><li><strong>Category:</strong> {Category}</li><li><strong>Class:</strong> {Class}</li><li><strong>Section:</strong> {Section}</li><li><strong>Mobile Number:</strong> {Student_Mobile}</li></ul><p>You can access your account using the following login credentials:</p><ul><li><strong>Username:</strong> {Login_Username}</li><li><strong>Password:</strong> {Password}</li></ul><p>To log in, please visit:<br><strong>Login URL:</strong> {Login_URL}</p><p>If you have any questions or need further assistance, please don’t hesitate to reach out.</p><p>Congratulations on your admission, and welcome to <strong>{Institute_Name}</strong>!</p><p>Best regards,<br>{Institute_Name} Team</p>', 1, 1);


#
# TABLE STRUCTURE FOR: enquiry
#

DROP TABLE IF EXISTS `enquiry`;

CREATE TABLE `enquiry` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `birthday` date DEFAULT NULL,
  `gender` tinyint(1) DEFAULT 0,
  `father_name` varchar(255) DEFAULT NULL,
  `mother_name` varchar(255) DEFAULT NULL,
  `mobile_no` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `address` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `previous_school` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `reference_id` int(11) NOT NULL,
  `response_id` int(11) NOT NULL,
  `response` varchar(255) NOT NULL,
  `date` date NOT NULL,
  `note` varchar(255) NOT NULL,
  `assigned_id` int(11) NOT NULL,
  `created_by` int(11) NOT NULL,
  `no_of_child` float NOT NULL,
  `class_id` int(11) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `branch_id` int(11) NOT NULL,
  `created_at` date NOT NULL,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `enquiry_rms_1` (`branch_id`),
  CONSTRAINT `enquiry_rms_1` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: enquiry_follow_up
#

DROP TABLE IF EXISTS `enquiry_follow_up`;

CREATE TABLE `enquiry_follow_up` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `enquiry_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `next_date` date NOT NULL,
  `response` varchar(255) DEFAULT NULL,
  `status` tinyint(1) NOT NULL,
  `note` varchar(255) NOT NULL,
  `follow_up_by` int(11) NOT NULL,
  `created_at` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `enquiry_follow_up_rms_1` (`enquiry_id`),
  CONSTRAINT `enquiry_follow_up_rms_1` FOREIGN KEY (`enquiry_id`) REFERENCES `enquiry` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: enquiry_reference
#

DROP TABLE IF EXISTS `enquiry_reference`;

CREATE TABLE `enquiry_reference` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `branch_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `enquiry_reference_rms_1` (`branch_id`),
  CONSTRAINT `enquiry_reference_rms_1` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: enquiry_response
#

DROP TABLE IF EXISTS `enquiry_response`;

CREATE TABLE `enquiry_response` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `branch_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `enquiry_response_rms_1` (`branch_id`),
  CONSTRAINT `enquiry_response_rms_1` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: enroll
#

DROP TABLE IF EXISTS `enroll`;

CREATE TABLE `enroll` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `section_id` int(11) NOT NULL,
  `roll` int(11) NOT NULL,
  `session_id` int(11) NOT NULL,
  `default_login` tinyint(4) NOT NULL DEFAULT 0,
  `branch_id` int(11) NOT NULL,
  `is_alumni` tinyint(4) NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `enroll_rms_1` (`student_id`),
  KEY `enroll_rms_2` (`session_id`),
  KEY `enroll_rms_3` (`class_id`),
  KEY `enroll_rms_4` (`section_id`),
  KEY `enroll_rms_5` (`branch_id`),
  CONSTRAINT `enroll_rms_1` FOREIGN KEY (`student_id`) REFERENCES `student` (`id`) ON DELETE CASCADE,
  CONSTRAINT `enroll_rms_2` FOREIGN KEY (`session_id`) REFERENCES `schoolyear` (`id`) ON DELETE CASCADE,
  CONSTRAINT `enroll_rms_3` FOREIGN KEY (`class_id`) REFERENCES `class` (`id`) ON DELETE CASCADE,
  CONSTRAINT `enroll_rms_4` FOREIGN KEY (`section_id`) REFERENCES `section` (`id`) ON DELETE CASCADE,
  CONSTRAINT `enroll_rms_5` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=328 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `enroll` (`id`, `student_id`, `class_id`, `section_id`, `roll`, `session_id`, `default_login`, `branch_id`, `is_alumni`, `created_at`, `updated_at`) VALUES (297, 297, 13, 2, 1, 5, 0, 1, 0, '2024-12-27 17:49:35', NULL);
INSERT INTO `enroll` (`id`, `student_id`, `class_id`, `section_id`, `roll`, `session_id`, `default_login`, `branch_id`, `is_alumni`, `created_at`, `updated_at`) VALUES (298, 298, 13, 2, 2, 5, 0, 1, 0, '2024-12-27 17:49:35', NULL);
INSERT INTO `enroll` (`id`, `student_id`, `class_id`, `section_id`, `roll`, `session_id`, `default_login`, `branch_id`, `is_alumni`, `created_at`, `updated_at`) VALUES (299, 299, 13, 2, 3, 5, 0, 1, 0, '2024-12-27 17:49:35', NULL);
INSERT INTO `enroll` (`id`, `student_id`, `class_id`, `section_id`, `roll`, `session_id`, `default_login`, `branch_id`, `is_alumni`, `created_at`, `updated_at`) VALUES (300, 300, 13, 2, 4, 5, 0, 1, 0, '2024-12-27 17:49:35', NULL);
INSERT INTO `enroll` (`id`, `student_id`, `class_id`, `section_id`, `roll`, `session_id`, `default_login`, `branch_id`, `is_alumni`, `created_at`, `updated_at`) VALUES (301, 301, 13, 3, 5, 5, 0, 1, 0, '2024-12-27 17:51:08', NULL);
INSERT INTO `enroll` (`id`, `student_id`, `class_id`, `section_id`, `roll`, `session_id`, `default_login`, `branch_id`, `is_alumni`, `created_at`, `updated_at`) VALUES (302, 302, 13, 4, 6, 5, 0, 1, 0, '2024-12-27 17:52:18', NULL);
INSERT INTO `enroll` (`id`, `student_id`, `class_id`, `section_id`, `roll`, `session_id`, `default_login`, `branch_id`, `is_alumni`, `created_at`, `updated_at`) VALUES (303, 303, 4, 5, 1, 6, 0, 1, 0, '2025-01-02 23:26:28', NULL);
INSERT INTO `enroll` (`id`, `student_id`, `class_id`, `section_id`, `roll`, `session_id`, `default_login`, `branch_id`, `is_alumni`, `created_at`, `updated_at`) VALUES (304, 304, 4, 5, 2, 6, 0, 1, 0, '2025-01-02 23:29:00', NULL);
INSERT INTO `enroll` (`id`, `student_id`, `class_id`, `section_id`, `roll`, `session_id`, `default_login`, `branch_id`, `is_alumni`, `created_at`, `updated_at`) VALUES (305, 305, 4, 5, 3, 6, 0, 1, 0, '2025-01-02 23:39:39', NULL);
INSERT INTO `enroll` (`id`, `student_id`, `class_id`, `section_id`, `roll`, `session_id`, `default_login`, `branch_id`, `is_alumni`, `created_at`, `updated_at`) VALUES (306, 306, 4, 5, 4, 6, 0, 1, 0, '2025-01-02 23:43:24', NULL);
INSERT INTO `enroll` (`id`, `student_id`, `class_id`, `section_id`, `roll`, `session_id`, `default_login`, `branch_id`, `is_alumni`, `created_at`, `updated_at`) VALUES (307, 307, 4, 5, 5, 6, 0, 1, 0, '2025-01-02 23:47:09', NULL);
INSERT INTO `enroll` (`id`, `student_id`, `class_id`, `section_id`, `roll`, `session_id`, `default_login`, `branch_id`, `is_alumni`, `created_at`, `updated_at`) VALUES (308, 308, 5, 5, 1, 6, 0, 1, 0, '2025-01-02 23:51:45', NULL);
INSERT INTO `enroll` (`id`, `student_id`, `class_id`, `section_id`, `roll`, `session_id`, `default_login`, `branch_id`, `is_alumni`, `created_at`, `updated_at`) VALUES (309, 309, 5, 5, 2, 6, 0, 1, 0, '2025-01-02 23:55:50', NULL);
INSERT INTO `enroll` (`id`, `student_id`, `class_id`, `section_id`, `roll`, `session_id`, `default_login`, `branch_id`, `is_alumni`, `created_at`, `updated_at`) VALUES (310, 310, 5, 5, 3, 6, 0, 1, 0, '2025-01-02 23:59:31', NULL);
INSERT INTO `enroll` (`id`, `student_id`, `class_id`, `section_id`, `roll`, `session_id`, `default_login`, `branch_id`, `is_alumni`, `created_at`, `updated_at`) VALUES (311, 311, 5, 5, 4, 6, 0, 1, 0, '2025-01-03 00:02:45', NULL);
INSERT INTO `enroll` (`id`, `student_id`, `class_id`, `section_id`, `roll`, `session_id`, `default_login`, `branch_id`, `is_alumni`, `created_at`, `updated_at`) VALUES (312, 312, 5, 5, 5, 6, 0, 1, 0, '2025-01-03 00:05:36', NULL);
INSERT INTO `enroll` (`id`, `student_id`, `class_id`, `section_id`, `roll`, `session_id`, `default_login`, `branch_id`, `is_alumni`, `created_at`, `updated_at`) VALUES (313, 313, 6, 5, 1, 6, 0, 1, 0, '2025-01-03 00:13:00', NULL);
INSERT INTO `enroll` (`id`, `student_id`, `class_id`, `section_id`, `roll`, `session_id`, `default_login`, `branch_id`, `is_alumni`, `created_at`, `updated_at`) VALUES (314, 314, 6, 5, 2, 6, 0, 1, 0, '2025-01-03 00:17:00', NULL);
INSERT INTO `enroll` (`id`, `student_id`, `class_id`, `section_id`, `roll`, `session_id`, `default_login`, `branch_id`, `is_alumni`, `created_at`, `updated_at`) VALUES (315, 315, 6, 5, 3, 6, 0, 1, 0, '2025-01-03 00:21:14', NULL);
INSERT INTO `enroll` (`id`, `student_id`, `class_id`, `section_id`, `roll`, `session_id`, `default_login`, `branch_id`, `is_alumni`, `created_at`, `updated_at`) VALUES (316, 316, 6, 5, 4, 6, 0, 1, 0, '2025-01-03 00:24:37', NULL);
INSERT INTO `enroll` (`id`, `student_id`, `class_id`, `section_id`, `roll`, `session_id`, `default_login`, `branch_id`, `is_alumni`, `created_at`, `updated_at`) VALUES (317, 317, 6, 5, 5, 6, 0, 1, 0, '2025-01-03 00:27:12', NULL);
INSERT INTO `enroll` (`id`, `student_id`, `class_id`, `section_id`, `roll`, `session_id`, `default_login`, `branch_id`, `is_alumni`, `created_at`, `updated_at`) VALUES (318, 318, 7, 5, 1, 6, 0, 1, 0, '2025-01-03 00:29:45', NULL);
INSERT INTO `enroll` (`id`, `student_id`, `class_id`, `section_id`, `roll`, `session_id`, `default_login`, `branch_id`, `is_alumni`, `created_at`, `updated_at`) VALUES (319, 319, 7, 5, 2, 6, 0, 1, 0, '2025-01-03 00:32:34', NULL);
INSERT INTO `enroll` (`id`, `student_id`, `class_id`, `section_id`, `roll`, `session_id`, `default_login`, `branch_id`, `is_alumni`, `created_at`, `updated_at`) VALUES (320, 320, 7, 5, 3, 6, 0, 1, 0, '2025-01-03 00:35:16', NULL);
INSERT INTO `enroll` (`id`, `student_id`, `class_id`, `section_id`, `roll`, `session_id`, `default_login`, `branch_id`, `is_alumni`, `created_at`, `updated_at`) VALUES (321, 321, 7, 5, 4, 6, 0, 1, 0, '2025-01-03 00:37:25', NULL);
INSERT INTO `enroll` (`id`, `student_id`, `class_id`, `section_id`, `roll`, `session_id`, `default_login`, `branch_id`, `is_alumni`, `created_at`, `updated_at`) VALUES (322, 322, 7, 5, 5, 6, 0, 1, 0, '2025-01-03 00:40:14', NULL);
INSERT INTO `enroll` (`id`, `student_id`, `class_id`, `section_id`, `roll`, `session_id`, `default_login`, `branch_id`, `is_alumni`, `created_at`, `updated_at`) VALUES (323, 323, 8, 5, 1, 6, 0, 1, 0, '2025-01-03 00:43:28', NULL);
INSERT INTO `enroll` (`id`, `student_id`, `class_id`, `section_id`, `roll`, `session_id`, `default_login`, `branch_id`, `is_alumni`, `created_at`, `updated_at`) VALUES (324, 324, 8, 5, 2, 6, 0, 1, 0, '2025-01-03 00:45:48', NULL);
INSERT INTO `enroll` (`id`, `student_id`, `class_id`, `section_id`, `roll`, `session_id`, `default_login`, `branch_id`, `is_alumni`, `created_at`, `updated_at`) VALUES (325, 325, 8, 5, 3, 6, 0, 1, 0, '2025-01-03 00:48:17', NULL);
INSERT INTO `enroll` (`id`, `student_id`, `class_id`, `section_id`, `roll`, `session_id`, `default_login`, `branch_id`, `is_alumni`, `created_at`, `updated_at`) VALUES (326, 326, 8, 5, 4, 6, 0, 1, 0, '2025-01-03 00:54:34', NULL);
INSERT INTO `enroll` (`id`, `student_id`, `class_id`, `section_id`, `roll`, `session_id`, `default_login`, `branch_id`, `is_alumni`, `created_at`, `updated_at`) VALUES (327, 327, 8, 5, 5, 6, 0, 1, 0, '2025-01-03 00:57:16', NULL);


#
# TABLE STRUCTURE FOR: event
#

DROP TABLE IF EXISTS `event`;

CREATE TABLE `event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `remark` text NOT NULL,
  `status` tinyint(1) NOT NULL,
  `type` text NOT NULL,
  `audition` longtext NOT NULL,
  `selected_list` longtext NOT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `image` varchar(255) NOT NULL,
  `created_by` varchar(200) NOT NULL,
  `session_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT NULL,
  `branch_id` int(11) DEFAULT NULL,
  `show_web` tinyint(3) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `event_rms_1` (`branch_id`),
  KEY `event_rms_2` (`session_id`),
  CONSTRAINT `event_rms_1` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE,
  CONSTRAINT `event_rms_2` FOREIGN KEY (`session_id`) REFERENCES `schoolyear` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: event_types
#

DROP TABLE IF EXISTS `event_types`;

CREATE TABLE `event_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `icon` varchar(200) NOT NULL,
  `branch_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `event_types_rms_1` (`branch_id`),
  CONSTRAINT `event_types_rms_1` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: exam
#

DROP TABLE IF EXISTS `exam`;

CREATE TABLE `exam` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` longtext NOT NULL,
  `term_id` int(11) DEFAULT NULL,
  `type_id` tinyint(4) NOT NULL COMMENT '1=mark,2=gpa,3=both',
  `session_id` int(11) NOT NULL,
  `branch_id` int(11) DEFAULT NULL,
  `remark` text NOT NULL,
  `mark_distribution` text NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `publish_result` tinyint(1) NOT NULL DEFAULT 1,
  `rank_generated` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `exam_rms_1` (`branch_id`),
  KEY `exam_rms_2` (`session_id`),
  CONSTRAINT `exam_rms_1` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_rms_2` FOREIGN KEY (`session_id`) REFERENCES `schoolyear` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `exam` (`id`, `name`, `term_id`, `type_id`, `session_id`, `branch_id`, `remark`, `mark_distribution`, `status`, `publish_result`, `rank_generated`, `created_at`, `updated_at`) VALUES (1, 'Mar-2025', 1, 3, 5, 1, '', '[\"1\"]', 0, 0, 0, '2024-12-27 14:20:25', NULL);
INSERT INTO `exam` (`id`, `name`, `term_id`, `type_id`, `session_id`, `branch_id`, `remark`, `mark_distribution`, `status`, `publish_result`, `rank_generated`, `created_at`, `updated_at`) VALUES (2, 'Jun-2025', 2, 3, 5, 1, '', '[\"1\"]', 0, 0, 0, '2024-12-27 14:31:34', NULL);
INSERT INTO `exam` (`id`, `name`, `term_id`, `type_id`, `session_id`, `branch_id`, `remark`, `mark_distribution`, `status`, `publish_result`, `rank_generated`, `created_at`, `updated_at`) VALUES (3, '1st Semister', 1, 3, 6, 1, '', '[\"1\",\"2\"]', 1, 1, 0, '2025-01-03 01:00:54', NULL);


#
# TABLE STRUCTURE FOR: exam_attendance
#

DROP TABLE IF EXISTS `exam_attendance`;

CREATE TABLE `exam_attendance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `exam_id` int(11) NOT NULL,
  `subject_id` int(11) NOT NULL,
  `status` varchar(4) DEFAULT NULL COMMENT 'P=Present, A=Absent, L=Late',
  `remark` varchar(255) DEFAULT NULL,
  `branch_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `exam_attendance_rms_1` (`branch_id`),
  KEY `exam_attendance_rms_2` (`exam_id`),
  KEY `exam_attendance_rms_3` (`student_id`),
  CONSTRAINT `exam_attendance_rms_1` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_attendance_rms_2` FOREIGN KEY (`exam_id`) REFERENCES `exam` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_attendance_rms_3` FOREIGN KEY (`student_id`) REFERENCES `student` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: exam_hall
#

DROP TABLE IF EXISTS `exam_hall`;

CREATE TABLE `exam_hall` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `hall_no` longtext NOT NULL,
  `seats` int(11) NOT NULL,
  `branch_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `exam_hall_rms_1` (`branch_id`),
  CONSTRAINT `exam_hall_rms_1` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `exam_hall` (`id`, `hall_no`, `seats`, `branch_id`) VALUES (2, '101', 50, 1);
INSERT INTO `exam_hall` (`id`, `hall_no`, `seats`, `branch_id`) VALUES (3, '102', 1000, 1);


#
# TABLE STRUCTURE FOR: exam_mark_distribution
#

DROP TABLE IF EXISTS `exam_mark_distribution`;

CREATE TABLE `exam_mark_distribution` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` longtext NOT NULL,
  `branch_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `exam_mark_distribution_rms_1` (`branch_id`),
  CONSTRAINT `exam_mark_distribution_rms_1` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `exam_mark_distribution` (`id`, `name`, `branch_id`) VALUES (1, 'Theory', 1);
INSERT INTO `exam_mark_distribution` (`id`, `name`, `branch_id`) VALUES (2, 'Practical', 1);


#
# TABLE STRUCTURE FOR: exam_rank
#

DROP TABLE IF EXISTS `exam_rank`;

CREATE TABLE `exam_rank` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exam_id` int(11) NOT NULL,
  `enroll_id` int(11) NOT NULL,
  `principal_comments` text DEFAULT NULL,
  `teacher_comments` text DEFAULT NULL,
  `rank` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `exam_group_class_batch_exam_id` (`exam_id`),
  KEY `student_id` (`enroll_id`),
  CONSTRAINT `exam_rank_rms_1` FOREIGN KEY (`enroll_id`) REFERENCES `enroll` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_rank_rms_2` FOREIGN KEY (`exam_id`) REFERENCES `exam` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: exam_term
#

DROP TABLE IF EXISTS `exam_term`;

CREATE TABLE `exam_term` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` longtext NOT NULL,
  `branch_id` int(11) DEFAULT NULL,
  `session_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `exam_term` (`id`, `name`, `branch_id`, `session_id`) VALUES (1, 'First Term', 1, 6);
INSERT INTO `exam_term` (`id`, `name`, `branch_id`, `session_id`) VALUES (2, 'Second Term', 1, 5);
INSERT INTO `exam_term` (`id`, `name`, `branch_id`, `session_id`) VALUES (3, 'Third Term', 1, 5);
INSERT INTO `exam_term` (`id`, `name`, `branch_id`, `session_id`) VALUES (4, 'Annual Exam', 1, 5);


#
# TABLE STRUCTURE FOR: fee_allocation
#

DROP TABLE IF EXISTS `fee_allocation`;

CREATE TABLE `fee_allocation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `group_id` int(11) NOT NULL,
  `branch_id` int(11) NOT NULL,
  `session_id` int(11) NOT NULL,
  `prev_due` decimal(18,2) NOT NULL DEFAULT 0.00,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `fee_allocation_rsm_1` (`student_id`),
  KEY `fee_allocation_rsm_2` (`branch_id`),
  KEY `fee_allocation_rsm_3` (`session_id`),
  CONSTRAINT `fee_allocation_rsm_1` FOREIGN KEY (`student_id`) REFERENCES `enroll` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fee_allocation_rsm_2` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fee_allocation_rsm_3` FOREIGN KEY (`session_id`) REFERENCES `schoolyear` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `fee_allocation` (`id`, `student_id`, `group_id`, `branch_id`, `session_id`, `prev_due`, `created_at`) VALUES (1, 303, 2, 1, 6, '0.00', '2025-01-03 00:59:13');
INSERT INTO `fee_allocation` (`id`, `student_id`, `group_id`, `branch_id`, `session_id`, `prev_due`, `created_at`) VALUES (2, 304, 2, 1, 6, '0.00', '2025-01-03 00:59:13');
INSERT INTO `fee_allocation` (`id`, `student_id`, `group_id`, `branch_id`, `session_id`, `prev_due`, `created_at`) VALUES (3, 305, 2, 1, 6, '0.00', '2025-01-03 00:59:13');
INSERT INTO `fee_allocation` (`id`, `student_id`, `group_id`, `branch_id`, `session_id`, `prev_due`, `created_at`) VALUES (4, 306, 2, 1, 6, '0.00', '2025-01-03 00:59:13');
INSERT INTO `fee_allocation` (`id`, `student_id`, `group_id`, `branch_id`, `session_id`, `prev_due`, `created_at`) VALUES (5, 307, 2, 1, 6, '0.00', '2025-01-03 00:59:13');


#
# TABLE STRUCTURE FOR: fee_fine
#

DROP TABLE IF EXISTS `fee_fine`;

CREATE TABLE `fee_fine` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `group_id` int(11) NOT NULL,
  `type_id` int(11) NOT NULL,
  `fine_value` varchar(20) NOT NULL,
  `fine_type` varchar(20) NOT NULL,
  `fee_frequency` varchar(20) NOT NULL,
  `branch_id` int(11) NOT NULL,
  `session_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fee_fine_rms_2` (`group_id`),
  KEY `fee_fine_rms_3` (`session_id`),
  KEY `fee_fine_rms_4` (`branch_id`),
  CONSTRAINT `fee_fine_rms_1` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fee_fine_rms_2` FOREIGN KEY (`group_id`) REFERENCES `fee_groups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fee_fine_rms_3` FOREIGN KEY (`session_id`) REFERENCES `schoolyear` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fee_fine_rms_4` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: fee_groups
#

DROP TABLE IF EXISTS `fee_groups`;

CREATE TABLE `fee_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `session_id` int(11) NOT NULL,
  `system` tinyint(4) NOT NULL DEFAULT 0,
  `branch_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `fee_groups_rms_1` (`branch_id`),
  KEY `fee_groups_rms_2` (`session_id`),
  CONSTRAINT `fee_groups_rms_1` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fee_groups_rms_2` FOREIGN KEY (`session_id`) REFERENCES `schoolyear` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `fee_groups` (`id`, `name`, `description`, `session_id`, `system`, `branch_id`, `created_at`) VALUES (1, 'New Admission', '', 5, 0, 1, '2024-12-27 18:05:20');
INSERT INTO `fee_groups` (`id`, `name`, `description`, `session_id`, `system`, `branch_id`, `created_at`) VALUES (2, 'New Admission', 'New Admission', 6, 0, 1, '2025-01-02 21:00:49');


#
# TABLE STRUCTURE FOR: fee_groups_details
#

DROP TABLE IF EXISTS `fee_groups_details`;

CREATE TABLE `fee_groups_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fee_groups_id` int(11) NOT NULL,
  `fee_type_id` int(11) NOT NULL,
  `amount` decimal(18,2) NOT NULL,
  `due_date` date DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `fee_groups_details_rms_1` (`fee_groups_id`),
  KEY `fee_groups_details_rms_2` (`fee_type_id`),
  CONSTRAINT `fee_groups_details_rms_1` FOREIGN KEY (`fee_groups_id`) REFERENCES `fee_groups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fee_groups_details_rms_2` FOREIGN KEY (`fee_type_id`) REFERENCES `fees_type` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `fee_groups_details` (`id`, `fee_groups_id`, `fee_type_id`, `amount`, `due_date`, `created_at`) VALUES (1, 1, 7, '1000.00', '2025-01-10', '2024-12-27 18:05:20');
INSERT INTO `fee_groups_details` (`id`, `fee_groups_id`, `fee_type_id`, `amount`, `due_date`, `created_at`) VALUES (2, 2, 1, '200.00', '2025-01-10', '2025-01-02 21:00:49');
INSERT INTO `fee_groups_details` (`id`, `fee_groups_id`, `fee_type_id`, `amount`, `due_date`, `created_at`) VALUES (3, 2, 4, '300.00', '2025-01-08', '2025-01-02 21:00:49');
INSERT INTO `fee_groups_details` (`id`, `fee_groups_id`, `fee_type_id`, `amount`, `due_date`, `created_at`) VALUES (4, 2, 5, '300.00', '2025-01-06', '2025-01-02 21:00:49');
INSERT INTO `fee_groups_details` (`id`, `fee_groups_id`, `fee_type_id`, `amount`, `due_date`, `created_at`) VALUES (5, 2, 7, '2000.00', '2024-12-30', '2025-01-02 21:00:49');


#
# TABLE STRUCTURE FOR: fee_payment_history
#

DROP TABLE IF EXISTS `fee_payment_history`;

CREATE TABLE `fee_payment_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `allocation_id` int(11) NOT NULL,
  `type_id` int(11) NOT NULL,
  `collect_by` varchar(20) DEFAULT NULL,
  `amount` decimal(18,2) NOT NULL,
  `discount` decimal(18,2) NOT NULL,
  `fine` decimal(18,2) NOT NULL,
  `pay_via` varchar(20) NOT NULL,
  `remarks` longtext NOT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fee_payment_history_rms_1` (`allocation_id`),
  KEY `fee_payment_history_rms_2` (`type_id`),
  CONSTRAINT `fee_payment_history_rms_1` FOREIGN KEY (`allocation_id`) REFERENCES `fee_allocation` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fee_payment_history_rms_2` FOREIGN KEY (`type_id`) REFERENCES `fees_type` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `fee_payment_history` (`id`, `allocation_id`, `type_id`, `collect_by`, `amount`, `discount`, `fine`, `pay_via`, `remarks`, `date`) VALUES (1, 1, 1, '1', '200.00', '0.00', '0.00', '1', '', '2025-01-03');
INSERT INTO `fee_payment_history` (`id`, `allocation_id`, `type_id`, `collect_by`, `amount`, `discount`, `fine`, `pay_via`, `remarks`, `date`) VALUES (2, 1, 4, '1', '300.00', '0.00', '0.00', '1', '', '2025-01-03');
INSERT INTO `fee_payment_history` (`id`, `allocation_id`, `type_id`, `collect_by`, `amount`, `discount`, `fine`, `pay_via`, `remarks`, `date`) VALUES (3, 1, 5, '1', '300.00', '0.00', '0.00', '1', '', '2025-01-03');
INSERT INTO `fee_payment_history` (`id`, `allocation_id`, `type_id`, `collect_by`, `amount`, `discount`, `fine`, `pay_via`, `remarks`, `date`) VALUES (4, 1, 7, '1', '2000.00', '0.00', '0.00', '1', '', '2025-01-03');


#
# TABLE STRUCTURE FOR: fees_reminder
#

DROP TABLE IF EXISTS `fees_reminder`;

CREATE TABLE `fees_reminder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `frequency` varchar(255) NOT NULL,
  `days` varchar(20) NOT NULL,
  `message` text NOT NULL,
  `dlt_template_id` varchar(255) DEFAULT NULL,
  `student` tinyint(3) NOT NULL,
  `guardian` tinyint(3) NOT NULL,
  `branch_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `fees_reminder_rms_1` (`branch_id`),
  CONSTRAINT `fees_reminder_rms_1` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `fees_reminder` (`id`, `frequency`, `days`, `message`, `dlt_template_id`, `student`, `guardian`, `branch_id`, `created_at`) VALUES (1, 'before', '3', 'Dear  {guardian_name} , Your Child  {child_name}  School Fee  {due_amount} and due is   {due_date}. Please Paid this fee as soon as possible. Thank you.', '', 0, 1, 1, '2024-12-27 18:09:01');


#
# TABLE STRUCTURE FOR: fees_type
#

DROP TABLE IF EXISTS `fees_type`;

CREATE TABLE `fees_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `fee_code` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `branch_id` int(11) NOT NULL DEFAULT 0,
  `system` tinyint(4) NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `fees_type` (`id`, `name`, `fee_code`, `description`, `branch_id`, `system`, `created_at`) VALUES (1, 'Tuition Fee', 'tuition-fee', '', 1, 0, '2024-12-27 18:01:36');
INSERT INTO `fees_type` (`id`, `name`, `fee_code`, `description`, `branch_id`, `system`, `created_at`) VALUES (2, 'Exam Fee', 'exam-fee', '', 1, 0, '2024-12-27 18:01:54');
INSERT INTO `fees_type` (`id`, `name`, `fee_code`, `description`, `branch_id`, `system`, `created_at`) VALUES (3, 'Model Test Fee', 'model-test-fee', '', 1, 0, '2024-12-27 18:02:23');
INSERT INTO `fees_type` (`id`, `name`, `fee_code`, `description`, `branch_id`, `system`, `created_at`) VALUES (4, 'ID Card Fee', 'id-card-fee', '', 1, 0, '2024-12-27 18:02:34');
INSERT INTO `fees_type` (`id`, `name`, `fee_code`, `description`, `branch_id`, `system`, `created_at`) VALUES (5, 'Shoulder & Tie', 'shoulder-&-tie', '', 1, 0, '2024-12-27 18:02:51');
INSERT INTO `fees_type` (`id`, `name`, `fee_code`, `description`, `branch_id`, `system`, `created_at`) VALUES (6, 'Book Fee', 'book-fee', '', 1, 0, '2024-12-27 18:02:59');
INSERT INTO `fees_type` (`id`, `name`, `fee_code`, `description`, `branch_id`, `system`, `created_at`) VALUES (7, 'Admission Fee', 'admission-fee', '', 1, 0, '2024-12-27 18:04:13');


#
# TABLE STRUCTURE FOR: front_cms_about
#

DROP TABLE IF EXISTS `front_cms_about`;

CREATE TABLE `front_cms_about` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `subtitle` varchar(255) DEFAULT NULL,
  `page_title` varchar(255) NOT NULL,
  `content` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `banner_image` varchar(255) DEFAULT NULL,
  `about_image` varchar(255) NOT NULL,
  `elements` mediumtext NOT NULL,
  `meta_description` text NOT NULL,
  `meta_keyword` text NOT NULL,
  `branch_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `front_cms_about` (`id`, `title`, `subtitle`, `page_title`, `content`, `banner_image`, `about_image`, `elements`, `meta_description`, `meta_keyword`, `branch_id`) VALUES (1, 'প্রতিষ্ঠানের ইতিহাস', NULL, 'প্রতিষ্ঠানের ইতিহাস', '<div>শিক্ষার্থীদের সু-শিক্ষায় শিক্ষিত করার লক্ষে ০১/০১/২০০৫ খ্রি: থেকে ফাকল পুলিশ লাইন্স স্কুল অ্যান্ড কলেজ, লালমনিরহাট প্রতিষ্ঠানটি পাঠদান করে আসছে । ফাকল পুলিশ লাইন স্কুল অ্যান্ড কলেজ, লালমনিরহাট প্রতিষ্ঠানটি প্রতিষ্ঠার পিছনে মূল উদ্দেশ্য ভবিষ্যতের চ্যালেঞ্জ মোকাবেলা করা, সর্বশেষ জ্ঞান, তথ্য, যোগাযোগ দক্ষতা এবং বাংলাদেশী সাংস্কৃতিক ঐতিহ্যের সংমিশ্রণ সহ একটি দৃষ্টিভঙ্গি সম্পর্কে শিক্ষা প্রদানের মাধ্যমে আত্মবিশ্বাসী এবং সফল শিক্ষার্থীদের গড়ে তোলা ।&nbsp;</div><div><br></div><div>মানসম্পন্ন শিক্ষা নিশ্চিত করতে নিঃসন্দেহে মানুষের মন ও মস্তিষ্কের অনেক বেশি যত্ন প্রয়োজন। একাডেমিক অধ্যয়ন এবং সহ-পাঠক্রমিক কার্যক্রম একজন শিক্ষার্থীর শারীরিক ও মানসিক বিকাশ খুবই প্রয়োজনীয় একটি বিষয় এবং ফাকল পুলিশ লাইন স্কুল অ্যান্ড কলেজ, লালমনিরহাট একাডেমিক অধ্যয়ন এবং সহপাঠ্যক্রমিক কার্যক্রমের জন্য একটি সুন্দর পরিবেশ নিশ্চিত করনে প্রতিশ্রুতিবদ্ধ।&nbsp;</div><div><br></div><div>ফাকল পুলিশ লাইন স্কুল অ্যান্ড কলেজ, লালমনিরহাট প্রতিষ্ঠানের মাধ্যমে আমরা এ অঞ্চলের মানুষের স্বপ্ন বাস্তবায়ন হবে বলে আমরা আশাবাদী।আমরা শিক্ষার আলোয় আলোকিত হতে চাই এবং আমাদের মুক্তিযুদ্ধের মূল্যবোধে উদ্বুদ্ধ হয়ে আমাদের শিক্ষার্থীদের উন্নত মানুষ হিসেবে গড়ে তুলতে চাই।</div><div><br></div><div>মান সম্পন্ন শিক্ষা নিশ্চিত করণ এবং মানবিক মূল্যবোধ সম্পন্ন মানুষ গড়ে তোলাই ফাকল পুলিশ লাইন স্কুল অ্যান্ড কলেজের মূল উদ্দেশ্য । মুক্তিযুদ্ধের চেতনায় সমৃদ্ধ আলোকিত মানুষ গঠন ও ২০৪১ সালের উন্নত বাংলাদেশ উপযোগী আধুনিক শিক্ষায় শিক্ষিত মানব সম্পদ গঠনে প্রতিষ্ঠানটি ভূমিকা রাখবে বলে আমাদের বিশ্বাস।&nbsp;</div><div>আমি&nbsp; প্রতিষ্ঠানটির সর্বাঙ্গীন মঙ্গল কামনা করি।</div><div>শিক্ষার্থীদের সু-শিক্ষায় শিক্ষিত করার লক্ষে ০১/০১/২০০৫ খ্রি: থেকে ফাকল পুলিশ লাইন্স স্কুল অ্যান্ড কলেজ, লালমনিরহাট প্রতিষ্ঠানটি পাঠদান করে আসছে । ফাকল পুলিশ লাইন স্কুল অ্যান্ড কলেজ, লালমনিরহাট প্রতিষ্ঠানটি প্রতিষ্ঠার পিছনে মূল উদ্দেশ্য ভবিষ্যতের চ্যালেঞ্জ মোকাবেলা করা, সর্বশেষ জ্ঞান, তথ্য, যোগাযোগ দক্ষতা এবং বাংলাদেশী সাংস্কৃতিক ঐতিহ্যের সংমিশ্রণ সহ একটি দৃষ্টিভঙ্গি সম্পর্কে শিক্ষা প্রদানের মাধ্যমে আত্মবিশ্বাসী এবং সফল শিক্ষার্থীদের গড়ে তোলা ।&nbsp;</div><div><br></div><div>মানসম্পন্ন শিক্ষা নিশ্চিত করতে নিঃসন্দেহে মানুষের মন ও মস্তিষ্কের অনেক বেশি যত্ন প্রয়োজন। একাডেমিক অধ্যয়ন এবং সহ-পাঠক্রমিক কার্যক্রম একজন শিক্ষার্থীর শারীরিক ও মানসিক বিকাশ খুবই প্রয়োজনীয় একটি বিষয় এবং ফাকল পুলিশ লাইন স্কুল অ্যান্ড কলেজ, লালমনিরহাট একাডেমিক অধ্যয়ন এবং সহপাঠ্যক্রমিক কার্যক্রমের জন্য একটি সুন্দর পরিবেশ নিশ্চিত করনে প্রতিশ্রুতিবদ্ধ।&nbsp;</div><div><br></div><div>ফাকল পুলিশ লাইন স্কুল অ্যান্ড কলেজ, লালমনিরহাট প্রতিষ্ঠানের মাধ্যমে আমরা এ অঞ্চলের মানুষের স্বপ্ন বাস্তবায়ন হবে বলে আমরা আশাবাদী।আমরা শিক্ষার আলোয় আলোকিত হতে চাই এবং আমাদের মুক্তিযুদ্ধের মূল্যবোধে উদ্বুদ্ধ হয়ে আমাদের শিক্ষার্থীদের উন্নত মানুষ হিসেবে গড়ে তুলতে চাই।</div><div><br></div><div>মান সম্পন্ন শিক্ষা নিশ্চিত করণ এবং মানবিক মূল্যবোধ সম্পন্ন মানুষ গড়ে তোলাই ফাকল পুলিশ লাইন স্কুল অ্যান্ড কলেজের মূল উদ্দেশ্য । মুক্তিযুদ্ধের চেতনায় সমৃদ্ধ আলোকিত মানুষ গঠন ও ২০৪১ সালের উন্নত বাংলাদেশ উপযোগী আধুনিক শিক্ষায় শিক্ষিত মানব সম্পদ গঠনে প্রতিষ্ঠানটি ভূমিকা রাখবে বলে আমাদের বিশ্বাস।&nbsp;</div><div>আমি&nbsp; প্রতিষ্ঠানটির সর্বাঙ্গীন মঙ্গল কামনা করি।শিক্ষার্থীদের সু-শিক্ষায় শিক্ষিত করার লক্ষে ০১/০১/২০০৫ খ্রি: থেকে ফাকল পুলিশ লাইন্স স্কুল অ্যান্ড কলেজ, লালমনিরহাট প্রতিষ্ঠানটি পাঠদান করে আসছে । ফাকল পুলিশ লাইন স্কুল অ্যান্ড কলেজ, লালমনিরহাট প্রতিষ্ঠানটি প্রতিষ্ঠার পিছনে মূল উদ্দেশ্য ভবিষ্যতের চ্যালেঞ্জ মোকাবেলা করা, সর্বশেষ জ্ঞান, তথ্য, যোগাযোগ দক্ষতা এবং বাংলাদেশী সাংস্কৃতিক ঐতিহ্যের সংমিশ্রণ সহ একটি দৃষ্টিভঙ্গি সম্পর্কে শিক্ষা প্রদানের মাধ্যমে আত্মবিশ্বাসী এবং সফল শিক্ষার্থীদের গড়ে তোলা ।&nbsp;</div><div><br></div><div>মানসম্পন্ন শিক্ষা নিশ্চিত করতে নিঃসন্দেহে মানুষের মন ও মস্তিষ্কের অনেক বেশি যত্ন প্রয়োজন। একাডেমিক অধ্যয়ন এবং সহ-পাঠক্রমিক কার্যক্রম একজন শিক্ষার্থীর শারীরিক ও মানসিক বিকাশ খুবই প্রয়োজনীয় একটি বিষয় এবং ফাকল পুলিশ লাইন স্কুল অ্যান্ড কলেজ, লালমনিরহাট একাডেমিক অধ্যয়ন এবং সহপাঠ্যক্রমিক কার্যক্রমের জন্য একটি সুন্দর পরিবেশ নিশ্চিত করনে প্রতিশ্রুতিবদ্ধ।&nbsp;</div><div><br></div><div>ফাকল পুলিশ লাইন স্কুল অ্যান্ড কলেজ, লালমনিরহাট প্রতিষ্ঠানের মাধ্যমে আমরা এ অঞ্চলের মানুষের স্বপ্ন বাস্তবায়ন হবে বলে আমরা আশাবাদী।আমরা শিক্ষার আলোয় আলোকিত হতে চাই এবং আমাদের মুক্তিযুদ্ধের মূল্যবোধে উদ্বুদ্ধ হয়ে আমাদের শিক্ষার্থীদের উন্নত মানুষ হিসেবে গড়ে তুলতে চাই।</div><div><br></div><div>মান সম্পন্ন শিক্ষা নিশ্চিত করণ এবং মানবিক মূল্যবোধ সম্পন্ন মানুষ গড়ে তোলাই ফাকল পুলিশ লাইন স্কুল অ্যান্ড কলেজের মূল উদ্দেশ্য । মুক্তিযুদ্ধের চেতনায় সমৃদ্ধ আলোকিত মানুষ গঠন ও ২০৪১ সালের উন্নত বাংলাদেশ উপযোগী আধুনিক শিক্ষায় শিক্ষিত মানব সম্পদ গঠনে প্রতিষ্ঠানটি ভূমিকা রাখবে বলে আমাদের বিশ্বাস।&nbsp;</div>', NULL, 'about1.jpg', '{\"cta_title\":\"Get in touch to join our community\",\"button_text\":\"Contact Our Office\",\"button_url\":\"contact\"}', 'This is a Smart School Management software for who want to make his school in Advance.', 'school management software,school managment software in bd,school managment software in elite design,elitedesign', 1);


#
# TABLE STRUCTURE FOR: front_cms_admission
#

DROP TABLE IF EXISTS `front_cms_admission`;

CREATE TABLE `front_cms_admission` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `page_title` varchar(255) DEFAULT NULL,
  `terms_conditions_title` varchar(255) DEFAULT NULL,
  `terms_conditions_description` text NOT NULL,
  `fee_elements` text DEFAULT NULL,
  `banner_image` varchar(255) DEFAULT NULL,
  `meta_description` text NOT NULL,
  `meta_keyword` text NOT NULL,
  `branch_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `front_cms_admission` (`id`, `title`, `description`, `page_title`, `terms_conditions_title`, `terms_conditions_description`, `fee_elements`, `banner_image`, `meta_description`, `meta_keyword`, `branch_id`) VALUES (1, 'অনলাইন এডমিশন ফরম', '<p>নিচের ফরমটি খুব সতর্কভাবে পুরন করুন, মনে রাখবেন যদি তথ্য ভুল বা মিথ্যা হয় তাহলে আবেদনটি বাতিল করা হবে।আবেদন ফি রিফান্ড যোগ্য নয়।</p>\r\n', 'অনলাইন এডমিশন', 'শর্তাবলী', '<p>মনে রাখবেন যদি তথ্য ভুল বা মিথ্যা হয় তাহলে আবেদনটি বাতিল করা হবে।আবেদন ফি রিফান্ড যোগ্য নয়।</p>', '[]', NULL, 'This is a Smart School Management software for who want to make his school in Advance.', 'school management software,school managment software in bd,school managment software in elite design,elitedesign', 1);


#
# TABLE STRUCTURE FOR: front_cms_admitcard
#

DROP TABLE IF EXISTS `front_cms_admitcard`;

CREATE TABLE `front_cms_admitcard` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_title` varchar(255) DEFAULT NULL,
  `templete_id` int(11) NOT NULL,
  `banner_image` varchar(255) DEFAULT NULL,
  `description` text NOT NULL,
  `meta_description` text NOT NULL,
  `meta_keyword` text NOT NULL,
  `branch_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `front_cms_admitcard` (`id`, `page_title`, `templete_id`, `banner_image`, `description`, `meta_description`, `meta_keyword`, `branch_id`) VALUES (1, 'এডমিট কার্ড', 2, NULL, '', ' This is a Smart School Management software for who want to make his school in Advance.', 'school management software,school managment software in bd,school managment software in elite design,elitedesign', 1);


#
# TABLE STRUCTURE FOR: front_cms_certificates
#

DROP TABLE IF EXISTS `front_cms_certificates`;

CREATE TABLE `front_cms_certificates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_title` varchar(255) DEFAULT NULL,
  `banner_image` varchar(255) DEFAULT NULL,
  `description` text NOT NULL,
  `meta_description` text NOT NULL,
  `meta_keyword` text NOT NULL,
  `branch_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `front_cms_certificates` (`id`, `page_title`, `banner_image`, `description`, `meta_description`, `meta_keyword`, `branch_id`) VALUES (1, 'সার্টিফিকেট', NULL, '', 'This is a Smart School Management software for who want to make his school in Advance.', 'school management software,school managment software in bd,school managment software in elite design,elitedesign', 1);


#
# TABLE STRUCTURE FOR: front_cms_contact
#

DROP TABLE IF EXISTS `front_cms_contact`;

CREATE TABLE `front_cms_contact` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `box_title` varchar(255) DEFAULT NULL,
  `box_description` varchar(500) DEFAULT NULL,
  `box_image` varchar(255) DEFAULT NULL,
  `form_title` varchar(355) DEFAULT NULL,
  `address` varchar(355) DEFAULT NULL,
  `phone` varchar(355) DEFAULT NULL,
  `email` varchar(355) DEFAULT NULL,
  `submit_text` varchar(355) DEFAULT NULL,
  `map_iframe` text DEFAULT NULL,
  `page_title` varchar(255) DEFAULT NULL,
  `banner_image` varchar(255) DEFAULT NULL,
  `meta_description` text DEFAULT NULL,
  `meta_keyword` text DEFAULT NULL,
  `branch_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `front_cms_contact` (`id`, `box_title`, `box_description`, `box_image`, `form_title`, `address`, `phone`, `email`, `submit_text`, `map_iframe`, `page_title`, `banner_image`, `meta_description`, `meta_keyword`, `branch_id`) VALUES (1, NULL, NULL, 'contact-info-box1.png', 'যোগাযোগ করতে নিচের আবেদন ফরমটি পুরন করুন', 'পুলিশ লাইন, মিশন মোড়, লালমনির হাট, সদর', '01775457008', 'info@elitedesign.com.bd', 'Send', NULL, 'যোগাযোগ', NULL, 'This is a Smart School Management software for who want to make his school in Advance.', 'school management software,school managment software in bd,school managment software in elite design,elitedesign', 1);


#
# TABLE STRUCTURE FOR: front_cms_events
#

DROP TABLE IF EXISTS `front_cms_events`;

CREATE TABLE `front_cms_events` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `page_title` varchar(255) DEFAULT NULL,
  `banner_image` varchar(255) DEFAULT NULL,
  `meta_description` text NOT NULL,
  `meta_keyword` text NOT NULL,
  `branch_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `front_cms_events` (`id`, `title`, `description`, `page_title`, `banner_image`, `meta_description`, `meta_keyword`, `branch_id`) VALUES (1, 'Upcoming Events', '<p>Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et. Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente ea proident.</p><p>Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven\'t heard of them accusamus labore sustainable VHS.</p>', 'ইভেন্ট', NULL, 'This is a Smart School Management software for who want to make his school in Advance.', 'school management software,school managment software in bd,school managment software in elite design,elitedesign', 1);


#
# TABLE STRUCTURE FOR: front_cms_exam_results
#

DROP TABLE IF EXISTS `front_cms_exam_results`;

CREATE TABLE `front_cms_exam_results` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_title` varchar(255) DEFAULT NULL,
  `grade_scale` tinyint(1) NOT NULL,
  `attendance` tinyint(1) NOT NULL,
  `banner_image` varchar(255) DEFAULT NULL,
  `description` text NOT NULL,
  `meta_description` text NOT NULL,
  `meta_keyword` text NOT NULL,
  `branch_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `front_cms_exam_results` (`id`, `page_title`, `grade_scale`, `attendance`, `banner_image`, `description`, `meta_description`, `meta_keyword`, `branch_id`) VALUES (1, 'পরীক্ষার রেজাল্ট', 1, 1, NULL, '', ' This is a Smart School Management software for who want to make his school in Advance.', 'school management software,school managment software in bd,school managment software in elite design,elitedesign', 1);


#
# TABLE STRUCTURE FOR: front_cms_faq
#

DROP TABLE IF EXISTS `front_cms_faq`;

CREATE TABLE `front_cms_faq` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `page_title` varchar(255) DEFAULT NULL,
  `banner_image` varchar(255) DEFAULT NULL,
  `meta_description` text NOT NULL,
  `meta_keyword` text NOT NULL,
  `branch_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `front_cms_faq` (`id`, `title`, `description`, `page_title`, `banner_image`, `meta_description`, `meta_keyword`, `branch_id`) VALUES (1, 'Frequently Asked Questions', '<p>Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et. Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente ea proident.</p>\r\n\r\n<p>Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven&#39;t heard of them accusamus labore sustainable VHS.</p>', 'ভিডিও গ্যালারী', NULL, 'This is a Smart School Management software for who want to make his school in Advance.', 'school management software,school managment software in bd,school managment software in elite design,elitedesign', 1);


#
# TABLE STRUCTURE FOR: front_cms_faq_list
#

DROP TABLE IF EXISTS `front_cms_faq_list`;

CREATE TABLE `front_cms_faq_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `branch_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `front_cms_faq_list` (`id`, `title`, `description`, `branch_id`) VALUES (9, 'PHaKAL 16 DECEMBER 2019', '9sFU2YiDdHw', 1);
INSERT INTO `front_cms_faq_list` (`id`, `title`, `description`, `branch_id`) VALUES (10, '26 MARCH 2019 PHaKAL DISPLAY', 'xbTn-DRfgFE', 1);
INSERT INTO `front_cms_faq_list` (`id`, `title`, `description`, `branch_id`) VALUES (11, 'জেলার সেরা প্রতিষ্ঠান লালমনিরহাটের ফাকল পুলিশ লাইন্স স্কুল অ্যান্ড কলেজ', 'V0FpkcUzFec', 1);


#
# TABLE STRUCTURE FOR: front_cms_gallery
#

DROP TABLE IF EXISTS `front_cms_gallery`;

CREATE TABLE `front_cms_gallery` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_title` varchar(255) DEFAULT NULL,
  `banner_image` varchar(255) DEFAULT NULL,
  `meta_description` text NOT NULL,
  `meta_keyword` text NOT NULL,
  `branch_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `front_cms_gallery` (`id`, `page_title`, `banner_image`, `meta_description`, `meta_keyword`, `branch_id`) VALUES (1, 'ফটো গ্যালারী', NULL, 'This is a Smart School Management software for who want to make his school in Advance.', 'school management software,school managment software in bd,school managment software in elite design,elitedesign', 1);


#
# TABLE STRUCTURE FOR: front_cms_gallery_category
#

DROP TABLE IF EXISTS `front_cms_gallery_category`;

CREATE TABLE `front_cms_gallery_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `branch_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `front_cms_gallery_category` (`id`, `name`, `branch_id`) VALUES (1, 'সাংস্কৃতিক অনুষ্ঠান', 1);


#
# TABLE STRUCTURE FOR: front_cms_gallery_content
#

DROP TABLE IF EXISTS `front_cms_gallery_content`;

CREATE TABLE `front_cms_gallery_content` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `thumb_image` varchar(255) NOT NULL,
  `date` date NOT NULL,
  `category_id` int(11) NOT NULL,
  `added_by` int(11) NOT NULL,
  `file_type` varchar(255) NOT NULL,
  `elements` longtext NOT NULL,
  `show_web` tinyint(4) NOT NULL DEFAULT 0,
  `branch_id` int(11) NOT NULL,
  `created_at` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `front_cms_gallery_content` (`id`, `title`, `alias`, `description`, `thumb_image`, `date`, `category_id`, `added_by`, `file_type`, `elements`, `show_web`, `branch_id`, `created_at`) VALUES (1, '1st s.s.c batch of phakal', '1st-ssc-batch-of-phakal', '1st s.s.c batch of phakal', 'gallery-1735634671.jpg', '2024-12-31', 1, 1, '', '[]', 1, 1, '2024-12-31');
INSERT INTO `front_cms_gallery_content` (`id`, `title`, `alias`, `description`, `thumb_image`, `date`, `category_id`, `added_by`, `file_type`, `elements`, `show_web`, `branch_id`, `created_at`) VALUES (2, 'অভিভাবগ সমাবেশে পুরুস্কার বিতরনী', 'অভভবগ-সমবশ-পরসকর-বতরন', 'অভিভাবগ সমাবেশে পুরুস্কার বিতরনী', 'gallery-1735635388.jpg', '2024-12-31', 1, 1, '', '[]', 1, 1, '2024-12-31');
INSERT INTO `front_cms_gallery_content` (`id`, `title`, `alias`, `description`, `thumb_image`, `date`, `category_id`, `added_by`, `file_type`, `elements`, `show_web`, `branch_id`, `created_at`) VALUES (3, 'SSC 2017 batch', 'ssc-2017-batch', 'SSC 2017 batch', 'gallery-1735760481.jpg', '2025-01-02', 1, 1, '', '[]', 1, 1, '2025-01-02');
INSERT INTO `front_cms_gallery_content` (`id`, `title`, `alias`, `description`, `thumb_image`, `date`, `category_id`, `added_by`, `file_type`, `elements`, `show_web`, `branch_id`, `created_at`) VALUES (4, 'Respect sir medam & sp sir', 'respect-sir-medam-sp-sir', 'Respect sir medam & sp sir', 'gallery-1735760640.jpg', '2025-01-02', 1, 1, '', '[]', 1, 1, '2025-01-02');
INSERT INTO `front_cms_gallery_content` (`id`, `title`, `alias`, `description`, `thumb_image`, `date`, `category_id`, `added_by`, `file_type`, `elements`, `show_web`, `branch_id`, `created_at`) VALUES (5, 'অভিভাবগ সমাবেশে পুরুস্কার বিতরনী', 'অভভবগ-সমবশ-পরসকর-বতরন-1', 'অভিভাবগ সমাবেশে পুরুস্কার বিতরনী', 'gallery-1735760710.jpg', '2025-01-02', 1, 1, '', '[]', 1, 1, '2025-01-02');
INSERT INTO `front_cms_gallery_content` (`id`, `title`, `alias`, `description`, `thumb_image`, `date`, `category_id`, `added_by`, `file_type`, `elements`, `show_web`, `branch_id`, `created_at`) VALUES (6, 'অভিভাবগ সমাবেশ', 'অভভবগ-সমবশ', 'অভিভাবগ সমাবেশ', 'gallery-1735760743.jpg', '2025-01-02', 1, 1, '', '[]', 1, 1, '2025-01-02');


#
# TABLE STRUCTURE FOR: front_cms_home
#

DROP TABLE IF EXISTS `front_cms_home`;

CREATE TABLE `front_cms_home` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` longtext DEFAULT NULL,
  `subtitle` varchar(255) DEFAULT NULL,
  `item_type` varchar(20) NOT NULL,
  `description` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `elements` mediumtext DEFAULT NULL,
  `color1` varchar(100) DEFAULT NULL,
  `color2` varchar(100) DEFAULT NULL,
  `branch_id` int(11) NOT NULL,
  `active` tinyint(3) NOT NULL DEFAULT 1,
  `principal_short_message` longtext DEFAULT NULL,
  `principal_long_message` longtext DEFAULT NULL,
  `sovapoti_short_message` longtext DEFAULT NULL,
  `sovapoti_long_message` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `color1`, `color2`, `branch_id`, `active`, `principal_short_message`, `principal_long_message`, `sovapoti_short_message`, `sovapoti_long_message`) VALUES (1, 'প্রতিষ্ঠানের ইতিহাস', NULL, 'wellcome', 'শিক্ষার্থীদের সুশিক্ষার শিক্ষিত করার লক্ষ্যে খ্রিস্টাব্দ থেকে ফাকল পুলিশ লাইন স্কুল এন্ড কলেজ লালমনিরহাট প্রতিষ্ঠানটি পাঠদান করে আসছে। ফাগল পুলিশ লাইন স্কুল এন্ড কলেজ লালমনিরহাট প্রতিষ্ঠানটি প্রতিষ্ঠার পেছনের মূল উদ্দেশ্য ভবিষ্যতের চ্যালেঞ্জ মোকাবেলা করা সর্বশেষ জ্ঞান তথ্য যোগাযোগ দক্ষতা এবং বাংলাদেশের সাংস্কৃতিক ঐতিহ্যের সংবিধান সহ একটি দৃষ্টিভঙ্গি সম্পর্কে শিক্ষা', '{\"image\":\"wellcome1.jpg\"}', NULL, NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `color1`, `color2`, `branch_id`, `active`, `principal_short_message`, `principal_long_message`, `sovapoti_short_message`, `sovapoti_long_message`) VALUES (2, 'বাংলাদেশের শিক্ষা ব্যবস্থার একটি পূর্ণাঙ্গ ধারা মাদরাসা শিক্ষা। সাধারণ শিক্ষার পাশপাশি সমান্তরালভাবে এটি বয়ে চলেছে দীর্ঘদিন ধরে এবং এ দেশের জন-মানসে তার স্থান করে নিয়েছে সুরক্ষিত ও সুদৃঢ়ভাবে। ধর্মীয় শিক্ষা ও জাগতিক', NULL, 'teachers', 'শিক্ষার্থীদের সু-শিক্ষায় শিক্ষিত করার লক্ষে ০১/০১/২০০৫ খ্রি: থেকে ফাকল পুলিশ লাইন্স স্কুল অ্যান্ড কলেজ, লালমনিরহাট প্রতিষ্ঠানটি পাঠদান করে আসছে । \r\n\r\nফাকল পুলিশ লাইন স্কুল অ্যান্ড কলেজ, লালমনিরহাট প্রতিষ্ঠানটি প্রতিষ্ঠার পিছনে মূল উদ্দেশ্য ভবিষ্যতের চ্যালেঞ্জ মোকাবেলা করা, সর্বশেষ জ্ঞান, তথ্য, যোগাযোগ দক্ষতা এবং বাংলাদেশী সাংস্কৃতিক ঐতিহ্যের সংমিশ্রণ সহ একটি দৃষ্টিভঙ্গি সম্পর্কে শিক্ষা প্রদানের মাধ্যমে আত্মবিশ্বাসী এবং সফল শিক্ষার্থীদের গড়ে তোলা । \r\n\r\n\r\nমানসম্পন্ন শিক্ষা নিশ্চিত করতে নিঃসন্দেহে মানুষের মন ও মস্তিষ্কের অনেক বেশি যত্ন প্রয়োজন। একাডেমিক অধ্যয়ন এবং সহ-পাঠক্রমিক কার্যক্রম একজন শিক্ষার্থীর শারীরিক ও মানসিক বিকাশ খুবই প্রয়োজনীয় একটি বিষয় এবং ফাকল পুলিশ লাইন স্কুল অ্যান্ড কলেজ, লালমনিরহাট একাডেমিক অধ্যয়ন এবং সহপাঠ্যক্রমিক কার্যক্রমের জন্য একটি সুন্দর পরিবেশ নিশ্চিত করনে প্রতিশ্রুতিবদ্ধ। \r\n\r\nফাকল পুলিশ লাইন স্কুল অ্যান্ড কলেজ, লালমনিরহাট প্রতিষ্ঠানের মাধ্যমে আমরা এ অঞ্চলের মানুষের স্বপ্ন বাস্তবায়ন হবে বলে আমরা আশাবাদী।আমরা শিক্ষার আলোয় আলোকিত হতে চাই এবং আমাদের মুক্তিযুদ্ধের মূল্যবোধে উদ্বুদ্ধ হয়ে আমাদের শিক্ষার্থীদের উন্নত মানুষ হিসেবে গড়ে তুলতে চাই।\r\n\r\nমান সম্পন্ন শিক্ষা নিশ্চিত করণ এবং মানবিক মূল্যবোধ সম্পন্ন মানুষ গড়ে তোলাই ফাকল পুলিশ লাইন স্কুল অ্যান্ড কলেজের মূল উদ্দেশ্য । মুক্তিযুদ্ধের চেতনায় সমৃদ্ধ আলোকিত মানুষ গঠন ও ২০৪১ সালের উন্নত বাংলাদেশ উপযোগী আধুনিক শিক্ষায় শিক্ষিত মানব সম্পদ গঠনে প্রতিষ্ঠানটি ভূমিকা রাখবে বলে আমাদের বিশ্বাস। \r\nআমি  প্রতিষ্ঠানটির সর্বাঙ্গীন মঙ্গল কামনা করি।\r\n\r\nশিক্ষার্থীদের সু-শিক্ষায় শিক্ষিত করার লক্ষে ০১/০১/২০০৫ খ্রি: থেকে ফাকল পুলিশ লাইন্স স্কুল অ্যান্ড কলেজ, লালমনিরহাট প্রতিষ্ঠানটি পাঠদান করে আসছে । \r\n\r\nফাকল পুলিশ লাইন স্কুল অ্যান্ড কলেজ, লালমনিরহাট প্রতিষ্ঠানটি প্রতিষ্ঠার পিছনে মূল উদ্দেশ্য ভবিষ্যতের চ্যালেঞ্জ মোকাবেলা করা, সর্বশেষ জ্ঞান, তথ্য, যোগাযোগ দক্ষতা এবং বাংলাদেশী সাংস্কৃতিক ঐতিহ্যের সংমিশ্রণ সহ একটি দৃষ্টিভঙ্গি সম্পর্কে শিক্ষা প্রদানের মাধ্যমে আত্মবিশ্বাসী এবং সফল শিক্ষার্থীদের গড়ে তোলা । \r\n\r\n\r\nমানসম্পন্ন শিক্ষা নিশ্চিত করতে নিঃসন্দেহে মানুষের মন ও মস্তিষ্কের অনেক বেশি যত্ন প্রয়োজন। একাডেমিক অধ্যয়ন এবং সহ-পাঠক্রমিক কার্যক্রম একজন শিক্ষার্থীর শারীরিক ও মানসিক বিকাশ খুবই প্রয়োজনীয় একটি বিষয় এবং ফাকল পুলিশ লাইন স্কুল অ্যান্ড কলেজ, লালমনিরহাট একাডেমিক অধ্যয়ন এবং সহপাঠ্যক্রমিক কার্যক্রমের জন্য একটি সুন্দর পরিবেশ নিশ্চিত করনে প্রতিশ্রুতিবদ্ধ। \r\n\r\nফাকল পুলিশ লাইন স্কুল অ্যান্ড কলেজ, লালমনিরহাট প্রতিষ্ঠানের মাধ্যমে আমরা এ অঞ্চলের মানুষের স্বপ্ন বাস্তবায়ন হবে বলে আমরা আশাবাদী।আমরা শিক্ষার আলোয় আলোকিত হতে চাই এবং আমাদের মুক্তিযুদ্ধের মূল্যবোধে উদ্বুদ্ধ হয়ে আমাদের শিক্ষার্থীদের উন্নত মানুষ হিসেবে গড়ে তুলতে চাই।\r\n\r\nমান সম্পন্ন শিক্ষা নিশ্চিত করণ এবং মানবিক মূল্যবোধ সম্পন্ন মানুষ গড়ে তোলাই ফাকল পুলিশ লাইন স্কুল অ্যান্ড কলেজের মূল উদ্দেশ্য । মুক্তিযুদ্ধের চেতনায় সমৃদ্ধ আলোকিত মানুষ গঠন ও ২০৪১ সালের উন্নত বাংলাদেশ উপযোগী আধুনিক শিক্ষায় শিক্ষিত মানব সম্পদ গঠনে প্রতিষ্ঠানটি ভূমিকা রাখবে বলে আমাদের বিশ্বাস। \r\nআমি  প্রতিষ্ঠানটির সর্বাঙ্গীন মঙ্গল কামনা করি।শিক্ষার্থীদের সু-শিক্ষায় শিক্ষিত করার লক্ষে ০১/০১/২০০৫ খ্রি: থেকে ফাকল পুলিশ লাইন্স স্কুল অ্যান্ড কলেজ, লালমনিরহাট প্রতিষ্ঠানটি পাঠদান করে আসছে । \r\n\r\nফাকল পুলিশ লাইন স্কুল অ্যান্ড কলেজ, লালমনিরহাট প্রতিষ্ঠানটি প্রতিষ্ঠার পিছনে মূল উদ্দেশ্য ভবিষ্যতের চ্যালেঞ্জ মোকাবেলা করা, সর্বশেষ জ্ঞান, তথ্য, যোগাযোগ দক্ষতা এবং বাংলাদেশী সাংস্কৃতিক ঐতিহ্যের সংমিশ্রণ সহ একটি দৃষ্টিভঙ্গি সম্পর্কে শিক্ষা প্রদানের মাধ্যমে আত্মবিশ্বাসী এবং সফল শিক্ষার্থীদের গড়ে তোলা । \r\n\r\n\r\nমানসম্পন্ন শিক্ষা নিশ্চিত করতে নিঃসন্দেহে মানুষের মন ও মস্তিষ্কের অনেক বেশি যত্ন প্রয়োজন। একাডেমিক অধ্যয়ন এবং সহ-পাঠক্রমিক কার্যক্রম একজন শিক্ষার্থীর শারীরিক ও মানসিক বিকাশ খুবই প্রয়োজনীয় একটি বিষয় এবং ফাকল পুলিশ লাইন স্কুল অ্যান্ড কলেজ, লালমনিরহাট একাডেমিক অধ্যয়ন এবং সহপাঠ্যক্রমিক কার্যক্রমের জন্য একটি সুন্দর পরিবেশ নিশ্চিত করনে প্রতিশ্রুতিবদ্ধ। \r\n\r\nফাকল পুলিশ লাইন স্কুল অ্যান্ড কলেজ, লালমনিরহাট প্রতিষ্ঠানের মাধ্যমে আমরা এ অঞ্চলের মানুষের স্বপ্ন বাস্তবায়ন হবে বলে আমরা আশাবাদী।আমরা শিক্ষার আলোয় আলোকিত হতে চাই এবং আমাদের মুক্তিযুদ্ধের মূল্যবোধে উদ্বুদ্ধ হয়ে আমাদের শিক্ষার্থীদের উন্নত মানুষ হিসেবে গড়ে তুলতে চাই।\r\n\r\nমান সম্পন্ন শিক্ষা নিশ্চিত করণ এবং মানবিক মূল্যবোধ সম্পন্ন মানুষ গড়ে তোলাই ফাকল পুলিশ লাইন স্কুল অ্যান্ড কলেজের মূল উদ্দেশ্য । মুক্তিযুদ্ধের চেতনায় সমৃদ্ধ আলোকিত মানুষ গঠন ও ২০৪১ সালের উন্নত বাংলাদেশ উপযোগী আধুনিক শিক্ষায় শিক্ষিত মানব সম্পদ গঠনে প্রতিষ্ঠানটি ভূমিকা রাখবে বলে আমাদের বিশ্বাস। \r\nআমি  প্রতিষ্ঠানটির সর্বাঙ্গীন মঙ্গল কামনা করি।শিক্ষার্থীদের সু-শিক্ষায় শিক্ষিত করার লক্ষে ০১/০১/২০০৫ খ্রি: থেকে ফাকল পুলিশ লাইন্স স্কুল অ্যান্ড কলেজ, লালমনিরহাট প্রতিষ্ঠানটি পাঠদান করে আসছে । \r\n\r\nফাকল পুলিশ লাইন স্কুল অ্যান্ড কলেজ, লালমনিরহাট প্রতিষ্ঠানটি প্রতিষ্ঠার পিছনে মূল উদ্দেশ্য ভবিষ্যতের চ্যালেঞ্জ মোকাবেলা করা, সর্বশেষ জ্ঞান, তথ্য, যোগাযোগ দক্ষতা এবং বাংলাদেশী সাংস্কৃতিক ঐতিহ্যের সংমিশ্রণ সহ একটি দৃষ্টিভঙ্গি সম্পর্কে শিক্ষা প্রদানের মাধ্যমে আত্মবিশ্বাসী এবং সফল শিক্ষার্থীদের গড়ে তোলা । \r\n\r\n\r\nমানসম্পন্ন শিক্ষা নিশ্চিত করতে নিঃসন্দেহে মানুষের মন ও মস্তিষ্কের অনেক বেশি যত্ন প্রয়োজন। একাডেমিক অধ্যয়ন এবং সহ-পাঠক্রমিক কার্যক্রম একজন শিক্ষার্থীর শারীরিক ও মানসিক বিকাশ খুবই প্রয়োজনীয় একটি বিষয় এবং ফাকল পুলিশ লাইন স্কুল অ্যান্ড কলেজ, লালমনিরহাট একাডেমিক অধ্যয়ন এবং সহপাঠ্যক্রমিক কার্যক্রমের জন্য একটি সুন্দর পরিবেশ নিশ্চিত করনে প্রতিশ্রুতিবদ্ধ। \r\n\r\nফাকল পুলিশ লাইন স্কুল অ্যান্ড কলেজ, লালমনিরহাট প্রতিষ্ঠানের মাধ্যমে আমরা এ অঞ্চলের মানুষের স্বপ্ন বাস্তবায়ন হবে বলে আমরা আশাবাদী।আমরা শিক্ষার আলোয় আলোকিত হতে চাই এবং আমাদের মুক্তিযুদ্ধের মূল্যবোধে উদ্বুদ্ধ হয়ে আমাদের শিক্ষার্থীদের উন্নত মানুষ হিসেবে গড়ে তুলতে চাই।\r\n\r\nমান সম্পন্ন শিক্ষা নিশ্চিত করণ এবং মানবিক মূল্যবোধ সম্পন্ন মানুষ গড়ে তোলাই ফাকল পুলিশ লাইন স্কুল অ্যান্ড কলেজের মূল উদ্দেশ্য । মুক্তিযুদ্ধের চেতনায় সমৃদ্ধ আলোকিত মানুষ গঠন ও ২০৪১ সালের উন্নত বাংলাদেশ উপযোগী আধুনিক শিক্ষায় শিক্ষিত মানব সম্পদ গঠনে প্রতিষ্ঠানটি ভূমিকা রাখবে বলে আমাদের বিশ্বাস। \r\nআমি  প্রতিষ্ঠানটির সর্বাঙ্গীন মঙ্গল কামনা করি।শিক্ষার্থীদের সু-শিক্ষায় শিক্ষিত করার লক্ষে ০১/০১/২০০৫ খ্রি: থেকে ফাকল পুলিশ লাইন্স স্কুল অ্যান্ড কলেজ, লালমনিরহাট প্রতিষ্ঠানটি পাঠদান করে আসছে । \r\n\r\nফাকল পুলিশ লাইন স্কুল অ্যান্ড কলেজ, লালমনিরহাট প্রতিষ্ঠানটি প্রতিষ্ঠার পিছনে মূল উদ্দেশ্য ভবিষ্যতের চ্যালেঞ্জ মোকাবেলা করা, সর্বশেষ জ্ঞান, তথ্য, যোগাযোগ দক্ষতা এবং বাংলাদেশী সাংস্কৃতিক ঐতিহ্যের সংমিশ্রণ সহ একটি দৃষ্টিভঙ্গি সম্পর্কে শিক্ষা প্রদানের মাধ্যমে আত্মবিশ্বাসী এবং সফল শিক্ষার্থীদের গড়ে তোলা । \r\n\r\n\r\nমানসম্পন্ন শিক্ষা নিশ্চিত করতে নিঃসন্দেহে মানুষের মন ও মস্তিষ্কের অনেক বেশি যত্ন প্রয়োজন। একাডেমিক অধ্যয়ন এবং সহ-পাঠক্রমিক কার্যক্রম একজন শিক্ষার্থীর শারীরিক ও মানসিক বিকাশ খুবই প্রয়োজনীয় একটি বিষয় এবং ফাকল পুলিশ লাইন স্কুল অ্যান্ড কলেজ, লালমনিরহাট একাডেমিক অধ্যয়ন এবং সহপাঠ্যক্রমিক কার্যক্রমের জন্য একটি সুন্দর পরিবেশ নিশ্চিত করনে প্রতিশ্রুতিবদ্ধ। \r\n\r\nফাকল পুলিশ লাইন স্কুল অ্যান্ড কলেজ, লালমনিরহাট প্রতিষ্ঠানের মাধ্যমে আমরা এ অঞ্চলের মানুষের স্বপ্ন বাস্তবায়ন হবে বলে আমরা আশাবাদী।আমরা শিক্ষার আলোয় আলোকিত হতে চাই এবং আমাদের মুক্তিযুদ্ধের মূল্যবোধে উদ্বুদ্ধ হয়ে আমাদের শিক্ষার্থীদের উন্নত মানুষ হিসেবে গড়ে তুলতে চাই।', '{\"teacher_start\":null,\"image\":null}', NULL, NULL, 1, 1, NULL, 'বাংলাদেশের শিক্ষা ব্যবস্থার একটি পূর্ণাঙ্গ ধারা মাদরাসা শিক্ষা। সাধারণ শিক্ষার পাশপাশি সমান্তরালভাবে এটি বয়ে চলেছে দীর্ঘদিন ধরে এবং এ দেশের জন-মানসে তার স্থান করে নিয়েছে সুরক্ষিত ও সুদৃঢ়ভাবে। \r\n\r\nধর্মীয় শিক্ষা ও জাগতিক শিক্ষা দুটি পরস্পরের পরিপুরক। এ সমন্বিত ইসলামী শিক্ষা ব্যবস্থার প্রতিষ্ঠানিক রুপই হচ্ছে মাদরাসা শিক্ষা। ইহলৌকিক উন্নতির সাথে সাথে পারলৌকিক মুক্তির পথ দেখাতেই প্রতিষ্ঠা করা হয়েছে “আল জান্নাত ইসলামিক এডুকেশন ইনস্টিটিউট”।\r\n বাংলাদেশের দেড় সহস্রাধিক ফাযিল মাদরাসার মিছিলে ২০০২ সালে প্রতিষ্ঠিত এ মাদরাসাটি বিগত ২০১৬ সালে যোগ হলো।\r\n\r\nমাদরাসা শিক্ষা ব্যবস্থাকে সার্বজনীন মানসম্মত করার জন্য অপরিহার্য হচ্ছে অঙ্গীকার ও সার্বিক গুণগত ব্যবস্থাপনা এবং সৃজনশীল ও উদ্ভাবনীমূলক শিক্ষা কার্যক্রম পরিচালনার জন্য দরকার অনুকুল অবকাঠামো ও পরিবেশ। \r\n\r\nআমরা অঙ্গীকারাবদ্ধ, গুণগত ব্যবস্থাপনায় সদা সচেষ্ঠ এবং অবকাঠামো ও পরিবেশগত দিক দিয়ে মাশাল্লাহ্ জেলায় শ্রেষ্ঠত্বের দাবিদার। \r\n\r\nতাই, আসুন আমরা যার যার অবস্থান থেকে সাহায্য করে যেমন, কেউ ছাত্র-ছাত্রী দিয়ে, কেউ মেধা দিয়ে, কেউবা পরামর্শ দিয়ে মাদরাসাটিকে সামনের দিকে এগিয়ে নিয়ে যাই। \r\n\r\nবাংলাদেশের শিক্ষা ব্যবস্থার একটি পূর্ণাঙ্গ ধারা মাদরাসা শিক্ষা। সাধারণ শিক্ষার পাশপাশি সমান্তরালভাবে এটি বয়ে চলেছে দীর্ঘদিন ধরে এবং এ দেশের জন-মানসে তার স্থান করে নিয়েছে সুরক্ষিত ও সুদৃঢ়ভাবে। \r\n\r\nধর্মীয় শিক্ষা ও জাগতিক শিক্ষা দুটি পরস্পরের পরিপুরক। এ সমন্বিত ইসলামী শিক্ষা ব্যবস্থার প্রতিষ্ঠানিক রুপই হচ্ছে মাদরাসা শিক্ষা। ইহলৌকিক উন্নতির সাথে সাথে পারলৌকিক মুক্তির পথ দেখাতেই প্রতিষ্ঠা করা হয়েছে “আল জান্নাত ইসলামিক এডুকেশন ইনস্টিটিউট”।\r\n বাংলাদেশের দেড় সহস্রাধিক ফাযিল মাদরাসার মিছিলে ২০০২ সালে প্রতিষ্ঠিত এ মাদরাসাটি বিগত ২০১৬ সালে যোগ হলো।\r\n\r\nমাদরাসা শিক্ষা ব্যবস্থাকে সার্বজনীন মানসম্মত করার জন্য অপরিহার্য হচ্ছে অঙ্গীকার ও সার্বিক গুণগত ব্যবস্থাপনা এবং সৃজনশীল ও উদ্ভাবনীমূলক শিক্ষা কার্যক্রম পরিচালনার জন্য দরকার অনুকুল অবকাঠামো ও পরিবেশ। \r\n\r\nআমরা অঙ্গীকারাবদ্ধ, গুণগত ব্যবস্থাপনায় সদা সচেষ্ঠ এবং অবকাঠামো ও পরিবেশগত দিক দিয়ে মাশাল্লাহ্ জেলায় শ্রেষ্ঠত্বের দাবিদার। \r\n\r\nতাই, আসুন আমরা যার যার অবস্থান থেকে সাহায্য করে যেমন, কেউ ছাত্র-ছাত্রী দিয়ে, কেউ মেধা দিয়ে, কেউবা পরামর্শ দিয়ে মাদরাসাটিকে সামনের দিকে এগিয়ে নিয়ে যাই। বাংলাদেশের শিক্ষা ব্যবস্থার একটি পূর্ণাঙ্গ ধারা মাদরাসা শিক্ষা। সাধারণ শিক্ষার পাশপাশি সমান্তরালভাবে এটি বয়ে চলেছে দীর্ঘদিন ধরে এবং এ দেশের জন-মানসে তার স্থান করে নিয়েছে সুরক্ষিত ও সুদৃঢ়ভাবে। \r\n\r\nধর্মীয় শিক্ষা ও জাগতিক শিক্ষা দুটি পরস্পরের পরিপুরক। এ সমন্বিত ইসলামী শিক্ষা ব্যবস্থার প্রতিষ্ঠানিক রুপই হচ্ছে মাদরাসা শিক্ষা। ইহলৌকিক উন্নতির সাথে সাথে পারলৌকিক মুক্তির পথ দেখাতেই প্রতিষ্ঠা করা হয়েছে “আল জান্নাত ইসলামিক এডুকেশন ইনস্টিটিউট”।\r\n বাংলাদেশের দেড় সহস্রাধিক ফাযিল মাদরাসার মিছিলে ২০০২ সালে প্রতিষ্ঠিত এ মাদরাসাটি বিগত ২০১৬ সালে যোগ হলো।\r\n\r\nমাদরাসা শিক্ষা ব্যবস্থাকে সার্বজনীন মানসম্মত করার জন্য অপরিহার্য হচ্ছে অঙ্গীকার ও সার্বিক গুণগত ব্যবস্থাপনা এবং সৃজনশীল ও উদ্ভাবনীমূলক শিক্ষা কার্যক্রম পরিচালনার জন্য দরকার অনুকুল অবকাঠামো ও পরিবেশ। \r\n\r\nআমরা অঙ্গীকারাবদ্ধ, গুণগত ব্যবস্থাপনায় সদা সচেষ্ঠ এবং অবকাঠামো ও পরিবেশগত দিক দিয়ে মাশাল্লাহ্ জেলায় শ্রেষ্ঠত্বের দাবিদার। \r\n\r\nতাই, আসুন আমরা যার যার অবস্থান থেকে সাহায্য করে যেমন, কেউ ছাত্র-ছাত্রী দিয়ে, কেউ মেধা দিয়ে, কেউবা পরামর্শ দিয়ে মাদরাসাটিকে সামনের দিকে এগিয়ে নিয়ে যাই। বাংলাদেশের শিক্ষা ব্যবস্থার একটি পূর্ণাঙ্গ ধারা মাদরাসা শিক্ষা। সাধারণ শিক্ষার পাশপাশি সমান্তরালভাবে এটি বয়ে চলেছে দীর্ঘদিন ধরে এবং এ দেশের জন-মানসে তার স্থান করে নিয়েছে সুরক্ষিত ও সুদৃঢ়ভাবে। \r\n\r\nধর্মীয় শিক্ষা ও জাগতিক শিক্ষা দুটি পরস্পরের পরিপুরক। এ সমন্বিত ইসলামী শিক্ষা ব্যবস্থার প্রতিষ্ঠানিক রুপই হচ্ছে মাদরাসা শিক্ষা। ইহলৌকিক উন্নতির সাথে সাথে পারলৌকিক মুক্তির পথ দেখাতেই প্রতিষ্ঠা করা হয়েছে “আল জান্নাত ইসলামিক এডুকেশন ইনস্টিটিউট”।\r\n বাংলাদেশের দেড় সহস্রাধিক ফাযিল মাদরাসার মিছিলে ২০০২ সালে প্রতিষ্ঠিত এ মাদরাসাটি বিগত ২০১৬ সালে যোগ হলো।\r\n\r\nমাদরাসা শিক্ষা ব্যবস্থাকে সার্বজনীন মানসম্মত করার জন্য অপরিহার্য হচ্ছে অঙ্গীকার ও সার্বিক গুণগত ব্যবস্থাপনা এবং সৃজনশীল ও উদ্ভাবনীমূলক শিক্ষা কার্যক্রম পরিচালনার জন্য দরকার অনুকুল অবকাঠামো ও পরিবেশ। \r\n\r\nআমরা অঙ্গীকারাবদ্ধ, গুণগত ব্যবস্থাপনায় সদা সচেষ্ঠ এবং অবকাঠামো ও পরিবেশগত দিক দিয়ে মাশাল্লাহ্ জেলায় শ্রেষ্ঠত্বের দাবিদার। \r\n\r\nতাই, আসুন আমরা যার যার অবস্থান থেকে সাহায্য করে যেমন, কেউ ছাত্র-ছাত্রী দিয়ে, কেউ মেধা দিয়ে, কেউবা পরামর্শ দিয়ে মাদরাসাটিকে সামনের দিকে এগিয়ে নিয়ে যাই। ', 'বাংলাদেশের শিক্ষা ব্যবস্থার একটি পূর্ণাঙ্গ ধারা মাদরাসা শিক্ষা। সাধারণ শিক্ষার পাশপাশি সমান্তরালভাবে এটি বয়ে চলেছে দীর্ঘদিন ধরে এবং এ দেশের জন-মানসে তার স্থান করে নিয়েছে সুরক্ষিত ও সুদৃঢ়ভাবে। ধর্মীয় শিক্ষা ও জাগতিক', NULL);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `color1`, `color2`, `branch_id`, `active`, `principal_short_message`, `principal_long_message`, `sovapoti_short_message`, `sovapoti_long_message`) VALUES (3, 'WHY CHOOSE US', NULL, 'services', 'Lorem Ipsum is simply dummy text of the printing and typesetting industry.', '', NULL, NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `color1`, `color2`, `branch_id`, `active`, `principal_short_message`, `principal_long_message`, `sovapoti_short_message`, `sovapoti_long_message`) VALUES (4, 'Request for a free Education Class', 'Medical Services', 'cta', '', '{\"mobile_no\":\"+2484-398-8987\",\"button_text\":\"Request Now\",\"button_url\":\"http:\\/\\/localhost\\/multi_pro\\/home\\/admission\\/\"}', NULL, NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `color1`, `color2`, `branch_id`, `active`, `principal_short_message`, `principal_long_message`, `sovapoti_short_message`, `sovapoti_long_message`) VALUES (7, 'Online Classes', NULL, 'features', 'Nulla metus metus ullamcorper vel tincidunt sed euismod nibh Quisque volutpat condimentum velit class aptent taciti sociosqu.', '{\"button_text\":\"Read More\",\"button_url\":\"#\",\"icon\":\"fas fa-video\"}', NULL, NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `color1`, `color2`, `branch_id`, `active`, `principal_short_message`, `principal_long_message`, `sovapoti_short_message`, `sovapoti_long_message`) VALUES (8, 'Scholarship', NULL, 'features', 'Nulla metus metus ullamcorper vel tincidunt sed euismod nibh Quisque volutpat condimentum velit class aptent taciti sociosqu.', '{\"button_text\":\"Read More\",\"button_url\":\"#\",\"icon\":\"fas fa-graduation-cap\"}', NULL, NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `color1`, `color2`, `branch_id`, `active`, `principal_short_message`, `principal_long_message`, `sovapoti_short_message`, `sovapoti_long_message`) VALUES (9, 'Books & Liberary', NULL, 'features', 'Nulla metus metus ullamcorper vel tincidunt sed euismod nibh Quisque volutpat condimentum velit class aptent taciti sociosqu.', '{\"button_text\":\"Read More\",\"button_url\":\"#\",\"icon\":\"fas fa-book-reader\"}', NULL, NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `color1`, `color2`, `branch_id`, `active`, `principal_short_message`, `principal_long_message`, `sovapoti_short_message`, `sovapoti_long_message`) VALUES (10, 'Trending Courses', NULL, 'features', 'Nulla metus metus ullamcorper vel tincidunt sed euismod nibh Quisque volutpat condimentum velit class aptent taciti sociosqu.', '{\"button_text\":\"Read More\",\"button_url\":\"#\",\"icon\":\"fab fa-discourse\"}', NULL, NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `color1`, `color2`, `branch_id`, `active`, `principal_short_message`, `principal_long_message`, `sovapoti_short_message`, `sovapoti_long_message`) VALUES (11, 'WHAT PEOPLE SAYS', NULL, 'testimonial', 'Fusce sem dolor, interdum in efficitur at, faucibus nec lorem. Sed nec molestie justo.', '', NULL, NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `color1`, `color2`, `branch_id`, `active`, `principal_short_message`, `principal_long_message`, `sovapoti_short_message`, `sovapoti_long_message`) VALUES (12, '20 years experience in the field of study', NULL, 'statistics', 'Lorem Ipsum is simply dummy text printer took a galley of type and scrambled it to make a type specimen book.', '{\"image\":\"counter-parallax1.jpg\",\"widget_title_1\":\"Certified Teachers\",\"widget_icon_1\":\"fas fa-user-tie\",\"type_1\":\"teacher\",\"widget_title_2\":\"Students Enrolled\",\"widget_icon_2\":\"fas fa-user-graduate\",\"type_2\":\"student\",\"widget_title_3\":\"Classes\",\"widget_icon_3\":\"fas fa-graduation-cap\",\"type_3\":\"class\",\"widget_title_4\":\"Section\",\"widget_icon_4\":\"fas fa-award\",\"type_4\":\"section\"}', NULL, NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `color1`, `color2`, `branch_id`, `active`, `principal_short_message`, `principal_long_message`, `sovapoti_short_message`, `sovapoti_long_message`) VALUES (13, 'ফাকল পুলিশ লাইন্স স্কুল অ্যান্ড কলেজ', NULL, 'slider', NULL, '{\"position\":null,\"button_text1\":null,\"button_url1\":null,\"button_text2\":null,\"button_url2\":null,\"image\":\"home-slider-1735579176.jpg\"}', NULL, NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `color1`, `color2`, `branch_id`, `active`, `principal_short_message`, `principal_long_message`, `sovapoti_short_message`, `sovapoti_long_message`) VALUES (14, 'সুবিশাল আধুনিক কম্পিউটার ল্যাব', NULL, 'slider', NULL, '{\"position\":null,\"button_text1\":null,\"button_url1\":null,\"button_text2\":null,\"button_url2\":null,\"image\":\"home-slider-1735579541.jpg\"}', NULL, NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `color1`, `color2`, `branch_id`, `active`, `principal_short_message`, `principal_long_message`, `sovapoti_short_message`, `sovapoti_long_message`) VALUES (15, 'সুবিশাল বইয়ের লাইব্রেরী (হরেক রকম বইয়ের সমাহার)', NULL, 'slider', NULL, '{\"position\":null,\"button_text1\":null,\"button_url1\":null,\"button_text2\":null,\"button_url2\":null,\"image\":\"home-slider-1735579608.jpg\"}', NULL, NULL, 1, 1, NULL, NULL, NULL, NULL);


#
# TABLE STRUCTURE FOR: front_cms_home_seo
#

DROP TABLE IF EXISTS `front_cms_home_seo`;

CREATE TABLE `front_cms_home_seo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_title` varchar(255) NOT NULL,
  `meta_keyword` text NOT NULL,
  `meta_description` text NOT NULL,
  `branch_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `front_cms_home_seo` (`id`, `page_title`, `meta_keyword`, `meta_description`, `branch_id`) VALUES (1, 'ফাকল পুলিশ লাইন্স স্কুল অ্যান্ড কলেজ', 'school management software,school managment software in bd,school managment software in elite design,elitedesign', 'This is a Smart School Management software for who want to make his school in Advance.', 1);


#
# TABLE STRUCTURE FOR: front_cms_menu
#

DROP TABLE IF EXISTS `front_cms_menu`;

CREATE TABLE `front_cms_menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `alias` varchar(100) NOT NULL,
  `ordering` int(11) NOT NULL,
  `parent_id` int(11) DEFAULT 0,
  `open_new_tab` int(11) NOT NULL DEFAULT 0,
  `ext_url` tinyint(3) NOT NULL DEFAULT 0,
  `ext_url_address` text DEFAULT NULL,
  `publish` tinyint(3) NOT NULL,
  `system` tinyint(3) NOT NULL,
  `branch_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `front_cms_menu` (`id`, `title`, `alias`, `ordering`, `parent_id`, `open_new_tab`, `ext_url`, `ext_url_address`, `publish`, `system`, `branch_id`, `created_at`) VALUES (1, 'Home', '', 1, 0, 0, 0, '', 1, 1, 0, '2019-08-09 18:18:54');
INSERT INTO `front_cms_menu` (`id`, `title`, `alias`, `ordering`, `parent_id`, `open_new_tab`, `ext_url`, `ext_url_address`, `publish`, `system`, `branch_id`, `created_at`) VALUES (2, 'Events', 'events', 3, 0, 0, 0, '', 1, 1, 0, '2019-08-09 18:18:54');
INSERT INTO `front_cms_menu` (`id`, `title`, `alias`, `ordering`, `parent_id`, `open_new_tab`, `ext_url`, `ext_url_address`, `publish`, `system`, `branch_id`, `created_at`) VALUES (3, 'Teachers', 'teachers', 2, 0, 0, 0, '', 1, 1, 0, '2019-08-09 18:18:54');
INSERT INTO `front_cms_menu` (`id`, `title`, `alias`, `ordering`, `parent_id`, `open_new_tab`, `ext_url`, `ext_url_address`, `publish`, `system`, `branch_id`, `created_at`) VALUES (4, 'About Us', 'about', 4, 0, 0, 0, '', 1, 1, 0, '2019-08-09 18:18:54');
INSERT INTO `front_cms_menu` (`id`, `title`, `alias`, `ordering`, `parent_id`, `open_new_tab`, `ext_url`, `ext_url_address`, `publish`, `system`, `branch_id`, `created_at`) VALUES (5, 'FAQ', 'faq', 5, 0, 0, 0, '', 1, 1, 0, '2019-08-09 18:18:54');
INSERT INTO `front_cms_menu` (`id`, `title`, `alias`, `ordering`, `parent_id`, `open_new_tab`, `ext_url`, `ext_url_address`, `publish`, `system`, `branch_id`, `created_at`) VALUES (6, 'Online Admission', 'admission', 6, 0, 0, 0, '', 1, 1, 0, '2019-08-09 18:18:54');
INSERT INTO `front_cms_menu` (`id`, `title`, `alias`, `ordering`, `parent_id`, `open_new_tab`, `ext_url`, `ext_url_address`, `publish`, `system`, `branch_id`, `created_at`) VALUES (7, 'Contact Us', 'contact', 13, 0, 0, 0, '', 1, 1, 0, '2019-08-09 18:18:54');
INSERT INTO `front_cms_menu` (`id`, `title`, `alias`, `ordering`, `parent_id`, `open_new_tab`, `ext_url`, `ext_url_address`, `publish`, `system`, `branch_id`, `created_at`) VALUES (8, 'Pages', 'pages', 9, 0, 0, 1, '#', 1, 1, 0, '2019-08-09 18:18:54');
INSERT INTO `front_cms_menu` (`id`, `title`, `alias`, `ordering`, `parent_id`, `open_new_tab`, `ext_url`, `ext_url_address`, `publish`, `system`, `branch_id`, `created_at`) VALUES (9, 'Admit Card', 'admit_card', 10, 8, 0, 0, '', 1, 1, 0, '2021-03-16 10:24:32');
INSERT INTO `front_cms_menu` (`id`, `title`, `alias`, `ordering`, `parent_id`, `open_new_tab`, `ext_url`, `ext_url_address`, `publish`, `system`, `branch_id`, `created_at`) VALUES (10, 'Exam Results', 'exam_results', 11, 8, 0, 0, '', 1, 1, 0, '2021-03-16 10:24:32');
INSERT INTO `front_cms_menu` (`id`, `title`, `alias`, `ordering`, `parent_id`, `open_new_tab`, `ext_url`, `ext_url_address`, `publish`, `system`, `branch_id`, `created_at`) VALUES (11, 'Certificates', 'certificates', 12, 8, 0, 0, '', 1, 1, 0, '2021-03-21 18:04:44');
INSERT INTO `front_cms_menu` (`id`, `title`, `alias`, `ordering`, `parent_id`, `open_new_tab`, `ext_url`, `ext_url_address`, `publish`, `system`, `branch_id`, `created_at`) VALUES (12, 'Gallery', 'gallery', 7, 0, 0, 0, '', 1, 1, 0, '2021-03-21 18:04:44');
INSERT INTO `front_cms_menu` (`id`, `title`, `alias`, `ordering`, `parent_id`, `open_new_tab`, `ext_url`, `ext_url_address`, `publish`, `system`, `branch_id`, `created_at`) VALUES (13, 'News', 'news', 8, 0, 0, 0, '', 1, 1, 0, '2024-05-12 20:50:05');


#
# TABLE STRUCTURE FOR: front_cms_menu_visible
#

DROP TABLE IF EXISTS `front_cms_menu_visible`;

CREATE TABLE `front_cms_menu_visible` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `menu_id` int(11) NOT NULL,
  `parent_id` varchar(11) DEFAULT NULL,
  `ordering` varchar(20) DEFAULT NULL,
  `invisible` tinyint(2) NOT NULL DEFAULT 1,
  `branch_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `front_cms_menu_visible` (`id`, `name`, `menu_id`, `parent_id`, `ordering`, `invisible`, `branch_id`) VALUES (2, 'হোম', 1, '0', '0', 1, 1);
INSERT INTO `front_cms_menu_visible` (`id`, `name`, `menu_id`, `parent_id`, `ordering`, `invisible`, `branch_id`) VALUES (3, 'শিক্ষক', 3, '0', '2', 0, 1);
INSERT INTO `front_cms_menu_visible` (`id`, `name`, `menu_id`, `parent_id`, `ordering`, `invisible`, `branch_id`) VALUES (4, 'ইভেন্ট', 2, '0', '3', 1, 1);
INSERT INTO `front_cms_menu_visible` (`id`, `name`, `menu_id`, `parent_id`, `ordering`, `invisible`, `branch_id`) VALUES (5, 'প্রতিষ্ঠানের ইতিহাস', 4, '0', '1', 0, 1);
INSERT INTO `front_cms_menu_visible` (`id`, `name`, `menu_id`, `parent_id`, `ordering`, `invisible`, `branch_id`) VALUES (6, 'ভিডিও গ্যালারী', 5, '0', '8', 0, 1);
INSERT INTO `front_cms_menu_visible` (`id`, `name`, `menu_id`, `parent_id`, `ordering`, `invisible`, `branch_id`) VALUES (7, 'অনলাইন এডমিশন', 6, '0', '6', 0, 1);
INSERT INTO `front_cms_menu_visible` (`id`, `name`, `menu_id`, `parent_id`, `ordering`, `invisible`, `branch_id`) VALUES (8, 'ফটো গ্যালারী', 12, '0', '7', 0, 1);
INSERT INTO `front_cms_menu_visible` (`id`, `name`, `menu_id`, `parent_id`, `ordering`, `invisible`, `branch_id`) VALUES (9, 'নোটিশ', 13, '0', '8', 0, 1);
INSERT INTO `front_cms_menu_visible` (`id`, `name`, `menu_id`, `parent_id`, `ordering`, `invisible`, `branch_id`) VALUES (10, 'একাডেমিক তথ্য', 8, NULL, '9', 0, 1);
INSERT INTO `front_cms_menu_visible` (`id`, `name`, `menu_id`, `parent_id`, `ordering`, `invisible`, `branch_id`) VALUES (11, 'এডমিট কার্ড', 9, '8', '10', 0, 1);
INSERT INTO `front_cms_menu_visible` (`id`, `name`, `menu_id`, `parent_id`, `ordering`, `invisible`, `branch_id`) VALUES (12, 'পরীক্ষার রেজাল্ট', 10, '8', '11', 0, 1);
INSERT INTO `front_cms_menu_visible` (`id`, `name`, `menu_id`, `parent_id`, `ordering`, `invisible`, `branch_id`) VALUES (13, 'সার্টিফিকেট', 11, '8', '12', 0, 1);
INSERT INTO `front_cms_menu_visible` (`id`, `name`, `menu_id`, `parent_id`, `ordering`, `invisible`, `branch_id`) VALUES (14, 'যোগাযোগ', 7, '0', '13', 0, 1);


#
# TABLE STRUCTURE FOR: front_cms_news
#

DROP TABLE IF EXISTS `front_cms_news`;

CREATE TABLE `front_cms_news` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `page_title` varchar(255) DEFAULT NULL,
  `banner_image` varchar(255) DEFAULT NULL,
  `meta_description` text NOT NULL,
  `meta_keyword` text NOT NULL,
  `branch_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `front_cms_news` (`id`, `title`, `description`, `page_title`, `banner_image`, `meta_description`, `meta_keyword`, `branch_id`) VALUES (1, '', '', 'নোটিশ', NULL, 'This is a Smart School Management software for who want to make his school in Advance.', 'school management software,school managment software in bd,school managment software in elite design,elitedesign', 1);


#
# TABLE STRUCTURE FOR: front_cms_news_list
#

DROP TABLE IF EXISTS `front_cms_news_list`;

CREATE TABLE `front_cms_news_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `description` text NOT NULL,
  `image` varchar(255) NOT NULL,
  `alias` varchar(500) DEFAULT NULL,
  `date` date NOT NULL,
  `show_web` tinyint(4) NOT NULL DEFAULT 1,
  `branch_id` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `front_cms_news_list_rms_1` (`branch_id`),
  CONSTRAINT `front_cms_news_list_rms_1` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `front_cms_news_list` (`id`, `title`, `description`, `image`, `alias`, `date`, `show_web`, `branch_id`, `created_at`) VALUES (16, 'Regarding admission to class 1 for the 2025 academic year', '<p>২০২৫ শিক্ষাবর্ষের জন্য সরকারি স্কুলে ভর্তি বিজ্ঞপ্তি প্রকাশ করেছে মাধ্যমিক ও উচ্চ শিক্ষা অধিদপ্তর (মাউশি)। এই বছরে সরকারি স্কুলে ভর্তির প্রক্রিয়া সম্পূর্ণভাবে অনলাইনে হবে। আগ্রহী শিক্ষার্থীদের নির্ধারিত ওয়েবসাইটে (gsa.teletalk.com.bd) গিয়ে আবেদন করতে হবে।</p><p>সরকারি স্কুলে ভর্তি আবেদন ২০২৫ সময়সীমা ও ফি</p><p>ভর্তি আবেদন ১২ নভেম্বর ২০২৪ থেকে শুরু হয়ে চলবে ৩০ নভেম্বর ২০২৪ পর্যন্ত। আবেদনের শেষ তারিখ ৩০ নভেম্বর বিকেল ৫টা পর্যন্ত। আবেদনকারী শিক্ষার্থীদের জন্য ভর্তি আবেদন ফি ১১০ টাকা নির্ধারণ করা হয়েছে। এই ফি শুধুমাত্র টেলিটক প্রি-পেইড মোবাইল থেকে SMS এর মাধ্যমে প্রদান করতে হবে।</p><p><br></p><p>এবারের ভর্তি প্রক্রিয়া সবার জন্য কিছুটা ভিন্ন। আবেদনকারীদেরকে লটারির মাধ্যমে নির্বাচিত করা হবে। অর্থাৎ, কোনো স্কুল থেকে সরাসরি ভর্তি ফরম বিতরণ করা হবে না। শিক্ষার্থীদের একমাত্র সুযোগ হল অনলাইনে আবেদন করা এবং পরে লটারি প্রক্রিয়ার মাধ্যমে তারা ভর্তি হতে পারবেন।</p><p>যে সব স্কুলে ভর্তি আবেদন করা যাবে</p><p>২০২৫ শিক্ষাবর্ষে ভর্তি হওয়া যাবে দেশের সকল জাতীয়করণকৃত সরকারি মাধ্যমিক স্কুল ও বেসরকারি স্কুল-এ। ঢাকা মহানগরী এবং বিভাগীয় শহরের মেট্রোপলিটান এলাকা ও জেলা সদর উপজেলা পর্যায়ের স্কুলগুলোও এই প্রক্রিয়ার আওতায় থাকবে।</p><p><br></p><p>আবেদন প্রক্রিয়া</p><p><br></p><p>১. প্রথমে আবেদনকারীরা ওয়েবসাইট gsa.teletalk.com.bd এ গিয়ে নিজেদের তথ্য দিয়ে আবেদন করবেন।</p><p>২. অনলাইনে আবেদন করার সময় শিক্ষার্থীরা সর্বোচ্চ ৫টি স্কুলে আবেদন করতে পারবেন।</p><p>৩. আবেদন ফি ১১০ টাকা প্রদান করতে হবে।</p><p>৪. আবেদন করার পর শিক্ষার্থীদের তথ্য ও স্কুলের স্থান অনুযায়ী লটারির মাধ্যমে নির্বাচিত করা হবে।</p>', '99a95d414144b25978c4491b24977f3e.jpg', 'regarding-admission-to-class-1-for-the-2025-academic-year', '2025-01-01', 1, 1, '2025-01-01 11:23:38');
INSERT INTO `front_cms_news_list` (`id`, `title`, `description`, `image`, `alias`, `date`, `show_web`, `branch_id`, `created_at`) VALUES (17, 'Regarding payment of salary for the month of December 2024 (including previous arrears)', '<p>২০২৫ শিক্ষাবর্ষের জন্য সরকারি স্কুলে ভর্তি বিজ্ঞপ্তি প্রকাশ করেছে মাধ্যমিক ও উচ্চ শিক্ষা অধিদপ্তর (মাউশি)। এই বছরে সরকারি স্কুলে ভর্তির প্রক্রিয়া সম্পূর্ণভাবে অনলাইনে হবে। আগ্রহী শিক্ষার্থীদের নির্ধারিত ওয়েবসাইটে (gsa.teletalk.com.bd) গিয়ে আবেদন করতে হবে।</p><p>সরকারি স্কুলে ভর্তি আবেদন ২০২৫ সময়সীমা ও ফি</p><p>ভর্তি আবেদন ১২ নভেম্বর ২০২৪ থেকে শুরু হয়ে চলবে ৩০ নভেম্বর ২০২৪ পর্যন্ত। আবেদনের শেষ তারিখ ৩০ নভেম্বর বিকেল ৫টা পর্যন্ত। আবেদনকারী শিক্ষার্থীদের জন্য ভর্তি আবেদন ফি ১১০ টাকা নির্ধারণ করা হয়েছে। এই ফি শুধুমাত্র টেলিটক প্রি-পেইড মোবাইল থেকে SMS এর মাধ্যমে প্রদান করতে হবে।</p><p><br></p><p>এবারের ভর্তি প্রক্রিয়া সবার জন্য কিছুটা ভিন্ন। আবেদনকারীদেরকে লটারির মাধ্যমে নির্বাচিত করা হবে। অর্থাৎ, কোনো স্কুল থেকে সরাসরি ভর্তি ফরম বিতরণ করা হবে না। শিক্ষার্থীদের একমাত্র সুযোগ হল অনলাইনে আবেদন করা এবং পরে লটারি প্রক্রিয়ার মাধ্যমে তারা ভর্তি হতে পারবেন।</p><p>যে সব স্কুলে ভর্তি আবেদন করা যাবে</p><p>২০২৫ শিক্ষাবর্ষে ভর্তি হওয়া যাবে দেশের সকল জাতীয়করণকৃত সরকারি মাধ্যমিক স্কুল ও বেসরকারি স্কুল-এ। ঢাকা মহানগরী এবং বিভাগীয় শহরের মেট্রোপলিটান এলাকা ও জেলা সদর উপজেলা পর্যায়ের স্কুলগুলোও এই প্রক্রিয়ার আওতায় থাকবে।</p><p><br></p><p>আবেদন প্রক্রিয়া</p><p><br></p><p>১. প্রথমে আবেদনকারীরা ওয়েবসাইট gsa.teletalk.com.bd এ গিয়ে নিজেদের তথ্য দিয়ে আবেদন করবেন।</p><p>২. অনলাইনে আবেদন করার সময় শিক্ষার্থীরা সর্বোচ্চ ৫টি স্কুলে আবেদন করতে পারবেন।</p><p>৩. আবেদন ফি ১১০ টাকা প্রদান করতে হবে।</p><p>৪. আবেদন করার পর শিক্ষার্থীদের তথ্য ও স্কুলের স্থান অনুযায়ী লটারির মাধ্যমে নির্বাচিত করা হবে।</p>', 'e42c81bc25739a338be90bdde0b69eab.jpg', 'regarding-payment-of-salary-for-the-month-of-december-2024-including-previous-arrears', '2025-01-01', 1, 1, '2025-01-01 11:31:31');
INSERT INTO `front_cms_news_list` (`id`, `title`, `description`, `image`, `alias`, `date`, `show_web`, `branch_id`, `created_at`) VALUES (18, 'Regarding payment of board and other fees for filling out the form for 2025 SSC examinees', '<p>২০২৫ শিক্ষাবর্ষের জন্য সরকারি স্কুলে ভর্তি বিজ্ঞপ্তি প্রকাশ করেছে মাধ্যমিক ও উচ্চ শিক্ষা অধিদপ্তর (মাউশি)। এই বছরে সরকারি স্কুলে ভর্তির প্রক্রিয়া সম্পূর্ণভাবে অনলাইনে হবে। আগ্রহী শিক্ষার্থীদের নির্ধারিত ওয়েবসাইটে (gsa.teletalk.com.bd) গিয়ে আবেদন করতে হবে।</p><p>সরকারি স্কুলে ভর্তি আবেদন ২০২৫ সময়সীমা ও ফি</p><p>ভর্তি আবেদন ১২ নভেম্বর ২০২৪ থেকে শুরু হয়ে চলবে ৩০ নভেম্বর ২০২৪ পর্যন্ত। আবেদনের শেষ তারিখ ৩০ নভেম্বর বিকেল ৫টা পর্যন্ত। আবেদনকারী শিক্ষার্থীদের জন্য ভর্তি আবেদন ফি ১১০ টাকা নির্ধারণ করা হয়েছে। এই ফি শুধুমাত্র টেলিটক প্রি-পেইড মোবাইল থেকে SMS এর মাধ্যমে প্রদান করতে হবে।</p><p><br></p><p>এবারের ভর্তি প্রক্রিয়া সবার জন্য কিছুটা ভিন্ন। আবেদনকারীদেরকে লটারির মাধ্যমে নির্বাচিত করা হবে। অর্থাৎ, কোনো স্কুল থেকে সরাসরি ভর্তি ফরম বিতরণ করা হবে না। শিক্ষার্থীদের একমাত্র সুযোগ হল অনলাইনে আবেদন করা এবং পরে লটারি প্রক্রিয়ার মাধ্যমে তারা ভর্তি হতে পারবেন।</p><p>যে সব স্কুলে ভর্তি আবেদন করা যাবে</p><p>২০২৫ শিক্ষাবর্ষে ভর্তি হওয়া যাবে দেশের সকল জাতীয়করণকৃত সরকারি মাধ্যমিক স্কুল ও বেসরকারি স্কুল-এ। ঢাকা মহানগরী এবং বিভাগীয় শহরের মেট্রোপলিটান এলাকা ও জেলা সদর উপজেলা পর্যায়ের স্কুলগুলোও এই প্রক্রিয়ার আওতায় থাকবে।</p><p><br></p><p>আবেদন প্রক্রিয়া</p><p><br></p><p>১. প্রথমে আবেদনকারীরা ওয়েবসাইট gsa.teletalk.com.bd এ গিয়ে নিজেদের তথ্য দিয়ে আবেদন করবেন।</p><p>২. অনলাইনে আবেদন করার সময় শিক্ষার্থীরা সর্বোচ্চ ৫টি স্কুলে আবেদন করতে পারবেন।</p><p>৩. আবেদন ফি ১১০ টাকা প্রদান করতে হবে।</p><p>৪. আবেদন করার পর শিক্ষার্থীদের তথ্য ও স্কুলের স্থান অনুযায়ী লটারির মাধ্যমে নির্বাচিত করা হবে।</p>', '7da41f45a05ab0f9f6b2a8cc1fe6923c.jpg', 'regarding-payment-of-board-and-other-fees-for-filling-out-the-form-for-2025-ssc-examinees', '2025-01-01', 1, 1, '2025-01-01 11:33:30');
INSERT INTO `front_cms_news_list` (`id`, `title`, `description`, `image`, `alias`, `date`, `show_web`, `branch_id`, `created_at`) VALUES (19, 'Regarding school bus service in the 2025 academic year', '<p>২০২৫ শিক্ষাবর্ষের জন্য সরকারি স্কুলে ভর্তি বিজ্ঞপ্তি প্রকাশ করেছে মাধ্যমিক ও উচ্চ শিক্ষা অধিদপ্তর (মাউশি)। এই বছরে সরকারি স্কুলে ভর্তির প্রক্রিয়া সম্পূর্ণভাবে অনলাইনে হবে। আগ্রহী শিক্ষার্থীদের নির্ধারিত ওয়েবসাইটে (gsa.teletalk.com.bd) গিয়ে আবেদন করতে হবে।</p><p>সরকারি স্কুলে ভর্তি আবেদন ২০২৫ সময়সীমা ও ফি</p><p>ভর্তি আবেদন ১২ নভেম্বর ২০২৪ থেকে শুরু হয়ে চলবে ৩০ নভেম্বর ২০২৪ পর্যন্ত। আবেদনের শেষ তারিখ ৩০ নভেম্বর বিকেল ৫টা পর্যন্ত। আবেদনকারী শিক্ষার্থীদের জন্য ভর্তি আবেদন ফি ১১০ টাকা নির্ধারণ করা হয়েছে। এই ফি শুধুমাত্র টেলিটক প্রি-পেইড মোবাইল থেকে SMS এর মাধ্যমে প্রদান করতে হবে।</p><p><br></p><p>এবারের ভর্তি প্রক্রিয়া সবার জন্য কিছুটা ভিন্ন। আবেদনকারীদেরকে লটারির মাধ্যমে নির্বাচিত করা হবে। অর্থাৎ, কোনো স্কুল থেকে সরাসরি ভর্তি ফরম বিতরণ করা হবে না। শিক্ষার্থীদের একমাত্র সুযোগ হল অনলাইনে আবেদন করা এবং পরে লটারি প্রক্রিয়ার মাধ্যমে তারা ভর্তি হতে পারবেন।</p><p>যে সব স্কুলে ভর্তি আবেদন করা যাবে</p><p>২০২৫ শিক্ষাবর্ষে ভর্তি হওয়া যাবে দেশের সকল জাতীয়করণকৃত সরকারি মাধ্যমিক স্কুল ও বেসরকারি স্কুল-এ। ঢাকা মহানগরী এবং বিভাগীয় শহরের মেট্রোপলিটান এলাকা ও জেলা সদর উপজেলা পর্যায়ের স্কুলগুলোও এই প্রক্রিয়ার আওতায় থাকবে।</p><p><br></p><p>আবেদন প্রক্রিয়া</p><p><br></p><p>১. প্রথমে আবেদনকারীরা ওয়েবসাইট gsa.teletalk.com.bd এ গিয়ে নিজেদের তথ্য দিয়ে আবেদন করবেন।</p><p>২. অনলাইনে আবেদন করার সময় শিক্ষার্থীরা সর্বোচ্চ ৫টি স্কুলে আবেদন করতে পারবেন।</p><p>৩. আবেদন ফি ১১০ টাকা প্রদান করতে হবে।</p><p>৪. আবেদন করার পর শিক্ষার্থীদের তথ্য ও স্কুলের স্থান অনুযায়ী লটারির মাধ্যমে নির্বাচিত করা হবে।</p>', 'e1777b6ea353b6847ea1043c164b894d.jpg', 'regarding-school-bus-service-in-the-2025-academic-year', '2025-01-01', 1, 1, '2025-01-01 11:34:44');
INSERT INTO `front_cms_news_list` (`id`, `title`, `description`, `image`, `alias`, `date`, `show_web`, `branch_id`, `created_at`) VALUES (20, 'Regarding the payment of salaries for the month of September 2024 (including previous arrears).', '<p>২০২৫ শিক্ষাবর্ষের জন্য সরকারি স্কুলে ভর্তি বিজ্ঞপ্তি প্রকাশ করেছে মাধ্যমিক ও উচ্চ শিক্ষা অধিদপ্তর (মাউশি)। এই বছরে সরকারি স্কুলে ভর্তির প্রক্রিয়া সম্পূর্ণভাবে অনলাইনে হবে। আগ্রহী শিক্ষার্থীদের নির্ধারিত ওয়েবসাইটে (gsa.teletalk.com.bd) গিয়ে আবেদন করতে হবে।</p><p>সরকারি স্কুলে ভর্তি আবেদন ২০২৫ সময়সীমা ও ফি</p><p>ভর্তি আবেদন ১২ নভেম্বর ২০২৪ থেকে শুরু হয়ে চলবে ৩০ নভেম্বর ২০২৪ পর্যন্ত। আবেদনের শেষ তারিখ ৩০ নভেম্বর বিকেল ৫টা পর্যন্ত। আবেদনকারী শিক্ষার্থীদের জন্য ভর্তি আবেদন ফি ১১০ টাকা নির্ধারণ করা হয়েছে। এই ফি শুধুমাত্র টেলিটক প্রি-পেইড মোবাইল থেকে SMS এর মাধ্যমে প্রদান করতে হবে।</p><p><br></p><p>এবারের ভর্তি প্রক্রিয়া সবার জন্য কিছুটা ভিন্ন। আবেদনকারীদেরকে লটারির মাধ্যমে নির্বাচিত করা হবে। অর্থাৎ, কোনো স্কুল থেকে সরাসরি ভর্তি ফরম বিতরণ করা হবে না। শিক্ষার্থীদের একমাত্র সুযোগ হল অনলাইনে আবেদন করা এবং পরে লটারি প্রক্রিয়ার মাধ্যমে তারা ভর্তি হতে পারবেন।</p><p>যে সব স্কুলে ভর্তি আবেদন করা যাবে</p><p>২০২৫ শিক্ষাবর্ষে ভর্তি হওয়া যাবে দেশের সকল জাতীয়করণকৃত সরকারি মাধ্যমিক স্কুল ও বেসরকারি স্কুল-এ। ঢাকা মহানগরী এবং বিভাগীয় শহরের মেট্রোপলিটান এলাকা ও জেলা সদর উপজেলা পর্যায়ের স্কুলগুলোও এই প্রক্রিয়ার আওতায় থাকবে।</p><p><br></p><p>আবেদন প্রক্রিয়া</p><p><br></p><p>১. প্রথমে আবেদনকারীরা ওয়েবসাইট gsa.teletalk.com.bd এ গিয়ে নিজেদের তথ্য দিয়ে আবেদন করবেন।</p><p>২. অনলাইনে আবেদন করার সময় শিক্ষার্থীরা সর্বোচ্চ ৫টি স্কুলে আবেদন করতে পারবেন।</p><p>৩. আবেদন ফি ১১০ টাকা প্রদান করতে হবে।</p><p>৪. আবেদন করার পর শিক্ষার্থীদের তথ্য ও স্কুলের স্থান অনুযায়ী লটারির মাধ্যমে নির্বাচিত করা হবে।</p>', '5f88194ef89bb4e1950bc6b678555c41.jpg', 'regarding-the-payment-of-salaries-for-the-month-of-september-2024-including-previous-arrears', '2025-01-01', 1, 1, '2025-01-01 11:36:06');
INSERT INTO `front_cms_news_list` (`id`, `title`, `description`, `image`, `alias`, `date`, `show_web`, `branch_id`, `created_at`) VALUES (21, 'Regarding caution against being deceived by fraudsters regarding scholarships', '<p>২০২৫ শিক্ষাবর্ষের জন্য সরকারি স্কুলে ভর্তি বিজ্ঞপ্তি প্রকাশ করেছে মাধ্যমিক ও উচ্চ শিক্ষা অধিদপ্তর (মাউশি)। এই বছরে সরকারি স্কুলে ভর্তির প্রক্রিয়া সম্পূর্ণভাবে অনলাইনে হবে। আগ্রহী শিক্ষার্থীদের নির্ধারিত ওয়েবসাইটে (gsa.teletalk.com.bd) গিয়ে আবেদন করতে হবে।</p><p>সরকারি স্কুলে ভর্তি আবেদন ২০২৫ সময়সীমা ও ফি</p><p>ভর্তি আবেদন ১২ নভেম্বর ২০২৪ থেকে শুরু হয়ে চলবে ৩০ নভেম্বর ২০২৪ পর্যন্ত। আবেদনের শেষ তারিখ ৩০ নভেম্বর বিকেল ৫টা পর্যন্ত। আবেদনকারী শিক্ষার্থীদের জন্য ভর্তি আবেদন ফি ১১০ টাকা নির্ধারণ করা হয়েছে। এই ফি শুধুমাত্র টেলিটক প্রি-পেইড মোবাইল থেকে SMS এর মাধ্যমে প্রদান করতে হবে।</p><p><br></p><p>এবারের ভর্তি প্রক্রিয়া সবার জন্য কিছুটা ভিন্ন। আবেদনকারীদেরকে লটারির মাধ্যমে নির্বাচিত করা হবে। অর্থাৎ, কোনো স্কুল থেকে সরাসরি ভর্তি ফরম বিতরণ করা হবে না। শিক্ষার্থীদের একমাত্র সুযোগ হল অনলাইনে আবেদন করা এবং পরে লটারি প্রক্রিয়ার মাধ্যমে তারা ভর্তি হতে পারবেন।</p><p>যে সব স্কুলে ভর্তি আবেদন করা যাবে</p><p>২০২৫ শিক্ষাবর্ষে ভর্তি হওয়া যাবে দেশের সকল জাতীয়করণকৃত সরকারি মাধ্যমিক স্কুল ও বেসরকারি স্কুল-এ। ঢাকা মহানগরী এবং বিভাগীয় শহরের মেট্রোপলিটান এলাকা ও জেলা সদর উপজেলা পর্যায়ের স্কুলগুলোও এই প্রক্রিয়ার আওতায় থাকবে।</p><p><br></p><p>আবেদন প্রক্রিয়া</p><p><br></p><p>১. প্রথমে আবেদনকারীরা ওয়েবসাইট gsa.teletalk.com.bd এ গিয়ে নিজেদের তথ্য দিয়ে আবেদন করবেন।</p><p>২. অনলাইনে আবেদন করার সময় শিক্ষার্থীরা সর্বোচ্চ ৫টি স্কুলে আবেদন করতে পারবেন।</p><p>৩. আবেদন ফি ১১০ টাকা প্রদান করতে হবে।</p><p>৪. আবেদন করার পর শিক্ষার্থীদের তথ্য ও স্কুলের স্থান অনুযায়ী লটারির মাধ্যমে নির্বাচিত করা হবে।</p>', '0b9c5a8ec84aa8acbd7a909aacf3c599.jpg', 'regarding-caution-against-being-deceived-by-fraudsters-regarding-scholarships', '2025-01-01', 1, 1, '2025-01-01 11:37:52');


#
# TABLE STRUCTURE FOR: front_cms_pages
#

DROP TABLE IF EXISTS `front_cms_pages`;

CREATE TABLE `front_cms_pages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_title` varchar(255) NOT NULL,
  `content` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `menu_id` int(11) NOT NULL,
  `banner_image` varchar(255) DEFAULT NULL,
  `meta_description` text NOT NULL,
  `meta_keyword` text NOT NULL,
  `branch_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: front_cms_services
#

DROP TABLE IF EXISTS `front_cms_services`;

CREATE TABLE `front_cms_services` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `subtitle` varchar(255) DEFAULT NULL,
  `parallax_image` varchar(255) DEFAULT NULL,
  `branch_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `front_cms_services` (`id`, `title`, `subtitle`, `parallax_image`, `branch_id`) VALUES (1, 'Get Well Soon', 'Our Best <span>Services</span>', 'service_parallax1.jpg', 1);


#
# TABLE STRUCTURE FOR: front_cms_services_list
#

DROP TABLE IF EXISTS `front_cms_services_list`;

CREATE TABLE `front_cms_services_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `icon` varchar(255) DEFAULT NULL,
  `branch_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `front_cms_services_list` (`id`, `title`, `description`, `icon`, `branch_id`) VALUES (1, 'Online Course Facilities', 'Making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text.', 'fas fa-headphones', 1);
INSERT INTO `front_cms_services_list` (`id`, `title`, `description`, `icon`, `branch_id`) VALUES (2, 'Modern Book Library', 'Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for \'lorem ipsum\' will uncover.', 'fas fa-book-open', 1);
INSERT INTO `front_cms_services_list` (`id`, `title`, `description`, `icon`, `branch_id`) VALUES (3, 'Be Industrial Leader', 'Making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model.', 'fas fa-industry', 1);
INSERT INTO `front_cms_services_list` (`id`, `title`, `description`, `icon`, `branch_id`) VALUES (4, 'Programming Courses', 'Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for \'lorem ipsum\' will.', 'fas fa-code', 1);
INSERT INTO `front_cms_services_list` (`id`, `title`, `description`, `icon`, `branch_id`) VALUES (5, 'Foreign Languages', 'Making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for \'lorem ipsum\' will uncover.', 'fas fa-language', 1);
INSERT INTO `front_cms_services_list` (`id`, `title`, `description`, `icon`, `branch_id`) VALUES (6, 'Alumni Directory', 'Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a for \'lorem ipsum\' will uncover.', 'fas fa-user-graduate', 1);


#
# TABLE STRUCTURE FOR: front_cms_setting
#

DROP TABLE IF EXISTS `front_cms_setting`;

CREATE TABLE `front_cms_setting` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `application_title` varchar(255) NOT NULL,
  `url_alias` varchar(255) DEFAULT NULL,
  `cms_active` tinyint(4) NOT NULL DEFAULT 0,
  `online_admission` tinyint(4) NOT NULL DEFAULT 0,
  `theme` varchar(255) NOT NULL,
  `captcha_status` varchar(20) NOT NULL,
  `recaptcha_site_key` varchar(255) NOT NULL,
  `recaptcha_secret_key` varchar(255) NOT NULL,
  `address` varchar(350) NOT NULL,
  `mobile_no` varchar(60) NOT NULL,
  `email` varchar(60) NOT NULL,
  `copyright_text` varchar(255) NOT NULL,
  `fav_icon` varchar(255) NOT NULL,
  `google_analytics` text DEFAULT NULL,
  `primary_color` varchar(100) NOT NULL DEFAULT '#ff685c',
  `menu_color` varchar(100) NOT NULL DEFAULT '#fff',
  `hover_color` varchar(100) DEFAULT '#f04133',
  `text_color` varchar(100) DEFAULT '#232323',
  `text_secondary_color` varchar(100) DEFAULT '#383838',
  `footer_background_color` varchar(100) DEFAULT '#383838',
  `footer_text_color` varchar(100) DEFAULT '#8d8d8d',
  `copyright_bg_color` varchar(100) DEFAULT '#262626',
  `copyright_text_color` varchar(100) DEFAULT '#8d8d8d',
  `border_radius` varchar(100) NOT NULL DEFAULT '0',
  `branch_id` int(11) NOT NULL,
  `main_logo` varchar(255) DEFAULT NULL,
  `mobile_logo` varchar(255) DEFAULT NULL,
  `eienn_code` varchar(255) DEFAULT NULL,
  `college_code` varchar(255) DEFAULT NULL,
  `emergency_notice` longtext DEFAULT NULL,
  `principal_images` varchar(255) DEFAULT NULL,
  `sovapoti_images` varchar(255) DEFAULT NULL,
  `facebook_page_url` varchar(255) DEFAULT NULL,
  `terms` longtext DEFAULT NULL,
  `privacy` longtext DEFAULT NULL,
  `facebook_url` varchar(255) DEFAULT NULL,
  `twitter_url` varchar(255) DEFAULT NULL,
  `youtube_url` varchar(255) DEFAULT NULL,
  `google_plus` varchar(255) DEFAULT NULL,
  `linkedin_url` varchar(255) DEFAULT NULL,
  `pinterest_url` varchar(255) DEFAULT NULL,
  `instagram_url` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `front_cms_setting` (`id`, `application_title`, `url_alias`, `cms_active`, `online_admission`, `theme`, `captcha_status`, `recaptcha_site_key`, `recaptcha_secret_key`, `address`, `mobile_no`, `email`, `copyright_text`, `fav_icon`, `google_analytics`, `primary_color`, `menu_color`, `hover_color`, `text_color`, `text_secondary_color`, `footer_background_color`, `footer_text_color`, `copyright_bg_color`, `copyright_text_color`, `border_radius`, `branch_id`, `main_logo`, `mobile_logo`, `eienn_code`, `college_code`, `emergency_notice`, `principal_images`, `sovapoti_images`, `facebook_page_url`, `terms`, `privacy`, `facebook_url`, `twitter_url`, `youtube_url`, `google_plus`, `linkedin_url`, `pinterest_url`, `instagram_url`) VALUES (1, 'ফাকল পুলিশ লাইন্স স্কুল অ্যান্ড কলেজ', 'demo', 1, 1, 'red', 'disable', '', '', 'পুলিশ লাইন, মিশন মোড়, লালমনির হাট, সদর', '০১৭৭৫৪৫৭০০৮', 'info@elitedesign.com.bd', '© সকল কিছুর স্বত্বাধিকারঃ ফাকল পুলিশ লাইন্স স্কুল অ্যান্ড কলেজ', 'fav_icon1.png', '', '#051939', '#051939', '#000000', NULL, NULL, '#141414', NULL, '#1c1c1c', NULL, '0', 1, 'main_logo1.jpg', 'mobile_logo1.png', '১৩১০১৫', '৭২৫৮', 'আমাদের ওয়েব সাইটের সার্বিক উন্নয়ন এর কাজ চলছে। কাজ চলাকালীন অবস্থায় , আপনাদের সাময়িকভাবে কিছুটা অসুবিধা হতে পারে এর জন্য আমরা আন্তরিকভাবে দুক্ষিত । আমাদের ওয়েবসাইট উন্নয়নের কাজটি আগামিকাল শেষ হবে। আমাদের সাথে থাকার জন্য ধন্যবাদ।', 'principal_images1.jpg', 'sovapoti_images1.jpg', 'official.elitedesign', 'These terms and conditions outline the rules and regulations for the use of Phakal police lines school and college\'s Website, located at www.phakal.edu.bd.\r\nBy accessing this website we assume you accept these terms and conditions. Do not continue to use Phakal police lines school and college if you do not agree to take all of the terms and conditions stated on this page.\r\n\r\nThe following terminology applies to these Terms and Conditions, Privacy Statement and Disclaimer Notice and all Agreements: \"Client\", \"You\" and \"Your\" refers to you, the person log on this website and compliant to the Company\'s terms and conditions. \"The Company\", \"Ourselves\", \"We\", \"Our\" and \"Us\", refers to our Company. \"Party\", \"Parties\", or \"Us\", refers to both the Client and ourselves. All terms refer to the offer, acceptance and consideration of payment necessary to undertake the process of our assistance to the Client in the most appropriate manner for the express purpose of meeting the Client\'s needs in respect of provision of the Company\'s stated services, in accordance with and subject to, prevailing law of bd. Any use of the above terminology or other words in the singular, plural, capitalization and/or he/she or they, are taken as interchangeable and therefore as referring to same.\r\n\r\nCookies\r\nWe employ the use of cookies. By accessing Phakal police lines school and college, you agreed to use cookies in agreement with the Phakal police lines school and college\'s Privacy Policy.\r\n\r\nMost interactive websites use cookies to let us retrieve the user\'s details for each visit. Cookies are used by our website to enable the functionality of certain areas to make it easier for people visiting our website. Some of our affiliate/advertising partners may also use cookies.\r\n\r\nLicense\r\nUnless otherwise stated, Phakal police lines school and college and/or its licensors own the intellectual property rights for all material on Phakal police lines school and college. All intellectual property rights are reserved. You may access this from Phakal police lines school and college for your own personal use subjected to restrictions set in these terms and conditions.\r\n\r\nYou must not:\r\n\r\nRepublish material from Phakal police lines school and college\r\nSell, rent or sub-license material from Phakal police lines school and college\r\nReproduce, duplicate or copy material from Phakal police lines school and college\r\nRedistribute content from Phakal police lines school and college\r\nParts of this website offer an opportunity for users to post and exchange opinions and information in certain areas of the website. Phakal police lines school and college does not filter, edit, publish or review Comments prior to their presence on the website. Comments do not reflect the views and opinions of Phakal police lines school and college,its agents and/or affiliates. Comments reflect the views and opinions of the person who post their views and opinions. To the extent permitted by applicable laws, Phakal police lines school and college shall not be liable for the Comments or for any liability, damages or expenses caused and/or suffered as a result of any use of and/or posting of and/or appearance of the Comments on this website.\r\n\r\nPhakal police lines school and college reserves the right to monitor all Comments and to remove any Comments which can be considered inappropriate, offensive or causes breach of these Terms and Conditions.\r\n\r\nYou warrant and represent that:\r\n\r\nYou are entitled to post the Comments on our website and have all necessary licenses and consents to do so;\r\nThe Comments do not invade any intellectual property right, including without limitation copyright, patent or trademark of any third party;\r\nThe Comments do not contain any defamatory, libelous, offensive, indecent or otherwise unlawful material which is an invasion of privacy\r\nThe Comments will not be used to solicit or promote business or custom or present commercial activities or unlawful activity.\r\nYou hereby grant Phakal police lines school and college a non-exclusive license to use, reproduce, edit and authorize others to use, reproduce and edit any of your Comments in any and all forms, formats or media.\r\n\r\nHyperlinking to our Content\r\nThe following organizations may link to our Website without prior written approval:\r\n\r\nGovernment agencies;\r\nSearch engines;\r\nNews organizations;\r\nOnline directory distributors may link to our Website in the same manner as they hyperlink to the Websites of other listed businesses; and\r\nSystem wide Accredited Businesses except soliciting non-profit organizations, charity shopping malls, and charity fundraising groups which may not hyperlink to our Web site.\r\nThese organizations may link to our home page, to publications or to other Website information so long as the link: (a) is not in any way deceptive; (b) does not falsely imply sponsorship, endorsement or approval of the linking party and its products and/or services; and (c) fits within the context of the linking party\'s site.\r\n\r\nWe may consider and approve other link requests from the following types of organizations:\r\n\r\ncommonly-known consumer and/or business information sources;\r\ndot.com community sites;\r\nassociations or other groups representing charities;\r\nonline directory distributors;\r\ninternet portals;\r\naccounting, law and consulting firms; and\r\neducational institutions and trade associations.\r\nWe will approve link requests from these organizations if we decide that: (a) the link would not make us look unfavorably to ourselves or to our accredited businesses; (b) the organization does not have any negative records with us; (c) the benefit to us from the visibility of the hyperlink compensates the absence of Phakal police lines school and college; and (d) the link is in the context of general resource information.\r\n\r\nThese organizations may link to our home page so long as the link: (a) is not in any way deceptive; (b) does not falsely imply sponsorship, endorsement or approval of the linking party and its products or services; and (c) fits within the context of the linking party\'s site.\r\n\r\nIf you are one of the organizations listed in paragraph 2 above and are interested in linking to our website, you must inform us by sending an e-mail to Phakal police lines school and college. Please include your name, your organization name, contact information as well as the URL of your site, a list of any URLs from which you intend to link to our Website, and a list of the URLs on our site to which you would like to link. Wait 2-3 weeks for a response.\r\n\r\nApproved organizations may hyperlink to our Website as follows:\r\n\r\nBy use of our corporate name; or\r\nBy use of the uniform resource locator being linked to; or\r\nBy use of any other description of our Website being linked to that makes sense within the context and format of content on the linking party\'s site.\r\nNo use of Phakal police lines school and college\'s logo or other artwork will be allowed for linking absent a trademark license agreement.\r\n\r\niFrames\r\nWithout prior approval and written permission, you may not create frames around our Webpages that alter in any way the visual presentation or appearance of our Website.\r\n\r\nContent Liability\r\nWe shall not be hold responsible for any content that appears on your Website. You agree to protect and defend us against all claims that is rising on your Website. No link(s) should appear on any Website that may be interpreted as libelous, obscene or criminal, or which infringes, otherwise violates, or advocates the infringement or other violation of, any third party rights.\r\n\r\nReservation of Rights\r\nWe reserve the right to request that you remove all links or any particular link to our Website. You approve to immediately remove all links to our Website upon request. We also reserve the right to amen these terms and conditions and it\'s linking policy at any time. By continuously linking to our Website, you agree to be bound to and follow these linking terms and conditions.\r\n\r\nRemoval of links from our website\r\nIf you find any link on our Website that is offensive for any reason, you are free to contact and inform us any moment. We will consider requests to remove links but we are not obligated to or so or to respond to you directly.\r\n\r\nWe do not ensure that the information on this website is correct, we do not warrant its completeness or accuracy; nor do we promise to ensure that the website remains available or that the material on the website is kept up to date.\r\n\r\nDisclaimer\r\nTo the maximum extent permitted by applicable law, we exclude all representations, warranties and conditions relating to our website and the use of this website. Nothing in this disclaimer will:\r\n\r\nlimit or exclude our or your liability for death or personal injury;\r\nlimit or exclude our or your liability for fraud or fraudulent misrepresentation;\r\nlimit any of our or your liabilities in any way that is not permitted under applicable law; or\r\nexclude any of our or your liabilities that may not be excluded under applicable law.\r\nThe limitations and prohibitions of liability set in this Section and elsewhere in this disclaimer: (a) are subject to the preceding paragraph; and (b) govern all liabilities arising under the disclaimer, including liabilities arising in contract, in tort and for breach of statutory duty.\r\n\r\nAs long as the website and the information and services on the website are provided free of charge, we will not be liable for any loss or damage of any nature.', 'At Phakal police lines school and college, accessible from www.phakal.edu.bd, one of our main priorities is the privacy of our visitors. This Privacy Policy document contains types of information that is collected and recorded by Phakal police lines school and college and how we use it.\r\nIf you have additional questions or require more information about our Privacy Policy, do not hesitate to contact us.\r\n\r\nThis Privacy Policy applies only to our online activities and is valid for visitors to our website with regards to the information that they shared and/or collect in Phakal police lines school and college. This policy is not applicable to any information collected offline or via channels other than this website.\r\n\r\nConsent\r\nBy using our website, you hereby consent to our Privacy Policy and agree to its terms.\r\n\r\nInformation we collect\r\nThe personal information that you are asked to provide, and the reasons why you are asked to provide it, will be made clear to you at the point we ask you to provide your personal information.\r\n\r\nIf you contact us directly, we may receive additional information about you such as your name, email address, phone number, the contents of the message and/or attachments you may send us, and any other information you may choose to provide.\r\n\r\nWhen you register for an Account, we may ask for your contact information, including items such as name, company name, address, email address, and telephone number.\r\n\r\nHow we use your information\r\nWe use the information we collect in various ways, including to:\r\n\r\nProvide, operate, and maintain our website\r\nImprove, personalize, and expand our website\r\nUnderstand and analyze how you use our website\r\nDevelop new products, services, features, and functionality\r\nCommunicate with you, either directly or through one of our partners, including for customer service, to provide you with updates and other information relating to the website, and for marketing and promotional purposes\r\nSend you emails\r\nFind and prevent fraud\r\nLog Files\r\nPhakal police lines school and college follows a standard procedure of using log files. These files log visitors when they visit websites. All hosting companies do this and a part of hosting services\' analytics. The information collected by log files include internet protocol (IP) addresses, browser type, Internet Service Provider (ISP), date and time stamp, referring/exit pages, and possibly the number of clicks. These are not linked to any information that is personally identifiable. The purpose of the information is for analyzing trends, administering the site, tracking users\' movement on the website, and gathering demographic information.\r\n\r\nCookies and Web Beacons\r\nLike any other website, Phakal police lines school and college uses \"cookies\". These cookies are used to store information including visitors\' preferences, and the pages on the website that the visitor accessed or visited. The information is used to optimize the users\' experience by customizing our web page content based on visitors\' browser type and/or other information.\r\n\r\nOur Advertising Partners\r\nSome of advertisers on our site may use cookies and web beacons. Our advertising partners are listed below. Each of our advertising partners has their own Privacy Policy for their policies on user data. For easier access, we hyperlinked to their Privacy Policies below.\r\n\r\nGoogle\r\n\r\nhttps://policies.google.com/technologies/ads\r\n\r\nAdvertising Partners Privacy Policies\r\nYou may consult this list to find the Privacy Policy for each of the advertising partners of Phakal police lines school and college.\r\n\r\nThird-party ad servers or ad networks uses technologies like cookies, JavaScript, or Web Beacons that are used in their respective advertisements and links that appear on Phakal police lines school and college, which are sent directly to users\' browser. They automatically receive your IP address when this occurs. These technologies are used to measure the effectiveness of their advertising campaigns and/or to personalize the advertising content that you see on websites that you visit.\r\n\r\nNote that Phakal police lines school and college has no access to or control over these cookies that are used by third-party advertisers.\r\n\r\nThird Party Privacy Policies\r\nPhakal police lines school and college\'s Privacy Policy does not apply to other advertisers or websites. Thus, we are advising you to consult the respective Privacy Policies of these third-party ad servers for more detailed information. It may include their practices and instructions about how to opt-out of certain options.\r\n\r\nYou can choose to disable cookies through your individual browser options. To know more detailed information about cookie management with specific web browsers, it can be found at the browsers\' respective websites.\r\n\r\nCCPA Privacy Rights (Do Not Sell My Personal Information)\r\nUnder the CCPA, among other rights, California consumers have the right to:\r\n\r\nRequest that a business that collects a consumer\'s personal data disclose the categories and specific pieces of personal data that a business has collected about consumers.\r\n\r\nRequest that a business delete any personal data about the consumer that a business has collected.\r\n\r\nRequest that a business that sells a consumer\'s personal data, not sell the consumer\'s personal data.\r\n\r\nIf you make a request, we have one month to respond to you. If you would like to exercise any of these rights, please contact us.\r\n\r\nGDPR Data Protection Rights\r\nWe would like to make sure you are fully aware of all of your data protection rights. Every user is entitled to the following:\r\n\r\nThe right to access – You have the right to request copies of your personal data. We may charge you a small fee for this service.\r\n\r\nThe right to rectification – You have the right to request that we correct any information you believe is inaccurate. You also have the right to request that we complete the information you believe is incomplete.\r\n\r\nThe right to erasure – You have the right to request that we erase your personal data, under certain conditions.\r\n\r\nThe right to restrict processing – You have the right to request that we restrict the processing of your personal data, under certain conditions.\r\n\r\nThe right to object to processing – You have the right to object to our processing of your personal data, under certain conditions.\r\n\r\nThe right to data portability – You have the right to request that we transfer the data that we have collected to another organization, or directly to you, under certain conditions.\r\n\r\nIf you make a request, we have one month to respond to you. If you would like to exercise any of these rights, please contact us.\r\n\r\nChildren\'s Information\r\nAnother part of our priority is adding protection for children while using the internet. We encourage parents and guardians to observe, participate in, and/or monitor and guide their online activity.\r\n\r\nPhakal police lines school and college does not knowingly collect any Personal Identifiable Information from children under the age of 13. If you think that your child provided this kind of information on our website, we strongly encourage you to contact us immediately and we will do our best efforts to promptly remove such information from our records.\r\n\r\nChanges to This Privacy Policy\r\nWe may update our Privacy Policy from time to time. Thus, we advise you to review this page periodically for any changes. We will notify you of any changes by posting the new Privacy Policy on this page. These changes are effective immediately, after they are posted on this page.\r\n\r\nContact Us\r\nIf you have any questions or suggestions about our Privacy Policy, do not hesitate to contact us.', NULL, NULL, NULL, NULL, NULL, NULL, NULL);


#
# TABLE STRUCTURE FOR: front_cms_teachers
#

DROP TABLE IF EXISTS `front_cms_teachers`;

CREATE TABLE `front_cms_teachers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_title` varchar(255) DEFAULT NULL,
  `banner_image` varchar(255) DEFAULT NULL,
  `meta_description` text NOT NULL,
  `meta_keyword` text NOT NULL,
  `branch_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `front_cms_teachers` (`id`, `page_title`, `banner_image`, `meta_description`, `meta_keyword`, `branch_id`) VALUES (1, 'শিক্ষকগন', NULL, 'This is a Smart School Management software for who want to make his school in Advance.', 'school management software,school managment software in bd,school managment software in elite design,elitedesign', 1);


#
# TABLE STRUCTURE FOR: front_cms_testimonial
#

DROP TABLE IF EXISTS `front_cms_testimonial`;

CREATE TABLE `front_cms_testimonial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `surname` varchar(355) NOT NULL,
  `image` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `rank` int(5) NOT NULL,
  `branch_id` int(11) NOT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `front_cms_testimonial` (`id`, `name`, `surname`, `image`, `description`, `rank`, `branch_id`, `created_by`, `created_at`) VALUES (1, 'Gartrell Wright', 'Los Angeles', 'defualt.png', 'Intexure have done an excellent job presenting the analysis & insights. I am confident in saying  have helped encounter  is to be welcomed and every pain avoided”.', 1, 1, 1, '2019-08-23 18:26:42');
INSERT INTO `front_cms_testimonial` (`id`, `name`, `surname`, `image`, `description`, `rank`, `branch_id`, `created_by`, `created_at`) VALUES (2, 'Clifton Hyde', 'Newyork City', 'defualt.png', '“Owing to the claims of duty or the obligations of business it will frequently occur that pleasures have to be repudiated and annoyances accepted always holds”.', 4, 1, 1, '2019-08-23 18:26:42');
INSERT INTO `front_cms_testimonial` (`id`, `name`, `surname`, `image`, `description`, `rank`, `branch_id`, `created_by`, `created_at`) VALUES (3, 'Emily Lemus', 'Los Angeles', 'defualt.png', '“Intexure have done an excellent job presenting the analysis & insights. I am confident in saying  have helped encounter  is to be welcomed and every pain avoided”.', 5, 1, 1, '2019-08-23 18:26:42');
INSERT INTO `front_cms_testimonial` (`id`, `name`, `surname`, `image`, `description`, `rank`, `branch_id`, `created_by`, `created_at`) VALUES (4, 'Michel Jhon', 'CEO', 'defualt.png', '“Owing to the claims of duty or the obligations of business it will frequently occur that pleasures have to be repudiated and annoyances accepted always holds”.', 3, 2, 1, '2019-08-23 18:26:42');
INSERT INTO `front_cms_testimonial` (`id`, `name`, `surname`, `image`, `description`, `rank`, `branch_id`, `created_by`, `created_at`) VALUES (5, 'Hilda Howard', 'Chicago City', 'defualt.png', '“Owing to the claims of duty or the obligations of business it will frequently occur that pleasures have to be repudiated and annoyances accepted always holds”.', 4, 2, 1, '2019-08-23 18:26:42');


#
# TABLE STRUCTURE FOR: global_settings
#

DROP TABLE IF EXISTS `global_settings`;

CREATE TABLE `global_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `institute_name` varchar(255) NOT NULL,
  `institution_code` varchar(255) NOT NULL,
  `reg_prefix` varchar(255) NOT NULL,
  `institute_email` varchar(100) NOT NULL,
  `address` text NOT NULL,
  `mobileno` varchar(100) NOT NULL,
  `currency` varchar(100) NOT NULL,
  `currency_symbol` varchar(100) NOT NULL,
  `currency_formats` tinyint(4) NOT NULL DEFAULT 1,
  `symbol_position` tinyint(4) NOT NULL DEFAULT 1,
  `sms_service_provider` varchar(100) NOT NULL,
  `session_id` int(11) NOT NULL,
  `translation` varchar(100) NOT NULL,
  `footer_text` varchar(255) NOT NULL,
  `animations` varchar(100) NOT NULL,
  `timezone` varchar(100) NOT NULL,
  `date_format` varchar(100) CHARACTER SET utf32 COLLATE utf32_unicode_ci NOT NULL,
  `facebook_url` varchar(255) NOT NULL,
  `twitter_url` varchar(255) NOT NULL,
  `linkedin_url` varchar(255) NOT NULL,
  `youtube_url` varchar(255) NOT NULL,
  `cron_secret_key` varchar(255) DEFAULT NULL,
  `preloader_backend` tinyint(1) NOT NULL DEFAULT 1,
  `footer_branch_switcher` tinyint(1) NOT NULL DEFAULT 1,
  `cms_default_branch` int(11) NOT NULL,
  `image_extension` text DEFAULT NULL,
  `image_size` float NOT NULL DEFAULT 1024,
  `file_extension` text DEFAULT NULL,
  `pid` varchar(255) DEFAULT NULL,
  `file_size` float DEFAULT 1024,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `global_settings` (`id`, `institute_name`, `institution_code`, `reg_prefix`, `institute_email`, `address`, `mobileno`, `currency`, `currency_symbol`, `currency_formats`, `symbol_position`, `sms_service_provider`, `session_id`, `translation`, `footer_text`, `animations`, `timezone`, `date_format`, `facebook_url`, `twitter_url`, `linkedin_url`, `youtube_url`, `cron_secret_key`, `preloader_backend`, `footer_branch_switcher`, `cms_default_branch`, `image_extension`, `image_size`, `file_extension`, `pid`, `file_size`, `created_at`, `updated_at`) VALUES (1, 'Phakal Police Lines School & College', 'PPLSC-', 'on', 'info@elitedesign.com.bd', 'Police Lines, Mission More, Lalmonir Hat Sadar, Bangladesh', '01775457008', 'BDT', 'TK', 1, 1, 'disabled', 6, 'english', '© 2025 All Rights Reserved By Phakal Police Lines School & College', 'fadeInUp', 'Asia/Dhaka', 'd.M.Y', 'https://facebook.com/official.elitedesign', 'https://facebook.com/official.elitedesign', 'https://facebook.com/official.elitedesign', 'https://facebook.com/official.elitedesign', 'de96a5c5c83213e9ae3efbc08d512290', 2, 0, 1, 'jpeg, jpg, bmp, png', '2048', 'txt, pdf, doc, xls, docx, xlsx, jpg, jpeg, png, gif, bmp, zip, mp4, 7z, wmv, rar', 'YWNjZmExNmMtMjhmNi00Njc3LTgyOWQtMDY1MzZlNjg0ZjQz', '2048', '2024-12-27 13:30:59', '0000-00-00 00:00:00');


#
# TABLE STRUCTURE FOR: grade
#

DROP TABLE IF EXISTS `grade`;

CREATE TABLE `grade` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `grade_point` varchar(255) NOT NULL,
  `lower_mark` int(11) NOT NULL,
  `upper_mark` int(11) NOT NULL,
  `remark` text NOT NULL,
  `branch_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `grade_rms_1` (`branch_id`),
  CONSTRAINT `grade_rms_1` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `grade` (`id`, `name`, `grade_point`, `lower_mark`, `upper_mark`, `remark`, `branch_id`) VALUES (1, 'A+', '5.0', 80, 100, 'Excellent!', 1);
INSERT INTO `grade` (`id`, `name`, `grade_point`, `lower_mark`, `upper_mark`, `remark`, `branch_id`) VALUES (2, 'A', '4', 70, 19, 'Very Good', 1);
INSERT INTO `grade` (`id`, `name`, `grade_point`, `lower_mark`, `upper_mark`, `remark`, `branch_id`) VALUES (3, 'A-', '3.5', 60, 69, 'Good', 1);
INSERT INTO `grade` (`id`, `name`, `grade_point`, `lower_mark`, `upper_mark`, `remark`, `branch_id`) VALUES (4, 'B', '3', 50, 59, 'Average', 1);
INSERT INTO `grade` (`id`, `name`, `grade_point`, `lower_mark`, `upper_mark`, `remark`, `branch_id`) VALUES (5, 'C', '2.5', 40, 49, 'Adequate', 1);
INSERT INTO `grade` (`id`, `name`, `grade_point`, `lower_mark`, `upper_mark`, `remark`, `branch_id`) VALUES (6, 'D', '2', 33, 39, 'Poor', 1);
INSERT INTO `grade` (`id`, `name`, `grade_point`, `lower_mark`, `upper_mark`, `remark`, `branch_id`) VALUES (7, 'F', '0', 0, 32, 'Fail', 1);


#
# TABLE STRUCTURE FOR: hall_allocation
#

DROP TABLE IF EXISTS `hall_allocation`;

CREATE TABLE `hall_allocation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `hall_no` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `section_id` int(11) NOT NULL,
  `exam_id` int(11) NOT NULL,
  `branch_id` int(11) NOT NULL,
  `session_id` int(11) NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: homework
#

DROP TABLE IF EXISTS `homework`;

CREATE TABLE `homework` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_id` int(11) NOT NULL,
  `section_id` int(11) NOT NULL,
  `session_id` int(11) NOT NULL,
  `subject_id` int(11) NOT NULL,
  `date_of_homework` date NOT NULL,
  `date_of_submission` date NOT NULL,
  `description` text NOT NULL,
  `created_by` int(11) NOT NULL,
  `create_date` date NOT NULL,
  `status` varchar(10) NOT NULL,
  `sms_notification` tinyint(2) NOT NULL,
  `schedule_date` date DEFAULT NULL,
  `document` varchar(255) NOT NULL,
  `evaluation_date` date DEFAULT NULL,
  `evaluated_by` int(11) NOT NULL,
  `branch_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `homework_rms_1` (`branch_id`),
  KEY `homework_rms_2` (`class_id`),
  KEY `homework_rms_3` (`section_id`),
  KEY `homework_rms_4` (`session_id`),
  KEY `homework_rms_5` (`subject_id`),
  CONSTRAINT `homework_rms_1` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE,
  CONSTRAINT `homework_rms_2` FOREIGN KEY (`class_id`) REFERENCES `class` (`id`) ON DELETE CASCADE,
  CONSTRAINT `homework_rms_3` FOREIGN KEY (`section_id`) REFERENCES `section` (`id`) ON DELETE CASCADE,
  CONSTRAINT `homework_rms_4` FOREIGN KEY (`session_id`) REFERENCES `schoolyear` (`id`) ON DELETE CASCADE,
  CONSTRAINT `homework_rms_5` FOREIGN KEY (`subject_id`) REFERENCES `subject` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: homework_evaluation
#

DROP TABLE IF EXISTS `homework_evaluation`;

CREATE TABLE `homework_evaluation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `homework_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `remark` text NOT NULL,
  `rank` int(11) NOT NULL,
  `date` date NOT NULL,
  `status` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `homework_evaluation_rms_1` (`homework_id`),
  CONSTRAINT `homework_evaluation_rms_1` FOREIGN KEY (`homework_id`) REFERENCES `homework` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: homework_submit
#

DROP TABLE IF EXISTS `homework_submit`;

CREATE TABLE `homework_submit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `homework_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `message` varchar(355) NOT NULL,
  `enc_name` varchar(355) DEFAULT NULL,
  `file_name` varchar(355) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `homework_submit_rms_1` (`homework_id`),
  KEY `homework_submit_rms_2` (`student_id`),
  CONSTRAINT `homework_submit_rms_1` FOREIGN KEY (`homework_id`) REFERENCES `homework` (`id`) ON DELETE CASCADE,
  CONSTRAINT `homework_submit_rms_2` FOREIGN KEY (`student_id`) REFERENCES `student` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: hostel
#

DROP TABLE IF EXISTS `hostel`;

CREATE TABLE `hostel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` longtext NOT NULL,
  `category_id` int(11) NOT NULL,
  `address` longtext NOT NULL,
  `watchman` longtext NOT NULL,
  `remarks` longtext DEFAULT NULL,
  `branch_id` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `hostel_rms_1` (`branch_id`),
  CONSTRAINT `hostel_rms_1` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: hostel_category
#

DROP TABLE IF EXISTS `hostel_category`;

CREATE TABLE `hostel_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` longtext NOT NULL,
  `description` longtext DEFAULT NULL,
  `branch_id` int(11) DEFAULT NULL,
  `type` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: hostel_room
#

DROP TABLE IF EXISTS `hostel_room`;

CREATE TABLE `hostel_room` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` longtext NOT NULL,
  `hostel_id` int(11) NOT NULL,
  `no_beds` int(11) NOT NULL,
  `category_id` int(11) DEFAULT NULL,
  `bed_fee` decimal(18,2) NOT NULL,
  `remarks` longtext NOT NULL,
  `branch_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: language_list
#

DROP TABLE IF EXISTS `language_list`;

CREATE TABLE `language_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(600) NOT NULL,
  `lang_field` varchar(600) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `rtl` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `rtl`, `created_at`, `updated_at`) VALUES (1, 'English', 'english', 1, 0, '2018-11-15 17:36:31', '2020-04-18 20:05:12');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `rtl`, `created_at`, `updated_at`) VALUES (2, 'Bengali', 'bengali', 1, 0, '2018-11-15 17:36:31', '2018-12-04 15:41:50');


#
# TABLE STRUCTURE FOR: languages
#

DROP TABLE IF EXISTS `languages`;

CREATE TABLE `languages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `word` varchar(255) NOT NULL,
  `english` varchar(255) NOT NULL,
  `bengali` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1424 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1, 'language', 'Language', 'ভাষা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (2, 'attendance_overview', 'Attendance Overview', 'উপস্থিতি পরিদর্শন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (3, 'annual_fee_summary', 'Annual Fee Summary', 'বার্ষিক ফি সংক্ষিপ্ত বিবরণ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (4, 'my_annual_attendance_overview', 'My Annual Attendance Overview', 'আমার বার্ষিক উপস্থিতি পরিদর্শন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (5, 'schedule', 'Schedule', 'সময়সূচী');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (6, 'student_admission', 'Student Admission', 'ছাত্র ভর্তি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (7, 'returned', 'Returned', 'ফেরৎ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (8, 'user_name', 'User Name', 'ব্যবহারকারীর নাম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (9, 'rejected', 'Rejected', 'প্রত্যাখ্যাত');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (10, 'route_name', 'Route Name', 'রুট নাম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (11, 'route_fare', 'Route Fare', 'রুট ভাড়া');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (12, 'edit_route', 'Edit Route', 'সম্পাদন করা রুট');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (13, 'this_value_is_required', 'This value is required.', 'এই মান প্রয়োজন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (14, 'vehicle_no', 'Vehicle No', 'যানবাহন নং');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (15, 'insurance_renewal_date', 'Insurance Renewal Date', 'বীমা নবায়ন তারিখ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (16, 'driver_name', 'Driver Name', 'ড্রাইভারের নাম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (17, 'driver_license', 'Driver License', 'চালকের অনুমোদন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (18, 'select_route', 'Select Route', 'রুট নির্বাচন করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (19, 'edit_vehicle', 'Edit Vehicle', 'যানবাহন সম্পাদনা করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (20, 'add_students', 'Add Students', 'ছাত্রদের যোগ করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (21, 'vehicle_number', 'Vehicle Number', 'যানবাহন সংখ্যা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (22, 'select_route_first', 'Select Route First', 'রুট প্রথম নির্বাচন করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (23, 'transport_fee', 'Transport Fee', 'পরিবহন ফি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (24, 'control', 'Control', 'নিয়ন্ত্রণ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (25, 'set_students', 'Set Students', 'ছাত্রদের সেট করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (26, 'hostel_list', 'Hostel List', 'হোস্টেল তালিকা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (27, 'watchman_name', 'Watchman Name', 'ওয়াচম্যান নাম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (28, 'hostel_address', 'Hostel Address', 'হোস্টেল ঠিকানা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (29, 'edit_hostel', 'Edit Hostel', 'হোস্টেল সম্পাদনা করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (30, 'room_name', 'Room Name', 'রুমের নাম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (31, 'no_of_beds', 'No Of Beds', 'শয্যা সংখ্যা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (32, 'select_hostel_first', 'Select Hostel First', 'হোস্টেল প্রথম নির্বাচন করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (33, 'remaining', 'Remaining', 'অবশিষ্ট');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (34, 'hostel_fee', 'Hostel Fee', 'হোস্টেল ফি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (35, 'accountant_list', 'Accountant List', 'অ্যাকাউন্টেন্ট তালিকা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (36, 'students_fees', 'Students Fees', 'ছাত্র ফি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (37, 'fees_status', 'Fees Status', 'ফি স্থিতি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (38, 'books', 'Books', 'বই');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (39, 'home_page', 'Home Page', 'হোম পেজ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (40, 'collected', 'Collected', 'সংগৃহীত');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (41, 'student_mark', 'Student Mark', 'ছাত্র মার্ক');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (42, 'select_exam_first', 'Select Exam First', 'নির্বাচন প্রথম নির্বাচন করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (43, 'transport_details', 'Transport Details', 'পরিবহন বিবরণ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (44, 'no_of_teacher', 'No of Teacher', 'শিক্ষকের সংখ্যা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (45, 'basic_details', 'Basic Details', 'মৌলিক বিবরণ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (46, 'fee_progress', 'Fee Progress', 'ফি অগ্রগতি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (47, 'word', 'Word', 'শব্দ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (48, 'book_category', 'Book Category', 'বই বিভাগ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (49, 'driver_phone', 'Driver Phone', 'ড্রাইভার ফোন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (50, 'invalid_csv_file', 'Invalid / Corrupted CSV File', 'অবৈধ / দূষিত CSV ফাইল');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (51, 'requested_book_list', 'Requested Book List', 'অনুরোধকৃত বইয়ের তালিকা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (52, 'request_status', 'Request Status', 'অনুরোধ স্থিতি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (53, 'book_request', 'Book Request', 'বইয়ের অনুরোধ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (54, 'logout', 'Logout', 'প্রস্থান');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (55, 'select_payment_method', 'Select Payment Method', 'পেমেন্ট পদ্ধতি নির্বাচন করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (56, 'select_method', 'Select Method', 'পদ্ধতি নির্বাচন করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (57, 'payment', 'Payment', 'প্রদান');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (58, 'filter', 'Filter', 'ছাঁকনি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (59, 'status', 'Status', 'অবস্থা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (60, 'paid', 'Paid', 'অর্থ প্রদান');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (61, 'unpaid', 'Unpaid', 'অবৈতনিক');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (62, 'method', 'Method', 'পদ্ধতি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (63, 'cash', 'Cash', 'নগদ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (64, 'check', 'Check', 'চেক');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (65, 'card', 'Card', 'কার্ড');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (66, 'payment_history', 'Payment History', 'অর্থ প্রদান ইতিহাস');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (67, 'category', 'Category', 'বিভাগ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (68, 'book_list', 'Book List', 'পাঠ্যতালিকা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (69, 'author', 'Author', 'লেখক');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (70, 'price', 'Price', 'মূল্য');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (71, 'available', 'Available', 'সহজলভ্য');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (72, 'unavailable', 'Unavailable', 'অপ্রাপ্য');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (73, 'transport_list', 'Transport List', 'পরিবহন তালিকা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (74, 'edit_transport', 'Edit Transport', 'পরিবহন সম্পাদনা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (75, 'hostel_name', 'Hostel Name', 'হোস্টেল নাম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (76, 'number_of_room', 'Hostel Of Room', 'রুম নম্বর');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (77, 'yes', 'Yes', 'হাঁ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (78, 'no', 'No', 'না');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (79, 'messages', 'Messages', 'বার্তা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (80, 'compose', 'Compose', 'নতুন বার্তা লিখতে');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (81, 'recipient', 'Recipient', 'প্রাপক');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (82, 'select_a_user', 'Select A User', 'নির্বাচন একটি ব্যবহারকারী');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (83, 'send', 'Send', 'পাঠান');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (84, 'global_settings', 'Global Settings', 'সার্বজনীন নির্ধারণ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (85, 'currency', 'Currency', 'মুদ্রা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (86, 'system_email', 'System Email', 'সিস্টেম ইমেইল');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (87, 'create', 'Create', 'সৃষ্টি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (88, 'save', 'Save', 'সংরক্ষণ করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (89, 'file', 'File', 'ফাইল');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (90, 'theme_settings', 'Theme Settings', 'থিম সেটিংস');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (91, 'default', 'Default', 'ডিফল্ট');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (92, 'select_theme', 'Select Theme', 'থিম নির্বাচন কর');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (93, 'upload_logo', 'Upload Logo', 'লোগো আপলোড করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (94, 'upload', 'Upload', 'আপলোড');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (95, 'remember', 'Remember', 'স্মরণ করা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (96, 'not_selected', 'Not Selected', 'অনির্বাচিত');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (97, 'disabled', 'Disabled', 'অক্ষম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (98, 'inactive_account', 'Inactive Account', 'নিষ্ক্রিয় অ্যাকাউন্ট');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (99, 'update_translations', 'Update Translations', 'আপডেট অনুবাদ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (100, 'language_list', 'Language List', 'নতুন ভাষাটি তালিকায় আগে');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (101, 'option', 'Option', 'পছন্দ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (102, 'edit_word', 'Edit Word', 'শব্দ সম্পাদনা করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (103, 'update_profile', 'Update Profile', 'প্রফাইল হালনাগাদ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (104, 'current_password', 'Current Password', 'বর্তমান পাসওয়ার্ড');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (105, 'new_password', 'New Password', 'নতুন পাসওয়ার্ড');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (106, 'login', 'Login', 'লগইন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (107, 'reset_password', 'Reset Password', 'পাসওয়ার্ড রিসেট করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (108, 'present', 'Present', 'হাজির');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (109, 'absent', 'Absent', 'অনুপস্থিত');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (110, 'update_attendance', 'Update Attendance', 'আপডেট এ্যাটেনডেন্স');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (111, 'undefined', 'Undefined', 'অনির্দিষ্ট');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (112, 'back', 'Back', 'পিছনে');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (113, 'save_changes', 'Save Changes', 'পরিবর্তনগুলোর সংরক্ষন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (114, 'uploader', 'Uploader', 'আপলোডার');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (115, 'download', 'Download', 'ডাউনলোড');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (116, 'remove', 'Remove', 'অপসারণ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (117, 'print', 'Print', 'ছাপানো');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (118, 'select_file_type', 'Select File Type', 'নির্বাচন ফাইল টাইপ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (119, 'excel', 'Excel', 'সীমা অতিক্রম করা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (120, 'other', 'Other', 'অন্যান্য');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (121, 'students_of_class', 'Students Of Class', 'ক্লাস ছাত্রদের');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (122, 'marks_obtained', 'Marks Obtained', 'প্রাপ্ত নম্বর');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (123, 'attendance_for_class', 'Attendance For Class', 'এ্যাটেনডেন্স বর্গ জন্য');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (124, 'receiver', 'Receiver', 'গ্রাহক');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (125, 'please_select_receiver', 'Please Select Receiver', 'দয়া করে রিসিভার নির্বাচন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (126, 'session_changed', 'Session Changed', 'সেশন পরিবর্তিত');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (127, 'exam_marks', 'Exam Marks', 'পরীক্ষার মার্কস');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (128, 'total_mark', 'Total Mark', 'মোট মার্ক');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (129, 'mark_obtained', 'Mark Obtained', 'মার্ক প্রাপ্ত');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (130, 'invoice/payment_list', 'Invoice / Payment List', 'ইনভয়েস / পেমেন্ট তালিকা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (131, 'obtained_marks', 'Obtained Marks', 'প্রাপ্ত মার্কস');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (132, 'highest_mark', 'Highest Mark', 'সর্বোচ্চ মার্ক');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (133, 'grade', 'Grade (GPA)', 'শ্রেণী');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (134, 'dashboard', 'Dashboard', 'ড্যাশবোর্ড');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (135, 'student', 'Student', 'ছাত্র');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (136, 'rename', 'Rename', 'নামান্তর');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (137, 'class', 'Class', 'শ্রেণী');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (138, 'teacher', 'Teacher', 'শিক্ষক');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (139, 'parents', 'Parents', 'মাতাপিতা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (140, 'subject', 'Subject', 'বিষয়');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (141, 'student_attendance', 'Student Attendance', 'ছাত্র উপস্থিতি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (142, 'exam_list', 'Exam List', 'পরীক্ষার তালিকা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (143, 'grades_range', 'Grades Range', 'গ্রেড পরিসীমা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (144, 'loading', 'Loading', 'বোঝাই');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (145, 'library', 'Library', 'লাইব্রেরি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (146, 'hostel', 'Hostel', 'ছাত্রাবাস');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (147, 'events', 'Events', 'সূচনাফলক');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (148, 'message', 'Message', 'বার্তা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (149, 'translations', 'Translations', 'অনুবাদের');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (150, 'account', 'Account', 'হিসাব');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (151, 'selected_session', 'Selected Session', 'নির্বাচিত সেশন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (152, 'change_password', 'Change Password', 'পাসওয়ার্ড পরিবর্তন করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (153, 'section', 'Section', 'অধ্যায়');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (154, 'edit', 'Edit', 'সম্পাদন করা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (155, 'delete', 'Delete', 'মুছে ফেলা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (156, 'cancel', 'Cancel', 'বাতিল');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (157, 'parent', 'Parent', 'মাতা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (158, 'attendance', 'Attendance', 'উপস্থিতি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (159, 'addmission_form', 'Admission Form', 'ভর্তির ফর্ম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (160, 'name', 'Name', 'নাম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (161, 'select', 'Select', 'নির্বাচন করা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (162, 'roll', 'Roll', 'রোল');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (163, 'birthday', 'Date Of Birth', 'জন্ম তারিখ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (164, 'gender', 'Gender', 'লিঙ্গ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (165, 'male', 'Male', 'পুরুষ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (166, 'female', 'Female', 'মহিলা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (167, 'address', 'Address', 'ঠিকানা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (168, 'phone', 'Phone', 'ফোন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (169, 'email', 'Email', 'ই-মেইল');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (170, 'password', 'Password', 'পাসওয়ার্ড');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (171, 'transport_route', 'Transport Route', 'পরিবহন রুট');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (172, 'photo', 'Photo', 'ছবি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (173, 'select_class', 'Select Class', 'ক্লাস নির্বাচন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (174, 'username_password_incorrect', 'Username Or Password Is Incorrect', 'ব্যাবহারকারীর নাম অথবা গোপন নাম্বারটি ভুল');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (175, 'select_section', 'Select Section', 'অনুচ্ছেদ নির্বাচন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (176, 'options', 'Options', 'বিকল্প');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (177, 'mark_sheet', 'Mark Sheet', 'নাম্বার শিট');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (178, 'profile', 'Profile', 'প্রোফাইলে');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (179, 'select_all', 'Select All', 'সবগুলো নির্বাচন করা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (180, 'select_none', 'Select None', 'কিছুই না');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (181, 'average', 'Average', 'গড়');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (182, 'transfer', 'Transfer', 'হস্তান্তর');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (183, 'edit_teacher', 'Edit Teacher', 'গুরু সম্পাদনা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (184, 'sex', 'Sex', 'লিঙ্গ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (185, 'marksheet_for', 'Marksheet For', 'মার্ক শীট');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (186, 'total_marks', 'Total Marks', 'মোট মার্কস');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (187, 'parent_phone', 'Parent Phone', 'পেরেন্ট ফোন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (188, 'subject_author', 'Subject Author', 'বিষয় লেখক');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (189, 'update', 'Update', 'হালনাগাদ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (190, 'class_list', 'Class List', 'ক্লাস তালিকা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (191, 'class_name', 'Class Name', 'শ্রেণির নাম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (192, 'name_numeric', 'Name Numeric', 'নাম সংখ্যাসূচক');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (193, 'select_teacher', 'Select Teacher', 'গুরু নির্বাচন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (194, 'edit_class', 'Edit Class', 'ক্লাস সম্পাদনা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (195, 'section_name', 'Section Name', 'অনুচ্ছেদ নাম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (196, 'add_section', 'Add Section', 'অনুচ্ছেদ যোগ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (197, 'subject_list', 'Subject List', 'বিষয় তালিকা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (198, 'subject_name', 'Subject Name', 'বিষয় নাম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (199, 'edit_subject', 'Edit Subject', 'বিষয় সম্পাদনা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (200, 'day', 'Day', 'দিন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (201, 'starting_time', 'Starting Time', 'সময় শুরু');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (202, 'hour', 'Hour', 'ঘন্টা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (203, 'minutes', 'Minutes', 'মিনিট');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (204, 'ending_time', 'Ending Time', 'সময় শেষ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (205, 'select_subject', 'Select Subject', 'বিষয় নির্বাচন করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (206, 'select_date', 'Select Date', 'তারিখ নির্বাচন করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (207, 'select_month', 'Select Month', 'মাস নির্বাচন করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (208, 'select_year', 'Select Year', 'নির্বাচন বছর');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (209, 'add_language', 'Add Language', 'ভাষা যোগ করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (210, 'exam_name', 'Exam Name', 'পরীক্ষার নাম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (211, 'date', 'Date', 'তারিখ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (212, 'comment', 'Comment', 'মন্তব্য');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (213, 'edit_exam', 'Edit Exam', 'পরীক্ষার সম্পাদনা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (214, 'grade_list', 'Grade List', 'গ্রেড তালিকা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (215, 'grade_name', 'Grade Name', 'গ্রেড নাম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (216, 'grade_point', 'Grade Point', 'গ্রেড পয়েন্ট');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (217, 'select_exam', 'Select Exam', 'পরীক্ষার নির্বাচন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (218, 'students', 'Students', 'শিক্ষার্থীরা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (219, 'subjects', 'Subjects', 'প্রজাদের');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (220, 'total', 'Total', 'মোট');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (221, 'select_academic_session', 'Select Academic Session', 'একাডেমিক সেশন নির্বাচন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (222, 'invoice_informations', 'Invoice Informations', 'চালান ইনফরমেশন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (223, 'title', 'Title', 'খেতাব');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (224, 'description', 'Description', 'বিবরণ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (225, 'payment_informations', 'Payment Informations', 'পেমেন্ট তথ্য');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (226, 'view_invoice', 'View Invoice', 'দেখুন চালান');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (227, 'payment_to', 'Payment To', 'পরিশোদ করা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (228, 'bill_to', 'Bill To', 'বিল করতে');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (229, 'total_amount', 'Total Amount', 'সর্বমোট পরিমাণ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (230, 'paid_amount', 'Paid Amount', 'দেওয়া পরিমাণ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (231, 'due', 'Due', 'দরুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (232, 'amount_paid', 'Amount Paid', 'পরিমাণ অর্থ প্রদান করা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (233, 'payment_successfull', 'Payment has been successful', 'পেমেন্ট সফল হয়েছে');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (234, 'add_invoice/payment', 'Add Invoice/payment', 'ইনভয়েস / পেমেন্ট যোগ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (235, 'invoices', 'Invoices', 'ইনভয়েস বা চালান');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (236, 'action', 'Action', 'কর্ম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (237, 'required', 'Required', 'প্রয়োজনীয়');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (238, 'info', 'Info', 'তথ্য');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (239, 'month', 'Month', 'মাস');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (240, 'details', 'Details', 'বিস্তারিত');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (241, 'new', 'New', 'নতুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (242, 'reply_message', 'Reply Message', 'বার্তা উত্তর');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (243, 'message_sent', 'Message Sent', 'বার্তা পাঠানো');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (244, 'search', 'Search', 'অনুসন্ধান');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (245, 'religion', 'Religion', 'ধর্ম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (246, 'blood_group', 'Blood group', 'রক্তের গ্রুপ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (247, 'database_backup', 'Database Backup', 'ডাটাবেজ ব্যাকআপ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (248, 'search', 'Search', 'অনুসন্ধান');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (249, 'payments_history', 'Fees Pay / Invoice', 'ফি পরিশোধ / চালান');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (250, 'message_restore', 'Message Restore', 'বার্তা পুনরুদ্ধার');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (251, 'write_new_message', 'Write New Message', 'নতুন বার্তা লিখতে');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (252, 'attendance_sheet', 'Attendance Sheet', 'এ্যাটেনডেন্স শীট');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (253, 'holiday', 'Holiday', 'ছুটির দিন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (254, 'exam', 'Exam', 'পরীক্ষা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (255, 'successfully', 'Successfully', 'সফলভাবে');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (256, 'admin', 'Admin', 'অ্যাডমিন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (257, 'inbox', 'Inbox', 'ইনবক্স');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (258, 'sent', 'Sent', 'প্রেরিত');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (259, 'important', 'Important', 'গুরুত্বপূর্ণ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (260, 'trash', 'Trash', 'আবর্জনা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (261, 'error', 'Unsuccessful', 'ব্যার্থ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (262, 'sessions_list', 'Sessions List', 'সেশন তালিকা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (263, 'session_settings', 'Session Settings', 'সেশন সেটিংস');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (264, 'add_designation', 'Add Designation', 'পদবী যোগ করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (265, 'users', 'Users', 'ব্যবহারকারীরা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (266, 'librarian', 'Librarian', 'গ্রন্থাগারিক');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (267, 'accountant', 'Accountant', 'হিসাবরক্ষক');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (268, 'academics', 'Academics', 'বিদ্যালয় সংক্রান্ত');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (269, 'employees_attendance', 'Employees Attendance', 'কর্মচারী উপস্থিতি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (270, 'set_exam_term', 'Set Exam Term', 'টার্ম সেট করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (271, 'set_attendance', 'Set Attendance', 'উপস্থিতি সেট করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (272, 'marks', 'Marks', 'মার্কস');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (273, 'books_category', 'Books Category', 'বই বিভাগ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (274, 'transport', 'Transport', 'পরিবহন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (275, 'fees', 'Fees', 'ফি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (276, 'fees_allocation', 'Fees Allocation', 'ফি বরাদ্দকরণ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (277, 'fee_category', 'Fee Category', 'ফি বিভাগ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (278, 'report', 'Report', 'প্রতিবেদন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (279, 'employee', 'Employee', 'কর্মচারী');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (280, 'invoice', 'Invoice', 'চালান');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (281, 'event_catalogue', 'Event Catalogue', 'ইভেন্ট ক্যাটালগ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (282, 'total_paid', 'Total Paid', 'মোট দেওয়া');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (283, 'total_due', 'Total Due', 'মোট বাকি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (284, 'fees_collect', 'Fees Collect', 'ফি সংগ্রহ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (285, 'total_school_students_attendance', 'Total School Students Attendance', 'মোট স্কুলের ছাত্র উপস্থিতি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (286, 'overview', 'Overview', 'সংক্ষিপ্ত বিবরণ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (287, 'currency_symbol', 'Currency Symbol', 'মুদ্রা প্রতীক');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (288, 'enable', 'Enable', 'সক্ষম করা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (289, 'disable', 'Disable', 'অক্ষম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (290, 'payment_settings', 'Payment Settings', 'পেমেন্ট সেটিংস');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (291, 'student_attendance_report', 'Student Attendance Report', 'ছাত্র উপস্থিতি রিপোর্ট');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (292, 'attendance_type', 'Attendance Type', 'উপস্থিতি প্রকার');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (293, 'late', 'Late', 'বিলম্বে');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (294, 'employees_attendance_report', 'Employees Attendance Report', 'কর্মচারী উপস্থিতি রিপোর্ট');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (295, 'attendance_report_of', 'Attendance Report Of', 'উপস্থিতি রিপোর্ট');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (296, 'fee_paid_report', 'Fee Paid Report', 'ফি প্রদান প্রতিবেদন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (297, 'invoice_no', 'Invoice No', 'চালান নং');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (298, 'payment_mode', 'Payment Mode', 'পরিশোধের মাধ্যম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (299, 'payment_type', 'Payment Type', 'পেমেন্ট টাইপ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (300, 'done', 'Done', 'সম্পন্ন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (301, 'select_fee_category', 'Select Fee Category', 'ফি বিভাগ নির্বাচন করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (302, 'discount', 'Discount', 'ডিসকাউন্ট');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (303, 'enter_discount_amount', 'Enter Discount Amount', 'ছাড়ের পরিমাণ লিখুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (304, 'online_payment', 'Online Payment', 'দূরবর্তী অর্থ প্রদান');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (305, 'student_name', 'Student Name', 'শিক্ষার্থীর নাম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (306, 'invoice_history', 'Invoice History', 'চালান ইতিহাস');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (307, 'discount_amount', 'Discount Amount', 'হ্রাসকৃত মুল্য');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (308, 'invoice_list', 'Invoice List', 'চালান তালিকা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (309, 'partly_paid', 'Partly Paid', 'আংশিক পরিশোধিত');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (310, 'fees_list', 'Fees List', 'ফি তালিকা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (311, 'voucher_id', 'Voucher ID', 'ভউচার আইডি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (312, 'transaction_date', 'Transaction Date', 'লেনদেন তারিখ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (313, 'admission_date', 'Admission Date', 'ভর্তির তারিখ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (314, 'user_status', 'User Status', 'ব্যবহারকারীর স্থিতি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (315, 'nationality', 'Nationality', 'জাতীয়তা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (316, 'register_no', 'Register No', 'রেজিস্টার নং');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (317, 'first_name', 'First Name', 'প্রথম নাম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (318, 'last_name', 'Last Name', 'নামের শেষাংশ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (319, 'state', 'State', 'রাষ্ট্র');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (320, 'transport_vehicle_no', 'Transport Vehicle No', 'পরিবহন যানবাহন নং');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (321, 'percent', 'Percent', 'শতাংশ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (322, 'average_result', 'Average Result', 'গড় ফলাফল');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (323, 'student_category', 'Student Category', 'ছাত্র বিভাগ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (324, 'category_name', 'Category Name', 'বিভাগ নাম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (325, 'category_list', 'Category List', 'বিভাগ তালিকা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (326, 'please_select_student_first', 'Please Select Students First', 'প্রথমে ছাত্রদের দয়া করে নির্বাচন করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (327, 'designation', 'Designation', 'উপাধি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (328, 'qualification', 'Qualification', 'যোগ্যতা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (329, 'account_deactivated', 'Account Deactivated', 'অ্যাকাউন্ট নিষ্ক্রিয়');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (330, 'account_activated', 'Account Activated', 'অ্যাকাউন্ট সক্রিয়');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (331, 'designation_list', 'Designation List', 'পদবী তালিকা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (332, 'joining_date', 'Joining Date', 'যোগদান তারিখ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (333, 'relation', 'Relation', 'সম্পর্ক');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (334, 'father_name', 'Father Name', 'বাবার নাম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (335, 'librarian_list', 'Librarian List', 'গ্রন্থাগারিক তালিকা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (336, 'class_numeric', 'Class Numeric', 'ক্লাস সাংখ্যিক');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (337, 'maximum_students', 'Maximum Students', 'সর্বোচ্চ ছাত্র');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (338, 'class_room', 'Class Room', 'ক্লাস রুমে');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (339, 'pass_mark', 'Pass Mark', 'পাশ নম্বর');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (340, 'exam_time', 'Exam Time (Min)', 'পরীক্ষার সময় (মিনিট)');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (341, 'time', 'Time', 'সময়');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (342, 'subject_code', 'Subject Code', 'বিষয় কোড');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (343, 'full_mark', 'Full Mark', 'পুরো নম্বর');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (344, 'subject_type', 'Subject Type', 'বিষয় প্রকার');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (345, 'date_of_publish', 'Date Of Publish', 'প্রকাশের তারিখ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (346, 'file_name', 'File Name', 'ফাইলের নাম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (347, 'students_list', 'Students List', 'ছাত্র তালিকা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (348, 'start_date', 'Start Date', 'শুরুর তারিখ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (349, 'end_date', 'End Date', 'শেষ তারিখ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (350, 'term_name', 'Term Name', 'টার্ম নাম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (351, 'grand_total', 'Grand Total', 'সর্বমোট');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (352, 'result', 'Result', 'ফল');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (353, 'books_list', 'Books List', 'বই তালিকা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (354, 'book_isbn_no', 'Book ISBN No', 'বই ISBN নং');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (355, 'total_stock', 'Total Stock', 'মোট স্টক');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (356, 'issued_copies', 'Issued Copies', 'ইস্যু করা কপি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (357, 'publisher', 'Publisher', 'প্রকাশক');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (358, 'books_issue', 'Books Issue', 'বই ইস্যু');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (359, 'user', 'User', 'ব্যবহারকারী');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (360, 'fine', 'Fine', 'জরিমানা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (361, 'pending', 'Pending', 'অনিষ্পন্ন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (362, 'return_date', 'Return Date', 'প্রত্যাবর্তন তারিখ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (363, 'accept', 'Accept', 'গ্রহণ করা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (364, 'reject', 'Reject', 'প্রত্যাখ্যান');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (365, 'issued', 'Issued', 'ইস্যু করা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (366, 'return', 'Return', 'প্রত্যাবর্তন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (367, 'renewal', 'Renewal', 'পুনরারম্ভ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (368, 'fine_amount', 'Fine Amount', 'জরিমানা পরিমাণ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (369, 'password_mismatch', 'Password Mismatch', 'পাসওয়ার্ড মেলেনি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (370, 'settings_updated', 'Settings Update', 'সেটিংস আপডেট করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (371, 'pass', 'Pass', 'পাস');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (372, 'event_to', 'Event To', 'ইভেন্টের জন্য');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (373, 'all_users', 'All Users', 'সকল ব্যবহারকারী');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (374, 'employees_list', 'Employees List', 'কর্মচারী তালিকা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (375, 'on', 'On', 'উপর');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (376, 'timezone', 'Timezone', 'সময় অঞ্চল');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (377, 'get_result', 'Get Result', 'ফলাফল পেতে');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (378, 'apply', 'Apply', 'প্রয়োগ করা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (379, 'hrm', 'Human Resource', 'মানব সম্পদ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (380, 'payroll', 'Payroll', 'বেতনের');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (381, 'salary_assign', 'Salary Assign', 'বেতন বরাদ্দ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (382, 'employee_salary', 'Payment Salary', 'পেমেন্ট বেতন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (383, 'application', 'Application', 'আবেদন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (384, 'award', 'Award', 'পুরস্কার');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (385, 'basic_salary', 'Basic Salary', 'মূল বেতন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (386, 'employee_name', 'Employee Name', 'কর্মকর্তার নাম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (387, 'name_of_allowance', 'Name Of Allowance', 'ভাতা নাম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (388, 'name_of_deductions', 'Name Of Deductions', 'কর্তনের নাম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (389, 'all_employees', 'All Employees', 'সমস্ত কর্মচারী');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (390, 'total_allowance', 'Total Allowance', 'মোট ভাতা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (391, 'total_deduction', 'Total Deductions', 'মোট কর্তন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (392, 'net_salary', 'Net Salary', 'মোট বেতন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (393, 'payslip', 'Payslip', 'স্লিপে');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (394, 'days', 'Days', 'দিন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (395, 'category_name_already_used', 'Category Name Already Used', 'বিভাগের নাম ইতিমধ্যে ব্যবহৃত');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (396, 'leave_list', 'Leave List', 'তালিকা ছেড়ে');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (397, 'leave_category', 'Leave Category', 'বিভাগ ছেড়ে');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (398, 'applied_on', 'Applied On', 'প্রয়োগ করা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (399, 'accepted', 'Accepted', 'গৃহীত');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (400, 'leave_statistics', 'Leave Statistics', 'ছুটি পরিসংখ্যান');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (401, 'leave_type', 'Leave Type', 'ছুটি টাইপ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (402, 'reason', 'Reason', 'কারণ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (403, 'close', 'Close', 'বন্ধ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (404, 'give_award', 'Give Award', 'পুরস্কার দাও');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (405, 'list', 'List', 'তালিকা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (406, 'award_name', 'Award Name', 'পুরস্কারের নাম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (407, 'gift_item', 'Gift Item', 'উপহার আইটেম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (408, 'cash_price', 'Cash Price', 'নগদ মূল্য');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (409, 'award_reason', 'Award Reason', 'পুরস্কার কারণ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (410, 'given_date', 'Given Date', 'প্রদত্ত তারিখ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (411, 'apply_leave', 'Apply Leave', 'ছুটি প্রয়োগ করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (412, 'leave_application', 'Leave Application', 'ছুটি আবেদন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (413, 'allowances', 'Allowances', 'তৃপ্তি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (414, 'add_more', 'Add More', 'আরো যোগ করো');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (415, 'deductions', 'Deductions', 'কর্তন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (416, 'salary_details', 'Salary Details', 'বেতন বিবরণ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (417, 'salary_month', 'Salary Month', 'বেতন মাস');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (418, 'leave_data_update_successfully', 'Leave Data Updated Successfully', 'ছুটি ডেটা সফলভাবে আপডেট করা হয়েছে');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (419, 'fees_history', 'Fees History', 'ফি ইতিহাস');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (420, 'bank_name', 'Bank Name', 'ব্যাংকের নাম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (421, 'branch', 'Branch', 'শাখা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (422, 'bank_address', 'Bank Address', 'ব্যাংকের ঠিকানা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (423, 'ifsc_code', 'IFSC Code', 'আইএফসিসি কোড');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (424, 'account_no', 'Account No', 'হিসাব নাম্বার');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (425, 'add_bank', 'Add Bank', 'ব্যাংক জুড়ুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (426, 'account_name', 'Account Holder', 'হিসাবের নাম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (427, 'database_backup_completed', 'Database Backup Completed', 'ডাটাবেস ব্যাকআপ সম্পন্ন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (428, 'restore_database', 'Restore Database', 'ডাটাবেস পুনঃস্থাপন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (429, 'template', 'Template', 'টেমপ্লেট');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (430, 'time_and_date', 'Time And Date', 'সময় এবং তারিখ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (431, 'everyone', 'Everyone', 'সবাই');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (432, 'invalid_amount', 'Invalid Amount', 'অকার্যকর পরিমাণ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (433, 'leaving_date_is_not_available_for_you', 'Leaving Date Is Not Available For You', 'তারিখ রেখে আপনার জন্য উপলব্ধ নয়');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (434, 'animations', 'Animations', 'অ্যানিমেশন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (435, 'email_settings', 'Email Settings', 'ইমেল সেটিংস');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (436, 'deduct_month', 'Deduct Month', 'কেটে মাস');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (437, 'no_employee_available', 'No Employee Available', 'কোন কর্মচারী প্রাপ্তিসাধ্য');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (438, 'advance_salary_application_submitted', 'Advance Salary Application Submitted', 'অগ্রিম বেতন আবেদন জমা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (439, 'date_format', 'Date Format', 'তারিখ বিন্যাস');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (440, 'id_card_generate', 'ID Card Generate', 'আইডি কার্ড তৈরি করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (441, 'issue_salary', 'Issue Salary', 'বেতন ইস্যু');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (442, 'advance_salary', 'Advance Salary', 'বেতন অগ্রিম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (443, 'logo', 'Logo', 'লোগো');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (444, 'book_request', 'Book Request', 'বই অনুরোধ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (445, 'reporting', 'Reporting', 'প্রতিবেদন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (446, 'paid_salary', 'Paid Salary', 'বেতন দেওয়া');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (447, 'due_salary', 'Due Salary', 'বাকি বেতন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (448, 'route', 'Route', 'রুট');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (449, 'academic_details', 'Academic Details', 'একাডেমিক বিবরণ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (450, 'guardian_details', 'Guardian Details', 'অভিভাবক বিস্তারিত');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (451, 'due_amount', 'Due Amount', 'বাকি টাকা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (452, 'fee_due_report', 'Fee Due Report', 'ফি প্রতিবেদনের রিপোর্ট');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (453, 'other_details', 'Other Details', 'অন্যান্য বিস্তারিত');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (454, 'last_exam_report', 'Last Exam Report', 'শেষ পরীক্ষার রিপোর্ট');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (455, 'book_issued', 'Book Issued', 'বই ইস্যু করা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (456, 'interval_month', 'Interval 30 Days', 'অন্তর 30 দিন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (457, 'attachments', 'Attachments', 'সংযুক্তিসমূহ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (458, 'fees_payment', 'Fees Payment', 'ফি প্রদান');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (459, 'fees_summary', 'Fees Summary', 'ফি সংক্ষিপ্ত বিবরণ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (460, 'total_fees', 'Total Fees', 'মোট ফি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (461, 'weekend_attendance_inspection', 'Weekend Attendance Inspection', 'সপ্তাহান্তে উপস্থিতি পরিদর্শন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (462, 'book_issued_list', 'Book Issued List', 'বুক ইস্যু তালিকা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (463, 'lose_your_password', 'Lose Your Password?', 'আপনার পাসওয়ার্ড হারান?');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (464, 'all_branch_dashboard', 'All Branch Dashboard', 'সমস্ত শাখা ড্যাশবোর্ড');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (465, 'academic_session', 'Academic Session', 'একাডেমিক সেশন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (466, 'all_branches', 'All Branches', 'সমস্ত শাখা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (467, 'admission', 'Admission', 'ভর্তি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (468, 'create_admission', 'Create Admission', 'ভর্তি তৈরি করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (469, 'multiple_import', 'Multiple Import', 'একাধিক আমদানি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (470, 'student_details', 'Student Details', 'ছাত্র বিস্তারিত');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (471, 'student_list', 'Student List', 'ছাত্র তালিকা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (472, 'login_deactivate', 'Login Deactivate', 'লগইন নিষ্ক্রিয় করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (473, 'parents_list', 'Parents List', 'পিতামাতার তালিকা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (474, 'add_parent', 'Add Parent', 'মূল যোগ করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (475, 'employee_list', 'Employee List', 'কর্মচারী তালিকা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (476, 'add_department', 'Add Department', 'বিভাগ যোগ করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (477, 'add_employee', 'Add Employee', 'কর্মচারী যোগ করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (478, 'salary_template', 'Salary Template', 'বেতন টেমপ্লেট');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (479, 'salary_payment', 'Salary Payment', 'বেতন পেমেন্ট');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (480, 'payroll_summary', 'Payroll Summary', 'বেতন সারসংক্ষেপ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (481, 'academic', 'Academic', 'বিদ্যালয় সংক্রান্ত');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (482, 'control_classes', 'Control Classes', 'নিয়ন্ত্রণ ক্লাস');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (483, 'assign_class_teacher', 'Assign Class Teacher', 'ক্লাস শিক্ষক নিয়োগ\n\n');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (484, 'class_assign', 'Class Assign', 'ক্লাস বরাদ্দ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (485, 'assign', 'Assign', 'দায়িত্ব অর্পণ করা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (486, 'promotion', 'Promotion', 'পদোন্নতি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (487, 'attachments_book', 'Attachments Book', 'সংযুক্তি বই');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (488, 'upload_content', 'Upload Content', 'আপলোড কন্টেন্ট');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (489, 'attachment_type', 'Attachment Type', 'সংযুক্তি প্রকার');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (490, 'exam_master', 'Exam Master', 'পরীক্ষা মাস্টার');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (491, 'exam_hall', 'Exam Hall', 'পরীক্ষা হল');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (492, 'mark_entries', 'Mark Entries', 'মার্ক এন্ট্রি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (493, 'tabulation_sheet', 'Tabulation Sheet', 'ট্যাবলেট শীট');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (494, 'supervision', 'Supervision', 'রক্ষণাবেক্ষণ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (495, 'hostel_master', 'Hostel Master', 'হোস্টেল মাস্টার');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (496, 'hostel_room', 'Hostel Room', 'হোস্টেল রুম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (497, 'allocation_report', 'Allocation Report', 'বরাদ্দ রিপোর্ট');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (498, 'route_master', 'Route Master', 'রুট মাস্টার');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (499, 'vehicle_master', 'Vehicle Master', 'যানবাহন মাস্টার');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (500, 'stoppage', 'Stoppage', 'বিরতি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (501, 'assign_vehicle', 'Assign Vehicle', 'যানবাহন বরাদ্দ করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (502, 'reports', 'Reports', 'প্রতিবেদন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (503, 'books_entry', 'Books Entry', 'বই এন্ট্রি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (504, 'event_type', 'Event Type', 'ইভেন্টের ধরণ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (505, 'add_events', 'Add Events', 'ইভেন্ট যোগ করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (506, 'student_accounting', 'Student Accounting', 'ছাত্র অ্যাকাউন্টিং');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (507, 'create_single_invoice', 'Create Single Invoice', 'একক চালান মোট রুট তৈরি করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (508, 'create_multi_invoice', 'Create Multi Invoice', 'মাল্টি চালান তৈরি করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (509, 'summary_report', 'Summary Report', 'সারসংক্ষেপ প্রতিবেদন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (510, 'office_accounting', 'Office Accounting', 'অফিস একাউন্টিং');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (511, 'under_group', 'Under Group', 'দলের অধীনে');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (512, 'bank_account', 'Bank Account', 'ব্যাংক হিসাব');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (513, 'ledger_account', 'Ledger Account', 'লেজার অ্যাকাউন্ট');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (514, 'create_voucher', 'Create Voucher', 'ভাউচার তৈরি করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (515, 'day_book', 'Day Book', 'জাবেদা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (516, 'cash_book', 'Cash Book', 'নগদ বই');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (517, 'bank_book', 'Bank Book', 'ব্যাংক বই');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (518, 'ledger_book', 'Ledger Book', 'খতিয়ান বই');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (519, 'trial_balance', 'Trial Balance', 'ট্রায়াল ব্যালেন্স');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (520, 'settings', 'Settings', 'স্থাপন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (521, 'sms_settings', 'Sms Settings', 'এসএমএস সেটিংস');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (522, 'cash_book_of', 'Cash Book Of', 'ক্যাশ বুক');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (523, 'by_cash', 'By Cash', 'নগদে');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (524, 'by_bank', 'By Bank', 'ব্যাংক দ্বারা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (525, 'total_strength', 'Total Strength', 'মোট শক্তি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (526, 'teachers', 'Teachers', 'শিক্ষক');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (527, 'student_quantity', 'Student Quantity', 'ছাত্র পরিমাণ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (528, 'voucher', 'Voucher', 'রসিদ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (529, 'total_number', 'Total Number', 'মোট সংখ্যা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (530, 'total_route', 'Total Route', 'মোট রুট');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (531, 'total_room', 'Total Room', 'মোট কক্ষ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (532, 'amount', 'Amount', 'পরিমাণ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (533, 'branch_dashboard', 'Branch Dashboard', 'শাখা ড্যাশবোর্ড');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (534, 'branch_list', 'Branch List', 'শাখা তালিকা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (535, 'create_branch', 'Create Branch', 'শাখা তৈরি করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (536, 'branch_name', 'Branch Name', 'শাখার নাম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (537, 'school_name', 'School Name', 'স্কুল নাম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (538, 'mobile_no', 'Mobile No', 'মোবাইল নাম্বার');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (539, 'symbol', 'Symbol', 'পরিমাণ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (540, 'city', 'City', 'শহর');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (541, 'academic_year', 'Academic Year', 'একাডেমিক বছর');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (542, 'select_branch_first', 'First Select The Branch', 'প্রথমে শাখা নির্বাচন করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (543, 'select_class_first', 'Select Class First', 'ক্লাস প্রথম নির্বাচন করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (544, 'select_country', 'Select Country', 'দেশ নির্বাচন করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (545, 'mother_tongue', 'Mother Tongue', 'মাতৃভাষা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (546, 'caste', 'Caste', 'বর্ণ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (547, 'present_address', 'Present Address', 'বর্তমান ঠিকানা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (548, 'permanent_address', 'Permanent Address', 'স্থায়ী ঠিকানা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (549, 'profile_picture', 'Profile Picture', 'প্রোফাইল ছবি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (550, 'login_details', 'Login Details', 'লগ ইন তথ্য');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (551, 'retype_password', 'Retype Password', 'পাসওয়ার্ড আবার টাইপ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (552, 'occupation', 'Occupation', 'পেশা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (553, 'income', 'Income', 'আয়');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (554, 'education', 'Education', 'শিক্ষা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (555, 'first_select_the_route', 'First Select The Route', 'প্রথম রুট নির্বাচন করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (556, 'hostel_details', 'Hostel Details', 'হোটেল বিবরণ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (557, 'first_select_the_hostel', 'First Select The Hostel', 'প্রথম ছাত্রাবাস নির্বাচন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (558, 'previous_school_details', 'Previous School Details', 'পূর্ববর্তী স্কুল বিবরণ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (559, 'book_name', 'Book Name', 'বইয়ের নাম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (560, 'select_ground', 'Select Ground', 'গ্রাউন্ড নির্বাচন করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (561, 'import', 'Import', 'আমদানি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (562, 'add_student_category', 'Add Student Category', 'ছাত্র বিভাগ যোগ করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (563, 'id', 'Id', 'আইডি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (564, 'edit_category', 'Edit Category', 'বিভাগ সম্পাদনা করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (565, 'deactivate_account', 'Deactivate Account', 'অ্যাকাউন্ট নিষ্ক্রিয় করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (566, 'all_sections', 'All Sections', 'সব বিভাগ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (567, 'authentication_activate', 'Authentication Activate', 'প্রমাণীকরণ সক্রিয় করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (568, 'department', 'Department', 'বিভাগ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (569, 'salary_grades', 'Salary Grades', 'বেতন গ্রেড');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (570, 'overtime', 'Overtime Rate (Per Hour)', 'ওভারটাইম হার (প্রতি ঘন্টা)');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (571, 'salary_grade', 'Salary Grade', 'বেতন গ্রেড');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (572, 'payable_type', 'Payable Type', 'প্রদেয় প্রকার');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (573, 'edit_type', 'Edit Type', 'টাইপ সম্পাদনা করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (574, 'role', 'Role', 'ভূমিকা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (575, 'remuneration_info_for', 'Remuneration Info For', 'বেতন জন্য তথ্য');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (576, 'salary_paid', 'Salary Paid', 'বেতন দেওয়া');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (577, 'salary_unpaid', 'Salary Unpaid', 'বেতন পরিশোধ না');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (578, 'pay_now', 'Pay Now', 'এখন পরিশোধ করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (579, 'employee_role', 'Employee Role', 'কর্মচারী ভূমিকা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (580, 'create_at', 'Create At', 'এ তৈরি করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (581, 'select_employee', 'Select Employee', 'কর্মচারী নির্বাচন করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (582, 'review', 'Review', 'পর্যালোচনা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (583, 'reviewed_by', 'Reviewed By', 'দ্বারা পর্যালোচনা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (584, 'submitted_by', 'Submitted By', 'দ্বারা জমা দেওয়া');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (585, 'employee_type', 'Employee Type', 'কর্মচারী টাইপ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (586, 'approved', 'Approved', 'অনুমোদিত');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (587, 'unreviewed', 'Unreviewed', 'পর্যালোচনা না করা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (588, 'creation_date', 'Creation Date', 'তৈরির তারিখ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (589, 'no_information_available', 'No Information Available', 'কোন তথ্য নেই');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (590, 'continue_to_payment', 'Continue To Payment', 'পেমেন্ট অবিরত');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (591, 'overtime_total_hour', 'Overtime Total Hour', 'ওভারটাইম মোট ঘন্টা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (592, 'overtime_amount', 'Overtime Amount', 'ওভারটাইম পরিমাণ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (593, 'remarks', 'Remarks', 'মন্তব্য');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (594, 'view', 'View', 'দৃশ্য');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (595, 'leave_appeal', 'Leave Appeal', 'আবেদন ছেড়ে');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (596, 'create_leave', 'Create Leave', 'ছুটি তৈরি করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (597, 'user_role', 'User Role', 'ব্যবহারকারী ভূমিকা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (598, 'date_of_start', 'Date Of Start', 'শুরু তারিখ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (599, 'date_of_end', 'Date Of End', 'শেষ তারিখ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (600, 'winner', 'Winner', 'বিজয়ী');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (601, 'select_user', 'Select User', 'ব্যবহারকারী নির্বাচন করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (602, 'create_class', 'Create Class', 'ক্লাস তৈরি করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (603, 'class_teacher_allocation', 'Class Teacher Allocation', 'ক্লাস শিক্ষক বরাদ্দ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (604, 'class_teacher', 'Class Teacher', 'শ্রেণী শিক্ষক');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (605, 'create_subject', 'Create Subject', 'সাবজেক্ট তৈরি করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (606, 'select_multiple_subject', 'Select Multiple Subject', 'একাধিক বিষয় নির্বাচন করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (607, 'teacher_assign', 'Teacher Assign', 'শিক্ষক নিয়োগ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (608, 'teacher_assign_list', 'Teacher Assign List', 'শিক্ষক নিয়োগ তালিকা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (609, 'select_department_first', 'Select Department First', 'প্রথম বিভাগ নির্বাচন করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (610, 'create_book', 'Create Book', 'বই তৈরি করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (611, 'book_title', 'Book Title', 'বইয়ের শিরোনাম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (612, 'cover', 'Cover', 'আবরণ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (613, 'edition', 'Edition', 'সংস্করণ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (614, 'isbn_no', 'ISBN No', 'আইএসবিএন নং');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (615, 'purchase_date', 'Purchase Date', 'ক্রয় তারিখ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (616, 'cover_image', 'Cover Image', 'চিত্র কভার');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (617, 'book_issue', 'Book Issue', 'বই ইস্যু');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (618, 'date_of_issue', 'Date Of Issue', 'প্রদান এর তারিখ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (619, 'date_of_expiry', 'Date Of Expiry', 'মেয়াদ শেষ হওয়ার তারিখ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (620, 'select_category_first', 'Select Category First', 'প্রথম বিভাগ নির্বাচন করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (621, 'type_name', 'Type Name', 'নাম টাইপ করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (622, 'type_list', 'Type List', 'প্রকারের তালিকা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (623, 'icon', 'Icon', 'আইকন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (624, 'event_list', 'Event List', 'ইভেন্ট তালিকা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (625, 'create_event', 'Create Event', 'ইভেন্ট তৈরি করা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (626, 'type', 'Type', 'আদর্শ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (627, 'audience', 'Audience', 'শ্রোতা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (628, 'created_by', 'Created By', 'দ্বারা সৃষ্টি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (629, 'publish', 'Publish', 'প্রকাশ করা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (630, 'everybody', 'Everybody', 'সবাই');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (631, 'selected_class', 'Selected Class', 'নির্বাচিত ক্লাস');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (632, 'selected_section', 'Selected Section', 'নির্বাচিত বিভাগ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (633, 'information_has_been_updated_successfully', 'Information Has Been Updated Successfully', 'তথ্য সফলভাবে আপডেট হয়েছে Updated');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (634, 'create_invoice', 'Create Invoice', 'চালান তৈরি করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (635, 'invoice_entry', 'Invoice Entry', 'চালানের এন্ট্রি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (636, 'quick_payment', 'Quick Payment', 'দ্রুত অর্থ প্রদান');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (637, 'write_your_remarks', 'Write Your Remarks', 'আপনার মন্তব্য লিখুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (638, 'reset', 'Reset', 'রিসেট');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (639, 'fees_payment_history', 'Fees Payment History', 'ফি প্রদানের ইতিহাস');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (640, 'fees_summary_report', 'Fees Summary Report', 'ফি সংক্ষিপ্তসার প্রতিবেদন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (641, 'add_account_group', 'Add Account Group', 'অ্যাকাউন্ট গ্রুপ যুক্ত করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (642, 'account_group', 'Account Group', 'অ্যাকাউন্ট গ্রুপ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (643, 'account_group_list', 'Account Group List', 'অ্যাকাউন্ট গ্রুপ তালিকা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (644, 'mailbox', 'Mailbox', 'ডাকবাক্স');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (645, 'refresh_mail', 'Refresh Mail', 'রিফ্রেশ মেল');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (646, 'sender', 'Sender', 'প্রেরকের');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (647, 'general_settings', 'General Settings', 'সাধারণ সেটিংস');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (648, 'institute_name', 'Institute Name', 'প্রতিষ্ঠানের নাম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (649, 'institution_code', 'Institution Code', 'প্রতিষ্ঠান কোড');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (650, 'sms_service_provider', 'Sms Service Provider', 'এসএমএস পরিষেবা সরবরাহকারী');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (651, 'footer_text', 'Footer Text', 'পাদচরণ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (652, 'payment_control', 'Payment Control', 'পেমেন্ট কন্ট্রোল');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (653, 'sms_config', 'Sms Config', 'এসএমএস কনফিগার');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (654, 'sms_triggers', 'Sms Triggers', 'এসএমএস ট্রিগার');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (655, 'authentication_token', 'Authentication Token', 'প্রমাণীকরণ টোকেন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (656, 'sender_number', 'Sender Number', 'প্রেরকের নম্বর');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (657, 'username', 'Username', 'ব্যবহারকারীর নাম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (658, 'api_key', 'Api Key', 'এপি কি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (659, 'authkey', 'Authkey', 'Authkey');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (660, 'sender_id', 'Sender Id', 'প্রেরকের আইডি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (661, 'sender_name', 'Sender Name', 'প্রেরক নাম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (662, 'hash_key', 'Hash Key', 'হ্যাশ কী');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (663, 'notify_enable', 'Notify Enable', 'সক্ষমকে অবহিত করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (664, 'exam_attendance', 'Exam Attendance', 'পরীক্ষার উপস্থিতি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (665, 'exam_results', 'Exam Results', 'পরীক্ষার ফলাফল');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (666, 'email_config', 'Email Config', 'ইমেল কনফিগারেশন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (667, 'email_triggers', 'Email Triggers', 'ইমেল ট্রিগার');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (668, 'account_registered', 'Account Registered', 'অ্যাকাউন্ট নিবন্ধিত');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (669, 'forgot_password', 'Forgot Password', 'পাসওয়ার্ড ভুলে গেছেন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (670, 'new_message_received', 'New Message Received', 'নতুন বার্তা গৃহীত হয়েছে');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (671, 'payslip_generated', 'Payslip Generated', 'পেইলিপ জেনারেটেড');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (672, 'leave_approve', 'Leave Approve', 'ছাড়ুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (673, 'leave_reject', 'Leave Reject', 'প্রত্যাখ্যান ছেড়ে দিন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (674, 'advance_salary_approve', 'Leave Reject', 'প্রত্যাখ্যান ছেড়ে দিন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (675, 'advance_salary_reject', 'Advance Salary Reject', 'অগ্রিম বেতন প্রত্যাখ্যান');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (676, 'add_session', 'Add Session', 'সেশন যোগ করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (677, 'session', 'Session', 'সেশন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (678, 'created_at', 'Created At', 'এ নির্মিত');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (679, 'sessions', 'Sessions', 'দায়রা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (680, 'flag', 'Flag', 'পতাকা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (681, 'stats', 'Stats', 'পরিসংখ্যান');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (682, 'updated_at', 'Updated At', 'এ আপডেট');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (683, 'flag_icon', 'Flag Icon', 'পতাকা আইকন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (684, 'password_restoration', 'Password Restoration', 'পাসওয়ার্ড পুনরুদ্ধার');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (685, 'forgot', 'Forgot', 'ভুলে গেছেন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (686, 'back_to_login', 'Back To Login', 'প্রবেশ করতে পেছান');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (687, 'database_list', 'Database List', 'ডাটাবেস তালিকা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (688, 'create_backup', 'Create Backup', 'ব্যাকআপ তৈরি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (689, 'backup', 'Backup', 'ব্যাকআপ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (690, 'backup_size', 'Backup Size', 'ব্যাকআপ আকার');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (691, 'file_upload', 'File Upload', 'ফাইল আপলোড');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (692, 'parents_details', 'Parents Details', 'পিতামাতার বিশদ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (693, 'social_links', 'Social Links', 'সামাজিক বন্ধন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (694, 'create_hostel', 'Create Hostel', 'হোস্টেল তৈরি করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (695, 'allocation_list', 'Allocation List', 'বরাদ্দ তালিকা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (696, 'payslip_history', 'Payslip History', 'পেইলিপ ইতিহাস');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (697, 'my_attendance_overview', 'My Attendance Overview', 'আমার উপস্থিতি ওভারভিউ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (698, 'total_present', 'Total Present', 'মোট উপস্থিত');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (699, 'total_absent', 'Total Absent', 'মোট অনুপস্থিত');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (700, 'total_late', 'Total Late', 'মোট লেট');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (701, 'class_teacher_list', 'Class Teacher List', 'শ্রেণি শিক্ষকের তালিকা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (702, 'section_control', 'Section Control', 'বিভাগ নিয়ন্ত্রণ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (703, 'capacity ', 'Capacity', 'ধারণক্ষমতা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (704, 'request', 'Request', 'অনুরোধ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (705, 'salary_year', 'Salary Year', 'বেতন বছর');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (706, 'create_attachments', 'Create Attachments', 'সংযুক্তি তৈরি করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (707, 'publish_date', 'Publish Date', 'প্রকাশের তারিখ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (708, 'attachment_file', 'Attachment File', 'উচ্চ স্বরে পড়া');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (709, 'age', 'Age', 'Age');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (710, 'student_profile', 'Student Profile', 'ছাত্র প্রোফাইল');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (711, 'authentication', 'Authentication', 'প্রমাণীকরণ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (712, 'parent_information', 'Parent Information', 'মূল তথ্য');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (713, 'full_marks', 'Full Marks', 'পুরোপুরি লক্ষ্য');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (714, 'passing_marks', 'Passing Marks', 'পাসিং মার্কস');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (715, 'highest_marks', 'Highest Marks', 'সর্বোচ্চ নম্বর');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (716, 'unknown', 'Unknown', 'অজানা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (717, 'unpublish', 'Unpublish', 'অপ্রকাশিত');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (718, 'login_authentication_deactivate', 'Login Authentication Deactivate', 'লগইন প্রমাণীকরণ নিষ্ক্রিয় করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (719, 'employee_profile', 'Employee Profile', 'কর্মচারী প্রোফাইল');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (720, 'employee_details', 'Employee Details', 'কর্মচারীর বিবরণ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (721, 'salary_transaction', 'Salary Transaction', 'বেতন লেনদেন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (722, 'documents', 'Documents', 'কাগজপত্র');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (723, 'actions', 'Actions', 'ক্রিয়াকলাপ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (724, 'activity', 'Activity', 'কার্যকলাপ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (725, 'department_list', 'Department List', 'বিভাগ তালিকা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (726, 'manage_employee_salary', 'Manage Employee Salary', 'কর্মচারীদের বেতন পরিচালনা করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (727, 'the_configuration_has_been_updated', 'The Configuration Has Been Updated', 'কনফিগারেশন আপডেট হয়েছে');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (728, 'add', 'Add', 'যোগ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (729, 'create_exam', 'Create Exam', 'পরীক্ষা তৈরি করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (730, 'term', 'Term', 'শব্দ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (731, 'add_term', 'Add Term', 'টার্ম যুক্ত করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (732, 'create_grade', 'Create Grade', 'গ্রেড তৈরি করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (733, 'mark_starting', 'Mark Starting', 'শুরুর চিহ্ন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (734, 'mark_until', 'Mark Until', 'অবধি চিহ্নিত করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (735, 'room_list', 'Room List', 'রুম তালিকা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (736, 'room', 'Room', 'ঘর');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (737, 'route_list', 'Route List', 'রুটের তালিকা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (738, 'create_route', 'Create Route', 'রুট তৈরি করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (739, 'vehicle_list', 'Vehicle List', 'যানবাহনের তালিকা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (740, 'create_vehicle', 'Create Vehicle', 'যানবাহন তৈরি করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (741, 'stoppage_list', 'Stoppage List', 'স্টপেজ তালিকা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (742, 'create_stoppage', 'Create Stoppage', 'স্টপেজ তৈরি করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (743, 'stop_time', 'Stop Time', 'সময় বন্ধ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (744, 'employee_attendance', 'Employee Attendance', 'কর্মচারী উপস্থিতি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (745, 'attendance_report', 'Attendance Report', 'উপস্থিতি রিপোর্ট');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (746, 'opening_balance', 'Opening Balance', 'খোলার ভারসাম্য');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (747, 'add_opening_balance', 'Add Opening Balance', 'উদ্বোধনী ব্যালেন্স যুক্ত করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (748, 'credit', 'Credit', 'ধার');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (749, 'debit', 'Debit', 'খরচ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (750, 'opening_balance_list', 'Opening Balance List', 'খোলার ভারসাম্য তালিকা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (751, 'voucher_list', 'Voucher List', 'ভাউচার তালিকা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (752, 'voucher_head', 'Voucher Head', 'ভাউচার হেড');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (753, 'payment_method', 'Payment Method', 'মূল্যপরিশোধ পদ্ধতি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (754, 'credit_ledger_account', 'Credit Ledger Account', 'ক্রেডিট লেজার অ্যাকাউন্ট');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (755, 'debit_ledger_account', 'Debit Ledger Account', 'ডেবিট লেজার অ্যাকাউন্ট');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (756, 'voucher_no', 'Voucher No', 'ভাউচার নং');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (757, 'balance', 'Balance', 'ভারসাম্য');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (758, 'event_details', 'Event Details', 'অনুষ্ঠানের বিবরণ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (759, 'welcome_to', 'Welcome To', 'স্বাগতম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (760, 'report_card', 'Report Card', 'রিপোর্ট কার্ড');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (761, 'online_pay', 'Online Pay', 'অনলাইন পে');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (762, 'annual_fees_summary', 'Annual Fees Summary', 'বার্ষিক ফি সংক্ষিপ্তসার');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (763, 'my_children', 'My Children', 'আমার শিশু');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (764, 'assigned', 'Assigned', 'বরাদ্দ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (765, 'confirm_password', 'Confirm Password', 'পাসওয়ার্ড নিশ্চিত করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (766, 'searching_results', 'Searching Results', 'অনুসন্ধান ফলাফল');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (767, 'information_has_been_saved_successfully', 'Information Has Been Saved Successfully', 'তথ্য সাফল্যের সাথে সংরক্ষণ করা হয়েছে');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (768, 'information_deleted', 'The information has been successfully deleted', 'তথ্য সফলভাবে মুছে ফেলা হয়েছে');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (769, 'deleted_note', '*Note : This data will be permanently deleted', '* দ্রষ্টব্য: এই তথ্য স্থায়ীভাবে মুছে ফেলা হবে');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (770, 'are_you_sure', 'Are You Sure?', 'তুমি কি নিশ্চিত?');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (771, 'delete_this_information', 'Do You Want To Delete This Information?', 'আপনি এই তথ্য মুছে ফেলতে চান?');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (772, 'yes_continue', 'Yes, Continue', 'হ্যাঁ, চালিয়ে যান');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (773, 'deleted', 'Deleted', 'মুছে ফেলা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (774, 'collect', 'Collect', 'সংগ্রহ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (775, 'school_setting', 'School Setting', 'স্কুল সেটিং');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (776, 'set', 'Set', 'সেট');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (777, 'quick_view', 'Quick View', 'তারাতারি দেখা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (778, 'due_fees_invoice', 'Due Fees Invoice', 'পারিশ্রমিক ফি চালান');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (779, 'my_application', 'My Application', 'আমার আবেদন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (780, 'manage_application', 'Manage Application', 'অ্যাপ্লিকেশন পরিচালনা করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (781, 'leave', 'Leave', 'ছুটি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (782, 'live_class_rooms', 'Live Class Rooms', 'লাইভ ক্লাস রুম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (783, 'homework', 'Homework', 'বাড়ির কাজ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (784, 'evaluation_report', 'Evaluation Report', 'মূল্যায়ন প্রতিবেদন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (785, 'exam_term', 'Exam Term', 'পরীক্ষার মেয়াদ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (786, 'distribution', 'Distribution', 'বিতরণ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (787, 'exam_setup', 'Exam Setup', 'পরীক্ষা সেটআপ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (788, 'sms', 'Sms', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (789, 'fees_type', 'Fees Type', 'ফি প্রকার');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (790, 'fees_group', 'Fees Group', 'ফি গ্রুপ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (791, 'fine_setup', 'Fine Setup', 'ফাইন সেটআপ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (792, 'fees_reminder', 'Fees Reminder', 'ফি অনুস্মারক');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (793, 'new_deposit', 'New Deposit', 'নতুন আমানত');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (794, 'new_expense', 'New Expense', 'নতুন ব্যয়');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (795, 'all_transactions', 'All Transactions', 'সমস্ত লেনদেন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (796, 'head', 'Head', 'মাথা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (797, 'fees_reports', 'Fees Reports', 'ফি প্রতিবেদন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (798, 'fees_report', 'Fees Report', 'ফি রিপোর্ট');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (799, 'receipts_report', 'Receipts Report', 'প্রাপ্তি রিপোর্ট');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (800, 'due_fees_report', 'Due Fees Report', 'বকেয়া ফি রিপোর্ট');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (801, 'fine_report', 'Fine Report', 'ফাইন রিপোর্ট');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (802, 'financial_reports', 'Financial Reports', 'আর্থিক প্রতিবেদন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (803, 'statement', 'Statement', 'বিবৃতি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (804, 'repots', 'Repots', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (805, 'expense', 'Expense', 'ব্যয়');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (806, 'transitions', 'Transitions', 'স্থানান্তর');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (807, 'sheet', 'Sheet', 'চাদর');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (808, 'income_vs_expense', 'Income Vs Expense', 'আয় বনাম ব্যয়');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (809, 'attendance_reports', 'Attendance Reports', 'উপস্থিতি রিপোর্ট');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (810, 'examination', 'Examination', 'পরীক্ষা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (811, 'school_settings', 'School Settings', 'স্কুল সেটিংস');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (812, 'role_permission', 'Role Permission', 'ভূমিকা অনুমতি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (813, 'cron_job', 'Cron Job', 'ক্রোন জব');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (814, 'custom_field', 'Custom Field', 'কাস্টম ক্ষেত্র');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (815, 'enter_valid_email', 'Enter Valid Email', 'সঠিক ইমেইল এড্রেস প্রদান করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (816, 'lessons', 'Lessons', 'পাঠ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (817, 'live_class', 'Live Class', 'লাইভ ক্লাস');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (818, 'sl', 'Sl', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (819, 'meeting_id', 'Meeting ID', 'লাইভ ক্লাস');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (820, 'start_time', 'Start Time', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (821, 'end_time', 'End Time', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (822, 'zoom_meeting_id', 'Zoom Meeting Id', 'জুম মিটিং আইডি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (823, 'zoom_meeting_password', 'Zoom Meeting Password', 'জুম মিটিংয়ের পাসওয়ার্ড');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (824, 'time_slot', 'Time Slot', 'সময় স্লট');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (825, 'send_notification_sms', 'Send Notification Sms', 'বিজ্ঞপ্তি এসএমএস প্রেরণ করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (826, 'host', 'Host', 'নিমন্ত্রণকর্তা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (827, 'school', 'School', 'বিদ্যালয়');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (828, 'accounting_links', 'Accounting Links', 'অ্যাকাউন্টিং লিংক');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (829, 'applicant', 'Applicant', 'প্রার্থী');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (830, 'apply_date', 'Apply Date', 'আবেদন করুন তারিখ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (831, 'add_leave', 'Add Leave', 'ছুটি যুক্ত করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (832, 'leave_date', 'Leave Date', 'ছেড়ে দিন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (833, 'attachment', 'Attachment', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (834, 'comments', 'Comments', 'মন্তব্য');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (835, 'staff_id', 'Staff Id', 'স্টাফ আইডি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (836, 'income_vs_expense_of', 'Income Vs Expense Of', 'আয় বনাম ব্যয়');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (837, 'designation_name', 'Designation Name', 'পদবি নাম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (838, 'already_taken', 'This %s already exists.', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (839, 'department_name', 'Department Name', 'বিভাগ নাম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (840, 'date_of_birth', 'Date Of Birth', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (841, 'bulk_delete', 'Bulk Delete', 'বাল্ক মুছুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (842, 'guardian_name', 'Guardian Name', 'অভিভাবকের নাম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (843, 'fees_progress', 'Fees Progress', 'ফি অগ্রগতি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (844, 'evaluate', 'Evaluate', 'মূল্যনির্ধারণ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (845, 'date_of_homework', 'Date Of Homework', 'হোম ওয়ার্কের তারিখ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (846, 'date_of_submission', 'Date Of Submission', 'জমা তারিখ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (847, 'student_fees_report', 'Student Fees Report', 'শিক্ষার্থী ফি রিপোর্ট');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (848, 'student_fees_reports', 'Student Fees Reports', 'ছাত্র ফি প্রতিবেদন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (849, 'due_date', 'Due Date', 'নির্দিষ্ট তারিখ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (850, 'payment_date', 'Payment Date', 'টাকা প্রদানের তারিখ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (851, 'payment_via', 'Payment Via', 'অর্থ প্রদানের মাধ্যমে');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (852, 'generate', 'Generate', 'জেনারেট করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (853, 'print_date', 'Print Date', 'মুদ্রণ তারিখ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (854, 'bulk_sms_and_email', 'Bulk Sms And Email', 'বাল্ক এসএমএস এবং ইমেল');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (855, 'campaign_type', 'Campaign Type', 'প্রচারের ধরণ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (856, 'both', 'Both', 'উভয়');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (857, 'regular', 'Regular', 'নিয়মিত');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (858, 'Scheduled', 'Scheduled', 'তালিকাভুক্ত');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (859, 'campaign', 'Campaign', 'ক্যাম্পেইন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (860, 'campaign_name', 'Campaign Name', 'প্রচারাভিযান নাম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (861, 'sms_gateway', 'Sms Gateway', 'এসএমএস গেটওয়ে');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (862, 'recipients_type', 'Recipients Type', 'প্রাপক প্রকার');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (863, 'recipients_count', 'Recipients Count', 'প্রাপকগণ গণনা করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (864, 'body', 'Body', 'শরীর');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (865, 'guardian_already_exist', 'Guardian Already Exist', 'অভিভাবক ইতিমধ্যে বিদ্যমান');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (866, 'guardian', 'Guardian', 'অভিভাবক');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (867, 'mother_name', 'Mother Name', 'মা নাম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (868, 'bank_details', 'Bank Details', 'ব্যাংক বিবরণ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (869, 'skipped_bank_details', 'Skipped Bank Details', 'বাদ দেওয়া ব্যাঙ্কের বিশদ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (870, 'bank', 'Bank', 'ব্যাংক');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (871, 'holder_name', 'Holder Name', 'ধারক নাম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (872, 'bank_branch', 'Bank Branch', 'ব্যাংকের শাখা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (873, 'custom_field_for', 'Custom Field For', 'কাস্টম ফিল্ড জন্য');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (874, 'label', 'Label', 'লেবেল');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (875, 'order', 'Order', 'ক্রম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (876, 'online_admission', 'Online Admission', 'অনলাইন ভর্তি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (877, 'field_label', 'Field Label', 'ফিল্ড লেবেল');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (878, 'field_type', 'Field Label', 'ফিল্ড লেবেল');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (879, 'default_value', 'Default Value', 'ডিফল্ট মান');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (880, 'checked', 'Checked', 'সংযত');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (881, 'unchecked', 'Unchecked', 'অবারিত');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (882, 'roll_number', 'Roll Number', 'রোল নাম্বার');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (883, 'add_rows', 'Add Rows', 'সারি যুক্ত করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (884, 'salary', 'Salary', 'বেতন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (885, 'basic', 'Basic', 'মৌলিক');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (886, 'allowance', 'Allowance', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (887, 'deduction', 'Deduction', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (888, 'net', 'Net', 'নেট');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (889, 'activated_sms_gateway', 'Activated Sms Gateway', 'সক্রিয় এসএমএস গেটওয়ে');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (890, 'account_sid', 'Account Sid', 'অ্যাকাউন্ট সিড');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (891, 'roles', 'Roles', 'ভূমিকা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (892, 'system_role', 'System Role', 'সিস্টেমের ভূমিকা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (893, 'permission', 'Permission', 'অনুমতি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (894, 'edit_session', 'Edit Session', 'সেশন সম্পাদনা করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (895, 'transactions', 'Transactions', 'লেনদেন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (896, 'default_account', 'Default Account', 'ডিফল্ট অ্যাকাউন্ট');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (897, 'deposit', 'Deposit', 'আমানত');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (898, 'acccount', 'Acccount', 'অ্যাকাউন্টে');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (899, 'role_permission_for', 'Role Permission For', 'ভূমিকা জন্য অনুমতি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (900, 'feature', 'Feature', 'বৈশিষ্ট্য');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (901, 'access_denied', 'Access Denied', 'অ্যাক্সেস অস্বীকৃত');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (902, 'time_start', 'Time Start', 'সময় শুরু');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (903, 'time_end', 'Time End', 'সময় শেষ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (904, 'month_of_salary', 'Month Of Salary', 'বেতন মাস');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (905, 'add_documents', 'Add Documents', 'নথি যুক্ত করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (906, 'document_type', 'Document Type', 'নথিপত্র ধরণ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (907, 'document', 'Document', 'দলিল');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (908, 'document_title', 'Document Title', 'নথির শিরোনাম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (909, 'document_category', 'Document Category', 'নথি বিভাগ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (910, 'exam_result', 'Exam Result', 'পরীক্ষার ফলাফল');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (911, 'my_annual_fee_summary', 'My Annual Fee Summary', 'আমার বার্ষিক ফি সংক্ষিপ্তসার');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (912, 'book_manage', 'Book Manage', 'বই পরিচালনা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (913, 'add_leave_category', 'Add Leave Category', 'ছাড়ার বিভাগ যুক্ত করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (914, 'edit_leave_category', 'Edit Leave Category', 'বিভাগ ছেড়ে যান');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (915, 'staff_role', 'Staff Role', 'স্টাফ ভূমিকা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (916, 'edit_assign', 'Edit Assign', 'সম্পাদনা করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (917, 'view_report', 'View Report', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (918, 'rank_out_of_5', 'Rank Out Of 5', 'র‌্যাঙ্ক আউট 5');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (919, 'hall_no', 'Hall No', 'হল নং');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (920, 'no_of_seats', 'No Of Seats', 'নং আসন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (921, 'mark_distribution', 'Mark Distribution', 'চিহ্ন বিতরণ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (922, 'exam_type', 'Exam Type', 'পরীক্ষার ধরণ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (923, 'marks_and_grade', 'Marks And Grade', 'চিহ্ন এবং গ্রেড');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (924, 'min_percentage', 'Min Percentage', 'ন্যূনতম শতাংশ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (925, 'max_percentage', 'Max Percentage', 'সর্বোচ্চ শতাংশ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (926, 'cost_per_bed', 'Cost Per Bed', 'প্রতি বিছানা খরচ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (927, 'add_category', 'Add Category', 'বিভাগ যুক্ত করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (928, 'category_for', 'Category For', 'বিভাগের জন্য');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (929, 'start_place', 'Start Place', 'স্টার্ট প্লেস');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (930, 'stop_place', 'Stop Place', 'স্টপ প্লেস');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (931, 'vehicle', 'Vehicle', 'বাহন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (932, 'select_multiple_vehicle', 'Select Multiple Vehicle', 'একাধিক যান নির্বাচন করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (933, 'book_details', 'Book Details', 'বইয়ের বিবরণ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (934, 'issued_by', 'Issued By', 'প্রদান করেছেন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (935, 'return_by', 'Return By', 'ফিরে আসুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (936, 'group', 'Group', 'গ্রুপ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (937, 'individual', 'Individual', 'স্বতন্ত্র');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (938, 'recipients', 'Recipients', 'প্রাপক');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (939, 'group_name', 'Group Name', 'দলের নাম');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (940, 'fee_code', 'Fee Code', 'ফি কোড');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (941, 'fine_type', 'Fine Type', 'ফাইন টাইপ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (942, 'fine_value', 'Fine Value', 'সূক্ষ্ম মান');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (943, 'late_fee_frequency', 'Late Fee Frequency', 'দেরিতে ফি ফ্রিকোয়েন্সি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (944, 'fixed_amount', 'Fixed Amount', 'নির্দিষ্ট পরিমাণ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (945, 'fixed', 'Fixed', 'ফিক্সড');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (946, 'daily', 'Daily', 'দৈনন্দিন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (947, 'weekly', 'Weekly', 'সাপ্তাহিক');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (948, 'monthly', 'Monthly', 'মাসিক');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (949, 'annually', 'Annually', 'সালিয়ানা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (950, 'first_select_the_group', 'First Select The Group', 'প্রথমে গ্রুপটি নির্বাচন করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (951, 'percentage', 'Percentage', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (952, 'value', 'Value', 'মান');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (953, 'fee_group', 'Fee Group', 'ফি গ্রুপ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (954, 'due_invoice', 'Due Invoice', 'ইনভয়েস');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (955, 'reminder', 'Reminder', 'অনুস্মারক');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (956, 'frequency', 'Frequency', 'ফ্রিকোয়েন্সি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (957, 'notify', 'Notify', 'অবহিত');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (958, 'before', 'Before', 'আগে');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (959, 'after', 'After', 'পরে');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (960, 'number', 'Number', 'সংখ্যা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (961, 'ref_no', 'Ref No', 'সুত্র নেই');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (962, 'pay_via', 'Pay Via', 'ভায়া দিয়ে');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (963, 'ref', 'Ref', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (964, 'dr', 'Dr', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (965, 'cr', 'Cr', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (966, 'edit_book', 'Edit Book', 'সম্পাদনা বই');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (967, 'leaves', 'Leaves', 'পত্রাদি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (968, 'leave_request', 'Leave Request', 'অনুরোধ ত্যাগ করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (969, 'this_file_type_is_not_allowed', 'This File Type Is Not Allowed', 'এই ফাইল টাইপ অনুমোদিত নয়');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (970, 'error_reading_the_file', 'Error Reading The File', 'ফাইলটি পড়ার সময় ত্রুটি');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (971, 'staff', 'Staff', 'কর্মী');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (972, 'waiting', 'Waiting', 'অপেক্ষা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (973, 'live', 'Live', 'লাইভ দেখান');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (974, 'by', 'By', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (975, 'host_live_class', 'Host Live Class', 'হোস্ট লাইভ ক্লাস');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (976, 'join_live_class', 'Join Live Class', 'লাইভ ক্লাসে যোগদান করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (977, 'system_logo', 'System Logo', 'সিস্টেম লোগো');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (978, 'text_logo', 'Text Logo', 'পাঠ্য লোগো');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (979, 'printing_logo', 'Printing Logo', 'মুদ্রণ লোগো');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (980, 'expired', 'Expired', 'মেয়াদোত্তীর্ণ');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (981, 'collect_fees', 'Collect Fees', 'ফি সংগ্রহ করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (982, 'fees_code', 'Fees Code', 'ফি কোড');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (983, 'collect_by', 'Collect By', 'সংগ্রহ করুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (984, 'fee_payment', 'Fee Payment', 'ফি জমাদান');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (985, 'write_message', 'Write Message', 'বার্তা লিখুন');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (986, 'discard', 'Discard', 'বাতিল করা');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (987, 'message_sent_successfully', 'Message Sent Successfully', 'বার্তা সফলভাবে পাঠানো হয়েছে');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (988, 'visit_home_page', 'Visit Home Page', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (989, 'frontend', 'Frontend', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (990, 'setting', 'Setting', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (991, 'menu', 'Menu', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (992, 'page', 'Page', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (993, 'manage', 'Manage', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (994, 'slider', 'Slider', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (995, 'features', 'Features', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (996, 'testimonial', 'Testimonial', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (997, 'service', 'Service', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (998, 'faq', 'Faq', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (999, 'card_management', 'Card Management', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1000, 'id_card', 'Id Card', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1001, 'templete', 'Templete', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1002, 'admit_card', 'Admit Card', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1003, 'certificate', 'Certificate', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1004, 'system_update', 'System Update', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1005, 'url', 'Url', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1006, 'content', 'Content', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1007, 'banner_photo', 'Banner Photo', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1008, 'meta', 'Meta', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1009, 'keyword', 'Keyword', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1010, 'applicable_user', 'Applicable User', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1011, 'page_layout', 'Page Layout', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1012, 'background', 'Background', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1013, 'image', 'Image', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1014, 'width', 'Width', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1015, 'height', 'Height', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1016, 'signature', 'Signature', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1017, 'website', 'Website', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1018, 'cms', 'Cms', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1019, 'url_alias', 'Url Alias', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1020, 'cms_frontend', 'Cms Frontend', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1021, 'enabled', 'Enabled', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1022, 'receive_email_to', 'Receive Email To', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1023, 'captcha_status', 'Captcha Status', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1024, 'recaptcha_site_key', 'Recaptcha Site Key', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1025, 'recaptcha_secret_key', 'Recaptcha Secret Key', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1026, 'working_hours', 'Working Hours', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1027, 'fav_icon', 'Fav Icon', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1028, 'theme', 'Theme', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1029, 'fax', 'Fax', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1030, 'footer_about_text', 'Footer About Text', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1031, 'copyright_text', 'Copyright Text', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1032, 'facebook_url', 'Facebook Url', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1033, 'twitter_url', 'Twitter Url', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1034, 'youtube_url', 'Youtube Url', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1035, 'google_plus', 'Google Plus', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1036, 'linkedin_url', 'Linkedin Url', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1037, 'pinterest_url', 'Pinterest Url', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1038, 'instagram_url', 'Instagram Url', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1039, 'play', 'Play', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1040, 'video', 'Video', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1041, 'usename', 'Usename', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1042, 'experience_details', 'Experience Details', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1043, 'total_experience', 'Total Experience', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1044, 'class_schedule', 'Class Schedule', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1045, 'cms_default_branch', 'Cms Default Branch', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1046, 'website_page', 'Website Page', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1047, 'welcome', 'Welcome', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1048, 'services', 'Services', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1049, 'call_to_action_section', 'Call To Action Section', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1050, 'subtitle', 'Subtitle', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1051, 'cta', 'Cta', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1052, 'button_text', 'Button Text', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1053, 'button_url', 'Button Url', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1054, '_title', ' Title', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1055, 'contact', 'Contact', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1056, 'box_title', 'Box Title', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1057, 'box_description', 'Box Description', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1058, 'box_photo', 'Box Photo', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1059, 'form_title', 'Form Title', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1060, 'submit_button_text', 'Submit Button Text', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1061, 'map_iframe', 'Map Iframe', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1062, 'email_subject', 'Email Subject', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1063, 'prefix', 'Prefix', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1064, 'surname', 'Surname', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1065, 'rank', 'Rank', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1066, 'submit', 'Submit', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1067, 'certificate_name', 'Certificate Name', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1068, 'layout_width', 'Layout Width', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1069, 'layout_height', 'Layout Height', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1070, 'expiry_date', 'Expiry Date', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1071, 'position', 'Position', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1072, 'target_new_window', 'Target New Window', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1073, 'external_url', 'External Url', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1074, 'external_link', 'External Link', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1075, 'sms_notification', 'Sms Notification', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1076, 'scheduled_at', 'Scheduled At', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1077, 'published', 'Published', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1078, 'unpublished_on_website', 'Unpublished On Website', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1079, 'published_on_website', 'Published On Website', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1080, 'no_selection_available', 'No Selection Available', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1081, 'select_for_everyone', 'Select For Everyone', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1082, 'teacher_restricted', 'Teacher Restricted', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1083, 'guardian_relation', 'Guardian Relation', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1084, 'username_prefix', 'Username Prefix', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1085, 'default_password', 'Default Password', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1086, 'parents_profile', 'Parents Profile', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1087, 'childs', 'Childs', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1088, 'page_title', 'Page Title', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1089, 'select_menu', 'Select Menu', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1090, 'meta_keyword', 'Meta Keyword', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1091, 'meta_description', 'Meta Description', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1092, 'evaluation_date', 'Evaluation Date', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1093, 'evaluated_by', 'Evaluated By', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1094, 'complete', 'Complete', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1095, 'incomplete', 'Incomplete', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1096, 'payment_details', 'Payment Details', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1097, 'edit_attachments', 'Edit Attachments', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1098, 'live_classes', 'Live Classes', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1099, 'duration', 'Duration', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1100, 'metting_id', 'Metting Id', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1101, 'set_record', 'Set Record', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1102, 'set_mute_on_start', 'Set Mute On Start', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1103, 'button_text_1', 'Button Text 1', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1104, 'button_url_1', 'Button Url 1', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1105, 'button_text_2', 'Button Text 2', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1106, 'button_url_2', 'Button Url 2', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1107, 'left', 'Left', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1108, 'center', 'Center', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1109, 'right', 'Right', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1110, 'about', 'About', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1111, 'about_photo', 'About Photo', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1112, 'parallax_photo', 'Parallax Photo', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1113, 'decline', 'Decline', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1114, 'edit_grade', 'Edit Grade', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1115, 'mark', 'Mark', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1116, 'hall_room', 'Hall Room', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1117, 'student_promotion', 'Student Promotion', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1118, 'username_has_already_been_used', 'Username Has Already Been Used', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1119, 'fee_collection', 'Fee Collection', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1120, 'not_found_anything', 'Not Found Anything', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1121, 'preloader_backend', 'Preloader Backend', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1122, 'ive_class_method', 'Ive Class Method', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1123, 'live_class_method', 'Live Class Method', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1124, 'api_credential', 'Api Credential', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1125, 'translation_update', 'Translation Update', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1126, ' live_class_reports', ' Live Class Reports', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1127, 'live_class_reports', 'Live Class Reports', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1128, 'all', 'All', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1129, 'student_participation_report', 'Student Participation Report', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1130, 'joining_time', 'Joining Time', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1131, 'inventory', 'Inventory', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1132, 'product', 'Product', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1133, 'store', 'Store', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1134, 'supplier', 'Supplier', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1135, 'unit', 'Unit', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1136, 'purchase', 'Purchase', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1137, 'sales', 'Sales', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1138, 'issue', 'Issue', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1139, 'gallery', 'Gallery', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1140, 'news', 'News', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1141, 'reception', 'Reception', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1142, 'admission_enquiry', 'Admission Enquiry', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1143, 'postal_record', 'Postal Record', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1144, 'call_log', 'Call Log', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1145, 'visitor_log', 'Visitor Log', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1146, 'complaint', 'Complaint', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1147, 'multi_class', 'Multi Class', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1148, 'deactivate_reason', 'Deactivate Reason', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1149, 'marksheet', 'Marksheet', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1150, 'generate_position', 'Generate Position', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1151, 'online_exam', 'Online Exam', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1152, 'question_bank', 'Question Bank', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1153, 'question_group', 'Question Group', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1154, 'subject_wise', 'Subject Wise', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1155, 'my_issued_book', 'My Issued Book', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1156, 'book_issue/return', 'Book Issue/return', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1157, 'offline_payments', 'Offline Payments', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1158, 'payments', 'Payments', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1159, ' offline_payments', ' Offline Payments', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1160, 'login_credential', 'Login Credential', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1161, 'admission_report', 'Admission Report', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1162, 'class_&_section_report', 'Class & Section Report', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1163, 'sibling_report', 'Sibling Report', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1164, 'daily_reports', 'Daily Reports', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1165, 'overview_reports', 'Overview Reports', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1166, 'subject_wise_reports', 'Subject Wise Reports', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1167, 'subject_wise_by', 'Subject Wise By', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1168, 'progress', 'Progress', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1169, 'stock', 'Stock', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1170, 'issues', 'Issues', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1171, 'alumni', 'Alumni', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1172, 'manage_alumni', 'Manage Alumni', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1173, 'addon_manager', 'Addon Manager', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1174, 'modules', 'Modules', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1175, 'system_student_field', 'System Student Field', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1176, 'user_login_log', 'User Login Log', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1177, 'december', 'December', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1178, 'today_birthday', 'Today Birthday', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1179, 'currency_formats', 'Currency Formats', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1180, 'symbol_position', 'Symbol Position', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1181, 'edit_branch', 'Edit Branch', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1182, 'whatsapp_settings', 'Whatsapp Settings', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1183, 'general_setting', 'General Setting', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1184, 'weekends', 'Weekends', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1185, 'sunday', 'Sunday', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1186, 'monday', 'Monday', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1187, 'tuesday', 'Tuesday', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1188, 'wednesday', 'Wednesday', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1189, 'thursday', 'Thursday', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1190, 'friday', 'Friday', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1191, 'saturday', 'Saturday', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1192, 'select_weekends', 'Select Weekends', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1193, 'unique_roll', 'Unique Roll', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1194, 'classes_wise', 'Classes Wise', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1195, 'section_wise', 'Section Wise', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1196, 'start_from', 'Start From', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1197, 'digit', 'Digit', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1198, 'fees_carry_forward_setting', 'Fees Carry Forward Setting', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1199, 'due_days', 'Due Days', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1200, 'due_fees_calculation_with_fine_', 'Due Fees Calculation With Fine ', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1201, 'fields', 'Fields', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1202, 'active', 'Active', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1203, 'clear_userlog', 'Clear Userlog', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1204, 'browser', 'Browser', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1205, 'login_date_time', 'Login Date Time', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1206, 'platform', 'Platform', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1207, 'guardian_picture', 'Guardian Picture', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1208, 'publish_result', 'Publish Result', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1209, 'day_wise', 'Day Wise', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1210, 'header_title', 'Header Title', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1211, 'frontend_enable_chat', 'Frontend Enable Chat', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1212, 'backend_enable_chat', 'Backend Enable Chat', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1213, 'whatsapp_agent', 'Whatsapp Agent', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1214, 'agent', 'Agent', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1215, 'whataspp_number', 'Whataspp Number', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1216, 'weekend', 'Weekend', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1217, 'online_exam_publish', 'Online Exam Publish', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1218, 'student_birthday_wishes', 'Student Birthday Wishes', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1219, 'staff_birthday_wishes', 'Staff Birthday Wishes', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1220, 'alumni_event', 'Alumni Event', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1221, 'create_section', 'Create Section', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1222, 'section_list', 'Section List', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1223, 'edit_section', 'Edit Section', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1224, 'set_parameters_to_quickly_create_schedule', 'Set Parameters To Quickly Create Schedule', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1225, 'starting_date', 'Starting Date', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1226, 'interval', 'Interval', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1227, 'google_analytics', 'Google Analytics', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1228, 'addon', 'Addon', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1229, 'install', 'Install', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1230, 'version', 'Version', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1231, 'installed', 'Installed', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1232, 'last_upgrade', 'Last Upgrade', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1233, 'addon_purchase_code', 'Addon Purchase Code', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1234, 'install_now', 'Install Now', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1235, 'change', 'Change', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1236, 'class_&_section', 'Class & Section', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1237, 'admission_reports', 'Admission Reports', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1238, 'leave_days', 'Leave Days', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1239, 'advance_salary_request', 'Advance Salary Request', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1240, 'student_parent_panel', 'Student Parent Panel', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1241, 'privacy', 'Privacy', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1242, 'zoom_credentials', 'Zoom Credentials', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1243, 'set_zoom_redirect_url', 'Set Zoom Redirect Url', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1244, 'show_website', 'Show Website', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1245, 'exploring', 'Exploring', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1246, 'add_class', 'Add Class', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1247, 'enquiry', 'Enquiry', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1248, 'reference', 'Reference', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1249, 'next', 'Next', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1250, 'follow_up', 'Follow Up', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1251, 'previous_school', 'Previous School', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1252, 'no_of_child', 'No Of Child', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1253, 'response', 'Response', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1254, 'note', 'Note', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1255, 'class_applying_for', 'Class Applying For', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1256, 'confidential', 'Confidential', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1257, 'dispatch', 'Dispatch', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1258, 'receive', 'Receive', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1259, 'reference_no', 'Reference No', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1260, 'calling_purpose', 'Calling Purpose', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1261, 'call_type', 'Call Type', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1262, 'outgoing', 'Outgoing', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1263, 'incoming', 'Incoming', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1264, 'visitor', 'Visitor', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1265, 'visiting_purpose', 'Visiting Purpose', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1266, 'entry_time', 'Entry Time', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1267, 'exit_time', 'Exit Time', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1268, 'number_of_visitor', 'Number Of Visitor', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1269, 'token/pass', 'Token/pass', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1270, 'id_number', 'Id Number', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1271, 'complainant', 'Complainant', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1272, 'date_of_solution', 'Date Of Solution', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1273, 'assign_to', 'Assign To', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1274, 'action_taken', 'Action Taken', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1275, 'code', 'Code', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1276, 'purchase_unit', 'Purchase Unit', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1277, 'sale_unit', 'Sale Unit', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1278, 'unit_ratio', 'Unit Ratio', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1279, 'purchase_price', 'Purchase Price', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1280, 'sales_price', 'Sales Price', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1281, 'sales_unit', 'Sales Unit', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1282, 'store_code', 'Store Code', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1283, 'contact_number', 'Contact Number', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1284, 'company_name', 'Company Name', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1285, 'bill_no', 'Bill No', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1286, 'payable', 'Payable', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1287, 'ordered', 'Ordered', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1288, 'received', 'Received', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1289, 'add_products_to_stock_list', 'Add Products To Stock List', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1290, 'sale_to', 'Sale To', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1291, 'bill', 'Bill', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1292, 'summary', 'Summary', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1293, 'sub_total', 'Sub Total', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1294, 'enter_payment_amount', 'Enter Payment Amount', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1295, 'issue_to', 'Issue To', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1296, 'remark', 'Remark', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1297, 'quantity', 'Quantity', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1298, 'first_select_the_category', 'First Select The Category', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1299, 'net_total', 'Net Total', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1300, 'no_row_are_selected', 'No Row Are Selected', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1301, 'promotion_history', 'Promotion History', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1302, 'from_class', 'From Class', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1303, 'from_session', 'From Session', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1304, 'promoted_class', 'Promoted Class', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1305, 'promoted_session', 'Promoted Session', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1306, 'promoted_date', 'Promoted Date', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1307, 'sibling_information', 'Sibling Information', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1308, 'disable_reason', 'Disable Reason', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1309, 'the_next_session_was_transferred_to_the_students', 'The Next Session Was Transferred To The Students', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1310, 'promote_to_session', 'Promote To Session', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1311, 'promote_to_class', 'Promote To Class', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1312, 'promote_to_section', 'Promote To Section', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1313, 'mark_summary', 'Mark Summary', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1314, 'current_due_amount', 'Current Due Amount', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1315, 'with_fine', 'With Fine', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1316, 'running', 'Running', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1317, 'promoted', 'Promoted', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1318, 'questions_qty', 'Questions Qty', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1319, 'exam_status', 'Exam Status', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1320, 'limits_of_participation', 'Limits Of Participation', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1321, 'passing_mark', 'Passing Mark', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1322, 'instruction', 'Instruction', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1323, 'free', 'Free', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1324, 'question', 'Question', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1325, 'random', 'Random', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1326, 'result_publish', 'Result Publish', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1327, 'negative_mark', 'Negative Mark', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1328, 'applicable', 'Applicable', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1329, 'marks_display', 'Marks Display', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1330, 'make', 'Make', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1331, 'class_position', 'Class Position', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1332, 'exam_rank', 'Exam Rank', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1333, 'principal_comments', 'Principal Comments', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1334, 'teacher_comments', 'Teacher Comments', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1335, 'statistics', 'Statistics', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1336, 'employees', 'Employees', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1337, 'classes', 'Classes', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1338, 'parent_menu', 'Parent Menu', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1339, 'SMS configuration not found', 'SMS Configuration Not Found', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1340, 'thumb_image', 'Thumb Image', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1341, 'uploaded', 'Uploaded', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1342, 'no_sms_gateway_available', 'No Sms Gateway Available', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1343, 'send_wishes', 'Send Wishes', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1344, 'middle', 'Middle', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1345, 'header', 'Header', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1346, 'footer', 'Footer', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1347, 'grading_scale', 'Grading Scale', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1348, 'cumulative', 'Cumulative', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1349, 'background_file', 'Background File', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1350, 'purchase_code', 'Purchase Code', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1351, 'main_logo', 'Main Logo', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1352, 'Mobile_Logo', 'Mobile Logo', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1353, 'EIIN_No', 'EIIN No', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1354, 'College_Code', 'College Code', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1355, 'eiien_no', 'Eiien No', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1356, 'college_no', 'College No', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1357, 'password_has_been_changed', 'Password Has Been Changed', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1358, 'emergency_notice', 'Emergency Notice', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1359, 'Institute History Short', 'Institute History Short', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1360, 'Institute History', 'Institute History', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1361, 'Short', 'Short', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1362, 'Institute History Short Description', 'Institute History Short Description', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1363, 'Instititute History Tittle', 'Instititute History Tittle', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1364, 'Instititute History Short Description', 'Instititute History Short Description', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1365, 'Instititute Short Description', 'Instititute Short Description', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1366, 'Principal & Sovapoti', 'Principal & Sovapoti', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1367, 'Instititute Short', 'Instititute Short', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1368, 'Institute Photo', 'Institute Photo', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1369, 'Principal Message', 'Principal Message', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1370, 'Sovapoti Message', 'Sovapoti Message', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1371, 'Principal Short Message', 'Principal Short Message', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1372, 'Sovapoti Short Message', 'Sovapoti Short Message', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1373, 'Principal Long Message', 'Principal Long Message', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1374, 'Sovapoti Long Message', 'Sovapoti Long Message', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1375, 'Principal_photo', 'Principal Photo', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1376, 'Principal_images', 'Principal Images', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1377, 'Sovapoti_images', 'Sovapoti Images', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1378, 'Sovapotir_Images', 'Sovapotir Images', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1379, 'news_title', 'News Title', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1380, 'Facebook_Page_url', 'Facebook Page Url', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1381, 'URL_Embed_Link', 'URL Embed Link', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1382, 'Video_Gallery', 'Video Gallery', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1383, 'add_Video', 'Add Video', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1384, 'Youtube_Video_Embed_Link', 'Youtube Video Embed Link', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1385, 'Video Gallery', 'Video Gallery', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1386, 'Customization', 'Customization', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1387, 'gallery_title', 'Gallery Title', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1388, 'Terms_&_Condition', 'Terms & Condition', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1389, 'Privacy_Policy', 'Privacy Policy', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1390, 'SEO', 'SEO', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1391, 'Meta_tittle', 'Meta Tittle', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1392, 'fields_setting', 'Fields Setting', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1393, 'terms_conditions', 'Terms Conditions', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1394, 'online_addmission', 'Online Addmission', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1395, 'fee', 'Fee', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1396, 'pay', 'Pay', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1397, 'certificates', 'Certificates', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1398, 'Ivent', 'Ivent', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1399, 'Event', 'Event', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1400, 'default_template', 'Default Template', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1401, 'under_review', 'Under Review', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1402, 'january', 'January', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1403, 'Slug', 'Slug', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1404, 'alias', 'Alias', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1405, 'link', 'Link', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1406, 'Notice', 'Notice', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1407, 'add_Notice', 'Add Notice', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1408, 'edit_Notice', 'Edit Notice', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1409, 'all_days', 'All Days', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1410, 'mark_from', 'Mark From', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1411, 'mark_upto', 'Mark Upto', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1412, 'passing_session', 'Passing Session', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1413, 'send_confirmation_sms', 'Send Confirmation Sms', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1414, 'instructions', 'Instructions', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1415, 'payment_status', 'Payment Status', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1416, 'selected_revert', 'Selected Revert', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1417, 'invalid_marks', 'Invalid Marks', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1418, 'not_generated', 'Not Generated', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1419, 'apply_online_admission', 'Apply Online Admission', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1420, 'email_pdf_exam_marksheet', 'Email Pdf Exam Marksheet', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1421, 'email_pdf_fee_invoice', 'Email Pdf Fee Invoice', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1422, 'student_login_has_been_disabled', 'Student Login Has Been Disabled', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`) VALUES (1423, 'half_day', 'Half Day', '');


#
# TABLE STRUCTURE FOR: leave_application
#

DROP TABLE IF EXISTS `leave_application`;

CREATE TABLE `leave_application` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `role_id` int(11) NOT NULL,
  `category_id` int(2) NOT NULL,
  `reason` longtext CHARACTER SET utf32 COLLATE utf32_unicode_ci NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `leave_days` varchar(20) NOT NULL DEFAULT '0',
  `status` int(2) NOT NULL DEFAULT 1 COMMENT '1=pending,2=accepted 3=rejected',
  `apply_date` date DEFAULT NULL,
  `approved_by` int(11) NOT NULL,
  `orig_file_name` varchar(255) NOT NULL,
  `enc_file_name` varchar(255) NOT NULL,
  `comments` varchar(255) NOT NULL,
  `session_id` int(11) DEFAULT NULL,
  `branch_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: leave_category
#

DROP TABLE IF EXISTS `leave_category`;

CREATE TABLE `leave_category` (
  `id` int(2) NOT NULL AUTO_INCREMENT,
  `name` longtext CHARACTER SET utf32 COLLATE utf32_unicode_ci NOT NULL,
  `role_id` tinyint(1) NOT NULL,
  `days` int(11) NOT NULL,
  `branch_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `leave_category` (`id`, `name`, `role_id`, `days`, `branch_id`) VALUES (1, 'Casual Leave', 3, 10, 1);
INSERT INTO `leave_category` (`id`, `name`, `role_id`, `days`, `branch_id`) VALUES (2, 'Sick Leave', 3, 14, 1);


#
# TABLE STRUCTURE FOR: live_class
#

DROP TABLE IF EXISTS `live_class`;

CREATE TABLE `live_class` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `live_class_method` tinyint(1) NOT NULL DEFAULT 1,
  `title` varchar(255) NOT NULL,
  `meeting_id` varchar(255) NOT NULL,
  `meeting_password` varchar(255) NOT NULL,
  `own_api_key` tinyint(1) NOT NULL DEFAULT 0,
  `duration` int(11) NOT NULL,
  `bbb` longtext NOT NULL,
  `class_id` int(11) NOT NULL,
  `section_id` text NOT NULL,
  `remarks` text NOT NULL,
  `date` date NOT NULL,
  `start_time` time NOT NULL,
  `end_time` time NOT NULL,
  `created_by` int(11) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `branch_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: live_class_config
#

DROP TABLE IF EXISTS `live_class_config`;

CREATE TABLE `live_class_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `zoom_api_key` varchar(255) DEFAULT NULL,
  `zoom_api_secret` varchar(255) DEFAULT NULL,
  `bbb_salt_key` varchar(355) DEFAULT NULL,
  `bbb_server_base_url` varchar(355) DEFAULT NULL,
  `staff_api_credential` tinyint(1) NOT NULL DEFAULT 0,
  `student_api_credential` tinyint(1) NOT NULL DEFAULT 0,
  `branch_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: live_class_reports
#

DROP TABLE IF EXISTS `live_class_reports`;

CREATE TABLE `live_class_reports` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `live_class_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: login_credential
#

DROP TABLE IF EXISTS `login_credential`;

CREATE TABLE `login_credential` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `username` varchar(100) NOT NULL,
  `password` varchar(250) NOT NULL,
  `role` tinyint(2) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1 COMMENT '1(active) 0(deactivate)',
  `last_login` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=637 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (1, 1, 'info@elitedesign.com.bd', '$2y$10$F47nBozij68qvuPDfNl7euB1kcib17yr8QIwceqJThuZgDWtuEftW', 1, 1, '2025-01-11 23:06:53', '2024-12-27 13:31:06', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (39, 19, '', '$2y$10$926qW11jTWEfLq2UONqoguVC/bd5eF7U/MwW3khsp3gHbwCcVdmea', 6, 1, NULL, '2024-12-27 16:53:05', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (41, 20, '', '$2y$10$PeVcxKXr85ejZI6k5RXdEuCGcPecMlWRZN85s7VXyjXiDzUQVHwWi', 6, 1, NULL, '2024-12-27 16:53:05', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (43, 21, '', '$2y$10$y76FU6a6/Gb5Xgj4pi/XNuVtfANEGCPEtDMb4R5Zj1X7gukhh7CT.', 6, 1, NULL, '2024-12-27 16:53:05', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (45, 22, '', '$2y$10$8KIBTZOjr45X/t3JEr5ekeMeiFu/Z6LBsU00.ZCddZc7aShygOKtG', 6, 1, NULL, '2024-12-27 16:53:06', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (47, 23, '', '$2y$10$r.S/fr5x95G4W0r4IuQuPOg2/SL1JMdt6O1qGNGaNlSnC8wP/YaRq', 6, 1, NULL, '2024-12-27 16:53:06', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (49, 24, '', '$2y$10$GW0KklSAGwDxQfCmu.Caiu3QsR9n7nq4EX0XAUwRtqWxeRiqAm7Xq', 6, 1, NULL, '2024-12-27 16:53:06', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (51, 25, '', '$2y$10$Pm9fhk2Uzwy.07dumIVCL.Wmm8PBhVgTCplBjwFooIxMFEKem.qrS', 6, 1, NULL, '2024-12-27 16:53:06', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (53, 26, '', '$2y$10$ic3iczg3cwcxxT11UTWFcuT8yAK5Nj3x0TdmrHFTYgKB4YBaHM5OG', 6, 1, NULL, '2024-12-27 16:53:06', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (55, 27, '', '$2y$10$3.YJk3C6V9naie/Rd6ywwuT03GUQqVfnwzuAnUGs98yXYQds0E7ES', 6, 1, NULL, '2024-12-27 16:53:06', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (57, 28, '', '$2y$10$gSVb4bWQbmMioBTygvwyUuLdTBsthb5m6vAl0jp7MKFxj5AdkjVW.', 6, 1, NULL, '2024-12-27 16:53:06', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (59, 29, '', '$2y$10$P/sv8BF/GuG2iE/LKwYwEOdMmD23lWv3DrB4aAzrYgHTNP4rmGUM.', 6, 1, NULL, '2024-12-27 16:53:06', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (61, 30, '', '$2y$10$3p7xZQhZ2ATB3E8xSuolku8ldCNQhU7pDi6BX6O46tvFX/Hqdn086', 6, 1, NULL, '2024-12-27 16:53:07', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (63, 31, '', '$2y$10$FY30lZeFBFqm2jLR7xm1OOcCBiApqEgNhQ9kjAxKn3/knyckIhbEy', 6, 1, NULL, '2024-12-27 16:53:07', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (65, 32, '', '$2y$10$swUE60esitGI0U1nGrEwW.aN3GEbbyIQ3lV42AqXarFzhBETMe1v2', 6, 1, NULL, '2024-12-27 16:53:07', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (67, 33, '', '$2y$10$KYCWVD3bU/zM8W9D5O8tieH5daq.dOWx/Sm.p3GFPbjDypIebiEra', 6, 1, NULL, '2024-12-27 16:53:07', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (69, 34, '', '$2y$10$5G0aVr5TOH1o6rG7C6xMM.VOuYwerWbPzqs46jRXrikqs672pgQny', 6, 1, NULL, '2024-12-27 16:53:07', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (71, 35, '', '$2y$10$t/t.vK4Y6cBdQdBJwQCxI.JPhhKBLfTP9xbTyTMM8MP8NMjDnk8dS', 6, 1, NULL, '2024-12-27 16:53:07', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (75, 37, '', '$2y$10$9l2ysfVlRgwbGcXudNCTvO/3H8hEx4hzGEZWc7fEmdl8yV5NH.PWO', 6, 1, NULL, '2024-12-27 16:53:07', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (77, 38, '', '$2y$10$pN5HgZ6qp.O7/ylxh18iQuXhyeLTZjpPnoiw.4POjENLZ0xq9tHke', 6, 1, NULL, '2024-12-27 16:53:08', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (81, 40, '', '$2y$10$.RIsqmv/pkoSZA6rePHzp.SnNHcaOZzC6Edb59dvWeys.gRMxhrOC', 6, 1, NULL, '2024-12-27 16:53:08', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (83, 41, '', '$2y$10$3Co1yf7jjLNJY1jYDLomo.8hXHXSwwwpMgMhLfMjZz0FUbRAkdV0i', 6, 1, NULL, '2024-12-27 16:53:08', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (85, 42, '', '$2y$10$JCM6FYbSCqEYT5wbO/Mtb.fEsKF.1rZFBIl4HriqX0vwkJs1HSD0W', 6, 1, NULL, '2024-12-27 16:53:08', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (87, 43, '', '$2y$10$u5Mvo2YqyCjgSUnn4l3X/OedMKTtBgB4L1TZqsmA.OVzmeokITnzO', 6, 1, NULL, '2024-12-27 16:53:08', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (91, 45, '', '$2y$10$MEnH2Aj2px1KrocD6PL7eORFzOomzmQ0ec7NFQIe7Q1pBrkSz3otC', 6, 1, NULL, '2024-12-27 16:53:09', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (95, 47, '', '$2y$10$j5UmVhSremZxQwY9J5y2qOHcFk/CBv8O3SwZHoRy8RbwJPGJrfotK', 6, 1, NULL, '2024-12-27 16:58:16', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (97, 48, '', '$2y$10$2RVmtMRO29rODCnM4pvJeej2O1N5SOVjpK4vKdUvtOyC58s8fQDNa', 6, 1, NULL, '2024-12-27 16:58:16', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (99, 49, '', '$2y$10$J4mHWyCJbW7ZpRkg6R3DaeO06DjFeS.BAfeaSXrS3UxUxJXLQKmDq', 6, 1, NULL, '2024-12-27 17:00:18', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (101, 50, '', '$2y$10$9h0E4nFiKdUF80Fc5Epj5OK6nFZPmhUxpLpXogVXEOg6r7QvVczvS', 6, 1, NULL, '2024-12-27 17:00:18', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (103, 51, '', '$2y$10$bYoscNV4p8ERm5sDWf0Ls.e8cfQiIeIcXvxxL2VAu79va0X7uwInu', 6, 1, NULL, '2024-12-27 17:00:18', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (105, 52, '', '$2y$10$YQgk1BIRlVcz06JYhESMpex6fywaBsCSIDN3udzr4vAvA3dbHwxk6', 6, 1, NULL, '2024-12-27 17:00:18', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (107, 53, '', '$2y$10$DVijPmA91MhK4iib2HIA2.xP/KkYCw/RY9nTxy2V32RKIdLzwqqwy', 6, 1, NULL, '2024-12-27 17:01:21', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (109, 54, '', '$2y$10$FT1oKL33TvKj/Y864vsZUuyk7yEb9UGjuc7X1LMwXoM1jBWrgco6e', 6, 1, NULL, '2024-12-27 17:01:21', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (111, 55, '', '$2y$10$kMQe2nAYGmAr/z00FpD4FOo0.cjGEU4BwgP2ZYPG0fcbqeNja1Bx6', 6, 1, NULL, '2024-12-27 17:01:21', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (113, 56, '', '$2y$10$56RCrJoDQvFqq/NNqBeS6uEFTkItLR.o031JTCw9tj.j2ULd0m7XW', 6, 1, NULL, '2024-12-27 17:19:37', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (114, 56, '', '$2y$10$Q8XoggXAI/3q/7r9pybo8uBKwYku4uygwiNXbz7vRJpmtz0SXapHG', 7, 1, NULL, '2024-12-27 17:19:37', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (115, 57, '', '$2y$10$ke4EYpTl1ljTuHtLbJwf8el6SOr2xOiXAWTUvvOkWuYPmLj7Evgwe', 6, 1, NULL, '2024-12-27 17:19:37', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (116, 57, '', '$2y$10$YpV8zEbrxKFT2TXUumiaOePBy6iRKtufEmxPwLBB9TxIdJO/XXHTS', 7, 1, NULL, '2024-12-27 17:19:37', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (117, 58, '', '$2y$10$jS7kJMInHHmtga.dcvIJ3udvqHVGKENOPU0N1vxZdUnQ3Ui8XyWFm', 6, 1, NULL, '2024-12-27 17:19:37', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (118, 58, '', '$2y$10$R1j/ertwwAMJoR4FjcWq3.ACBB0EWIUdBzVTIIR6uAMB2Kske2bCm', 7, 1, NULL, '2024-12-27 17:19:37', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (119, 59, '', '$2y$10$/k1JdjI0nQAZTChhImbfHuLymF61NubK0T7w6ERdTbxu.j5vN/Guq', 6, 1, NULL, '2024-12-27 17:19:37', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (120, 59, '', '$2y$10$nt1e9TBh/gaqenmcszLh6OvInfOoUYbD56bexzceQYQT/1lfs9iYO', 7, 1, NULL, '2024-12-27 17:19:37', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (121, 60, '', '$2y$10$0dOBgX7pTcF0DUIUN65u9O1PtMiW1KAP877bbYU8YK7vJI5gOvLvq', 6, 1, NULL, '2024-12-27 17:19:37', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (122, 60, '', '$2y$10$sQ5zV.NCRaIyWf3KCOHLy.c26tIAUeKNlSA1gzx.ECwDcIdEVLxa.', 7, 1, NULL, '2024-12-27 17:19:37', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (123, 61, '', '$2y$10$.a1rJU0CXN8gwxXA6MOaH.kPhFi/7XX26027USnLZU82m/D.P0S36', 6, 1, NULL, '2024-12-27 17:19:38', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (124, 61, '', '$2y$10$URSczvlEfAwIINm19QsEM.pfjHFI6jfvNl3QH91OLkfMpHU4MszYa', 7, 1, NULL, '2024-12-27 17:19:38', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (125, 62, '', '$2y$10$jxnr5yuEaQwoTWpxsRhFwO.jj8dQLEr2X.2z0.ZnfhMFlRr4A3/8G', 6, 1, NULL, '2024-12-27 17:19:38', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (126, 62, '', '$2y$10$9CgWlYXHRWeIF52Y31/f6ORKvguAIFBqlqqxeayhFWAZcihYzLRJS', 7, 1, NULL, '2024-12-27 17:19:38', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (127, 63, '', '$2y$10$HzU3onsz5BcnaYOrRTCYtedv3wMbhHXwaW1BE2ezpRFW1dGHtu4N2', 6, 1, NULL, '2024-12-27 17:19:38', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (128, 63, '', '$2y$10$sDk6n1LbP2I3kKD.lV8N7ul.L45xqk2beDrm6I.gE/9zsD02HX51y', 7, 1, NULL, '2024-12-27 17:19:38', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (129, 64, '', '$2y$10$QSJMDR790CVAulykx0f5ReOqdOQ5aaTRpL0CR2s7GQqbyMqJeQ2FO', 6, 1, NULL, '2024-12-27 17:19:38', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (130, 64, '', '$2y$10$UwL0A3ujzfba75XLDFfphuHsEhx7aKwlR1ICOXMN2nf.9.PLaY46y', 7, 1, NULL, '2024-12-27 17:19:38', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (131, 65, '', '$2y$10$zKtqYy/5HeZrjVNYs2ZrA.pAZrWw6U7biIVAqiuHLuXuz2H0214Lm', 6, 1, NULL, '2024-12-27 17:19:38', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (132, 65, '', '$2y$10$qsqGKOvR1ZbFeVdGcvLbR.bnN93bPCf9kOzZUhkpHYIgXM3aKTRSK', 7, 1, NULL, '2024-12-27 17:19:38', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (133, 66, '', '$2y$10$eTbsc8CCZtrQ3mvlVcP5RenIpe/spDUmmjjWYbNLWdtoLy5Xp5H4e', 6, 1, NULL, '2024-12-27 17:19:38', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (134, 66, '', '$2y$10$mrFiW2la4gBdAQ65QlNcseiZ0TidTm1DnlkKS/McUvbnNk0uHmUeC', 7, 1, NULL, '2024-12-27 17:19:38', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (135, 67, '', '$2y$10$WT96GsZiKoq5rvhvNZvzU.4Xg/9hLzLRb68m90cBUNocIOf6E5DnS', 6, 1, NULL, '2024-12-27 17:19:38', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (136, 67, '', '$2y$10$3wZEU.1ZuYSB.g/b331Jj.HPnCOsKD8kmkFtPnHcJyikrn0IUhos6', 7, 1, NULL, '2024-12-27 17:19:38', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (137, 68, '', '$2y$10$6ehU9B.qOLdcidW4TrQWgO4dQSwVuGw/JpW58oCpye/ICjKcFE7Le', 6, 1, NULL, '2024-12-27 17:19:38', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (138, 68, '', '$2y$10$bmSLv5uss6nBPo/gVTvAqOo.dcfa71fdVwPgYN7BdsdoTsfit1sye', 7, 1, NULL, '2024-12-27 17:19:38', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (139, 69, '', '$2y$10$YBt.pqzg2lMSDi7yEgvR2u/RXFwsZvYtv3CTlkVj1uU4yRwZAp6xG', 6, 1, NULL, '2024-12-27 17:19:39', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (140, 69, '', '$2y$10$5fXEH.Jcxk2pRldeNbryEeziKFovvZOBxhUzRq3/79ZQWXKe5HK42', 7, 1, NULL, '2024-12-27 17:19:39', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (141, 70, '', '$2y$10$XiBwma9ND2zHUD5ojex55uAYfK8K3OTP/Uec.9QOiHV6ud9pAOrVe', 6, 1, NULL, '2024-12-27 17:19:39', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (142, 70, '', '$2y$10$unX8CpHpc5b/iGRT0K7TjORXal0oTnXaR36kPOv5ju2RLWLzLD/7S', 7, 1, NULL, '2024-12-27 17:19:39', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (143, 71, '', '$2y$10$j7bHQtNMMPhTaSHgBo9nVuyTREYlnA0Qu83ioTIcipB.OuRMRKjO.', 6, 1, NULL, '2024-12-27 17:19:39', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (144, 71, '', '$2y$10$v6Kr4umbIhT.7BG3ZEGXQOLVlJxe6yUq8Ca7UwTswkdjgkGTeRCl6', 7, 1, NULL, '2024-12-27 17:19:39', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (145, 72, '', '$2y$10$8d5PIMj4PDQ1iNJ71DqXHOXPpI9O4cDArQwUXCTYQCwwcJeu6EytW', 6, 1, NULL, '2024-12-27 17:19:39', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (146, 72, '', '$2y$10$U2YABMN4aWV7.YaQNwaZS.6u2LL0MJfPqk0jmy6hj6qvM7W/x7yiW', 7, 1, NULL, '2024-12-27 17:19:39', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (147, 73, '', '$2y$10$DaAdNcP/6iiluHao2S00jO4LT8VxiE7zRBX5Ek1ybV31tuSi3wGGe', 6, 1, NULL, '2024-12-27 17:19:39', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (148, 73, '', '$2y$10$bRthG9/8Wkz5jcmE5DyMcOyWLDU.ZseDI9jxlGd/voTAQsIMQVmRq', 7, 1, NULL, '2024-12-27 17:19:39', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (149, 74, '', '$2y$10$RKmYVF7ubI2MgHOcnIvW9u/WJGdUtufhcq2UiXnDPhyoZOG1DOvwS', 6, 1, NULL, '2024-12-27 17:19:39', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (150, 74, '', '$2y$10$ZuyHiH/aa/u7r0EZSjYgyOlR9nbzzH4eis0.I.9oXsHqXH8z74W7q', 7, 1, NULL, '2024-12-27 17:19:39', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (151, 75, '', '$2y$10$faUnTV7.zhhxi1qipqKgDOgZLUzNJ7SJNPxmswW5ZYnypcfy.6JAy', 6, 1, NULL, '2024-12-27 17:19:39', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (152, 75, '', '$2y$10$mbVfECXl3gRNxTuyfxGLLeHwjW2xRDa/IxRsdMNes3RCvTCSH1f9G', 7, 1, NULL, '2024-12-27 17:19:39', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (153, 76, '', '$2y$10$fEQIu8trkdmjJ2gH1ilRuONK7VCeybkeIhpfqXsT.nSL5SstPa9yy', 6, 1, NULL, '2024-12-27 17:19:39', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (154, 76, '', '$2y$10$xvdInB/sJwWbsEP.HNuX7Oumt9IbnWOEiXOhwYBIPbOGVh9qVYPGW', 7, 1, NULL, '2024-12-27 17:19:39', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (155, 77, '', '$2y$10$TjEwaBvRnCmgDTtx0NfM5.T6Tqm8voiOl4QC0EwRH14wi.m52t.Yu', 6, 1, NULL, '2024-12-27 17:19:39', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (156, 77, '', '$2y$10$MTII6F9C74NwfAmfee2EsekD7wabHVHEYRJYaE08jpF5s6gNvt98i', 7, 1, NULL, '2024-12-27 17:19:40', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (157, 78, '', '$2y$10$D.Qt4S1df00focRK1AR1NeESyHToA/Wg/mPfP8u4lhRU1UwLTtS1a', 6, 1, NULL, '2024-12-27 17:19:40', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (158, 78, '', '$2y$10$zdKEV4FmWWGGoFMnl5KMne53i4WuJg/aKU7jOg7iTBVf82hEbnAwW', 7, 1, NULL, '2024-12-27 17:19:40', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (159, 79, '', '$2y$10$gmitMcFYoO9w9jQ2UO4LUu7.UW5CIkMLzpnq7LU66IvjNH6BWRftO', 6, 1, NULL, '2024-12-27 17:19:40', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (160, 79, '', '$2y$10$z5RFIUXh6WdAl1gv0fCtOOdFgQ014Vtv7eqTi2W3W1x6qIthTtvfm', 7, 1, NULL, '2024-12-27 17:19:40', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (161, 80, '', '$2y$10$q.L8lne48THYIJ5z50YnvuzGXFG3EuZDYDXubdZnBLQHUCXQ56nqe', 6, 1, NULL, '2024-12-27 17:19:40', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (162, 80, '', '$2y$10$apdWUIGiZMuOgupO5saChucKzwTNRwCR0Whg8YoECm34aNl9RWU.G', 7, 1, NULL, '2024-12-27 17:19:40', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (163, 81, '', '$2y$10$VvUqKxC3ytH.klT7eeHw6.WLk0rQT1uQRK0sql2Sx6FHoAR/7TJAS', 6, 1, NULL, '2024-12-27 17:19:40', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (164, 81, '', '$2y$10$JydZhNJWPi5ItNN3cw2BU.SFg8ZCB3wI4SlG2JoYQ.EIeSG71LyZy', 7, 1, NULL, '2024-12-27 17:19:40', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (165, 82, '', '$2y$10$fiHboSt5ABZQ9hnrYD.bwuJ2Y4G/ccrB18x.A7Jxcld0bvs8iNuo.', 6, 1, NULL, '2024-12-27 17:19:40', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (166, 82, '', '$2y$10$8.pKhf3WBXw8mlLzoGzl..PGCyaV0v2CNLEL7lnTXIdYQqv88UXem', 7, 1, NULL, '2024-12-27 17:19:40', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (167, 83, '', '$2y$10$Irb1qvYWGtPOw8g38ffaeeYzfyoB8pLamD5HmzLS.eo3xmCdMgRUq', 6, 1, NULL, '2024-12-27 17:19:40', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (168, 83, '', '$2y$10$.8MY8kEPBhcxjGHphsrkxOE0yDLRGXf9Tlk5PCCWroNdD1iPvKUfC', 7, 1, NULL, '2024-12-27 17:19:40', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (169, 84, '', '$2y$10$m0UKzCNZ.UArkJXFWLru4elb2Hm6M7I3mp4ZTTgwpFiEGK0QcMgKi', 6, 1, NULL, '2024-12-27 17:19:40', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (170, 84, '', '$2y$10$T60DM4wCHmQy6dgnI7iaM.3.brjqeVewK1f3OiRBNfS.MvGt7xgOG', 7, 1, NULL, '2024-12-27 17:19:40', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (171, 85, '', '$2y$10$2yC93UXYtpJqKR8qdPyjne4kZ3/ohS9eU62mKZ/0Jn2fIYCnNao.2', 6, 1, NULL, '2024-12-27 17:19:40', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (172, 85, '', '$2y$10$vFmch0MWSXAQIafHG0BjEOj0p/1nb9CNHn9IyGZUqPliGfEtDOmhO', 7, 1, NULL, '2024-12-27 17:19:41', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (173, 86, '', '$2y$10$3K8EJ7aR9pkTtlrWT9/gMOSMJh/sIGyqlP8mCaQi8h9.MEDATRFmW', 6, 1, NULL, '2024-12-27 17:19:41', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (174, 86, '', '$2y$10$W6TjlvIZSeTrhnYxe63UWu1IyuDxp0UWcHd1FozSJVfX/OvT6PqOm', 7, 1, NULL, '2024-12-27 17:19:41', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (175, 87, '', '$2y$10$6t1eR57XDJQzmbBOhvuWq.ff7NEW.H8OMqsivT/pz.x3Y0Qy9NVJK', 6, 1, NULL, '2024-12-27 17:19:41', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (176, 87, '', '$2y$10$UR/8e4J1d5Etds3j.8InKOaQZ8h30y1mWsjAG6dVuuWiZMdOY2fHG', 7, 1, NULL, '2024-12-27 17:19:41', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (177, 88, '', '$2y$10$hnWsMJO4MFksp3dGdphiJ.19DY8RZmXQE35F/QKg6JaorU2mVGtpO', 6, 1, NULL, '2024-12-27 17:19:41', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (178, 88, '', '$2y$10$jjVgDSsNCEcjladCNlFL3uICqFaO9Ng.9HVvgZuJQQUlFITSDRGLK', 7, 1, NULL, '2024-12-27 17:19:41', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (179, 89, '', '$2y$10$.RcuRxNWqJCwcSA44fd2E.uQOhOKnJjWY/W4fOnLOdDedzF1bMz1O', 6, 1, NULL, '2024-12-27 17:19:41', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (180, 89, '', '$2y$10$30jYgVYb4DershlRqN008OtLhcrW7RakNq4fGgB/NE4DCG9VvJffi', 7, 1, NULL, '2024-12-27 17:19:41', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (181, 90, '', '$2y$10$hzibzdqCiaQAPPy6wGXWKOdBSVrYSEmQtqRiXC3a3tIDJ4LYBB9UO', 6, 1, NULL, '2024-12-27 17:19:41', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (182, 90, '', '$2y$10$EzawnYbWVPqGTFLDLeOSA.SNTw9OrqM2GlgzTqs0XAY.CRS0o7o/i', 7, 1, NULL, '2024-12-27 17:19:41', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (183, 91, '', '$2y$10$yiSim9EEAGvmoNt7492.1.gbrDPO3kgohEAIuRAOLo8BUZvgVYstG', 6, 1, NULL, '2024-12-27 17:19:41', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (184, 91, '', '$2y$10$moYQ8Yl3pqUlnFxa/LUBk.WmcotFZVR9fBZgxngUwIQ0CKly2Ifji', 7, 1, NULL, '2024-12-27 17:19:41', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (185, 92, '', '$2y$10$NLtLI5aJ.EgUGHHNoWkk/OFl4GoT4WaauwUtckFHq9S08pf1Zvw6G', 6, 1, NULL, '2024-12-27 17:19:41', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (186, 92, '', '$2y$10$yxldUWGgQd5iJjymq4ajTOjMaosXZJsmoO6sICtYPtuoIXlDjzM1W', 7, 1, NULL, '2024-12-27 17:19:41', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (187, 93, '', '$2y$10$/U0SN/jmq3L3i3bzawASL.XSbD801wfoOBA8PwJ/9NyHGJBVyLg2.', 6, 1, NULL, '2024-12-27 17:19:41', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (188, 93, '', '$2y$10$A0.lwP39YyD.qYFKQj.68eTZD4X6zjqz17ps026nYr1oNkba17na6', 7, 1, NULL, '2024-12-27 17:19:41', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (189, 94, '', '$2y$10$l2Bb0W5UfGyjQwG7/6wRjesQokJoRIb.ZBFPjuDbnFzfN70bMYZri', 6, 1, NULL, '2024-12-27 17:19:42', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (190, 94, '', '$2y$10$QoXH6xy26Lgot0TiKm/VCuo1qFxwwRDAz09emhj7QCx2kWsMsYZfe', 7, 1, NULL, '2024-12-27 17:19:42', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (191, 95, '', '$2y$10$nBItvptjaG2iY.zdufk5x.Fc.2588YDyJj2yQKPkqPQpjh77Lg4MG', 6, 1, NULL, '2024-12-27 17:19:42', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (192, 95, '', '$2y$10$Aki21i/0a3qgf.siTVy08OKbDGG9qUFy676q9knDDCbRJyjQ.vRbi', 7, 1, NULL, '2024-12-27 17:19:42', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (193, 96, '', '$2y$10$3P9y0SmrWnPYk.IVUkLILu1zPlHwJcbUzJr5pvX/kB6AVLbcRy45m', 6, 1, NULL, '2024-12-27 17:19:42', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (194, 96, '', '$2y$10$VgHicRAVe41BK81k2e7auOhuDWqd1cO9JunYD9vYnKlTzCNOEeAti', 7, 1, NULL, '2024-12-27 17:19:42', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (195, 97, '', '$2y$10$tTlpYu/HaztlZrDK3xKGi.5QC9wL457F8ixZS62JzeJ6u6v3DWwlu', 6, 1, NULL, '2024-12-27 17:19:42', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (196, 97, '', '$2y$10$U8SJN5pREl5QyU3NLXAC1.J3fNoYeVz9O5gSqk.YahxCYOrSSKQgy', 7, 1, NULL, '2024-12-27 17:19:42', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (197, 98, '', '$2y$10$vCVO8rCS6vRBda/.epsDs.cvzoN1si3MhgK6tF3QI5TlVKeObPxu2', 6, 1, NULL, '2024-12-27 17:19:42', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (198, 98, '', '$2y$10$wBBCw4fI61.f.4RVU0fQ4.2fbEkZqfcU8ncd84vP/vp1N.RpdBxsm', 7, 1, NULL, '2024-12-27 17:19:42', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (199, 99, '', '$2y$10$UL/6mV10r0WgCgm5fUgX0.OMMv7cHJJiC6m1KjroBUe965JdsCFGe', 6, 1, NULL, '2024-12-27 17:19:42', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (200, 99, '', '$2y$10$QdPl0sB9S.WV01MNzUc7x.9hFZLNhi8Yl5q78jiQZg651L7jRiueu', 7, 1, NULL, '2024-12-27 17:19:42', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (201, 100, '', '$2y$10$sm6JA6BNORkOqcOCeoGnAujKMGfDjD3O2qiaDRVuGDJLalnLxpCai', 6, 1, NULL, '2024-12-27 17:19:42', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (202, 100, '', '$2y$10$HjnhHtZ9OZT7ueG7iPoEEOioFT/h5mYAr.hDPJ/pNg5FgylNuwyz2', 7, 1, NULL, '2024-12-27 17:19:42', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (203, 3, 'Mamun123', '$2y$10$X1YC3GRQ9fhENpopgcyB8OJzKimxprpeRLRJTKNcHwn2oboCE.1zS', 3, 1, NULL, '2024-12-27 17:22:00', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (204, 101, '', '$2y$10$vfBoMrdRkdjxbTHkOZF5quo6AISxFJg2oPK0bfu7DtJH8IwDdnvVe', 6, 1, NULL, '2024-12-27 17:22:37', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (205, 101, '', '$2y$10$Hyfm9pnTmpfaLOtIZnmPWe3smbno/eZj1KawS4eOrq/gltrxL58w6', 7, 1, NULL, '2024-12-27 17:22:37', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (206, 102, '', '$2y$10$M129jeNosN8/iM2Vi9lSh.EzaXUBVs2Xaw/DsUyvBWfai3Df8P/CK', 6, 1, NULL, '2024-12-27 17:22:37', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (207, 102, '', '$2y$10$fzR3pmFps/J31R.RonbDUuiRY6xV/mbyj./B14oHtbugt0LnL4T5m', 7, 1, NULL, '2024-12-27 17:22:37', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (208, 103, '', '$2y$10$zXertAIrsXRnbBIpO4adiugZuGuFLqZtMNkgFNlnX8uFlDCcNs2.G', 6, 1, NULL, '2024-12-27 17:22:37', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (209, 103, '', '$2y$10$QHPWhfoWbCvPAlofDUXFreqmIeY9LP1lRiuG6VNDgeMuhNNq.WWJW', 7, 1, NULL, '2024-12-27 17:22:37', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (210, 104, '', '$2y$10$Afwip88reUfiUnvClhl5XucVC9Zp6XoxhsC5eR4HvoGbJKufCUepO', 6, 1, NULL, '2024-12-27 17:24:24', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (211, 104, '', '$2y$10$lAGdlTK/IKOQnymt1Tu44uXJy3x4ObIwJhaz26t2U/atvAz/7bpUu', 7, 1, NULL, '2024-12-27 17:24:25', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (212, 105, '', '$2y$10$MhfoOGyBUJtE/jYYZoGa2u6T5P2rvyMEcmB2F1rJmf2hRMrw.7awW', 6, 1, NULL, '2024-12-27 17:24:25', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (213, 105, '', '$2y$10$54Vk6fchmqodmyrpjdwi1.mjUgDw7hHv83Gr658IOlRT0d9AoUz5i', 7, 1, NULL, '2024-12-27 17:24:25', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (214, 106, '', '$2y$10$6Epmwp/vKPPpp7d2usUiZe9YmAC0KR/KHb8lf1YssGzF82pxv1uvm', 6, 1, NULL, '2024-12-27 17:24:25', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (215, 106, '', '$2y$10$.ATlKSNR.b5W9cnuvZ9rlOq56YJ8L4h9dTP2g7/veQiUFAkYipYsC', 7, 1, NULL, '2024-12-27 17:24:25', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (216, 107, '', '$2y$10$7SzecZFGGTkiqkXM3zhZAuFMxplbbxmFU12.GgLVQdUYv0pj8fYn.', 6, 1, NULL, '2024-12-27 17:24:25', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (217, 107, '', '$2y$10$WlZk3i28eaMQ.parVGDZQuc7toUqpBk.LFuz.iM19KGAkw0QbM52m', 7, 1, NULL, '2024-12-27 17:24:25', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (218, 108, '', '$2y$10$7xjBR.0wXPeexN9Bui9Auu8S5BTpd4ya.o6YlL72OV4E0Gi2hWjLG', 6, 1, NULL, '2024-12-27 17:24:25', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (219, 108, '', '$2y$10$YQ4bgvx6s11GIeH5rTKFh.nM.tT6/5yH0txyPcS1ECydV/Zm69m2u', 7, 1, NULL, '2024-12-27 17:24:25', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (220, 109, '', '$2y$10$3MbarQ3frS8/QsGvproqQObeS/XBcpL3KlStVLKOkHlo6wdj/1ty2', 6, 1, NULL, '2024-12-27 17:24:25', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (221, 109, '', '$2y$10$kSPX6tRmrqN1FzLcXfqGWuHpaod3iS7xwc4I0xjFo/x9nPknULxSe', 7, 1, NULL, '2024-12-27 17:24:25', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (222, 110, '', '$2y$10$6RXxfHOjzjxTJDfOILpC0e3zcx5gkmoPtA0sgCvNM.SRLPIkxW58W', 6, 1, NULL, '2024-12-27 17:24:25', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (223, 110, '', '$2y$10$q1EoCVAXSS0Ix.nOfX2d/e18hbnzGC7cUrFu7XcDkkvpF36LREWxm', 7, 1, NULL, '2024-12-27 17:24:25', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (224, 111, '', '$2y$10$gD8Bo8lvgMYeHVwSOTRAtey76vdMofCZwaExaL.bQghSXXMkXAZCm', 6, 1, NULL, '2024-12-27 17:24:25', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (225, 111, '', '$2y$10$1.KeStWLWheHpEyjs4cZpeUmJAeRKA4wV8FCfkeY99YfZXneRiRJe', 7, 1, NULL, '2024-12-27 17:24:25', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (226, 112, '', '$2y$10$isWTZA2g8kd6h8nlQhsNmeBzAbqi3WlpVnkPKsIeZnp2KNEOXODHe', 6, 1, NULL, '2024-12-27 17:24:25', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (227, 112, '', '$2y$10$1Nah9aMaqj2WvCkycc8yZOVWQN0Glp2mxJQoI25A1sicLUa/LONRa', 7, 1, NULL, '2024-12-27 17:24:25', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (228, 113, '', '$2y$10$lVEfD5GUKDcsdoSPHFn.meZK15KOTVrUgmN88VDLw6LRhUhKx4OHe', 6, 1, NULL, '2024-12-27 17:24:26', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (229, 113, '', '$2y$10$rFMxaCcfb5D5FALlvmFf6Oc9bvR6jxL1K.5tdM.LLuQDA82TrPahG', 7, 1, NULL, '2024-12-27 17:24:26', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (230, 114, '', '$2y$10$Brt4gMCcRRrwB9WHVxvS8OYsOs6of1j9l7ocGbS8ev51PFRAFeJCC', 6, 1, NULL, '2024-12-27 17:24:26', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (231, 114, '', '$2y$10$B2TbubBkgG4YNuwxAfMUrupV1268SEF7yLUYx0n5gCIupiltg33yC', 7, 1, NULL, '2024-12-27 17:24:26', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (232, 115, '', '$2y$10$xWnxlAoyh9dNiB.b2.67r.D5SFiYmpK8jsTPGlgGeaaTAeY1DiH.e', 6, 1, NULL, '2024-12-27 17:24:26', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (233, 115, '', '$2y$10$DjVM/s9lqkAtYk0G7aMQiOFMTI9n0Ta4E723WE7efv5MK2eCNwNoi', 7, 1, NULL, '2024-12-27 17:24:26', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (234, 116, '', '$2y$10$Oa0qmXaIOuLlgLF5mOhIA.RxDsFq9tGM4S5iZk3GKFlbhSboMGReC', 6, 1, NULL, '2024-12-27 17:24:26', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (235, 116, '', '$2y$10$w1Y0tVSwLpNQaafZLzW0w.Pj13MlE648Q3RF3RocaIiVFH1.1iuG6', 7, 1, NULL, '2024-12-27 17:24:26', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (236, 117, '', '$2y$10$V38cAmN.iT.bI3IxYFpVvOwoWaFxGHgXMOgtk3pKgeQDCHpBiCN0a', 6, 1, NULL, '2024-12-27 17:24:26', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (237, 117, '', '$2y$10$jHCLAhwh8rlJbnUsnOnJaOfI2nYtFbsu9hpaMAC9nLxvqZSIQ7jXi', 7, 1, NULL, '2024-12-27 17:24:26', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (238, 118, '', '$2y$10$CZ8BZFHvcW2pKAX2LiOPMeyP4gYg/ZD4Kee5qLb8ibQoqvmCSYRwi', 6, 1, NULL, '2024-12-27 17:24:26', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (239, 118, '', '$2y$10$GyXtRdDnJ6IiuhZSwl.vneWpMHHgbfzc/o7cc6JVTqeM.0dKB4txu', 7, 1, NULL, '2024-12-27 17:24:26', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (240, 119, '', '$2y$10$BhfiPSDNr59hBFyAVIrUs.SCnjiswz.m81jX0ydEjdwOChm5xRhoy', 6, 1, NULL, '2024-12-27 17:24:26', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (241, 119, '', '$2y$10$eXWiPqK0xYZsl27H4/Xe0.nOhMa3vcR3GrYv5XMuaD4j3sjMWF82i', 7, 1, NULL, '2024-12-27 17:24:26', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (242, 120, '', '$2y$10$k/oWT31n7pqqQBsueNYZu.jgWk2lynP5q9AAA7vzDdDJXsxSQmhoK', 6, 1, NULL, '2024-12-27 17:24:26', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (243, 120, '', '$2y$10$wpSvFHWWU8PCgnforuPeOeRyzKzGyf5LstAgwd6TdTh4OqzG9dpIK', 7, 1, NULL, '2024-12-27 17:24:26', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (244, 121, '', '$2y$10$VBDFlc/q5f89AgBr64s23en2FJ/6LeHr8Bf.sS9rDawYYFD6pZyKW', 6, 1, NULL, '2024-12-27 17:24:27', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (245, 121, '', '$2y$10$InZRXW1/ZXdCa1vv5smr1OISSWMuarf4o2DuwKkNgNMWR0QJucP66', 7, 1, NULL, '2024-12-27 17:24:27', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (246, 122, '', '$2y$10$niJnIlu0QfpnuVUxW/ywx..5plJJlkH21Wbi4yKSG73R7cJXlNetS', 6, 1, NULL, '2024-12-27 17:24:27', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (247, 122, '', '$2y$10$TYyYt3adf7eiapoQpxBMKODXAhlJ4EjFq7pNUEJ6eqTrpOfYYshai', 7, 1, NULL, '2024-12-27 17:24:27', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (248, 123, '', '$2y$10$2TWlCZA7.BQslaJkMN5/P.U/LG7/IU5hMTpLfUpKJ4wwBUMgC20jG', 6, 1, NULL, '2024-12-27 17:24:27', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (249, 123, '', '$2y$10$1i/ZdRFEwPm5X5JO.uyMAuVa9I4lFU5E35L5wqwNYzFk9k6lqw9UO', 7, 1, NULL, '2024-12-27 17:24:27', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (250, 124, '', '$2y$10$I7/rVplXLjKnUXISET6fWeTEV/6k.l66ft6xaHmRL1nU/YWsyd/s6', 6, 1, NULL, '2024-12-27 17:24:27', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (251, 124, '', '$2y$10$yg1bQ9uVvJwNAPBgA94ykuxsvn/hEUpxQljPT/8HXZq8oSwXJVuum', 7, 1, NULL, '2024-12-27 17:24:27', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (252, 125, '', '$2y$10$9OfM92Xnau.6LQsDdFqgFOiWdUM6mpRPR/sYUWxLWEAROuclj0/uC', 6, 1, NULL, '2024-12-27 17:24:27', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (253, 125, '', '$2y$10$6TXBGWdrImfCjXOlZCEIBehT7/UgkYM1H0r7K4GRsjn8IVmxDoANW', 7, 1, NULL, '2024-12-27 17:24:27', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (254, 126, '', '$2y$10$sNCRBZQd7MRIpgK5Rl4De.If632fz4.iMiMCG47ZDgdFlEDxQa/fy', 6, 1, NULL, '2024-12-27 17:24:27', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (255, 126, '', '$2y$10$KZG1WLaEOywxcG0JYSPKTeRCkoy4mHASx1AdyEo3o9fduPAZm7Quu', 7, 1, NULL, '2024-12-27 17:24:27', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (256, 127, '', '$2y$10$Zk3/leEwygsP8PzWDmhmh.DMxK0gxR/zHR0fy3mTWtfC0/CXIYfCC', 6, 1, NULL, '2024-12-27 17:24:27', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (257, 127, '', '$2y$10$9LdVT4I2cTs0gqWlr5.fZOz9.Sbg6OjeizcdvPvvdpDvqDTTXrCP6', 7, 1, NULL, '2024-12-27 17:24:27', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (258, 128, '', '$2y$10$QvnYrK3xjdoBUD6b4vLBVeRJuBXGsyOjEVI8.fD.TS8TZgmyKqDNe', 6, 1, NULL, '2024-12-27 17:24:27', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (259, 128, '', '$2y$10$Ea3jhsZYjvZC4CrxA2uOq.CBiZv54RrANwJOevmJo28nUIZW4zmOq', 7, 1, NULL, '2024-12-27 17:24:27', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (260, 129, '', '$2y$10$fS6npviPVyRwCoNW2W5.je1AsP8fJE9/TEEWBD0tIHJsPAX8jr.mC', 6, 1, NULL, '2024-12-27 17:24:27', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (261, 129, '', '$2y$10$TFIQaHF0Kmll3fEOeuK9Lu0X6l3329EbEh3mBLvKvYSrtB.AfXDze', 7, 1, NULL, '2024-12-27 17:24:28', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (262, 130, '', '$2y$10$Wdirk.7TB58h9vVvVgyQouBTzwUYecqANe0L/.4142BylqZBwud1q', 6, 1, NULL, '2024-12-27 17:24:28', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (263, 130, '', '$2y$10$A29SH0e24rAvmlNgcVoORO8kYl7JEOV9zpdXdzf9Uk087AcfM/Jf6', 7, 1, NULL, '2024-12-27 17:24:28', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (264, 131, '', '$2y$10$EegQE53Rv7hhhCiS6gjyMuEdhCVtGe6jo8v76TZOR61T6zkTz8Wle', 6, 1, NULL, '2024-12-27 17:24:28', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (265, 131, '', '$2y$10$N7UyDofVw4Mk9Fz6I/u1pOdRaHGtLjcknXmrBjnYbRDVDORDbwCIe', 7, 1, NULL, '2024-12-27 17:24:28', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (266, 132, '', '$2y$10$plmrGJ1RWEuyePTmyFjauOPyEw/RAH.xs6S7vUTz2lp524YxHXsy.', 6, 1, NULL, '2024-12-27 17:24:28', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (267, 132, '', '$2y$10$wc0F19wz2pxd1T63uJ.qje4JIWYW3swzyHfZTpgr1PFI8Q0GfSRqa', 7, 1, NULL, '2024-12-27 17:24:28', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (268, 133, '', '$2y$10$A4p29jDP9RPD2FWt3vMgg.rwto0NAMNYroCQ1ILzDkcYki5PfsDVW', 6, 1, NULL, '2024-12-27 17:24:28', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (269, 133, '', '$2y$10$qjQBgtxbJfEiU8R9pM40TOZkH2Jj/mL5r.tK.1PjuvgXtykJuvo2q', 7, 1, NULL, '2024-12-27 17:24:28', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (270, 134, '', '$2y$10$E9KHcfRrUaUS7G5YyX3pyewzNI0nHDIPwBFcWuRYL/hfp3UCUdZbe', 6, 1, NULL, '2024-12-27 17:24:28', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (271, 134, '', '$2y$10$Y3TmJPJ9C9raqdigskp2Y.PmJopStGhnDvyfP9669fxOTEqnISf1q', 7, 1, NULL, '2024-12-27 17:24:28', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (272, 135, '', '$2y$10$kqK/YHJuBC24PwVnAtMKLO2mC4QUrCc5i2m//pTLU4XnWL7T1el9O', 6, 1, NULL, '2024-12-27 17:24:28', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (273, 135, '', '$2y$10$D8SQ8Ni/CW516W/c3P2J9eyicpOTSR5qyxq3W2hcf4igwqTbjuYfi', 7, 1, NULL, '2024-12-27 17:24:28', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (274, 136, '', '$2y$10$Vvc5ec0rouhuGClXO1be0.pY5n/aaoRHc0hZ4LaPik0HnKg2mIdkG', 6, 1, NULL, '2024-12-27 17:24:28', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (275, 136, '', '$2y$10$0mmwVcGR6eYZHdukSlIQi.MEYBzIVO5BCIOr4OVmqchKiD74hAStO', 7, 1, NULL, '2024-12-27 17:24:28', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (276, 137, '', '$2y$10$ZQnekBjjL2OQ8cqkwytwK.dLq13G7ani580wgrIVkueo/I52GnVW2', 6, 1, NULL, '2024-12-27 17:24:28', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (277, 137, '', '$2y$10$MHyLQYZU5ji5pqKl50dwueS21FmdNBoAMZWSrVBN/NHnDXxqn1Bme', 7, 1, NULL, '2024-12-27 17:24:28', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (278, 138, '', '$2y$10$EMQEp2fS9y2leTP6/eYFTeqSO3GFmGutLKFzhABcj3rDXJGo4nRSO', 6, 1, NULL, '2024-12-27 17:24:29', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (279, 138, '', '$2y$10$Es5iNrswNvFwszI1J5V4neMIic3FnlCGzKpMfxSoBm4qOHcn5jo3u', 7, 1, NULL, '2024-12-27 17:24:29', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (280, 139, '', '$2y$10$5GHzdX21RAcAmHYo3gC7TOBJHaxNeayB7mCZEhlKHyDVKUX8Adl1O', 6, 1, NULL, '2024-12-27 17:26:08', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (281, 139, '', '$2y$10$HOGjm.ZQNCeqMKDM19Mba.wIkB2uBklh4LEHV67.1eyJV6Y09ZMT.', 7, 1, NULL, '2024-12-27 17:26:08', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (282, 140, '', '$2y$10$HR/a21dxTeyr1purwEF3H.ik52dQQETM.8J960TK86NQ.Z6ecxN3C', 6, 1, NULL, '2024-12-27 17:26:08', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (283, 140, '', '$2y$10$cn28y8cMVf5qilQj1Qc96erHTIB4JTwcrdK/RO3SXZ..ciKWokwpi', 7, 1, NULL, '2024-12-27 17:26:08', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (284, 141, '', '$2y$10$vSgoHbuzE4sReQVpQP.Z..gsleIRj78wh3IrkRvFt4x1fO/4BcjNi', 6, 1, NULL, '2024-12-27 17:26:08', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (285, 141, '', '$2y$10$A7AOXjZidkV7dCaTBybg7Ot/WuoMSZqF3zoH6VUD1BCpKXyEPePP6', 7, 1, NULL, '2024-12-27 17:26:08', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (286, 142, '', '$2y$10$Bh6uw1cz/J8aKL3JCxtgAOrCdggOh1G8tn5iA1SfoJ8W3rLxWB2d6', 6, 1, NULL, '2024-12-27 17:26:08', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (287, 142, '', '$2y$10$c77nz2IZMFyixyQnRoBrmO2edO3SFHjNVqLNi0i551y1.RxIVjbbi', 7, 1, NULL, '2024-12-27 17:26:08', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (288, 143, '', '$2y$10$Mk.cK84g7s4til5Tro67UumVu9ahP1hagcAeCJ7FX4X4oHChV2Cx6', 6, 1, NULL, '2024-12-27 17:26:08', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (289, 143, '', '$2y$10$j7uZFp30GSn/Ezmm6yAF9.ymV41QTgIG8x5L38cC5HLbtpv/bhpJm', 7, 1, NULL, '2024-12-27 17:26:08', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (290, 144, '', '$2y$10$VQv9C6eGu0B82ZcBw0sbd.VNCkeUC2JN9NS/dVvWBs1bkGagPnqFC', 6, 1, NULL, '2024-12-27 17:26:08', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (291, 144, '', '$2y$10$p7oZu2Y7T0C6rIT4HsBjAurBaFiH4Ip7OK4EbDGo0adZ1FoT8aA9i', 7, 1, NULL, '2024-12-27 17:26:08', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (292, 145, '', '$2y$10$PIQC9g4mkx8afW3S943exOkzMgo8E/3Q2KuL7IpHwh6W3jGXN/Xv2', 6, 1, NULL, '2024-12-27 17:26:08', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (293, 145, '', '$2y$10$3tvrSi47OH.DU3ehdnicuOTRSPhoEpMaQhaj5gYML0i3A4rmIoMoS', 7, 1, NULL, '2024-12-27 17:26:08', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (294, 146, '', '$2y$10$.B.fkPYfsCAnvbHePom2NeRvNyScKOX01txBQ12VG5Vqqxjd.dnEi', 6, 1, NULL, '2024-12-27 17:26:08', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (295, 146, '', '$2y$10$AQm4msyQy5rAqtdu.9fP5OxviQqWyNWpPAnCvQTnfmhMUs4loHlY.', 7, 1, NULL, '2024-12-27 17:26:09', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (296, 147, '', '$2y$10$0AIwdVH/JxzVqYutwO0gie/IckgAEp/76CyH32HlS5KP4i.XCedge', 6, 1, NULL, '2024-12-27 17:26:09', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (297, 147, '', '$2y$10$D3d1SdTekMjUcufaEpp7uOveoFKJ1A6KB9sHBn1OuUDdA2zwrMfxe', 7, 1, NULL, '2024-12-27 17:26:09', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (298, 148, '', '$2y$10$enoaks/aO6UwVEweGlir..1kv7kiy0itH5Ao85Trv9ylD2kEMopHG', 6, 1, NULL, '2024-12-27 17:26:09', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (299, 148, '', '$2y$10$Oxx3QWIJsOvHePe4A0o13uKnSfmKLfHdLag/Mn9QTwKYqwm/3nr7u', 7, 1, NULL, '2024-12-27 17:26:09', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (300, 149, '', '$2y$10$cDRBgqQp4F1QLcqJxvEgc.V7fx4T4z2DDNsRTFtz8RjOQQw7kEKr2', 6, 1, NULL, '2024-12-27 17:26:09', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (301, 149, '', '$2y$10$VVgmY9T3N0O4m8XwzEcgSuWPy30m1JIz0rNK0m6nlpItCQ0je9cqS', 7, 1, NULL, '2024-12-27 17:26:09', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (302, 150, '', '$2y$10$NjJSAoi98dqDKX.woVG3pu0KtfJc56cM76A/aSvaiNv1gUJKngv0a', 6, 1, NULL, '2024-12-27 17:26:09', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (303, 150, '', '$2y$10$wyovMLeocPnVDE0LXnEwiO/9ZIRqnOrzbfPVJtyBkzVMzja1RxmNK', 7, 1, NULL, '2024-12-27 17:26:09', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (304, 151, '', '$2y$10$B5ai.iy1GauSOqrtH65xxuSvYg4auUxYWNN17UpL1IZ8A/7Q5X.YO', 6, 1, NULL, '2024-12-27 17:26:09', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (305, 151, '', '$2y$10$5KYPb8aAVLylJVWCBghNceNLsLd.Nxnjc3wUDI0HcnaGykZeR8zRG', 7, 1, NULL, '2024-12-27 17:26:09', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (306, 152, '', '$2y$10$l5QwJT76vdnLIAxh7kYHLunMXtTdXcq5qyXNvu.geM1mR1W8xL.by', 6, 1, NULL, '2024-12-27 17:26:09', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (307, 152, '', '$2y$10$YTx3WdhVaibebtijEmi9eOpMLwjzVX/iu/FfPL47Ys5MbsATRJ7s.', 7, 1, NULL, '2024-12-27 17:26:09', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (308, 153, '', '$2y$10$VOuD47QchD/pcRz.lT0vd.65YrR23f0EFYjqLJbIDv.mo3o1C43Ra', 6, 1, NULL, '2024-12-27 17:26:09', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (309, 153, '', '$2y$10$8xHClf1lcVzFCwtA8brwLOzQyk.MM48AKsGQfHGxcahX/EiNYkI72', 7, 1, NULL, '2024-12-27 17:26:09', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (310, 154, '', '$2y$10$1bdZJVNgUrslzIw6lWDrAO7IQo6py9IC1H.ESTWi06xxTjfzZ3swy', 6, 1, NULL, '2024-12-27 17:26:09', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (311, 154, '', '$2y$10$xsg6OeANrAriXSKwUY4joO4JRWSK4qOGsO9YLdKqqiJkdr2SdfYDi', 7, 1, NULL, '2024-12-27 17:26:09', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (312, 155, '', '$2y$10$kh5142UcXPRnpOmPTA.3sO24q3CMR0v1EEU5VO7CHFtyy8iHE4LwS', 6, 1, NULL, '2024-12-27 17:26:10', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (313, 155, '', '$2y$10$tJqxMBK4PH8RvjcRhQ14iuBNFO7A7D6EJ0X219I9bzDOJNGv.9YCS', 7, 1, NULL, '2024-12-27 17:26:10', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (314, 156, '', '$2y$10$n8baTCBg7aopl.j4G8JSouZR2LtoWCsTVMH3FOQK5cFfm1XS/2DNy', 6, 1, NULL, '2024-12-27 17:26:10', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (315, 156, '', '$2y$10$Vbp/a6XrWETCHzuvfnt31.67j9CWc3XsD7elZnbdhGvgbFUJITweK', 7, 1, NULL, '2024-12-27 17:26:10', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (316, 157, '', '$2y$10$tW2YdP9Pu/XBttDcEw65yOVpUgXJTRg.aTEbRkHPYFCblsZZXe48S', 6, 1, NULL, '2024-12-27 17:26:10', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (317, 157, '', '$2y$10$fArkUf6LDIMQSUA/QgT85.tdu1L8jb4VWmQ/FnBPTYT3mZBIueGda', 7, 1, NULL, '2024-12-27 17:26:10', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (318, 158, '', '$2y$10$nS3wBeZIdxmdRYHjjv1iXu.qS0q1mH8CynSRLvrfRA9Vdp7WG.qIq', 6, 1, NULL, '2024-12-27 17:26:10', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (319, 158, '', '$2y$10$8bMzDT/Oe9I17QkbRYGijuAyHf/ZN73eQyW8wEZOSsAf6NnbJfY0.', 7, 1, NULL, '2024-12-27 17:26:10', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (320, 159, '', '$2y$10$yK1SyfE2qBF/O7I21.qkhOfI7r.XltDrNizONB0vutWBjxjxcXXDq', 6, 1, NULL, '2024-12-27 17:26:10', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (321, 159, '', '$2y$10$at5T6P65tLU29jxLd4FR.OiE9wUjrUO3rwCQSzfa.8qqrVsI04PBS', 7, 1, NULL, '2024-12-27 17:26:10', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (322, 160, '', '$2y$10$lP35kqUR2YIeMXWir2j/pOi66dHNRlf9pf39ynsD6xj6RgpKGm3bq', 6, 1, NULL, '2024-12-27 17:26:10', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (323, 160, '', '$2y$10$jVbdABB/aL7R2AU11zX60u9jVlk0AxruYStSa9sNmViK20YlVBSrm', 7, 1, NULL, '2024-12-27 17:26:10', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (324, 161, '', '$2y$10$EihydWDgxwujPuHXxv9S5uM./tZY6WX/kwmOObmd1O8v4MHqDZd8e', 6, 1, NULL, '2024-12-27 17:26:10', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (325, 161, '', '$2y$10$sQvRjziJh52rEmKRVMnASOTZcrxopUci/LyOsjmWAMzhnbT3w0eGK', 7, 1, NULL, '2024-12-27 17:26:10', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (326, 162, '', '$2y$10$aehmnIdbQnln5lY7frksOO8rokF.1oqg4cXvwENv3EadIMzCg9f4a', 6, 1, NULL, '2024-12-27 17:26:10', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (327, 162, '', '$2y$10$sfRlYP1FjYAe8vmh9lB7/.EqYdcXlr1mhEaAG0qBHTap1uV6dTvJy', 7, 1, NULL, '2024-12-27 17:26:10', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (328, 163, '', '$2y$10$XInZzNbut7iT2cXxMeIpC.tD6pMuqhefQfQXKkNIAtXlndLjsduhy', 6, 1, NULL, '2024-12-27 17:26:11', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (329, 163, '', '$2y$10$DefWi.d/cKv1j/lLIyCqCOgJEFzVYkcEUF6iDT1J8uycnyIu0aK6K', 7, 1, NULL, '2024-12-27 17:26:11', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (330, 164, '', '$2y$10$ugetjN8zdlbbCSc7jI4bfeGyRmGbW8e4zRrOPXjblBjo.dmcGZnfy', 6, 1, NULL, '2024-12-27 17:26:11', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (331, 164, '', '$2y$10$dJ0.wpSJ5fRc9ZJscPDEfO0TgH6hJSEP/Jhe/FDTjWms34G.xkPq2', 7, 1, NULL, '2024-12-27 17:26:11', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (332, 165, '', '$2y$10$/4a1Ydvei3WbM.TI6PYlEuxnJbxq9vMl1AoU6bDezyucIDLlJcg9K', 6, 1, NULL, '2024-12-27 17:26:11', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (333, 165, '', '$2y$10$rkcoIPimW3u8HP.wGA5Am.dHKu/t2AngsX58BTXXPJBQl5Rf6TaLC', 7, 1, NULL, '2024-12-27 17:26:11', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (334, 166, '', '$2y$10$FJCivP8ll4W2DnnI9x7uIu/749AbF37p.VP0yyIzVlYAj8AstucbO', 6, 1, NULL, '2024-12-27 17:26:11', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (335, 166, '', '$2y$10$JClj8uKQlyK33UQ1lYbgLeG9Ime4BNGebiAt2LgEdClrWhnwZXpoe', 7, 1, NULL, '2024-12-27 17:26:11', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (336, 167, '', '$2y$10$62fxh1a3HLIHI0rtozMicOFtothfozCdrdQ0nH1qH5IqM/ZHbM/Uq', 6, 1, NULL, '2024-12-27 17:26:11', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (337, 167, '', '$2y$10$iFiz8je4XJWQ7Aea3dQpx.LT1Xj.TU1kZXprqO0CAJSXLitPAlADa', 7, 1, NULL, '2024-12-27 17:26:11', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (338, 168, '', '$2y$10$iGlmyQWQ1mfUuZ97HuDR3eFF04Xsqi78qwTjD/.y7p7FzVT3PaMe2', 6, 1, NULL, '2024-12-27 17:26:11', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (339, 168, '', '$2y$10$dMGEpxK/lbnD2vOZUwtbV.0/EV5.VjlUrkdcmhVyoT7Xe74xbiRmy', 7, 1, NULL, '2024-12-27 17:26:11', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (340, 169, '', '$2y$10$bir9WlEVPjkF5d7/XyetGe8f7k2AvVSvA3hphBxu0ZBrTzC90l0vy', 6, 1, NULL, '2024-12-27 17:26:11', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (341, 169, '', '$2y$10$HEBGB01sOEkbJiWOCOflc.uYecDrGEIDWK6bbo3s9QmHfo0o3ZdMO', 7, 1, NULL, '2024-12-27 17:26:11', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (342, 170, '', '$2y$10$.RA6bBHI/xUDzI29kpCtxelqQ.0rIx1RIbZLwBt9KXO6wJJRAKz.u', 6, 1, NULL, '2024-12-27 17:26:11', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (343, 170, '', '$2y$10$BIFWsGAZlPPxcT2gjzCz1.PsEumQSynP9/iYzB3zeLG8coFjy.zDq', 7, 1, NULL, '2024-12-27 17:26:11', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (344, 171, '', '$2y$10$aalBp8MMQ8xM2VjkbdYtiuLM0hJKSthxvQ.y5R2VDADEnYICOpjCe', 6, 1, NULL, '2024-12-27 17:26:12', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (345, 171, '', '$2y$10$TEGyNUuftsgiXKYTKeK4FuF6kRghgIEV1lV9N9.o7JPrFrHJZcIu2', 7, 1, NULL, '2024-12-27 17:26:12', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (346, 172, '', '$2y$10$nFVLkrSpxUJTfc1MlyKh9uj5.iVwE8kfzdxzDTLmxY5hxDvqUcZD2', 6, 1, NULL, '2024-12-27 17:26:12', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (347, 172, '', '$2y$10$3HnF7ufKMcqKzgQ1hCHgwe0qSDrAOYWUP.uc.j4/8Z1tNiVm8v8Wi', 7, 1, NULL, '2024-12-27 17:26:12', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (348, 173, '', '$2y$10$0gTJohpbAXziNyQXBqSF7OMeUin1D0/3/nHMJ7A2v.d9ny9qprIOO', 6, 1, NULL, '2024-12-27 17:26:12', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (349, 173, '', '$2y$10$6T0pXXYNphEFpCDjWDPhaO6GlbQZwJGVlqI6A6SHl38mdKWm59yKi', 7, 1, NULL, '2024-12-27 17:26:12', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (350, 174, '', '$2y$10$7f6vwOo1jx3GZwzU2ON7QO05QOYUBeEEyJe1Z2ji7.MYyZutSkY.u', 6, 1, NULL, '2024-12-27 17:26:12', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (351, 174, '', '$2y$10$IL/B8dnswaFMQ/r4Cmz7ueh6N6F9hEqrLHEI26C7H0177p95UzHbG', 7, 1, NULL, '2024-12-27 17:26:12', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (352, 175, '', '$2y$10$0KvQ9vVy.kPLZepnX.3BluP/mHt2ijLJuzakfFi8N0rnbePd0CtFm', 6, 1, NULL, '2024-12-27 17:26:12', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (353, 175, '', '$2y$10$JW288/06pAFTxZUIK2PvA.zhVzh2pQmQTseJCpLI/uV0hg8zeVmpu', 7, 1, NULL, '2024-12-27 17:26:12', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (354, 176, '', '$2y$10$Gmj/DazmFKtBOEeJbU3jVOQZWT7fdpXLz5Cu.Xv8Ny4CP5CU.JL8i', 6, 1, NULL, '2024-12-27 17:26:12', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (355, 176, '', '$2y$10$bezkRMJ2QQeHNT.JeFZytuugFkKVNZF..Z3ul2MZXn1LhzCNhlbOS', 7, 1, NULL, '2024-12-27 17:26:12', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (356, 177, '', '$2y$10$sqmIJacR8JKAwLmtWmsB3ePvcufbX40OvV77fR7NXnTdrX7b8qszC', 6, 1, NULL, '2024-12-27 17:26:12', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (357, 177, '', '$2y$10$M5R2EvFAAL8Jxj7SrXf1XulR8MpO.5fO2pBiNmSP6RTT4Wg1zs0my', 7, 1, NULL, '2024-12-27 17:26:12', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (358, 178, '', '$2y$10$Of/B8vGXMari7eNdV8yoA.Sc8iMkBFYulGa7eabbmmhVzPv3nTpou', 6, 1, NULL, '2024-12-27 17:26:12', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (359, 178, '', '$2y$10$ASRM8v1g.aaf/53K23Zr0eTEc/DkoSy6imQPQeImPLQoVoLlHzIqW', 7, 1, NULL, '2024-12-27 17:26:13', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (360, 179, '', '$2y$10$1G8l/S5jbagoZqmnmVfaUu60eklR68US.mVAIrvl2v0pJ3VVdQEXS', 6, 1, NULL, '2024-12-27 17:28:14', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (361, 179, '', '$2y$10$G3GaCzFJK/yYAEniPuFQYei80IwS7JgtHBX6VRj0z1dGSgWtJeCkO', 7, 1, NULL, '2024-12-27 17:28:14', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (362, 180, '', '$2y$10$Tn4ToAz9lC6oY7pIKxuQJe99oH9UOsA1o7e/fy21yBlC.sFQNRG9i', 6, 1, NULL, '2024-12-27 17:28:14', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (363, 180, '', '$2y$10$bhxvvbfEA2CPbhre34Q1jem7btilHwaAsU1o6uino1l117xvBIvK6', 7, 1, NULL, '2024-12-27 17:28:14', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (364, 181, '', '$2y$10$Z5SNUWUJWGsYXJ5D2RW62.vj0j7zjMsffgryxwFGB6wnCGwXxyHGC', 6, 1, NULL, '2024-12-27 17:28:14', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (365, 181, '', '$2y$10$8CJtTTWoJn.PJfhzxKNTKepc74LFTRKdUeU9M6PTQ/1nuTgbE.2E.', 7, 1, NULL, '2024-12-27 17:28:14', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (366, 182, '', '$2y$10$2cBOz0r6rGXqHpdOB1obd.gYEl3BpobJxm7BWdD2PfbAGqZaRkT7q', 6, 1, NULL, '2024-12-27 17:28:14', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (367, 182, '', '$2y$10$YFspsHz0JyQhFgGxE8qaR.l1QhtoZ8Fz7GdJxGwoY6PkbdBumKhgS', 7, 1, NULL, '2024-12-27 17:28:14', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (368, 183, '', '$2y$10$UZFHXxfm5m7uI/ZklIP06e65JDTfi6X8XhDDxGC4tEgo0GWaUlFGa', 6, 1, NULL, '2024-12-27 17:28:14', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (369, 183, '', '$2y$10$COI0uNvt.AD/Qsj8uDUjjOwMQgasmJ/Hb8kdslDp7zCmH25z04Pc2', 7, 1, NULL, '2024-12-27 17:28:14', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (370, 184, '', '$2y$10$MWeYdDZR.9pA7Wy7bjVhueVBiQSaIMqrOnOunPg2qfPeyBKQwfH6S', 6, 1, NULL, '2024-12-27 17:28:15', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (371, 184, '', '$2y$10$qUj.VtqgRVMauGlO6IotJu3KyDp87F4zhygjDJrVbphvwBAesFK7O', 7, 1, NULL, '2024-12-27 17:28:15', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (372, 185, '', '$2y$10$e6CqmH2ctvGojK94DEpFHO7PXw6GMsPqk3kyACBUppvgkRV.7UnVq', 6, 1, NULL, '2024-12-27 17:28:15', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (373, 185, '', '$2y$10$zoVX4XDqBafE0P7FbvgyhuvmiAUP/1U8FB36.7iMKYA.WRmk9Ekrq', 7, 1, NULL, '2024-12-27 17:28:15', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (374, 186, '', '$2y$10$NO7IAdafNg4YMjL/3cb8Nuwcf.aOFP1tbtrCxhhrx7bnLks.KuGP2', 6, 1, NULL, '2024-12-27 17:28:15', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (375, 186, '', '$2y$10$o2jxEdW5tN61caJwmnuPouUuVr4tDCMEjMZ7SeBJizEIW4uN33Z6S', 7, 1, NULL, '2024-12-27 17:28:15', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (376, 187, '', '$2y$10$IaSUiC7u0NvKwQIpVvf8ZeY338PARUno730JTjVDpTNWWk15S7cqW', 6, 1, NULL, '2024-12-27 17:28:15', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (377, 187, '', '$2y$10$L3NZ4s6iwBGpbD7d/qF6N.XhvkWV.zT2HS2/oOzV9ABPu43rj/J4y', 7, 1, NULL, '2024-12-27 17:28:15', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (378, 188, '', '$2y$10$1cosyRlQz51ei11tDucdNeejz6D957UVglRwYgHFtquIQT8c5i5Vm', 6, 1, NULL, '2024-12-27 17:28:15', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (379, 188, '', '$2y$10$5ZNxdAEw3YjWY4vICKaGaeEBIqQcDPPqahqVqV3EBelv.KeoV1.Ke', 7, 1, NULL, '2024-12-27 17:28:15', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (380, 189, '', '$2y$10$UiIe.0YfXo7hChFCEPh6iuCvkTMbDv1p/MslpTSAR1CyUPuNXK6fm', 6, 1, NULL, '2024-12-27 17:28:15', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (381, 189, '', '$2y$10$wt.44C92hXkIJL6JkAwYRuX0ZiJdL2VIMEmboyUX8JDMbRflTU9ka', 7, 1, NULL, '2024-12-27 17:28:15', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (382, 190, '', '$2y$10$B5d4fGzaALo4lAsLkH/cZOLR8uarIprKVg9WDNz31/O5CA8xlM4fG', 6, 1, NULL, '2024-12-27 17:28:15', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (383, 190, '', '$2y$10$rU98jLFXz1RmxnQd6JHCQu4jaV3q5eC6NkJuYLH.dS2cnmU9fVRSy', 7, 1, NULL, '2024-12-27 17:28:15', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (384, 191, '', '$2y$10$2M0TgxBhI6boBxIZlDZ6Re3Sv6B6SqI9emQzFhy7aOkYpcFoAPb9C', 6, 1, NULL, '2024-12-27 17:28:15', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (385, 191, '', '$2y$10$ZTWI59LOdbgZlBsEg3IjPei9wFSjAxpQHHb.tk7Wpy7e/viRKVOta', 7, 1, NULL, '2024-12-27 17:28:15', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (386, 192, '', '$2y$10$ZPJwhtiuMoeG4bE7Dsgv0.Vt7LNQ19..T8aqSSiOrgvkY11X7s9nK', 6, 1, NULL, '2024-12-27 17:28:15', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (387, 192, '', '$2y$10$A7Vh9Kww9pxq3wGvwKAKhe4m30UwRmS6KUoNqUoCx0a3yTafEnkvC', 7, 1, NULL, '2024-12-27 17:28:16', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (388, 193, '', '$2y$10$OraMCkSStHcaK4jtAUYS0OYp/YEmhpCsn7n3eByDSG4XzUbcTX9EW', 6, 1, NULL, '2024-12-27 17:28:16', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (389, 193, '', '$2y$10$FFjbxZdMHWftl8kwGDLbYu3.iqnSYdlf9tDNN3irpXUHtFU/zRSr.', 7, 1, NULL, '2024-12-27 17:28:16', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (390, 194, '', '$2y$10$8rPVp7wRoY6fKnQpdgtk5e5ZzjEueFQ1JVh5hOSrc3Gbbschq8ed.', 6, 1, NULL, '2024-12-27 17:28:16', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (391, 194, '', '$2y$10$rxEtxWKKfVwnJ57YV2eyQOTVbA1eXCLCpigVRZTGjlesVz4HcM6W6', 7, 1, NULL, '2024-12-27 17:28:16', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (392, 195, '', '$2y$10$ChXfYcQpjB7eUcaI5Lqb9.83QecvlF2MSRVrAB22qI5ca8vYuYtbO', 6, 1, NULL, '2024-12-27 17:28:16', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (393, 195, '', '$2y$10$MD4HEF8rAo5AUeYCIxBhCeq68rrLet7VJWZKsIM5O5OYbCFPL0I12', 7, 1, NULL, '2024-12-27 17:28:16', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (394, 196, '', '$2y$10$.TNKR.8NNTgCWr/5rzQ3ne5DyKWGWKG4YZZyh6iWomDrGyEqC4mHe', 6, 1, NULL, '2024-12-27 17:28:16', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (395, 196, '', '$2y$10$6JwwnNXVKMjEpDtqcQlm7.PcQj6TihHoaEhC5YitsWu/R/d3XUilS', 7, 1, NULL, '2024-12-27 17:28:16', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (396, 197, '', '$2y$10$LOk7vRUDVCjyTCqpOyIcxOdxl0LtYL.xXN.kLx1n0DTsE3FAB2w6y', 6, 1, NULL, '2024-12-27 17:28:16', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (397, 197, '', '$2y$10$gZgo6B7JtdGtdpMHc1AzD./ZAPItvxYhXAgHGmzjEi64MQdg0k2Ie', 7, 1, NULL, '2024-12-27 17:28:16', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (398, 198, '', '$2y$10$w3nBG2doAYV/zLqnZPPCfO3JQoDdIlMmPRrwW.ifLDprXQker8DnC', 6, 1, NULL, '2024-12-27 17:28:16', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (399, 198, '', '$2y$10$JysWpBy2ue5tyITB.0h8ce6rEbf3jb2aOIaVgovj5jSAPKpmnH/bG', 7, 1, NULL, '2024-12-27 17:28:16', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (400, 199, '', '$2y$10$4HFxMQQRtSNWgpYTWn79k.JHNXdWnjyM3WzGBvZiVdxi7GgOYhiK2', 6, 1, NULL, '2024-12-27 17:28:16', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (401, 199, '', '$2y$10$JSC.id0i9KY0eAKihKLXFeXafZvxb8wvtWn.jNU3QnxuqaT/TnYki', 7, 1, NULL, '2024-12-27 17:28:16', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (402, 200, '', '$2y$10$MxXMsf.fJSFl1DIHsywP8exYA.ykYOPrvFO0hHrIpdwiYcin/L.NO', 6, 1, NULL, '2024-12-27 17:28:17', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (403, 200, '', '$2y$10$YpfCT3IVInJCTi3s.MPCUOJI/ejn2QMzfFoiVPGyNLdF.UUuaPyQC', 7, 1, NULL, '2024-12-27 17:28:17', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (404, 201, '', '$2y$10$fkdGKBVjd2b0n5FzE5JD1.DaKqjdgx4Pf451OabjtmT0h9PVt2QO6', 6, 1, NULL, '2024-12-27 17:28:17', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (405, 201, '', '$2y$10$GAeKBwaAtCm4C.FGgBqV/uGP.1cuidLEAb3lyS/rkBCJp4XnqOgXS', 7, 1, NULL, '2024-12-27 17:28:17', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (406, 202, '', '$2y$10$U1rxkB6uesa3t8wV4Fro4efOOfxtfhtwuPkr0Gj/k6dFA7QeWzn6.', 6, 1, NULL, '2024-12-27 17:28:17', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (407, 202, '', '$2y$10$LPq97vuGUwEjjLrH6EE14uynQALBwQfYl0aN./QfjLvm3o1zMcQmS', 7, 1, NULL, '2024-12-27 17:28:17', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (408, 203, '', '$2y$10$7yQbgvo22LFVVDUG2fsRjO2aaMy7s1PXVsHExnsMEm016r6M1V.je', 6, 1, NULL, '2024-12-27 17:28:17', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (409, 203, '', '$2y$10$MBo.BokLVtDuge.ppI7EW.y6UAooIA7JY.NkM7UIofBeXX5Zt4h9.', 7, 1, NULL, '2024-12-27 17:28:17', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (410, 204, '', '$2y$10$coPgpowJZouN2xB380Kh.OfHTGxvNc4zfouhq0x55L4IC4SjccX2u', 6, 1, NULL, '2024-12-27 17:28:17', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (411, 204, '', '$2y$10$AY2fXTxmRmnJP10kkIDNiunipnBwLjLjn1EwShhijNAMjwnzyUYze', 7, 1, NULL, '2024-12-27 17:28:17', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (412, 205, '', '$2y$10$rnAHC4snRqQhxTBBn3k4YOXo.2aETI/.ZydwpCIcQqBxDCj31G0fy', 6, 1, NULL, '2024-12-27 17:28:17', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (413, 205, '', '$2y$10$5.UA.eqmlKzB8/STKDxQLe5fnFg2Jo5QXXES0UyblHbHw9r8BhkpC', 7, 1, NULL, '2024-12-27 17:28:17', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (414, 206, '', '$2y$10$ji6uR1Xy/rX.5omwybyciO9L5OV3Oj7PQDIgNlxZESYqq1qUNptf2', 6, 1, NULL, '2024-12-27 17:30:01', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (415, 206, '', '$2y$10$sxOgLZz6M1Af6xr3rBmbSOOBjN7LQQIYiohgKSh9/6ME/Sj0k6hiy', 7, 1, NULL, '2024-12-27 17:30:01', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (416, 207, '', '$2y$10$n10DiFSme33N7OU4HqtUkeuN5UMKmHgxh.0TQKguyBq/LpQloauAu', 6, 1, NULL, '2024-12-27 17:30:01', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (417, 207, '', '$2y$10$twnWBpPmE0fv1U/CtTN7Cu3r4uOSTMXRv3FhI1YKV3ajFEKtVXx2C', 7, 1, NULL, '2024-12-27 17:30:01', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (418, 208, '', '$2y$10$j5em69KX.5r/wBYcmdM00eLu7CAwX0mgfqdbspN20ioKQD7c7z9Ke', 6, 1, NULL, '2024-12-27 17:30:02', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (419, 208, '', '$2y$10$li.njKuLr48OfUpj7Csu.eEa8GJLYmpGdfoSOs1q9B2rSJdjX7CZG', 7, 1, NULL, '2024-12-27 17:30:02', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (420, 209, '', '$2y$10$.ryl/IYXZsDx.GnWcnchCeJZKHTAOxRa2Xj1cOzHECedu4Y0bnUte', 6, 1, NULL, '2024-12-27 17:30:02', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (421, 209, '', '$2y$10$zZ3d..qsWsWrVS06Qb2wye8CM72Jx2fIBmawy4uDagUGtwq/1wAf.', 7, 1, NULL, '2024-12-27 17:30:02', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (422, 210, '', '$2y$10$v4PDqiZDiW42t7KB6AKYxuLSJ.OISTptqs.J0gjANKSjOUDVsMk9W', 6, 1, NULL, '2024-12-27 17:30:02', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (423, 210, '', '$2y$10$v0rUJURKZAhk2qeh3/1Rbe2mr9rVh.IdbP.QhwdVoKTRufpDYthvO', 7, 1, NULL, '2024-12-27 17:30:02', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (424, 211, '', '$2y$10$WramoE741km.QtIUlKoA/uB1DZwXnTFQySTf5tycvhWZKjfdw/1l.', 6, 1, NULL, '2024-12-27 17:30:02', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (425, 211, '', '$2y$10$WgCs3yJay9CMhqL8b4.IIetxwjkQZaHSNwhA5jVeEzQsLWuvRUIcG', 7, 1, NULL, '2024-12-27 17:30:02', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (426, 212, '', '$2y$10$ACem9e9ftPHJ59b8dxwdfei/sgoJmYaQj0kKEqi699gVJiy8QrmL6', 6, 1, NULL, '2024-12-27 17:30:02', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (427, 212, '', '$2y$10$6hjpY0swUs5PIp4GemUX0.Y0oelQ3mJA.fHtnlzXGyoCJZU2h4xTu', 7, 1, NULL, '2024-12-27 17:30:02', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (428, 213, '', '$2y$10$6CnJZsRl26Qo.qkTLwzMWe/KwE1g1M1bwIMjqtRsWHbSh0klyqaD.', 6, 1, NULL, '2024-12-27 17:30:02', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (429, 213, '', '$2y$10$3NKR4OiS.f2b2fDOX2gCxONSPIPWcMtb8yhdRHy7hoS2Qhid7hqSy', 7, 1, NULL, '2024-12-27 17:30:02', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (430, 214, '', '$2y$10$HfniCng3.PgahVj7dXp4gezqL7rFrqSOdVrv138BZeQMQpDyAXBGG', 6, 1, NULL, '2024-12-27 17:30:03', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (431, 214, '', '$2y$10$1qGvrAnut3cLvdjNkn5rfuiiGgAR8tzgq0MBjef7yZmBtv/uRbwUi', 7, 1, NULL, '2024-12-27 17:30:03', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (432, 215, '', '$2y$10$zKlyOPxrs1OS7t7todLGF.YNXNG4zBU43cikbwDQtvYpGdZ1840Hm', 6, 1, NULL, '2024-12-27 17:30:03', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (433, 215, '', '$2y$10$SFRAmecQ1pE8OWK8n6QGF.WYerzrkHzUxk8LbFO1Q6no37CG.Hoe6', 7, 1, NULL, '2024-12-27 17:30:03', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (434, 216, '', '$2y$10$MzxdWevBJVRUH0TjRmw1tOSjkPQDIO6F242jz7CPd80IACo2WvXFG', 6, 1, NULL, '2024-12-27 17:30:03', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (435, 216, '', '$2y$10$asQi28jr/ypn43sfqLzMaeHZBDS4qtWoBV86r0qFvTqE85LnOBO4a', 7, 1, NULL, '2024-12-27 17:30:03', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (436, 217, '', '$2y$10$7.6.yKVd1vVvSZhPRJw6n.CS9kSrS6Q1beljBNne7sm/ZpiV4pYgm', 6, 1, NULL, '2024-12-27 17:30:03', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (437, 217, '', '$2y$10$TXKmlWL69TwtsMspZPqaje..kA0t8H0l1ZimTLEAdCnCqvxN6Doem', 7, 1, NULL, '2024-12-27 17:30:03', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (438, 218, '', '$2y$10$ynT2eyumcs3JA6G0IBIL2uJSF8tZBkNbvbUR2bfoH0HMaD/2GgJaa', 6, 1, NULL, '2024-12-27 17:30:03', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (439, 218, '', '$2y$10$EFtcqKRcItMHuwN0cBKT/OJv5DUSZKIBgBtBfUtVmnSbax/YIwGiO', 7, 1, NULL, '2024-12-27 17:30:03', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (440, 219, '', '$2y$10$4pTBxKc7zAHKdGcLoN5zMuqjyFkbVpI.l6PBumMpKHIRKEe97kSda', 6, 1, NULL, '2024-12-27 17:30:04', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (441, 219, '', '$2y$10$0fdIa1vUIuAzlBKJTyGfoOe7A/UIe7JPaFDbH/kNdKv0C46Z1/gFK', 7, 1, NULL, '2024-12-27 17:30:04', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (442, 220, '', '$2y$10$RaxFr93P0VG8B9jlMNU3AeJDGG7w/yNFKA.DI0aFawfSyZmj0uu6O', 6, 1, NULL, '2024-12-27 17:30:04', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (443, 220, '', '$2y$10$h1s8459Ml2jUtOmjfPl28OzVosbKhtb.ZpTuakXT7FuizukDIGc8y', 7, 1, NULL, '2024-12-27 17:30:04', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (444, 221, '', '$2y$10$OZi.UJAcylsi4aukyu309OCYrCyOcNhE8NbFpXAflheqQIQJYfvcm', 6, 1, NULL, '2024-12-27 17:30:04', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (445, 221, '', '$2y$10$KFLPKA6A8fsUIAc54LZ/TeSlCgAfiKPFDQliPE.KQ6xIfzb6wEfpe', 7, 1, NULL, '2024-12-27 17:30:04', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (446, 222, '', '$2y$10$fFWcQFIYLva.7BRVc3KOIev8r7.wdqgkewSQsvATWceWBgAo33C6W', 6, 1, NULL, '2024-12-27 17:30:04', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (447, 222, '', '$2y$10$MNPtGT82enIduK/3LEP/tOpg2loxB21lgxiWHEg2.q3UbmRKUPxmW', 7, 1, NULL, '2024-12-27 17:30:04', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (448, 223, '', '$2y$10$bi/TrYRocxGt.IjUga9eAO5BvE33EEw8kckbP.yTHBcIv9/4/UaKa', 6, 1, NULL, '2024-12-27 17:30:04', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (449, 223, '', '$2y$10$XIdxSUYKappC59elDfisnObqqaDOBSzuhbFYFe4bJhomZKKuTfnR2', 7, 1, NULL, '2024-12-27 17:30:04', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (450, 224, '', '$2y$10$Ci3PzPdUQ4MUaRkwJj/dve4xy/Zdkc3SGc3H0MUSYjd85TO9TsDlq', 6, 1, NULL, '2024-12-27 17:31:46', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (451, 224, '', '$2y$10$zDgDh82c9dBYvdoO6iM94e0CAjhy/y04WvE4AzVKNXikkOZmPFoXy', 7, 1, NULL, '2024-12-27 17:31:46', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (452, 225, '', '$2y$10$GfbKYry7buWi8PaqjZjET.Pltpnftl9xyk6oI.4gHxWdrMu6NZgpG', 6, 1, NULL, '2024-12-27 17:31:46', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (453, 225, '', '$2y$10$3vYDlP7fPjaFmLjyGHy8uehmEMva7XnPQoCv7oBoEaYOyCyuxn4by', 7, 1, NULL, '2024-12-27 17:31:46', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (454, 226, '', '$2y$10$t3lcQZaBUkvJPSv/dby/HeaLE3uBNTTkVwIJ./Ut5D6UNP2lU/Yaq', 6, 1, NULL, '2024-12-27 17:31:47', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (455, 226, '', '$2y$10$XpR2ryuIDKi05Q3Ys.ShmeqSuyaOTRXIWlF5VYBqeaca1PTxrjTju', 7, 1, NULL, '2024-12-27 17:31:47', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (456, 227, '', '$2y$10$TEVqn/iFCdp2NRX5JToUzeyft37Eu/hpNvne9chuBAqlyicTzg3I.', 6, 1, NULL, '2024-12-27 17:31:47', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (457, 227, '', '$2y$10$hAZcXWQUywGsRR.Ej8de.e.2xH5RwD3mpTLMN1W2vX1eyvxqxXy5S', 7, 1, NULL, '2024-12-27 17:31:47', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (458, 228, '', '$2y$10$JIDhSv4PDykUpYF32onv7eUjT70pC3iG49r7KByLQJWqS2qMKfFQK', 6, 1, NULL, '2024-12-27 17:31:47', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (459, 228, '', '$2y$10$6KopPSVLLXY5OAGHJfwB/ucMfOp4k/g8AXhAlP1xqfGrjGk9d7pCG', 7, 1, NULL, '2024-12-27 17:31:47', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (460, 229, '', '$2y$10$JC7HOWq4wAyCBT0amQuYRubbz0wZWlF.t.20IyPsFjQqYXvMYDcNm', 6, 1, NULL, '2024-12-27 17:31:47', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (461, 229, '', '$2y$10$uqOnovLHwAHxZP/f7UyYJ..LxjVHHe0tEc67HLNYD5/b7ZRRQT0Fu', 7, 1, NULL, '2024-12-27 17:31:47', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (462, 230, '', '$2y$10$FbQEvHkTTzAUCJC1swpbf.oboLZiH0qdM.LTwpozFqEyeLMG.mjBC', 6, 1, NULL, '2024-12-27 17:31:47', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (463, 230, '', '$2y$10$mKYGW2i6BWHcFQVNNaWde.woGdh49LZ3C3iXu9Cy0LU6UxVsj7jP.', 7, 1, NULL, '2024-12-27 17:31:47', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (464, 231, '', '$2y$10$4zRIwU2akzDOUdwZO/aJcu707o9zYMPlvFIjm9i8CnSaZA6ZQHvom', 6, 1, NULL, '2024-12-27 17:31:47', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (465, 231, '', '$2y$10$zPeSl8FI5fO3S99KzpYfyu3k1OBlEBuaeMkCWrt4O2OSZLewgo.A.', 7, 1, NULL, '2024-12-27 17:31:47', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (466, 232, '', '$2y$10$4T38dQuKCLwiFDkeTDTrauErzEFkuhbthmW6gbh7.O43f/aFh7SLu', 6, 1, NULL, '2024-12-27 17:31:47', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (467, 232, '', '$2y$10$UZP18wrUcS3wpgv3UtL3SOpw6sh0eQGJ4zFYEIIL7LE6cd.wXzKE2', 7, 1, NULL, '2024-12-27 17:31:47', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (468, 233, '', '$2y$10$pI80swzv5SKGoUUkzvAWVuv/20wl8jP7M4wf20P52y800CQ087hJO', 6, 1, NULL, '2024-12-27 17:31:47', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (469, 233, '', '$2y$10$rGxGX5IZHaIKt4IIEtAj6eSjYeX6OtRx/4HuDLzY/xMMjS2RIfjQu', 7, 1, NULL, '2024-12-27 17:31:47', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (470, 234, '', '$2y$10$V68FUmwhc27QT1JeD0dQHe.vtlcp6Py7smngduR2carp7puKIVIyy', 6, 1, NULL, '2024-12-27 17:31:48', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (471, 234, '', '$2y$10$9JR7tFhCOHbOx.nY3z.Jd.X3/rGFVfJ1c.9Q0iio05NYJ0/4FBnxu', 7, 1, NULL, '2024-12-27 17:31:48', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (472, 235, '', '$2y$10$mR/NYFenux9ZWwvCPaD0J.yPLFxbMcuS2rwmEbpPyVrywEGfBekn.', 6, 1, NULL, '2024-12-27 17:31:48', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (473, 235, '', '$2y$10$MVHmwRBAkV85qClSkCAjZuM3F5HSZKhG9ptk9U3bxqKde.F6KpMw.', 7, 1, NULL, '2024-12-27 17:31:48', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (474, 236, '', '$2y$10$oZnXb.IZZkm0.yIXp6mF1OKRe0.0nDPzNogGFLlNtelmKWDIqwrLq', 6, 1, NULL, '2024-12-27 17:31:48', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (475, 236, '', '$2y$10$RdCFweMYEQey98Ur0myO4.Jc92MjDuFQ/NdIuhmxI3ZM6WzPkpLUG', 7, 1, NULL, '2024-12-27 17:31:48', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (476, 237, '', '$2y$10$Rwgo42I/AIeCykrRgTOEA.ez4U9XQq0HYJKX821b1gBohNMaDV0E6', 6, 1, NULL, '2024-12-27 17:31:48', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (477, 237, '', '$2y$10$AVl9E2IJ3tOJwKpHub089.AbXy/RhY3vZoTGcsilZu1/dDVDOMmNe', 7, 1, NULL, '2024-12-27 17:31:48', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (478, 238, '', '$2y$10$2xoAVy/kuiGSZPp7WPbY8uOrGKNOVAIv1J55/ek5m76F5/mJ9Yd02', 6, 1, NULL, '2024-12-27 17:31:48', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (479, 238, '', '$2y$10$gxQbBVoJhwnTD2onwtqAJuvgIg5x/nzAGRdEln0J.VcOKp6XgyPk.', 7, 1, NULL, '2024-12-27 17:31:48', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (480, 239, '', '$2y$10$mjrhb1BsxDwFRDf4rAYPVuzON8Ua4..eLqI3lojo65L5tXlg5EsxW', 6, 1, NULL, '2024-12-27 17:33:06', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (481, 239, '', '$2y$10$lvHc7WsFny/4oFHoW3AMNuUafV0p/ZXxeW4PQ95RnJT9DO3UrIpj.', 7, 1, NULL, '2024-12-27 17:33:06', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (482, 240, '', '$2y$10$kBjJY0kBW8SQtNvHchiDS.Nz7tZQGMnojb4oiSn5ZxkGXzHqAzH9y', 6, 1, NULL, '2024-12-27 17:33:06', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (483, 240, '', '$2y$10$4plLFsoEgICqUftOzLg3xes1kzihibV3jsx8EKabSHpYaVbr87Fry', 7, 1, NULL, '2024-12-27 17:33:06', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (484, 241, '', '$2y$10$O6ryi5J7SJS0rXi58AhPl.UR074oj/phOtNHCKbQTnDtdH0Q10YyS', 6, 1, NULL, '2024-12-27 17:33:06', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (485, 241, '', '$2y$10$cI5CQww/.DYf4ndoWAKBCOEvdFz6Krrip3XxriSF8RAjA7/6iG94i', 7, 1, NULL, '2024-12-27 17:33:06', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (486, 242, '', '$2y$10$F.l3kug0eNYSbVF4KnaIke3lIycJeGaLW1F.GrlZwbWyYVUvVz01m', 6, 1, NULL, '2024-12-27 17:33:06', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (487, 242, '', '$2y$10$R.lrA6vraC7tVvK7dT1B4.tu.3rvuyBLt230inEvk7XUVtEmvtG3O', 7, 1, NULL, '2024-12-27 17:33:06', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (488, 243, '', '$2y$10$JPp/cE3EMJPVBba4S7wmruSVkBpuhyINoYXHeOrqrBBVFgowmBDvC', 6, 1, NULL, '2024-12-27 17:33:06', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (489, 243, '', '$2y$10$vDa761gtn6tKO6r5sQnHDeYb9aNZdhYhIeaeCAvXiipX.rCzhE2pC', 7, 1, NULL, '2024-12-27 17:33:06', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (490, 244, '', '$2y$10$liMHj0b4inTFB9cVnYXP9uZsywXRCAnI3jR46b2cnzd7APeo0uhxS', 6, 1, NULL, '2024-12-27 17:33:06', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (491, 244, '', '$2y$10$9n1KxQIEFePlFQ1lcl6ClOPfnLT6XkeRS5/6SG1UUgLZo0udJlC2a', 7, 1, NULL, '2024-12-27 17:33:06', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (492, 245, '', '$2y$10$B3ajL86KqIwDH4AYAIkkUedBnsscYx/IdALA4edHbqwajfU29FvK2', 6, 1, NULL, '2024-12-27 17:33:07', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (493, 245, '', '$2y$10$0PQuA1jLIRNUVaOXFrqLrOwSAPQk8cIyBLA9I9bRKmIk4CZoEi34y', 7, 1, NULL, '2024-12-27 17:33:07', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (494, 246, '', '$2y$10$in1AIUV.6Z7SvqPG/h3nTOrfGfQOlvqK0shuggx3kTp50tRlY0exa', 6, 1, NULL, '2024-12-27 17:33:07', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (495, 246, '', '$2y$10$S7JuB/arJW8A2P1BDRjEIerKv3cG2EfwyTuebOhI4A5pd.8y7LVwu', 7, 1, NULL, '2024-12-27 17:33:07', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (496, 247, '', '$2y$10$1qOkDoK4zI78mYBG0G/2hOMJut3lXHOJHGzjdNQkExj1V7GwII.1m', 6, 1, NULL, '2024-12-27 17:33:07', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (497, 247, '', '$2y$10$b3MBGxO4N.XmYC59qz2WjOdJwuy4EV/gE7e9CrH2BGR/069WKlEtm', 7, 1, NULL, '2024-12-27 17:33:07', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (498, 248, '', '$2y$10$S0BV7SGMIh1oJBk23uw/geguef49GZRb3aHFms98wOhHR5.K8unDq', 6, 1, NULL, '2024-12-27 17:33:07', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (499, 248, '', '$2y$10$meDzMI0Ivch4yuxnTIdi2eKecSURWHjyZ4rvDAkbQ3j589ajt3O02', 7, 1, NULL, '2024-12-27 17:33:07', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (500, 249, '', '$2y$10$IT4QEQaXKv4igVzxdnMCQuzq3rmv0uyxX2Z2Ck.iMw4T31xNx2LIm', 6, 1, NULL, '2024-12-27 17:33:07', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (501, 249, '', '$2y$10$qlSYaY5Hob4Wss0dyn/QbO5YcFLUJo0CVIc7i9qoL0FYgLtQ7azMS', 7, 1, NULL, '2024-12-27 17:33:07', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (502, 250, '', '$2y$10$.H9hT0z6I8SCBH98bcsC7eG./loFSS0FDy80t8hE/YkQD4keYkefG', 6, 1, NULL, '2024-12-27 17:33:07', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (503, 250, '', '$2y$10$WXja7MxXPhK8uQ2cZv0d5eBPpbkLucb3XmgLBm2LHvms6BgTE1xdG', 7, 1, NULL, '2024-12-27 17:33:07', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (504, 251, '', '$2y$10$OIo69c3xpt1ClUUHOYXikeEi.jGn3PZOS6htODajQZi5yW9poG3NK', 6, 1, NULL, '2024-12-27 17:34:24', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (505, 251, '', '$2y$10$XOaMmWUYzoDa/wryC49X7.gnMJ.wiTBJ2sol53Z5gctkJfZPjmVCG', 7, 1, NULL, '2024-12-27 17:34:24', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (506, 252, '', '$2y$10$lDeaC6ufASXR0eCRsgYw3OnybzvAAIZa/S5UMS3m2k.IC9QP/LwiW', 6, 1, NULL, '2024-12-27 17:34:25', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (507, 252, '', '$2y$10$100Lz6mTDaILcT05h5hNdOOxnjUfROKPK66d9AETdjtHq7qFlkIau', 7, 1, NULL, '2024-12-27 17:34:25', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (508, 253, '', '$2y$10$F6S56hfAFPW73bQ/sz/pKuFv7yEBmLqd.8PgpmRQ6.s/4oxFqXMDa', 6, 1, NULL, '2024-12-27 17:34:25', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (509, 253, '', '$2y$10$iEy7dYjzypIcryxlctU/MuSGuLn74CuwGzugaP.80M2ir9ymB40au', 7, 1, NULL, '2024-12-27 17:34:25', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (510, 254, '', '$2y$10$cUXp8w9bZ7BH/1Pt7Kml6eJSid.ofnwYIlkxO8MUT6/JrF62J.gDa', 6, 1, NULL, '2024-12-27 17:34:25', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (511, 254, '', '$2y$10$RtyICSaOYC4NxCh1dqLxPOMsbhrR5XguynGMV4N7IeZDBQI4DvzL2', 7, 1, NULL, '2024-12-27 17:34:25', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (512, 255, '', '$2y$10$ib8kDVcg4pTe3rt6S9WZfO5090g5gC/vBh/k6RWoubK0QSAF2uN0O', 6, 1, NULL, '2024-12-27 17:34:25', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (513, 255, '', '$2y$10$RpSAUTiYLTKWJv8uIDGqM.jgUqQ6sSFoL8jroztGzoHIY81xI.p6K', 7, 1, NULL, '2024-12-27 17:34:25', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (514, 256, '', '$2y$10$Sfv4X3sxodCAHDAM962nte2t2G4x6norw9jaToDGb0AHSBE8bci3W', 6, 1, NULL, '2024-12-27 17:34:25', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (515, 256, '', '$2y$10$xHfH8WaG5lwE.gnwB/IvRu6EqF4BQWpXhqN7./2HAukJwwWQvlOOm', 7, 1, NULL, '2024-12-27 17:34:25', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (516, 257, '', '$2y$10$JCxxI1aKgH0WVtVZq3QMoeGBa.jtd760HDeHrZrjViEHuRTyRh0cW', 6, 1, NULL, '2024-12-27 17:34:25', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (517, 257, '', '$2y$10$zuCFdEYQYJUXE7pfgq8fI.fuZbfYKJ7i6DalJVrbrWmPcc9WRKuZK', 7, 1, NULL, '2024-12-27 17:34:25', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (518, 258, '', '$2y$10$7n/4y92OzVov6DyV7QBQ6ecUL7tc4j7TipjUfPxYjYfvbUcb9czmy', 6, 1, NULL, '2024-12-27 17:34:25', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (519, 258, '', '$2y$10$mGnKW49FOCkRBVQsINHAfOH0hSRqeHrsXxQKLrMoM2kzDL2KLy34O', 7, 1, NULL, '2024-12-27 17:34:25', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (520, 259, '', '$2y$10$GPC6J13/umFMROyGVPbGxu3aHZNh/xVPL7yK5LuCUdabPgFF6D20i', 6, 1, NULL, '2024-12-27 17:35:33', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (521, 259, '', '$2y$10$jW0SIRUFFWB6diHnJ2T/WOzETRkz49TfnrAiO1c4ErgxIhs7zyvMK', 7, 1, NULL, '2024-12-27 17:35:33', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (522, 260, '', '$2y$10$0SayGaevB4sGPUPhHZLU9urCQ8OyjswZTYXnDNPkYKrvlJJOfpCpe', 6, 1, NULL, '2024-12-27 17:35:33', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (523, 260, '', '$2y$10$8eBSJMiW9c1rm6ulN9ymR.8V294uPN7OIXq5WFrLHIwvcCKxg8tdK', 7, 1, NULL, '2024-12-27 17:35:33', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (524, 261, '', '$2y$10$JOW4HgpYXRHHUwYVwumxGezMfj8A8sYW1LvRyMdjMD33Hy5QOOGOq', 6, 1, NULL, '2024-12-27 17:35:33', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (525, 261, '', '$2y$10$0fj/YVmRNllW87etIk4l9e81lIf2YnQHcyPMmix4dUmkrQBDX7B0K', 7, 1, NULL, '2024-12-27 17:35:33', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (526, 262, '', '$2y$10$EVlOgQoJX97JKZUXRiB0q.BNdIA1T8dUa52d4NT6u4dysAL07cQoS', 6, 1, NULL, '2024-12-27 17:35:34', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (527, 262, '', '$2y$10$fVzRc.TYPc5i.wzP4ZQ3reJ21Ka1llSQybKC9TjJmKwTzIjww.Jma', 7, 1, NULL, '2024-12-27 17:35:34', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (528, 263, '', '$2y$10$PB9rJXw0iOk3dQqWFcr9Sedwe5u/AduCV1QAAHF3CPFpuc9MBrS.2', 6, 1, NULL, '2024-12-27 17:35:34', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (529, 263, '', '$2y$10$3wxfUCkC4N5mlkElsozi4OAwJWrvBOVB.o2Dsq4fm5KRVPsyyu/BS', 7, 1, NULL, '2024-12-27 17:35:34', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (530, 264, '', '$2y$10$icQ3iZC2vk10Es4CizRFW.PL2CUlc7UpfSzeMbiHF77Yu.Kvn2q7C', 6, 1, NULL, '2024-12-27 17:35:34', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (531, 264, '', '$2y$10$0otZIqkR2XgwXRQm560WhOIcAFloCLZYrdVl2gKCpyHgW/CPMM.lS', 7, 1, NULL, '2024-12-27 17:35:34', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (532, 265, '', '$2y$10$Dr6Dx0x5EOK38bHJ.qJfy.7kYrYOXzX0Qrfa2czQD15/o4s5lFR.i', 6, 1, NULL, '2024-12-27 17:35:34', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (533, 265, '', '$2y$10$O4iRTcioZ2uXfcfZCl1Ii.gacf9OjSEuiSHLhkSjXrkNVNSg8Oetm', 7, 1, NULL, '2024-12-27 17:35:34', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (534, 266, '', '$2y$10$8wFoI23nFFriSaX6920bH.kWZs2Q.sI6sYFTA5J/0h/a7yGrsNncK', 6, 1, NULL, '2024-12-27 17:35:34', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (535, 266, '', '$2y$10$Se64ubHOQ8upANoMdlToJO5eNbPvGHpLPJtG3sGRMvEScB.zBjk3W', 7, 1, NULL, '2024-12-27 17:35:34', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (536, 267, '', '$2y$10$ju31C7ZihuZzhf2scYH4IOd4mDGlSoYUz0aXgKUT1oOGx82Uro3WW', 6, 1, NULL, '2024-12-27 17:35:34', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (537, 267, '', '$2y$10$DJXkgrTSI93RPfMTQNeSMeXbQb2Cd82EXlaNm6PNrc3W7KWPtM.Vq', 7, 1, NULL, '2024-12-27 17:35:34', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (538, 268, '', '$2y$10$t9dpZM2b6DDDzrH8EurPW.WFwwHFw.7DQoL4dflP5tSFSY4DOMLyu', 6, 1, NULL, '2024-12-27 17:35:34', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (539, 268, '', '$2y$10$v2HmcqZhAHqra5BH9zEMNOkm0PNt5dPj/v/2Y7VBqLrahSHu0n70a', 7, 1, NULL, '2024-12-27 17:35:34', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (540, 269, '', '$2y$10$uzEBbHxVTXgDks4bKq.iFORvobgvF0khCDjV0e1yfop7FzAr0BARm', 6, 1, NULL, '2024-12-27 17:35:34', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (541, 269, '', '$2y$10$rVKwYSTPbhLm0uq4lkowIOSk2og3DAwWXYNEiuUtum9wRFN1mXmE2', 7, 1, NULL, '2024-12-27 17:35:34', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (542, 270, '', '$2y$10$oy9aVkd/A7fhGVPjlalWMeNbYyLPvChTlUG34VhGCZrKu9j7RUC2e', 6, 1, NULL, '2024-12-27 17:35:35', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (543, 270, '', '$2y$10$h1QIzHdd0oZi1FAtAdWl/e56SrvhG/nS5L8RhPZvkpwOw1x6JoTpa', 7, 1, NULL, '2024-12-27 17:35:35', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (544, 271, '', '$2y$10$pyMWSmOU6VWmyLbmhJ2jPOPj41.BYLfAZaSi13EcnmrS0bCOzrlA6', 6, 1, NULL, '2024-12-27 17:35:35', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (545, 271, '', '$2y$10$dOYMMkrLSimYSU1db7PU.OmMD7lCkxrvDPX6A3E/0yp2f6s2pQ47q', 7, 1, NULL, '2024-12-27 17:35:35', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (546, 272, '', '$2y$10$Mjye4SJgyuyTUciAoxtNie2bRNFkJHr8yaNiljrl64HqLxzKjXtdy', 6, 1, NULL, '2024-12-27 17:35:35', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (547, 272, '', '$2y$10$fFGRPdMCwyaQ9byyqv8ayuzc.7KGUZA1dsmo53LAZgfUzTG1Do7hu', 7, 1, NULL, '2024-12-27 17:35:35', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (548, 273, '', '$2y$10$HF82BFcvkhcFb2NkQn/Z6u1ibbw..W/3pi8/tBSiF3QA4SL44JH8.', 6, 1, NULL, '2024-12-27 17:35:35', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (549, 273, '', '$2y$10$hBR4Qc3MjXI8lZH9H8bFH.mVqmmlOrRhgSmcF0HZOCmayLl9TTP7O', 7, 1, NULL, '2024-12-27 17:35:35', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (550, 274, '', '$2y$10$kXCMC8ZoqPK/jEL30nthqOhypypGu1xOFTRma9bW2uLdtMK5.X95G', 6, 1, NULL, '2024-12-27 17:35:35', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (551, 274, '', '$2y$10$BWJZMSmqWPR4KbWKnyJAv.756mMqONDcdtHPkQdmPC5rqXK2O6Nay', 7, 1, NULL, '2024-12-27 17:35:35', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (552, 275, '', '$2y$10$QRRDS2gA1eZWYl90HTjlauBD73zvpBzIboBdk.6mKP/TcbZlIu.Uq', 6, 1, NULL, '2024-12-27 17:35:35', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (553, 275, '', '$2y$10$QB7JSbMYAE/0qr6u7.wry.6CNXXaaCoGALPE9UuQogdyqdEPhi6Sa', 7, 1, NULL, '2024-12-27 17:35:35', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (554, 276, '', '$2y$10$8Jnca2HoCMfTujuPmxo2gul6KKM0ieYCqzpdYNZPWt1OWNLXICPGa', 6, 1, NULL, '2024-12-27 17:37:15', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (555, 276, 'mishu', '$2y$10$nyD61Tr2usgN4hbFn/WM6.Zk2wLf2/ZOrksUfXphpg/pavv5Yzucu', 7, 1, NULL, '2024-12-27 17:37:15', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (556, 277, '', '$2y$10$QBdAiTdjFFUeHVxoiE49mO3mxK8X7gj/.USkkX//H6zFnrHC.0gQW', 6, 1, NULL, '2024-12-27 17:37:15', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (557, 277, 'eshita', '$2y$10$5B6iG5flwxyRDlEXIPCP/.v2kb4WTaZ0edviA86k7nbmYqTk.oanS', 7, 1, NULL, '2024-12-27 17:37:15', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (558, 278, '', '$2y$10$iZ1l71VlusMwVPtEJTDuy.52aKIXuJ/v0oj6UlRhVwBRkEPRSLqd6', 6, 1, NULL, '2024-12-27 17:37:15', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (559, 278, 'simi', '$2y$10$DrBFYcfT.JwTsMOH2kHfkOSr4y17.nuLqt2Oo6bd7kJeNrWekPPA2', 7, 1, NULL, '2024-12-27 17:37:15', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (560, 279, '', '$2y$10$bUkpV5j3BOym/xL6h8/5FO1xGAZfCVTP4qaC/B1T1VF8ohLZ/WKIu', 6, 1, NULL, '2024-12-27 17:37:15', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (561, 279, 'jahid', '$2y$10$mAmPsk77oE3qjUZkPBbZjOS944IlYC6PzVDylxru8qz11G6zjU2wW', 7, 1, NULL, '2024-12-27 17:37:15', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (562, 280, '', '$2y$10$tc2Z1PyG8DQVuy9Bnt7atOfXUfxI/JAmjhkfZaniYmoyM3gMbBvg.', 6, 1, NULL, '2024-12-27 17:37:15', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (563, 280, 'jakir', '$2y$10$SRB5L6z1zwIJ45EF1PuyPOKUHU1aqmwyOcwcM7xfHk5Ftp1ItqSiS', 7, 1, NULL, '2024-12-27 17:37:15', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (564, 281, '', '$2y$10$HABP968g8if5gQs.b02RUe0yqHDfEHOfeg/iUkvRMDQzVCtayAtLu', 6, 1, NULL, '2024-12-27 17:37:15', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (565, 281, 'uttam', '$2y$10$1BpVB9pfRCB87vuX1Z.TauzTv3kzRqhrggo5y.Jhs4WpRKsULuEEa', 7, 1, NULL, '2024-12-27 17:37:15', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (566, 282, '', '$2y$10$t9K3JI/T1JG8rbsA90pHy.3oSUzApB5h3zLBmKPdkWAsYGYDVqlN.', 6, 1, NULL, '2024-12-27 17:37:15', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (567, 282, 'tanjila', '$2y$10$foicRhhv55nsC/cn4vs9.uLtwZbrN4/t2bKUEYG0875G8DUN7Mq5G', 7, 1, NULL, '2024-12-27 17:37:15', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (568, 283, '', '$2y$10$ThaHV6yW9GT7EsVI/k7oMOxy/GvlUCkwICXEJf338oeObEbktnXX6', 6, 1, NULL, '2024-12-27 17:37:15', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (569, 283, 'sanjida', '$2y$10$RJ6iJbl98nMVDW.Mjn0UgOvSOKShuOMk.eeDr7VULG5dca90hsjeq', 7, 1, NULL, '2024-12-27 17:37:16', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (570, 284, '', '$2y$10$bTeGj6Fv8qbgLiwJIW3KJO/oZfjqXQ/sQWxnTs/U0HE5M.xGt/8sC', 6, 1, NULL, '2024-12-27 17:40:00', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (571, 284, 'maysha', '$2y$10$zuXanQnmCcpJsmDnniy9JO.1MzCg/mjx9hw5FXzQbsZt8C3k5svIa', 7, 1, NULL, '2024-12-27 17:40:00', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (572, 285, '', '$2y$10$lau4DODGny0FT2YQbOz2/.nEPnBHAedCwSbMGJp8686zrRjP8.Xim', 6, 1, NULL, '2024-12-27 17:40:00', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (573, 285, 'tonu', '$2y$10$C.d2gMoVGHVozxv4uemWY./bhzEZkHY07rr2lmKAbZfqNfPPICrJm', 7, 1, NULL, '2024-12-27 17:40:00', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (574, 286, '', '$2y$10$Nj8UnJyfI9aMjmyvdHw3pep1ZE7YXZkzMvnFslFYqhN5ZmX.k8Awu', 6, 1, NULL, '2024-12-27 17:40:00', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (575, 286, 'tanvir', '$2y$10$9H/AG8A9oMJ7.8B9NhLdi.Yi0Vkrli4aXgzwoQ8n2.rhtf5SQrp.e', 7, 1, NULL, '2024-12-27 17:40:00', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (576, 287, '', '$2y$10$b0qL2IphwA40rhIkVXXbtOXbH746t.TEK1N0PyMLHjpkBYXXkKnrG', 6, 1, NULL, '2024-12-27 17:40:01', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (577, 287, 'sneha', '$2y$10$5ikhW6g1oylJNGLtAGT7ie4sOEsJh.eB1XWgd3Vcn7u6rN5126ima', 7, 1, NULL, '2024-12-27 17:40:01', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (578, 288, '', '$2y$10$X8syoJGloxG/Tyy19HgNuevkczQm3nlum9LLlWnT4o4ZVlpLFKUeK', 6, 1, NULL, '2024-12-27 17:40:01', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (579, 288, 'bakkar', '$2y$10$1mOpu/Na8BgzDYgWqrbcROGqDZ1XG9GifKn7zYZEOZs6OsLR/qRzu', 7, 1, NULL, '2024-12-27 17:40:01', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (580, 289, '', '$2y$10$lVW1cE537OCXuvulpg691eyk3xZhxZesw4z0WqtLE35jmMFxZ8tL.', 6, 1, NULL, '2024-12-27 17:40:01', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (581, 289, 'nadia', '$2y$10$qsk3qydO1hgysvC1gcUM5ORavF8.2iZP2XQQdhRMTe/Tk1DMEWinG', 7, 1, NULL, '2024-12-27 17:40:01', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (582, 290, '', '$2y$10$O67okhjnH80n360AylePEOqk0K.b6WGO93l5ybZ8HURKtzbSASZa2', 6, 1, NULL, '2024-12-27 17:40:01', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (583, 290, 'shelim', '$2y$10$kEhalK2ld9zLangGlAw5AuS6VhreP64T66yQeTYHEKx/WFNZye1ty', 7, 1, NULL, '2024-12-27 17:40:01', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (584, 291, '', '$2y$10$XP73mZK1WNt4i5ZkjcFZzOTwaCkOmW0jczmpIq/.cK7pXtSzHXw7m', 6, 1, NULL, '2024-12-27 17:40:01', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (585, 291, 'rakibul', '$2y$10$OQxqixTDUykGZKxAEbVtSu1jzJCnfL.oJYiqt6cdxlq1K/hdK54wq', 7, 1, NULL, '2024-12-27 17:40:01', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (586, 292, '', '$2y$10$petak5lAadno8yT8R46xiO4WYDh04N0Xuy3sV.P9rXKIUQ2/Zjs.K', 6, 1, NULL, '2024-12-27 17:40:01', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (587, 292, 'shaj', '$2y$10$2HQB2CHIPnizX/FD1pqEa.5cvj6aQy4WL7a//H8AKjWwsgJ0aSegy', 7, 1, NULL, '2024-12-27 17:40:01', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (588, 293, '', '$2y$10$fArZ2KrI4shNmuYK2K6hjOPqhzemPmhcsusAgL.f5INsPeMKq6/Q2', 6, 1, NULL, '2024-12-27 17:40:01', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (589, 293, 'sohan', '$2y$10$pU/Pix3wtCPG5DE1sygQIOuPovPRFau9AnV8MXCE5kR/1DIl2m6RO', 7, 1, NULL, '2024-12-27 17:40:01', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (590, 294, '', '$2y$10$5xNVCtm5rEn4V1l/4TGxYesBA6WSWluzZf3FeRKptifSIZM6Aa3sC', 6, 1, NULL, '2024-12-27 17:40:01', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (591, 294, '', '$2y$10$zvX/IqFZHRsSH6GZGx0t9OX93IVN4XvZgTE0UWayVYjplGybBFfRO', 7, 1, NULL, '2024-12-27 17:40:02', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (593, 295, '', '$2y$10$VgZT6QwdQLa/Ov2vtZye6OGYmtDQ4yyyWHE/7IVSjeD4sNoOZofum', 7, 1, NULL, '2024-12-27 17:40:02', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (594, 296, '', '$2y$10$9K2Gc5UgjpPytFkoxxaQROLVvSRsGUp4oBAZavagI4ma3gOyv0ib.', 6, 1, NULL, '2024-12-27 17:40:02', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (595, 296, '', '$2y$10$EdgOO7Z5PxPVGBIgF.WO1.VKrX/rrRJkLTnHxKmHNyRgzQvlEcNMK', 7, 1, NULL, '2024-12-27 17:40:02', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (596, 297, '', '$2y$10$Sa8lpoXTYlZbW3EH8bZoWuxKZ5QjIuqf13J5uG7j5pwvaKs32H.uO', 6, 1, NULL, '2024-12-27 17:49:35', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (597, 297, 'neyoti', '$2y$10$fNVbzRs/L5tOEP82DUUgyO6LGf.MSAXhf1xpLkx2ZR7V.J/FtQWNe', 7, 1, NULL, '2024-12-27 17:49:35', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (598, 298, '', '$2y$10$GwehpTpYZMFxZ/BKBBE39.8tsNV5vZbsN68fWfOEgBZEde/V8sZj6', 6, 1, NULL, '2024-12-27 17:49:35', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (599, 298, 'anisha', '$2y$10$9OADNSNS.Mi1BhWhyMAKDefIgV5d35jOC3i13a54wwAeGmm.10LAC', 7, 1, NULL, '2024-12-27 17:49:35', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (600, 299, '', '$2y$10$ihvg4CPLOtDfOobkGZENquZq6tVEeRv34OfmE8BJid75DZDwM62mm', 6, 1, NULL, '2024-12-27 17:49:35', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (601, 299, 'adiba', '$2y$10$UzN2WoM26mdu/V7Wvt.x5uewH0Ol60ycHGMwR8aoHy0AUieWLNqIu', 7, 1, NULL, '2024-12-27 17:49:35', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (602, 300, '', '$2y$10$w4Aanx1wYSa1L.TiZX9.c.8EDgtt1DsvQWvAlnpMy/7J9w17aLvMK', 6, 1, NULL, '2024-12-27 17:49:35', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (603, 300, 'jahidul', '$2y$10$gqLmrPxgEx66fp.kmajYB.RHC5geCGFAaW8t2A/9j/7368ncKTC26', 7, 1, NULL, '2024-12-27 17:49:35', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (604, 301, '', '$2y$10$/xL4Q2Qe1br.GTtoKZnxde65n03NeTDL6xClIZCG6ZNOsMuHHcQnG', 6, 1, NULL, '2024-12-27 17:51:08', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (605, 301, '', '$2y$10$Xh25nVccEZM5yGjRiuypxeeHoes9laNCvxSlOUqQAoKLYlm.bDYS.', 7, 1, NULL, '2024-12-27 17:51:08', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (607, 302, '', '$2y$10$hkBCMGcXNXhNeYVgR/eG.eImjUDZrVjB5kHeOq.x6THlkqYXvUzzK', 7, 1, NULL, '2024-12-27 17:52:18', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (608, 4, 'kalam77777', '$2y$10$T.lYALdqBmDqs7fQU8qFDeIz.O.Tu6AnRvX3iCJLsunRonmJtcy.q', 3, 1, NULL, '2024-12-31 14:05:58', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (609, 5, 'bormon75', '$2y$10$XuB9d7RbcGBqXaw7gKglc.OmuiBRzhnjP7PFhwjEsc0WkqGcGQCgi', 3, 1, NULL, '2025-01-02 01:10:50', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (610, 6, 'rashedakhatun', '$2y$10$Vf.PS.6NPW.jz6XqeQ925OBIAvlS1nkg1sN8TZ9SRIFvhA9fkTzE.', 3, 1, NULL, '2025-01-02 01:13:11', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (611, 303, 'GD303', '$2y$10$SChpsuVFQaW7sbPpm8xsHeknSFe821EwIDXygw9JBWOL9WgtT79BC', 6, 1, NULL, '2025-01-02 23:26:28', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (612, 303, 'ST303', '$2y$10$FmKnVQFZ2J9ak7ep1xiFROufJW3/cBWCN12q1S3P45vNWmJMr0EUi', 7, 1, NULL, '2025-01-02 23:26:28', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (613, 304, 'ST304', '$2y$10$PiG.AvO1xQRLmvYRLC9TVuo535eD91kO3E0tGJPQNJziSNZM/MYwa', 7, 1, NULL, '2025-01-02 23:29:00', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (614, 305, 'ST305', '$2y$10$VmabYgKaQ5lpcBW9cHpSouWVIBIj4XaWFuClKKhlpt.ouEci3EATy', 7, 1, NULL, '2025-01-02 23:39:39', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (615, 306, 'ST306', '$2y$10$eYT9Y5e5lefeyDorEnCDHO9AGEo8dIHi8iRiruyPTvMncz.ZVupSe', 7, 1, NULL, '2025-01-02 23:43:24', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (616, 307, 'ST307', '$2y$10$.S.LtIZfDI2ing56dD0mFux/SnnLYRcXxmxJ34VBrlh5DkOMbJ4ly', 7, 1, NULL, '2025-01-02 23:47:09', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (617, 308, 'ST308', '$2y$10$4b/azOqWqri4nWjZrOx.3eBQvMQMcaQBqe8X.T/9e6/hfnKnrLncu', 7, 1, NULL, '2025-01-02 23:51:45', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (618, 309, 'ST309', '$2y$10$o0iVVh4cZwoM1t4qPvRrPOgkIbkYfOWfJeyvJrHQdUwiP2hgotmzK', 7, 1, NULL, '2025-01-02 23:55:50', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (619, 310, 'ST310', '$2y$10$aTUX5hVdEk639ilo11fZ5O5i493KCbMoT3JlYIlf5U3/qI/lQc/dG', 7, 1, NULL, '2025-01-02 23:59:31', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (620, 311, 'ST311', '$2y$10$x9zQ9j/SHgXvRgGaqA94KO2n1LDKJboYzvp3LCGhG4WO0RqrH1/kq', 7, 1, NULL, '2025-01-03 00:02:45', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (621, 312, 'ST312', '$2y$10$zrLguqrTzj/3ClcXe6k7BOxuoHvvfR58JsHQ7fNc7wP0zvxULAqb2', 7, 1, NULL, '2025-01-03 00:05:36', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (622, 313, 'ST313', '$2y$10$9C8XJTVtRBXCXbYFi7Xkb.4WDHsuhEULdsASX11.4QlZtKk5lb9Dm', 7, 1, NULL, '2025-01-03 00:13:00', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (623, 314, 'ST314', '$2y$10$kent6/hs6FAalOdZHb0WneGk4yQhJyJC5l8wuM3roYanhcK0dFTzm', 7, 1, NULL, '2025-01-03 00:17:00', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (624, 315, 'ST315', '$2y$10$WMa9aHsAYCfJQAeK7iCiZO.pFMYbyicV5zDY1pRJHNJYV9aOz4TFi', 7, 1, NULL, '2025-01-03 00:21:14', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (625, 316, 'ST316', '$2y$10$rTVOR.hKJpe3iHCGFErpoOduakvWjsI8va3cTljxGkSDLsCXHbXvu', 7, 1, NULL, '2025-01-03 00:24:37', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (626, 317, 'ST317', '$2y$10$aSzP4eklsaZE3zvQubNyKe9yWQEbj9ufefHBTQIq1GtDaBO1R6.x.', 7, 1, NULL, '2025-01-03 00:27:12', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (627, 318, 'ST318', '$2y$10$4fANe10r7MWQ2VXDkEJTIujLc6bV5L/NLQHIlbCLgeRd3jh/N0d3u', 7, 1, NULL, '2025-01-03 00:29:45', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (628, 319, 'ST319', '$2y$10$ICTZyr8idK2WKvjPhNbRRug.29WlBpwxbUsmdgZstDi.De6yyUpV6', 7, 1, NULL, '2025-01-03 00:32:34', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (629, 320, 'ST320', '$2y$10$1vR5Gm/aX3TRPGEfwirvuO3KR19bG9YV4NMnb6bBveSNDejJFWG.S', 7, 1, NULL, '2025-01-03 00:35:16', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (630, 321, 'ST321', '$2y$10$2MgVpecWUOEIfDHxOhwetuq76s4U.DTPFDa2M.58d4w.SvfFbxaG.', 7, 1, NULL, '2025-01-03 00:37:25', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (631, 322, 'ST322', '$2y$10$4QPjfhllxe0PVMnRrhoD1.zKMDvBqun1HhW/g/EFm/C4q8B.0ozja', 7, 1, NULL, '2025-01-03 00:40:14', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (632, 323, 'ST323', '$2y$10$9wa7Bq2WQ/bVvWNa4X5tzujf01d4nOrBHhu1KuPZLRG.JGTRrC2oO', 7, 1, NULL, '2025-01-03 00:43:28', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (633, 324, 'ST324', '$2y$10$ZbccKreiM888Hv2HeMX3l.cn/w/lo0acH6FlX/uWlxvlp9JBkW2oy', 7, 1, NULL, '2025-01-03 00:45:48', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (634, 325, 'ST325', '$2y$10$x90eguWQWNxUe2C1XYNnwOQqKKu8vdj/rlnenbNI8EgTV.iTH8uKO', 7, 1, NULL, '2025-01-03 00:48:17', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (635, 326, 'ST326', '$2y$10$QqROhtIcfW9JDYQZAQX7uelZdWXBOYPJHr5zAKNPZVqtczrLEwJSa', 7, 1, NULL, '2025-01-03 00:54:34', NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (636, 327, 'ST327', '$2y$10$pWycxBibFJS1HJaq5bFTvO/NNgukoebD5FBnvMRs5DbN32SluLWVS', 7, 1, NULL, '2025-01-03 00:57:16', NULL);


#
# TABLE STRUCTURE FOR: login_log
#

DROP TABLE IF EXISTS `login_log`;

CREATE TABLE `login_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `role` int(11) NOT NULL,
  `ip` varchar(255) NOT NULL,
  `browser` varchar(255) NOT NULL,
  `platform` varchar(255) NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `branch_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `login_log_rms_1` (`branch_id`),
  CONSTRAINT `login_log_rms_1` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=99 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (1, 1, 1, '37.111.206.144', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2024-12-27 19:31:33', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (2, 1, 1, '103.248.204.82', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2024-12-27 20:04:12', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (3, 2, 2, '103.248.204.82', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2024-12-27 20:11:06', 1);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (4, 1, 1, '103.248.204.82', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2024-12-27 20:15:32', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (5, 2, 2, '2401:1900:80c4:307a:8d:72b0:605b:3e92', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2024-12-27 20:16:18', 1);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (6, 2, 2, '103.122.255.10', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2024-12-27 20:27:28', 1);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (7, 2, 2, '103.248.204.82', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2024-12-27 20:34:07', 1);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (8, 2, 2, '103.122.255.10', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2024-12-27 20:51:26', 1);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (9, 1, 1, '103.248.204.82', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2024-12-27 21:34:34', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (10, 2, 2, '103.248.204.82', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2024-12-27 22:03:01', 1);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (11, 1, 1, '103.248.204.83', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2024-12-27 22:31:15', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (12, 2, 2, '103.248.204.83', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2024-12-27 23:02:25', 1);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (13, 2, 2, '103.248.204.83', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2024-12-27 23:33:37', 1);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (14, 1, 1, '103.248.204.83', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2024-12-27 23:37:51', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (15, 2, 2, '103.248.204.83', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2024-12-27 23:56:07', 1);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (16, 2, 2, '37.111.194.247', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2024-12-28 00:28:06', 1);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (17, 1, 1, '37.111.194.247', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2024-12-28 00:32:13', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (18, 2, 2, '37.111.194.247', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2024-12-28 00:48:19', 1);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (19, 1, 1, '103.248.204.82', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2024-12-28 01:06:51', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (20, 1, 1, '37.111.194.247', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2024-12-28 01:07:10', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (21, 2, 2, '37.111.194.247', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2024-12-28 01:23:55', 1);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (22, 2, 2, '103.248.204.82', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2024-12-28 01:34:57', 1);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (23, 2, 2, '103.248.204.82', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2024-12-28 01:35:48', 1);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (24, 2, 2, '103.248.204.83', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2024-12-28 03:07:36', 1);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (25, 2, 2, '103.248.204.83', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2024-12-28 03:09:29', 1);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (26, 1, 1, '37.111.194.247', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2024-12-28 03:10:29', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (27, 1, 1, '37.111.194.247', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2024-12-28 03:32:17', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (28, 2, 2, '127.0.0.1', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2024-12-31 05:08:42', 1);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (29, 1, 1, '127.0.0.1', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2024-12-31 05:09:49', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (30, 1, 1, '127.0.0.1', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2024-12-31 11:10:39', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (31, 1, 1, '127.0.0.1', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2024-12-31 17:41:19', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (32, 1, 1, '127.0.0.1', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2024-12-31 17:41:56', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (33, 1, 1, '127.0.0.1', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2024-12-31 17:45:06', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (34, 1, 1, '127.0.0.1', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2024-12-31 17:48:20', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (35, 1, 1, '127.0.0.1', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-01 01:46:47', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (36, 1, 1, '127.0.0.1', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-01 02:11:40', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (37, 1, 1, '127.0.0.1', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-01 03:44:19', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (38, 1, 1, '127.0.0.1', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-01 03:50:12', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (39, 1, 1, '127.0.0.1', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-01 04:55:57', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (40, 1, 1, '127.0.0.1', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-01 05:15:05', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (41, 1, 1, '127.0.0.1', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-01 07:24:35', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (42, 1, 1, '127.0.0.1', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-01 11:36:02', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (43, 1, 1, '127.0.0.1', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-01 12:20:42', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (44, 1, 1, '127.0.0.1', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-01 12:24:33', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (45, 1, 1, '127.0.0.1', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-02 03:28:10', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (46, 1, 1, '127.0.0.1', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-02 04:48:10', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (47, 1, 1, '127.0.0.1', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-02 06:50:29', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (48, 1, 1, '127.0.0.1', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-02 06:56:37', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (49, 1, 1, '127.0.0.1', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-02 07:39:22', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (50, 1, 1, '127.0.0.1', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-02 07:41:43', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (51, 1, 1, '127.0.0.1', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-02 07:43:58', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (52, 1, 1, '127.0.0.1', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-02 07:46:32', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (53, 1, 1, '127.0.0.1', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-02 10:21:42', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (54, 1, 1, '127.0.0.1', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-02 12:24:45', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (55, 1, 1, '127.0.0.1', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-02 12:36:40', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (56, 1, 1, '127.0.0.1', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-02 13:10:57', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (57, 1, 1, '127.0.0.1', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-02 13:20:30', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (58, 1, 1, '127.0.0.1', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-02 13:28:30', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (59, 1, 1, '127.0.0.1', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-02 13:31:18', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (60, 1, 1, '127.0.0.1', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-02 13:43:55', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (61, 1, 1, '127.0.0.1', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-02 13:54:21', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (62, 1, 1, '127.0.0.1', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-02 14:02:02', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (63, 1, 1, '127.0.0.1', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-02 14:07:12', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (64, 1, 1, '127.0.0.1', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-02 14:09:37', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (65, 1, 1, '127.0.0.1', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-02 14:26:42', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (66, 1, 1, '127.0.0.1', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-02 16:03:02', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (67, 1, 1, '127.0.0.1', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-02 16:24:50', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (68, 1, 1, '127.0.0.1', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-03 01:48:05', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (69, 1, 1, '127.0.0.1', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-03 01:48:41', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (70, 1, 1, '127.0.0.1', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-03 09:27:33', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (71, 1, 1, '127.0.0.1', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-03 12:37:05', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (72, 1, 1, '127.0.0.1', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-03 16:16:28', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (73, 1, 1, '127.0.0.1', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-03 16:20:26', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (74, 1, 1, '103.131.145.159', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-03 02:37:10', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (75, 1, 1, '103.131.145.159', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-03 02:38:08', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (76, 1, 1, '103.131.145.159', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-03 02:49:37', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (77, 1, 1, '103.131.145.159', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-03 02:53:07', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (78, 1, 1, '103.131.145.159', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-03 11:59:48', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (79, 1, 1, '103.131.145.159', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-03 20:40:25', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (80, 1, 1, '103.131.145.159', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-03 21:46:18', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (81, 1, 1, '103.131.145.159', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-03 22:22:22', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (82, 1, 1, '103.131.145.159', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-03 22:31:28', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (83, 1, 1, '103.131.145.159', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-04 12:13:05', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (84, 1, 1, '103.131.145.159', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-06 17:07:59', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (85, 1, 1, '103.131.145.159', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-07 23:38:22', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (86, 1, 1, '103.131.145.159', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-09 12:12:56', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (87, 1, 1, '103.131.145.159', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-10 14:51:01', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (88, 1, 1, '103.131.145.159', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-10 15:16:29', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (89, 1, 1, '103.131.145.159', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-10 19:20:27', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (90, 1, 1, '103.111.225.201', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-10 19:51:24', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (91, 1, 1, '103.239.254.239', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-10 22:32:33', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (92, 1, 1, '103.122.251.206', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-11 01:00:14', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (93, 1, 1, '103.135.88.211', 'Chrome 130.0.0.0', 'Android', '2025-01-11 07:44:21', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (94, 1, 1, '58.145.184.240', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-11 12:21:55', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (95, 1, 1, '103.197.204.173', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-11 18:12:39', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (96, 1, 1, '103.197.204.173', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-11 18:18:59', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (97, 1, 1, '103.23.204.60', 'Firefox 134.0', 'Windows 10 / 11', '2025-01-11 18:48:22', NULL);
INSERT INTO `login_log` (`id`, `user_id`, `role`, `ip`, `browser`, `platform`, `timestamp`, `branch_id`) VALUES (98, 1, 1, '103.138.250.202', 'Chrome 131.0.0.0', 'Windows 10 / 11', '2025-01-11 23:06:53', NULL);


#
# TABLE STRUCTURE FOR: mark
#

DROP TABLE IF EXISTS `mark`;

CREATE TABLE `mark` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `subject_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `section_id` int(11) NOT NULL,
  `exam_id` int(11) NOT NULL,
  `mark` text DEFAULT NULL,
  `absent` varchar(4) DEFAULT NULL,
  `session_id` int(11) NOT NULL,
  `branch_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `mark` (`id`, `student_id`, `subject_id`, `class_id`, `section_id`, `exam_id`, `mark`, `absent`, `session_id`, `branch_id`) VALUES (1, 323, 1, 8, 5, 3, '{\"1\":\"40\",\"2\":\"5\"}', '', 6, 1);
INSERT INTO `mark` (`id`, `student_id`, `subject_id`, `class_id`, `section_id`, `exam_id`, `mark`, `absent`, `session_id`, `branch_id`) VALUES (2, 324, 1, 8, 5, 3, '{\"1\":\"70\",\"2\":\"30\"}', '', 6, 1);
INSERT INTO `mark` (`id`, `student_id`, `subject_id`, `class_id`, `section_id`, `exam_id`, `mark`, `absent`, `session_id`, `branch_id`) VALUES (3, 325, 1, 8, 5, 3, '{\"1\":\"69\",\"2\":\"22\"}', '', 6, 1);
INSERT INTO `mark` (`id`, `student_id`, `subject_id`, `class_id`, `section_id`, `exam_id`, `mark`, `absent`, `session_id`, `branch_id`) VALUES (4, 326, 1, 8, 5, 3, '{\"1\":\"40\",\"2\":\"20\"}', '', 6, 1);
INSERT INTO `mark` (`id`, `student_id`, `subject_id`, `class_id`, `section_id`, `exam_id`, `mark`, `absent`, `session_id`, `branch_id`) VALUES (5, 327, 1, 8, 5, 3, '{\"1\":\"60\",\"2\":\"25\"}', '', 6, 1);
INSERT INTO `mark` (`id`, `student_id`, `subject_id`, `class_id`, `section_id`, `exam_id`, `mark`, `absent`, `session_id`, `branch_id`) VALUES (6, 323, 2, 8, 5, 3, '{\"1\":\"45\",\"2\":\"20\"}', '', 6, 1);
INSERT INTO `mark` (`id`, `student_id`, `subject_id`, `class_id`, `section_id`, `exam_id`, `mark`, `absent`, `session_id`, `branch_id`) VALUES (7, 324, 2, 8, 5, 3, '{\"1\":\"50\",\"2\":\"20\"}', '', 6, 1);
INSERT INTO `mark` (`id`, `student_id`, `subject_id`, `class_id`, `section_id`, `exam_id`, `mark`, `absent`, `session_id`, `branch_id`) VALUES (8, 325, 2, 8, 5, 3, '{\"1\":\"53\",\"2\":\"20\"}', '', 6, 1);
INSERT INTO `mark` (`id`, `student_id`, `subject_id`, `class_id`, `section_id`, `exam_id`, `mark`, `absent`, `session_id`, `branch_id`) VALUES (9, 326, 2, 8, 5, 3, '{\"1\":\"60\",\"2\":\"30\"}', '', 6, 1);
INSERT INTO `mark` (`id`, `student_id`, `subject_id`, `class_id`, `section_id`, `exam_id`, `mark`, `absent`, `session_id`, `branch_id`) VALUES (10, 327, 2, 8, 5, 3, '{\"1\":\"70\",\"2\":\"30\"}', '', 6, 1);
INSERT INTO `mark` (`id`, `student_id`, `subject_id`, `class_id`, `section_id`, `exam_id`, `mark`, `absent`, `session_id`, `branch_id`) VALUES (11, 323, 3, 8, 5, 3, '{\"1\":\"60\",\"2\":\"30\"}', '', 6, 1);
INSERT INTO `mark` (`id`, `student_id`, `subject_id`, `class_id`, `section_id`, `exam_id`, `mark`, `absent`, `session_id`, `branch_id`) VALUES (12, 324, 3, 8, 5, 3, '{\"1\":\"69\",\"2\":\"30\"}', '', 6, 1);
INSERT INTO `mark` (`id`, `student_id`, `subject_id`, `class_id`, `section_id`, `exam_id`, `mark`, `absent`, `session_id`, `branch_id`) VALUES (13, 325, 3, 8, 5, 3, '{\"1\":\"65\",\"2\":\"25\"}', '', 6, 1);
INSERT INTO `mark` (`id`, `student_id`, `subject_id`, `class_id`, `section_id`, `exam_id`, `mark`, `absent`, `session_id`, `branch_id`) VALUES (14, 326, 3, 8, 5, 3, '{\"1\":\"55\",\"2\":\"30\"}', '', 6, 1);
INSERT INTO `mark` (`id`, `student_id`, `subject_id`, `class_id`, `section_id`, `exam_id`, `mark`, `absent`, `session_id`, `branch_id`) VALUES (15, 327, 3, 8, 5, 3, '{\"1\":\"70\",\"2\":\"30\"}', '', 6, 1);
INSERT INTO `mark` (`id`, `student_id`, `subject_id`, `class_id`, `section_id`, `exam_id`, `mark`, `absent`, `session_id`, `branch_id`) VALUES (16, 323, 4, 8, 5, 3, '{\"1\":\"70\",\"2\":\"22\"}', '', 6, 1);
INSERT INTO `mark` (`id`, `student_id`, `subject_id`, `class_id`, `section_id`, `exam_id`, `mark`, `absent`, `session_id`, `branch_id`) VALUES (17, 324, 4, 8, 5, 3, '{\"1\":\"70\",\"2\":\"22\"}', '', 6, 1);
INSERT INTO `mark` (`id`, `student_id`, `subject_id`, `class_id`, `section_id`, `exam_id`, `mark`, `absent`, `session_id`, `branch_id`) VALUES (18, 325, 4, 8, 5, 3, '{\"1\":\"70\",\"2\":\"22\"}', '', 6, 1);
INSERT INTO `mark` (`id`, `student_id`, `subject_id`, `class_id`, `section_id`, `exam_id`, `mark`, `absent`, `session_id`, `branch_id`) VALUES (19, 326, 4, 8, 5, 3, '{\"1\":\"70\",\"2\":\"22\"}', '', 6, 1);
INSERT INTO `mark` (`id`, `student_id`, `subject_id`, `class_id`, `section_id`, `exam_id`, `mark`, `absent`, `session_id`, `branch_id`) VALUES (20, 327, 4, 8, 5, 3, '{\"1\":\"70\",\"2\":\"22\"}', '', 6, 1);
INSERT INTO `mark` (`id`, `student_id`, `subject_id`, `class_id`, `section_id`, `exam_id`, `mark`, `absent`, `session_id`, `branch_id`) VALUES (21, 323, 5, 8, 5, 3, '{\"1\":\"60\",\"2\":\"29\"}', '', 6, 1);
INSERT INTO `mark` (`id`, `student_id`, `subject_id`, `class_id`, `section_id`, `exam_id`, `mark`, `absent`, `session_id`, `branch_id`) VALUES (22, 324, 5, 8, 5, 3, '{\"1\":\"70\",\"2\":\"30\"}', '', 6, 1);
INSERT INTO `mark` (`id`, `student_id`, `subject_id`, `class_id`, `section_id`, `exam_id`, `mark`, `absent`, `session_id`, `branch_id`) VALUES (23, 325, 5, 8, 5, 3, '{\"1\":\"62\",\"2\":\"28\"}', '', 6, 1);
INSERT INTO `mark` (`id`, `student_id`, `subject_id`, `class_id`, `section_id`, `exam_id`, `mark`, `absent`, `session_id`, `branch_id`) VALUES (24, 326, 5, 8, 5, 3, '{\"1\":\"55\",\"2\":\"25\"}', '', 6, 1);
INSERT INTO `mark` (`id`, `student_id`, `subject_id`, `class_id`, `section_id`, `exam_id`, `mark`, `absent`, `session_id`, `branch_id`) VALUES (25, 327, 5, 8, 5, 3, '{\"1\":\"45\",\"2\":\"30\"}', '', 6, 1);
INSERT INTO `mark` (`id`, `student_id`, `subject_id`, `class_id`, `section_id`, `exam_id`, `mark`, `absent`, `session_id`, `branch_id`) VALUES (26, 323, 6, 8, 5, 3, '{\"1\":\"55\",\"2\":\"30\"}', '', 6, 1);
INSERT INTO `mark` (`id`, `student_id`, `subject_id`, `class_id`, `section_id`, `exam_id`, `mark`, `absent`, `session_id`, `branch_id`) VALUES (27, 324, 6, 8, 5, 3, '{\"1\":\"70\",\"2\":\"25\"}', '', 6, 1);
INSERT INTO `mark` (`id`, `student_id`, `subject_id`, `class_id`, `section_id`, `exam_id`, `mark`, `absent`, `session_id`, `branch_id`) VALUES (28, 325, 6, 8, 5, 3, '{\"1\":\"69\",\"2\":\"25\"}', '', 6, 1);
INSERT INTO `mark` (`id`, `student_id`, `subject_id`, `class_id`, `section_id`, `exam_id`, `mark`, `absent`, `session_id`, `branch_id`) VALUES (29, 326, 6, 8, 5, 3, '{\"1\":\"70\",\"2\":\"30\"}', '', 6, 1);
INSERT INTO `mark` (`id`, `student_id`, `subject_id`, `class_id`, `section_id`, `exam_id`, `mark`, `absent`, `session_id`, `branch_id`) VALUES (30, 327, 6, 8, 5, 3, '{\"1\":\"70\",\"2\":\"22\"}', '', 6, 1);


#
# TABLE STRUCTURE FOR: marksheet_template
#

DROP TABLE IF EXISTS `marksheet_template`;

CREATE TABLE `marksheet_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `background` varchar(355) DEFAULT NULL,
  `logo` varchar(355) DEFAULT NULL,
  `left_signature` varchar(255) NOT NULL,
  `middle_signature` varchar(255) DEFAULT NULL,
  `right_signature` varchar(255) DEFAULT NULL,
  `attendance_percentage` tinyint(4) NOT NULL DEFAULT 1,
  `grading_scale` tinyint(4) NOT NULL DEFAULT 1,
  `position` tinyint(4) NOT NULL DEFAULT 1,
  `cumulative_average` tinyint(4) NOT NULL DEFAULT 1,
  `class_average` tinyint(4) NOT NULL DEFAULT 1,
  `result` tinyint(4) NOT NULL DEFAULT 1,
  `subject_position` tinyint(4) NOT NULL DEFAULT 1,
  `remark` tinyint(4) NOT NULL DEFAULT 1,
  `header_content` text DEFAULT NULL,
  `footer_content` text DEFAULT NULL,
  `page_layout` tinyint(1) NOT NULL,
  `photo_style` tinyint(1) NOT NULL,
  `photo_size` float NOT NULL DEFAULT 120,
  `top_space` varchar(25) NOT NULL DEFAULT '0',
  `bottom_space` varchar(25) NOT NULL DEFAULT '0',
  `right_space` varchar(25) NOT NULL DEFAULT '0',
  `left_space` varchar(25) NOT NULL DEFAULT '0',
  `branch_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `certificates_templete_rms_1` (`branch_id`),
  CONSTRAINT `marksheet_template_rms_1` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `marksheet_template` (`id`, `name`, `background`, `logo`, `left_signature`, `middle_signature`, `right_signature`, `attendance_percentage`, `grading_scale`, `position`, `cumulative_average`, `class_average`, `result`, `subject_position`, `remark`, `header_content`, `footer_content`, `page_layout`, `photo_style`, `photo_size`, `top_space`, `bottom_space`, `right_space`, `left_space`, `branch_id`, `created_at`) VALUES (1, 'Academic Transcript', '65101777e78082880ec479bb639de28a.jpg', '4401200af3ceabecf85bb59aaeef729d.png', '', '', '', 1, 1, 1, 1, 1, 1, 1, 1, '<div style=\"width: 100%;\">\r\n	<div style=\"text-align: center; width: 80%; float: left;\">\r\n		 </div></div><div style=\"width: 100%;\"><div style=\"text-align: center; width: 80%; float: left;\"> </div><div style=\"width: 80%; float: left;\"><table class=\"table table-bordered\" style=\"margin-top: 20px; background: transparent;\">\r\n			<tbody>\r\n				<tr>\r\n					<th>Name</th><td><p> {name} <span style=\"background-color: transparent;\">({gender})</span><br></p></td>\r\n					<th>Register No\r\n					</th><td>{register_no}</td>\r\n					<th>Roll Number\r\n					</th><td>{roll}</td>\r\n				</tr>\r\n				<tr>\r\n					<th>Father Name\r\n					</th><td>{father_name}</td>\r\n					<th>Admission Date\r\n					</th><td>{admission_date}</td>\r\n					<th>Date of Birth\r\n					</th><td>{birthday}</td>\r\n				</tr>\r\n				<tr>\r\n					<th>Mother Name\r\n					</th><td>{mother_name}</td>\r\n					<th>Class\r\n					</th><td>{class} ({section})</td>\r\n					<th>Gender\r\n					</th><td>{gender}</td>\r\n				</tr>\r\n			</tbody>\r\n		</table>\r\n	</div>\r\n	<div style=\"width: 20%; float: left; text-align: right; margin-top: 20px;\">\r\n		{student_photo}\r\n	</div>\r\n</div>', '<div style=\"width: 100%;\"><table class=\"table table-bordered\"><tbody><tr><td><table class=\"table table-bordered\"><tbody><tr><td><b>Class Teacher\'s Comment</b></td><td><p> {principal_comments} {name}  <br></p></td></tr><tr><td><b>Next Term Begin and Fees</b></td><td><p> {principal_comments} <br></p></td></tr></tbody></table><p>Printed Date<b>:</b> {print_date}  Added Curriculum >> {left_signature}  Stamp >> {middle_signature}  Scan >> {right_signature} </p></td></tr></tbody></table></div>', 1, 1, '120', '240', '20', '60', '60', 1, '2024-12-27 23:29:20');


#
# TABLE STRUCTURE FOR: message
#

DROP TABLE IF EXISTS `message`;

CREATE TABLE `message` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `body` longtext NOT NULL,
  `subject` varchar(255) NOT NULL,
  `file_name` text DEFAULT NULL,
  `enc_name` text DEFAULT NULL,
  `trash_sent` tinyint(1) NOT NULL,
  `trash_inbox` int(11) NOT NULL,
  `fav_inbox` tinyint(1) NOT NULL,
  `fav_sent` tinyint(1) NOT NULL,
  `reciever` varchar(100) NOT NULL,
  `sender` varchar(100) NOT NULL,
  `read_status` tinyint(1) NOT NULL DEFAULT 0 COMMENT '0 unread 1 read',
  `reply_status` tinyint(1) NOT NULL DEFAULT 0 COMMENT '0 unread 1 read',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `message` (`id`, `body`, `subject`, `file_name`, `enc_name`, `trash_sent`, `trash_inbox`, `fav_inbox`, `fav_sent`, `reciever`, `sender`, `read_status`, `reply_status`, `created_at`, `updated_at`) VALUES (1, '<p>Hi, </p>', 'Text Message', NULL, NULL, 0, 0, 0, 0, '3-3', '2-2', 0, 0, '2024-12-27 23:26:08', '0000-00-00 00:00:00');


#
# TABLE STRUCTURE FOR: message_reply
#

DROP TABLE IF EXISTS `message_reply`;

CREATE TABLE `message_reply` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `message_id` int(11) NOT NULL,
  `body` text NOT NULL,
  `file_name` text NOT NULL,
  `enc_name` text NOT NULL,
  `identity` int(11) NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: migrations
#

DROP TABLE IF EXISTS `migrations`;

CREATE TABLE `migrations` (
  `version` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `migrations` (`version`) VALUES ('670');


#
# TABLE STRUCTURE FOR: modules_manage
#

DROP TABLE IF EXISTS `modules_manage`;

CREATE TABLE `modules_manage` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `modules_id` int(11) NOT NULL,
  `isEnabled` tinyint(1) NOT NULL,
  `branch_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `modules_manage` (`id`, `modules_id`, `isEnabled`, `branch_id`) VALUES (1, 26, 0, 1);
INSERT INTO `modules_manage` (`id`, `modules_id`, `isEnabled`, `branch_id`) VALUES (2, 8, 1, 1);
INSERT INTO `modules_manage` (`id`, `modules_id`, `isEnabled`, `branch_id`) VALUES (3, 12, 1, 1);
INSERT INTO `modules_manage` (`id`, `modules_id`, `isEnabled`, `branch_id`) VALUES (4, 15, 1, 1);
INSERT INTO `modules_manage` (`id`, `modules_id`, `isEnabled`, `branch_id`) VALUES (5, 21, 1, 1);
INSERT INTO `modules_manage` (`id`, `modules_id`, `isEnabled`, `branch_id`) VALUES (6, 20, 1, 1);
INSERT INTO `modules_manage` (`id`, `modules_id`, `isEnabled`, `branch_id`) VALUES (7, 14, 1, 1);
INSERT INTO `modules_manage` (`id`, `modules_id`, `isEnabled`, `branch_id`) VALUES (8, 7, 1, 1);
INSERT INTO `modules_manage` (`id`, `modules_id`, `isEnabled`, `branch_id`) VALUES (9, 10, 0, 1);
INSERT INTO `modules_manage` (`id`, `modules_id`, `isEnabled`, `branch_id`) VALUES (10, 5, 1, 1);
INSERT INTO `modules_manage` (`id`, `modules_id`, `isEnabled`, `branch_id`) VALUES (11, 25, 1, 1);
INSERT INTO `modules_manage` (`id`, `modules_id`, `isEnabled`, `branch_id`) VALUES (12, 13, 0, 1);
INSERT INTO `modules_manage` (`id`, `modules_id`, `isEnabled`, `branch_id`) VALUES (13, 19, 1, 1);
INSERT INTO `modules_manage` (`id`, `modules_id`, `isEnabled`, `branch_id`) VALUES (14, 27, 1, 1);
INSERT INTO `modules_manage` (`id`, `modules_id`, `isEnabled`, `branch_id`) VALUES (15, 17, 1, 1);
INSERT INTO `modules_manage` (`id`, `modules_id`, `isEnabled`, `branch_id`) VALUES (16, 23, 1, 1);
INSERT INTO `modules_manage` (`id`, `modules_id`, `isEnabled`, `branch_id`) VALUES (17, 24, 0, 1);
INSERT INTO `modules_manage` (`id`, `modules_id`, `isEnabled`, `branch_id`) VALUES (18, 16, 1, 1);
INSERT INTO `modules_manage` (`id`, `modules_id`, `isEnabled`, `branch_id`) VALUES (19, 11, 0, 1);
INSERT INTO `modules_manage` (`id`, `modules_id`, `isEnabled`, `branch_id`) VALUES (20, 22, 1, 1);


#
# TABLE STRUCTURE FOR: offline_fees_payments
#

DROP TABLE IF EXISTS `offline_fees_payments`;

CREATE TABLE `offline_fees_payments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_method` int(11) NOT NULL,
  `invoice_no` varchar(50) DEFAULT NULL,
  `student_enroll_id` int(11) DEFAULT NULL,
  `fees_allocation_id` int(11) DEFAULT NULL,
  `fees_type_id` int(11) DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `reference` varchar(200) DEFAULT NULL,
  `amount` float(10,2) DEFAULT NULL,
  `fine` float(10,2) DEFAULT NULL,
  `submit_date` datetime DEFAULT NULL,
  `approve_date` datetime DEFAULT NULL,
  `orig_file_name` varchar(255) DEFAULT NULL,
  `enc_file_name` text DEFAULT NULL,
  `note` varchar(255) DEFAULT NULL,
  `comments` text DEFAULT NULL,
  `approved_by` int(11) DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `student_fees_master_id` (`fees_allocation_id`),
  KEY `fee_groups_feetype_id` (`fees_type_id`),
  KEY `offline_fees_payments_ibfk_4` (`approved_by`),
  KEY `student_session_id` (`student_enroll_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: offline_payment_types
#

DROP TABLE IF EXISTS `offline_payment_types`;

CREATE TABLE `offline_payment_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `note` varchar(500) DEFAULT NULL,
  `branch_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `offline_payment_types` (`id`, `name`, `note`, `branch_id`) VALUES (1, 'Bikash {ersonal', '<p>pay here: 01775457008 Bikash personal</p>', 1);
INSERT INTO `offline_payment_types` (`id`, `name`, `note`, `branch_id`) VALUES (2, 'Rocket', '<p>pay here: 01870829343 rocket personal</p>', 1);
INSERT INTO `offline_payment_types` (`id`, `name`, `note`, `branch_id`) VALUES (3, 'Nagod personal', '<p>pay here: 01870829343 nagod personal</p>', 1);


#
# TABLE STRUCTURE FOR: online_admission
#

DROP TABLE IF EXISTS `online_admission`;

CREATE TABLE `online_admission` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(255) DEFAULT NULL,
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) DEFAULT NULL,
  `gender` varchar(25) DEFAULT NULL,
  `birthday` varchar(100) DEFAULT NULL,
  `religion` varchar(100) DEFAULT NULL,
  `caste` varchar(100) DEFAULT NULL,
  `blood_group` varchar(100) DEFAULT NULL,
  `mobile_no` varchar(50) DEFAULT NULL,
  `mother_tongue` varchar(100) DEFAULT NULL,
  `present_address` text DEFAULT NULL,
  `permanent_address` text DEFAULT NULL,
  `admission_date` varchar(100) DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  `student_photo` varchar(255) DEFAULT NULL,
  `category_id` varchar(11) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `previous_school_details` text DEFAULT NULL,
  `guardian_name` varchar(255) DEFAULT NULL,
  `guardian_relation` varchar(50) DEFAULT NULL,
  `father_name` varchar(255) DEFAULT NULL,
  `mother_name` varchar(255) DEFAULT NULL,
  `grd_occupation` varchar(255) DEFAULT NULL,
  `grd_income` varchar(25) DEFAULT NULL,
  `grd_education` varchar(255) DEFAULT NULL,
  `grd_email` varchar(255) DEFAULT NULL,
  `grd_mobile_no` varchar(50) DEFAULT NULL,
  `grd_address` text DEFAULT NULL,
  `grd_city` varchar(255) DEFAULT NULL,
  `grd_state` varchar(255) DEFAULT NULL,
  `grd_photo` varchar(255) DEFAULT NULL,
  `status` tinyint(3) NOT NULL DEFAULT 1,
  `payment_status` tinyint(1) NOT NULL DEFAULT 0,
  `payment_amount` decimal(18,2) NOT NULL,
  `payment_details` longtext NOT NULL,
  `branch_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `section_id` varchar(11) DEFAULT NULL,
  `apply_date` datetime NOT NULL,
  `doc` varchar(255) DEFAULT NULL,
  `created_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `online_admission_rms_1` (`branch_id`),
  CONSTRAINT `online_admission_rms_1` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `online_admission` (`id`, `reference_no`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mobile_no`, `mother_tongue`, `present_address`, `permanent_address`, `admission_date`, `city`, `state`, `student_photo`, `category_id`, `email`, `previous_school_details`, `guardian_name`, `guardian_relation`, `father_name`, `mother_name`, `grd_occupation`, `grd_income`, `grd_education`, `grd_email`, `grd_mobile_no`, `grd_address`, `grd_city`, `grd_state`, `grd_photo`, `status`, `payment_status`, `payment_amount`, `payment_details`, `branch_id`, `class_id`, `section_id`, `apply_date`, `doc`, `created_date`) VALUES (2, '8910295', 'Elite Design', 'janatar bangladesh', 'male', '2025-01-02', 'Islam', NULL, 'A+', '01954578089', NULL, 'Holding: 13/2033-02,Lotifpur Moddhopara,Bogura', 'hhhh', '2025-01-03', 'Bogura', NULL, '6c2e198a12b7d3566baa2ba22e9fc151.png', NULL, 'elitedesign.com.bdvvv@gmail.com', '{\"school_name\":\"cbbcbcv\",\"qualification\":\"SSC\",\"remarks\":\"ghhgh\"}', NULL, NULL, 'hggh', 'hghghg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 1, 0, '0.00', '', 1, 2, NULL, '2025-01-03 01:30:13', 'f3d443d958eabc9ef037e269d490cef3.jpg', '2025-01-03 01:30:13');
INSERT INTO `online_admission` (`id`, `reference_no`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mobile_no`, `mother_tongue`, `present_address`, `permanent_address`, `admission_date`, `city`, `state`, `student_photo`, `category_id`, `email`, `previous_school_details`, `guardian_name`, `guardian_relation`, `father_name`, `mother_name`, `grd_occupation`, `grd_income`, `grd_education`, `grd_email`, `grd_mobile_no`, `grd_address`, `grd_city`, `grd_state`, `grd_photo`, `status`, `payment_status`, `payment_amount`, `payment_details`, `branch_id`, `class_id`, `section_id`, `apply_date`, `doc`, `created_date`) VALUES (3, '39802917', 'dfghdfh', 'dhdhd', 'male', '', '', NULL, '', '', NULL, '', '', '2025-01-08', '', NULL, '', NULL, '', '', NULL, NULL, '', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 1, 0, '0.00', '', 1, 2, NULL, '2025-01-08 17:48:52', '97ffd0ff4cef167d88c756112e9c5990.png', '2025-01-08 17:48:52');
INSERT INTO `online_admission` (`id`, `reference_no`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mobile_no`, `mother_tongue`, `present_address`, `permanent_address`, `admission_date`, `city`, `state`, `student_photo`, `category_id`, `email`, `previous_school_details`, `guardian_name`, `guardian_relation`, `father_name`, `mother_name`, `grd_occupation`, `grd_income`, `grd_education`, `grd_email`, `grd_mobile_no`, `grd_address`, `grd_city`, `grd_state`, `grd_photo`, `status`, `payment_status`, `payment_amount`, `payment_details`, `branch_id`, `class_id`, `section_id`, `apply_date`, `doc`, `created_date`) VALUES (4, '59237614', 'Rafiqul', 'Islam', 'male', '2025-01-09', 'muslim', NULL, 'A+', '01850636864', NULL, 'Fazilpur, Feni', 'Fjdd', '2025-01-11', 'Feni', NULL, 'f19fcdab75940cb14a412883bfd345cc.jpg', NULL, 'rafiqulislam98316844@gmail.com', '{\"school_name\":\"Tgf\",\"qualification\":\"Ht\",\"remarks\":\"Cbb\"}', NULL, NULL, 'Dbbd', 'Bdfb', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 1, 0, '0.00', '', 1, 2, NULL, '2025-01-11 07:43:48', '949446f23a30ea5db609fa265a356d9d.jpg', '2025-01-11 07:43:48');
INSERT INTO `online_admission` (`id`, `reference_no`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mobile_no`, `mother_tongue`, `present_address`, `permanent_address`, `admission_date`, `city`, `state`, `student_photo`, `category_id`, `email`, `previous_school_details`, `guardian_name`, `guardian_relation`, `father_name`, `mother_name`, `grd_occupation`, `grd_income`, `grd_education`, `grd_email`, `grd_mobile_no`, `grd_address`, `grd_city`, `grd_state`, `grd_photo`, `status`, `payment_status`, `payment_amount`, `payment_details`, `branch_id`, `class_id`, `section_id`, `apply_date`, `doc`, `created_date`) VALUES (5, '87399306', 'Anamul Haque', 'Noyon', 'male', '2025-01-11', 'Islam', NULL, 'A-', '0997318386', NULL, 'Gangail,Nandail, Gangail,Nandail', 'Gangail,Nandail, Gangail,Nandail', '2025-01-11', 'Mymensingh', NULL, '1be30f2f962320249eae91a63dfdd20b.jpg', NULL, '', '{\"school_name\":\"nil\",\"qualification\":\"d\",\"remarks\":\"s\"}', NULL, NULL, 'saiful Islam', 'shahana', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 1, 0, '0.00', '', 1, 2, NULL, '2025-01-11 23:05:16', '1dde43e008328b73eb4d39603ac19ce7.jpg', '2025-01-11 23:05:16');


#
# TABLE STRUCTURE FOR: online_admission_fields
#

DROP TABLE IF EXISTS `online_admission_fields`;

CREATE TABLE `online_admission_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fields_id` int(11) NOT NULL,
  `status` tinyint(4) NOT NULL DEFAULT 1,
  `required` tinyint(4) NOT NULL DEFAULT 0,
  `system` tinyint(1) NOT NULL DEFAULT 1,
  `branch_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `online_admission_fields` (`id`, `fields_id`, `status`, `required`, `system`, `branch_id`) VALUES (1, 2, 1, 1, 1, 1);
INSERT INTO `online_admission_fields` (`id`, `fields_id`, `status`, `required`, `system`, `branch_id`) VALUES (2, 3, 1, 0, 1, 1);
INSERT INTO `online_admission_fields` (`id`, `fields_id`, `status`, `required`, `system`, `branch_id`) VALUES (3, 4, 1, 0, 1, 1);
INSERT INTO `online_admission_fields` (`id`, `fields_id`, `status`, `required`, `system`, `branch_id`) VALUES (4, 5, 1, 1, 1, 1);
INSERT INTO `online_admission_fields` (`id`, `fields_id`, `status`, `required`, `system`, `branch_id`) VALUES (5, 6, 0, 0, 1, 1);
INSERT INTO `online_admission_fields` (`id`, `fields_id`, `status`, `required`, `system`, `branch_id`) VALUES (6, 7, 0, 0, 1, 1);
INSERT INTO `online_admission_fields` (`id`, `fields_id`, `status`, `required`, `system`, `branch_id`) VALUES (7, 8, 1, 0, 1, 1);
INSERT INTO `online_admission_fields` (`id`, `fields_id`, `status`, `required`, `system`, `branch_id`) VALUES (8, 9, 0, 0, 1, 1);
INSERT INTO `online_admission_fields` (`id`, `fields_id`, `status`, `required`, `system`, `branch_id`) VALUES (9, 10, 1, 0, 1, 1);
INSERT INTO `online_admission_fields` (`id`, `fields_id`, `status`, `required`, `system`, `branch_id`) VALUES (10, 11, 0, 0, 1, 1);
INSERT INTO `online_admission_fields` (`id`, `fields_id`, `status`, `required`, `system`, `branch_id`) VALUES (11, 12, 1, 0, 1, 1);
INSERT INTO `online_admission_fields` (`id`, `fields_id`, `status`, `required`, `system`, `branch_id`) VALUES (12, 13, 1, 0, 1, 1);
INSERT INTO `online_admission_fields` (`id`, `fields_id`, `status`, `required`, `system`, `branch_id`) VALUES (13, 14, 1, 0, 1, 1);
INSERT INTO `online_admission_fields` (`id`, `fields_id`, `status`, `required`, `system`, `branch_id`) VALUES (14, 15, 0, 0, 1, 1);
INSERT INTO `online_admission_fields` (`id`, `fields_id`, `status`, `required`, `system`, `branch_id`) VALUES (15, 16, 1, 0, 1, 1);
INSERT INTO `online_admission_fields` (`id`, `fields_id`, `status`, `required`, `system`, `branch_id`) VALUES (16, 17, 1, 0, 1, 1);
INSERT INTO `online_admission_fields` (`id`, `fields_id`, `status`, `required`, `system`, `branch_id`) VALUES (17, 18, 1, 0, 1, 1);
INSERT INTO `online_admission_fields` (`id`, `fields_id`, `status`, `required`, `system`, `branch_id`) VALUES (18, 19, 1, 0, 1, 1);
INSERT INTO `online_admission_fields` (`id`, `fields_id`, `status`, `required`, `system`, `branch_id`) VALUES (19, 20, 0, 0, 1, 1);
INSERT INTO `online_admission_fields` (`id`, `fields_id`, `status`, `required`, `system`, `branch_id`) VALUES (20, 21, 0, 0, 1, 1);
INSERT INTO `online_admission_fields` (`id`, `fields_id`, `status`, `required`, `system`, `branch_id`) VALUES (21, 22, 1, 0, 1, 1);
INSERT INTO `online_admission_fields` (`id`, `fields_id`, `status`, `required`, `system`, `branch_id`) VALUES (22, 23, 1, 0, 1, 1);
INSERT INTO `online_admission_fields` (`id`, `fields_id`, `status`, `required`, `system`, `branch_id`) VALUES (23, 24, 0, 0, 1, 1);
INSERT INTO `online_admission_fields` (`id`, `fields_id`, `status`, `required`, `system`, `branch_id`) VALUES (24, 25, 0, 0, 1, 1);
INSERT INTO `online_admission_fields` (`id`, `fields_id`, `status`, `required`, `system`, `branch_id`) VALUES (25, 26, 0, 0, 1, 1);
INSERT INTO `online_admission_fields` (`id`, `fields_id`, `status`, `required`, `system`, `branch_id`) VALUES (26, 27, 0, 0, 1, 1);
INSERT INTO `online_admission_fields` (`id`, `fields_id`, `status`, `required`, `system`, `branch_id`) VALUES (27, 28, 0, 0, 1, 1);
INSERT INTO `online_admission_fields` (`id`, `fields_id`, `status`, `required`, `system`, `branch_id`) VALUES (28, 29, 0, 0, 1, 1);
INSERT INTO `online_admission_fields` (`id`, `fields_id`, `status`, `required`, `system`, `branch_id`) VALUES (29, 30, 0, 0, 1, 1);
INSERT INTO `online_admission_fields` (`id`, `fields_id`, `status`, `required`, `system`, `branch_id`) VALUES (30, 31, 1, 1, 1, 1);
INSERT INTO `online_admission_fields` (`id`, `fields_id`, `status`, `required`, `system`, `branch_id`) VALUES (31, 32, 0, 0, 1, 1);
INSERT INTO `online_admission_fields` (`id`, `fields_id`, `status`, `required`, `system`, `branch_id`) VALUES (32, 33, 0, 0, 1, 1);


#
# TABLE STRUCTURE FOR: online_exam
#

DROP TABLE IF EXISTS `online_exam`;

CREATE TABLE `online_exam` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `class_id` int(11) NOT NULL,
  `section_id` text NOT NULL,
  `subject_id` text NOT NULL,
  `limits_participation` int(11) NOT NULL,
  `exam_start` datetime DEFAULT NULL,
  `exam_end` datetime DEFAULT NULL,
  `duration` time NOT NULL,
  `mark_type` tinyint(1) NOT NULL DEFAULT 1,
  `passing_mark` float NOT NULL DEFAULT 0,
  `instruction` text DEFAULT NULL,
  `session_id` int(11) DEFAULT NULL,
  `publish_result` tinyint(1) NOT NULL DEFAULT 0,
  `marks_display` tinyint(1) NOT NULL DEFAULT 1,
  `neg_mark` tinyint(1) NOT NULL DEFAULT 0,
  `question_type` tinyint(1) NOT NULL DEFAULT 0,
  `publish_status` tinyint(1) NOT NULL DEFAULT 0,
  `exam_type` tinyint(1) NOT NULL DEFAULT 0,
  `fee` float NOT NULL DEFAULT 0,
  `created_by` int(11) NOT NULL,
  `position_generated` tinyint(1) NOT NULL DEFAULT 0,
  `branch_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `session_id` (`session_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: online_exam_answer
#

DROP TABLE IF EXISTS `online_exam_answer`;

CREATE TABLE `online_exam_answer` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `online_exam_id` int(11) NOT NULL,
  `question_id` int(11) NOT NULL,
  `answer` longtext DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: online_exam_attempts
#

DROP TABLE IF EXISTS `online_exam_attempts`;

CREATE TABLE `online_exam_attempts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `online_exam_id` int(11) NOT NULL,
  `count` float NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: online_exam_payment
#

DROP TABLE IF EXISTS `online_exam_payment`;

CREATE TABLE `online_exam_payment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `exam_id` int(11) NOT NULL,
  `payment_method` tinyint(4) NOT NULL,
  `amount` float NOT NULL DEFAULT 0,
  `transaction_id` varchar(500) NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: online_exam_submitted
#

DROP TABLE IF EXISTS `online_exam_submitted`;

CREATE TABLE `online_exam_submitted` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `online_exam_id` int(11) NOT NULL,
  `remark` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `position` int(11) NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: parent
#

DROP TABLE IF EXISTS `parent`;

CREATE TABLE `parent` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `relation` varchar(255) DEFAULT NULL,
  `father_name` varchar(255) DEFAULT NULL,
  `mother_name` varchar(255) DEFAULT NULL,
  `occupation` varchar(100) DEFAULT NULL,
  `income` varchar(100) DEFAULT NULL,
  `education` varchar(255) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `mobileno` varchar(100) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  `branch_id` int(11) DEFAULT NULL,
  `photo` varchar(255) DEFAULT NULL,
  `facebook_url` varchar(255) DEFAULT NULL,
  `linkedin_url` varchar(255) DEFAULT NULL,
  `twitter_url` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT NULL,
  `active` tinyint(2) NOT NULL DEFAULT 0 COMMENT '0(active) 1(deactivate)',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=304 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `parent` (`id`, `name`, `relation`, `father_name`, `mother_name`, `occupation`, `income`, `education`, `email`, `mobileno`, `address`, `city`, `state`, `branch_id`, `photo`, `facebook_url`, `linkedin_url`, `twitter_url`, `created_at`, `updated_at`, `active`) VALUES (303, 'Md Abdul Rashid', 'Father', 'Khijir Uddin Munshi', 'Jamila', 'Business', '10000', 'SSC', 'rashid@gmail.com', '01775457006', 'Holding: 13/2033-02,Lotifpur Moddhopara,Bogura', NULL, NULL, 1, 'defualt.png', NULL, NULL, NULL, '2025-01-02 23:26:28', NULL, 0);


#
# TABLE STRUCTURE FOR: payment_config
#

DROP TABLE IF EXISTS `payment_config`;

CREATE TABLE `payment_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `paypal_username` varchar(255) DEFAULT NULL,
  `paypal_password` varchar(255) DEFAULT NULL,
  `paypal_signature` varchar(255) DEFAULT NULL,
  `paypal_email` varchar(255) DEFAULT NULL,
  `paypal_sandbox` tinyint(4) DEFAULT NULL,
  `paypal_status` tinyint(4) DEFAULT NULL,
  `stripe_secret` varchar(255) DEFAULT NULL,
  `stripe_publishiable` varchar(255) NOT NULL,
  `stripe_demo` varchar(255) DEFAULT NULL,
  `stripe_status` tinyint(4) DEFAULT NULL,
  `payumoney_key` varchar(255) DEFAULT NULL,
  `payumoney_salt` varchar(255) DEFAULT NULL,
  `payumoney_demo` tinyint(4) DEFAULT NULL,
  `payumoney_status` tinyint(4) DEFAULT NULL,
  `paystack_secret_key` varchar(255) NOT NULL,
  `paystack_status` tinyint(4) NOT NULL,
  `razorpay_key_id` varchar(255) NOT NULL,
  `razorpay_key_secret` varchar(255) NOT NULL,
  `razorpay_demo` tinyint(4) NOT NULL,
  `razorpay_status` tinyint(4) NOT NULL,
  `sslcz_store_id` varchar(255) NOT NULL,
  `sslcz_store_passwd` varchar(255) NOT NULL,
  `sslcommerz_sandbox` tinyint(1) NOT NULL,
  `sslcommerz_status` tinyint(1) NOT NULL,
  `jazzcash_merchant_id` varchar(255) NOT NULL,
  `jazzcash_passwd` varchar(255) NOT NULL,
  `jazzcash_integerity_salt` varchar(255) NOT NULL,
  `jazzcash_sandbox` tinyint(1) NOT NULL,
  `jazzcash_status` tinyint(1) NOT NULL,
  `midtrans_client_key` varchar(255) NOT NULL,
  `midtrans_server_key` varchar(255) NOT NULL,
  `midtrans_sandbox` tinyint(1) NOT NULL,
  `midtrans_status` tinyint(1) NOT NULL,
  `flutterwave_public_key` varchar(255) DEFAULT NULL,
  `flutterwave_secret_key` varchar(255) DEFAULT NULL,
  `flutterwave_sandbox` tinyint(4) NOT NULL DEFAULT 0,
  `flutterwave_status` tinyint(4) NOT NULL DEFAULT 0,
  `paytm_merchantmid` varchar(255) DEFAULT NULL,
  `paytm_merchantkey` varchar(255) DEFAULT NULL,
  `paytm_merchant_website` varchar(255) DEFAULT NULL,
  `paytm_industry_type` varchar(255) DEFAULT NULL,
  `paytm_status` tinyint(1) NOT NULL DEFAULT 0,
  `toyyibpay_secretkey` varchar(255) DEFAULT NULL,
  `toyyibpay_categorycode` varchar(255) DEFAULT NULL,
  `toyyibpay_status` tinyint(1) NOT NULL DEFAULT 0,
  `payhere_merchant_id` varchar(255) DEFAULT NULL,
  `payhere_merchant_secret` varchar(255) DEFAULT NULL,
  `payhere_status` tinyint(1) NOT NULL DEFAULT 0,
  `nepalste_public_key` varchar(255) DEFAULT NULL,
  `nepalste_secret_key` varchar(255) DEFAULT NULL,
  `nepalste_status` tinyint(1) NOT NULL DEFAULT 0,
  `branch_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `payment_config` (`id`, `paypal_username`, `paypal_password`, `paypal_signature`, `paypal_email`, `paypal_sandbox`, `paypal_status`, `stripe_secret`, `stripe_publishiable`, `stripe_demo`, `stripe_status`, `payumoney_key`, `payumoney_salt`, `payumoney_demo`, `payumoney_status`, `paystack_secret_key`, `paystack_status`, `razorpay_key_id`, `razorpay_key_secret`, `razorpay_demo`, `razorpay_status`, `sslcz_store_id`, `sslcz_store_passwd`, `sslcommerz_sandbox`, `sslcommerz_status`, `jazzcash_merchant_id`, `jazzcash_passwd`, `jazzcash_integerity_salt`, `jazzcash_sandbox`, `jazzcash_status`, `midtrans_client_key`, `midtrans_server_key`, `midtrans_sandbox`, `midtrans_status`, `flutterwave_public_key`, `flutterwave_secret_key`, `flutterwave_sandbox`, `flutterwave_status`, `paytm_merchantmid`, `paytm_merchantkey`, `paytm_merchant_website`, `paytm_industry_type`, `paytm_status`, `toyyibpay_secretkey`, `toyyibpay_categorycode`, `toyyibpay_status`, `payhere_merchant_id`, `payhere_merchant_secret`, `payhere_status`, `nepalste_public_key`, `nepalste_secret_key`, `nepalste_status`, `branch_id`, `created_at`, `updated_at`) VALUES (1, NULL, NULL, NULL, NULL, NULL, 0, NULL, '', NULL, 0, NULL, NULL, NULL, 0, '', 0, '', '', 0, 0, '111', '111', 1, 1, '', '', '', 0, 0, '', '', 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, 0, NULL, NULL, 0, NULL, NULL, 0, NULL, NULL, 0, 1, '2025-01-02 00:20:25', NULL);


#
# TABLE STRUCTURE FOR: payment_salary_stipend
#

DROP TABLE IF EXISTS `payment_salary_stipend`;

CREATE TABLE `payment_salary_stipend` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payslip_id` int(11) NOT NULL,
  `name` longtext NOT NULL,
  `amount` int(11) NOT NULL,
  `type` varchar(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: payment_types
#

DROP TABLE IF EXISTS `payment_types`;

CREATE TABLE `payment_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `branch_id` int(11) NOT NULL DEFAULT 0,
  `timestamp` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `payment_types` (`id`, `name`, `branch_id`, `timestamp`) VALUES (1, 'Cash', 0, '2019-07-27 18:12:21');
INSERT INTO `payment_types` (`id`, `name`, `branch_id`, `timestamp`) VALUES (2, 'Card', 0, '2019-07-27 18:12:31');
INSERT INTO `payment_types` (`id`, `name`, `branch_id`, `timestamp`) VALUES (3, 'Cheque', 0, '2019-12-21 10:07:59');
INSERT INTO `payment_types` (`id`, `name`, `branch_id`, `timestamp`) VALUES (4, 'Bank Transfer', 0, '2019-12-21 10:08:36');
INSERT INTO `payment_types` (`id`, `name`, `branch_id`, `timestamp`) VALUES (5, 'Other', 0, '2019-12-21 10:08:45');
INSERT INTO `payment_types` (`id`, `name`, `branch_id`, `timestamp`) VALUES (6, 'Paypal', 0, '2019-12-21 10:08:45');
INSERT INTO `payment_types` (`id`, `name`, `branch_id`, `timestamp`) VALUES (7, 'Stripe', 0, '2019-12-21 10:08:45');
INSERT INTO `payment_types` (`id`, `name`, `branch_id`, `timestamp`) VALUES (8, 'PayUmoney', 0, '2019-12-21 10:08:45');
INSERT INTO `payment_types` (`id`, `name`, `branch_id`, `timestamp`) VALUES (9, 'Paystack', 0, '2019-12-21 10:08:45');
INSERT INTO `payment_types` (`id`, `name`, `branch_id`, `timestamp`) VALUES (10, 'Razorpay', 0, '2019-12-21 10:08:45');
INSERT INTO `payment_types` (`id`, `name`, `branch_id`, `timestamp`) VALUES (11, 'SSLcommerz', 0, '2022-05-21 10:08:45');
INSERT INTO `payment_types` (`id`, `name`, `branch_id`, `timestamp`) VALUES (12, 'Jazzcash', 0, '2022-05-21 10:08:45');
INSERT INTO `payment_types` (`id`, `name`, `branch_id`, `timestamp`) VALUES (13, 'Midtrans', 0, '2022-05-21 10:08:45');
INSERT INTO `payment_types` (`id`, `name`, `branch_id`, `timestamp`) VALUES (14, 'Flutter Wave', 0, '2022-05-15 10:08:45');
INSERT INTO `payment_types` (`id`, `name`, `branch_id`, `timestamp`) VALUES (15, 'Offline Payments', 0, '2022-05-15 10:08:45');
INSERT INTO `payment_types` (`id`, `name`, `branch_id`, `timestamp`) VALUES (16, 'Paytm', 0, '2023-05-12 12:08:45');
INSERT INTO `payment_types` (`id`, `name`, `branch_id`, `timestamp`) VALUES (17, 'toyyibPay', 0, '2023-05-12 12:08:45');
INSERT INTO `payment_types` (`id`, `name`, `branch_id`, `timestamp`) VALUES (18, 'Payhere', 0, '2023-05-12 12:08:45');
INSERT INTO `payment_types` (`id`, `name`, `branch_id`, `timestamp`) VALUES (19, 'Nepalste', 0, '2023-05-12 12:08:45');


#
# TABLE STRUCTURE FOR: payslip
#

DROP TABLE IF EXISTS `payslip`;

CREATE TABLE `payslip` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) NOT NULL,
  `month` varchar(200) DEFAULT NULL,
  `year` varchar(20) NOT NULL,
  `basic_salary` decimal(18,2) NOT NULL,
  `total_allowance` decimal(18,2) NOT NULL,
  `total_deduction` decimal(18,2) NOT NULL,
  `net_salary` decimal(18,2) NOT NULL,
  `bill_no` varchar(25) NOT NULL,
  `remarks` text NOT NULL,
  `pay_via` tinyint(1) NOT NULL,
  `hash` varchar(200) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `paid_by` varchar(200) DEFAULT NULL,
  `branch_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `payslip` (`id`, `staff_id`, `month`, `year`, `basic_salary`, `total_allowance`, `total_deduction`, `net_salary`, `bill_no`, `remarks`, `pay_via`, `hash`, `created_at`, `paid_by`, `branch_id`) VALUES (1, 3, '11', '2024', '5000.00', '0.00', '0.00', '5000.00', '0001', '', 1, '4ab94c5b133f869410d99e4884fba0cb', '2024-12-27 17:28:14', '2', 1);


#
# TABLE STRUCTURE FOR: payslip_details
#

DROP TABLE IF EXISTS `payslip_details`;

CREATE TABLE `payslip_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payslip_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `amount` decimal(18,2) NOT NULL,
  `type` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: permission
#

DROP TABLE IF EXISTS `permission`;

CREATE TABLE `permission` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `module_id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `prefix` varchar(100) NOT NULL,
  `show_view` tinyint(1) DEFAULT 1,
  `show_add` tinyint(1) DEFAULT 1,
  `show_edit` tinyint(1) DEFAULT 1,
  `show_delete` tinyint(1) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=175 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (1, 2, 'Student', 'student', 1, 1, 1, 1, '2020-01-22 17:45:47');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (2, 2, 'Multiple Import', 'multiple_import', 0, 1, 0, 0, '2020-01-22 17:45:47');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (3, 2, 'Student Category', 'student_category', 1, 1, 1, 1, '2020-01-22 17:45:47');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (4, 2, 'Student Id Card', 'student_id_card', 1, 0, 0, 0, '2020-01-22 17:45:47');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (5, 2, 'Disable Authentication', 'student_disable_authentication', 1, 1, 0, 0, '2020-01-22 17:45:47');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (6, 4, 'Employee', 'employee', 1, 1, 1, 1, '2020-01-22 17:55:19');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (7, 3, 'Parent', 'parent', 1, 1, 1, 1, '2020-01-22 19:24:05');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (8, 3, 'Disable Authentication', 'parent_disable_authentication', 1, 1, 0, 0, '2020-01-22 20:22:21');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (9, 4, 'Department', 'department', 1, 1, 1, 1, '2020-01-22 23:41:39');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (10, 4, 'Designation', 'designation', 1, 1, 1, 1, '2020-01-22 23:41:39');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (11, 4, 'Disable Authentication', 'employee_disable_authentication', 1, 1, 0, 0, '2020-01-22 23:41:39');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (12, 5, 'Salary Template', 'salary_template', 1, 1, 1, 1, '2020-01-23 11:13:57');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (13, 5, 'Salary Assign', 'salary_assign', 1, 1, 0, 0, '2020-01-23 11:14:05');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (14, 5, 'Salary Payment', 'salary_payment', 1, 1, 0, 0, '2020-01-24 12:45:40');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (15, 5, 'Salary Summary Report', 'salary_summary_report', 1, 0, 0, 0, '2020-03-14 23:09:17');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (16, 5, 'Advance Salary', 'advance_salary', 1, 1, 1, 1, '2020-01-29 00:23:39');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (17, 5, 'Advance Salary Manage', 'advance_salary_manage', 1, 1, 1, 1, '2020-01-25 10:57:12');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (18, 5, 'Advance Salary Request', 'advance_salary_request', 1, 1, 0, 1, '2020-01-28 23:49:58');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (19, 5, 'Leave Category', 'leave_category', 1, 1, 1, 1, '2020-01-29 08:46:23');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (20, 5, 'Leave Request', 'leave_request', 1, 1, 1, 1, '2020-01-30 18:06:33');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (21, 5, 'Leave Manage', 'leave_manage', 1, 1, 1, 1, '2020-01-29 13:27:15');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (22, 5, 'Award', 'award', 1, 1, 1, 1, '2020-02-01 00:49:11');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (23, 6, 'Classes', 'classes', 1, 1, 1, 1, '2020-02-02 00:10:00');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (24, 6, 'Section', 'section', 1, 1, 1, 1, '2020-02-02 03:06:44');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (25, 6, 'Assign Class Teacher', 'assign_class_teacher', 1, 1, 1, 1, '2020-02-02 13:09:22');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (26, 6, 'Subject', 'subject', 1, 1, 1, 1, '2020-02-03 10:32:39');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (27, 6, 'Subject Class Assign ', 'subject_class_assign', 1, 1, 1, 1, '2020-02-03 23:43:19');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (28, 6, 'Subject Teacher Assign', 'subject_teacher_assign', 1, 1, 0, 1, '2020-02-04 01:05:11');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (29, 6, 'Class Timetable', 'class_timetable', 1, 1, 1, 1, '2020-02-04 11:50:37');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (30, 2, 'Student Promotion', 'student_promotion', 1, 1, 0, 0, '2020-02-06 00:20:30');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (31, 8, 'Attachments', 'attachments', 1, 1, 1, 1, '2020-02-06 23:59:43');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (32, 7, 'Homework', 'homework', 1, 1, 1, 1, '2020-02-07 11:40:08');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (33, 8, 'Attachment Type', 'attachment_type', 1, 1, 1, 1, '2020-02-07 13:16:28');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (34, 9, 'Exam', 'exam', 1, 1, 1, 1, '2020-02-07 15:59:29');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (35, 9, 'Exam Term', 'exam_term', 1, 1, 1, 1, '2020-02-07 18:09:28');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (36, 9, 'Exam Hall', 'exam_hall', 1, 1, 1, 1, '2020-02-07 20:31:04');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (37, 9, 'Exam Timetable', 'exam_timetable', 1, 1, 0, 1, '2020-02-08 23:04:31');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (38, 9, 'Exam Mark', 'exam_mark', 1, 1, 1, 1, '2020-02-10 18:53:41');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (39, 9, 'Exam Grade', 'exam_grade', 1, 1, 1, 1, '2020-02-10 23:29:16');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (40, 10, 'Hostel', 'hostel', 1, 1, 1, 1, '2020-02-11 10:41:36');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (41, 10, 'Hostel Category', 'hostel_category', 1, 1, 1, 1, '2020-02-11 13:52:31');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (42, 10, 'Hostel Room', 'hostel_room', 1, 1, 1, 1, '2020-02-11 17:50:09');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (43, 10, 'Hostel Allocation', 'hostel_allocation', 1, 0, 0, 1, '2020-02-11 19:06:15');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (44, 11, 'Transport Route', 'transport_route', 1, 1, 1, 1, '2020-02-12 11:26:19');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (45, 11, 'Transport Vehicle', 'transport_vehicle', 1, 1, 1, 1, '2020-02-12 11:57:30');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (46, 11, 'Transport Stoppage', 'transport_stoppage', 1, 1, 1, 1, '2020-02-12 12:49:20');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (47, 11, 'Transport Assign', 'transport_assign', 1, 1, 1, 1, '2020-02-12 15:55:21');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (48, 11, 'Transport Allocation', 'transport_allocation', 1, 0, 0, 1, '2020-02-13 01:33:05');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (49, 12, 'Student Attendance', 'student_attendance', 0, 1, 0, 0, '2020-02-13 11:25:53');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (50, 12, 'Employee Attendance', 'employee_attendance', 0, 1, 0, 0, '2020-02-13 16:04:16');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (51, 12, 'Exam Attendance', 'exam_attendance', 0, 1, 0, 0, '2020-02-13 17:08:14');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (52, 12, 'Student Attendance Report', 'student_attendance_report', 1, 0, 0, 0, '2020-02-14 01:20:56');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (53, 12, 'Employee Attendance Report', 'employee_attendance_report', 1, 0, 0, 0, '2020-02-14 12:08:53');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (54, 12, 'Exam Attendance Report', 'exam_attendance_report', 1, 0, 0, 0, '2020-02-14 12:21:40');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (55, 13, 'Book', 'book', 1, 1, 1, 1, '2020-02-14 12:40:42');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (56, 13, 'Book Category', 'book_category', 1, 1, 1, 1, '2020-02-15 10:11:41');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (57, 13, 'Book Manage', 'book_manage', 1, 1, 0, 1, '2020-02-15 17:13:24');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (58, 13, 'Book Request', 'book_request', 1, 1, 0, 1, '2020-02-17 12:45:19');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (59, 14, 'Event', 'event', 1, 1, 1, 1, '2020-02-18 00:02:15');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (60, 14, 'Event Type', 'event_type', 1, 1, 1, 1, '2020-02-18 10:40:33');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (61, 15, 'Sendsmsmail', 'sendsmsmail', 1, 1, 0, 1, '2020-02-22 13:19:57');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (62, 15, 'Sendsmsmail Template', 'sendsmsmail_template', 1, 1, 1, 1, '2020-02-22 16:14:57');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (63, 17, 'Account', 'account', 1, 1, 1, 1, '2020-02-25 15:34:43');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (64, 17, 'Deposit', 'deposit', 1, 1, 1, 1, '2020-02-25 18:56:11');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (65, 17, 'Expense', 'expense', 1, 1, 1, 1, '2020-02-26 12:35:57');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (66, 17, 'All Transactions', 'all_transactions', 1, 0, 0, 0, '2020-02-26 19:35:05');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (67, 17, 'Voucher Head', 'voucher_head', 1, 1, 1, 1, '2020-02-25 16:50:56');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (68, 17, 'Accounting Reports', 'accounting_reports', 1, 1, 1, 1, '2020-02-25 19:36:24');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (69, 16, 'Fees Type', 'fees_type', 1, 1, 1, 1, '2020-02-27 16:11:03');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (70, 16, 'Fees Group', 'fees_group', 1, 1, 1, 1, '2020-02-26 11:49:09');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (71, 16, 'Fees Fine Setup', 'fees_fine_setup', 1, 1, 1, 1, '2020-03-05 08:59:27');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (72, 16, 'Fees Allocation', 'fees_allocation', 1, 1, 1, 1, '2020-03-01 19:47:43');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (73, 16, 'Collect Fees', 'collect_fees', 0, 1, 0, 0, '2020-03-15 10:23:58');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (74, 16, 'Fees Reminder', 'fees_reminder', 1, 1, 1, 1, '2020-03-15 10:29:58');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (75, 16, 'Due Invoice', 'due_invoice', 1, 0, 0, 0, '2020-03-15 10:33:36');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (76, 16, 'Invoice', 'invoice', 1, 0, 0, 1, '2020-03-15 10:38:06');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (77, 9, 'Mark Distribution', 'mark_distribution', 1, 1, 1, 1, '2020-03-19 19:02:54');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (78, 9, 'Report Card', 'report_card', 1, 0, 0, 0, '2020-03-20 18:20:28');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (79, 9, 'Tabulation Sheet', 'tabulation_sheet', 1, 0, 0, 0, '2020-03-21 13:12:38');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (80, 15, 'Sendsmsmail Reports', 'sendsmsmail_reports', 1, 0, 0, 0, '2020-03-21 23:02:02');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (81, 18, 'Global Settings', 'global_settings', 1, 0, 1, 0, '2020-03-22 11:05:41');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (82, 18, 'Payment Settings', 'payment_settings', 1, 1, 0, 0, '2020-03-22 11:08:57');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (83, 18, 'Sms Settings', 'sms_settings', 1, 1, 1, 1, '2020-03-22 11:08:57');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (84, 18, 'Email Settings', 'email_settings', 1, 1, 1, 1, '2020-03-22 11:10:39');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (85, 18, 'Translations', 'translations', 1, 1, 1, 1, '2020-03-22 11:18:33');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (86, 18, 'Backup', 'backup', 1, 1, 1, 1, '2020-03-22 13:09:33');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (87, 18, 'Backup Restore', 'backup_restore', 0, 1, 0, 0, '2020-03-22 13:09:34');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (88, 7, 'Homework Evaluate', 'homework_evaluate', 1, 1, 0, 0, '2020-03-28 10:20:29');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (89, 7, 'Evaluation Report', 'evaluation_report', 1, 0, 0, 0, '2020-03-28 15:56:04');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (90, 18, 'School Settings', 'school_settings', 1, 0, 1, 0, '2020-03-30 23:36:37');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (91, 1, 'Monthly Income Vs Expense Pie Chart', 'monthly_income_vs_expense_chart', 1, 0, 0, 0, '2020-03-31 12:15:31');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (92, 1, 'Annual Student Fees Summary Chart', 'annual_student_fees_summary_chart', 1, 0, 0, 0, '2020-03-31 12:15:31');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (93, 1, 'Employee Count Widget', 'employee_count_widget', 1, 0, 0, 0, '2020-03-31 12:31:56');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (94, 1, 'Student Count Widget', 'student_count_widget', 1, 0, 0, 0, '2020-03-31 12:31:56');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (95, 1, 'Parent Count Widget', 'parent_count_widget', 1, 0, 0, 0, '2020-03-31 12:31:56');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (96, 1, 'Teacher Count Widget', 'teacher_count_widget', 1, 0, 0, 0, '2020-03-31 12:31:56');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (97, 1, 'Student Quantity Pie Chart', 'student_quantity_pie_chart', 1, 0, 0, 0, '2020-03-31 13:14:07');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (98, 1, 'Weekend Attendance Inspection Chart', 'weekend_attendance_inspection_chart', 1, 0, 0, 0, '2020-03-31 13:14:07');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (99, 1, 'Admission Count Widget', 'admission_count_widget', 1, 0, 0, 0, '2020-03-31 13:22:05');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (100, 1, 'Voucher Count Widget', 'voucher_count_widget', 1, 0, 0, 0, '2020-03-31 13:22:05');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (101, 1, 'Transport Count Widget', 'transport_count_widget', 1, 0, 0, 0, '2020-03-31 13:22:05');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (102, 1, 'Hostel Count Widget', 'hostel_count_widget', 1, 0, 0, 0, '2020-03-31 13:22:05');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (103, 18, 'Accounting Links', 'accounting_links', 1, 0, 1, 0, '2020-03-31 15:46:30');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (104, 16, 'Fees Reports', 'fees_reports', 1, 0, 0, 0, '2020-04-01 21:52:19');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (105, 18, 'Cron Job', 'cron_job', 1, 0, 1, 0, '2020-03-31 15:46:30');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (106, 18, 'Custom Field', 'custom_field', 1, 1, 1, 1, '2020-03-31 15:46:30');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (107, 5, 'Leave Reports', 'leave_reports', 1, 0, 0, 0, '2020-03-31 15:46:30');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (108, 18, 'Live Class Config', 'live_class_config', 1, 0, 1, 0, '2020-03-31 15:46:30');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (109, 19, 'Live Class', 'live_class', 1, 1, 1, 1, '2020-03-31 15:46:30');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (110, 20, 'Certificate Templete', 'certificate_templete', 1, 1, 1, 1, '2020-03-31 15:46:30');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (111, 20, 'Generate Student Certificate', 'generate_student_certificate', 1, 0, 0, 0, '2020-03-31 15:46:30');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (112, 20, 'Generate Employee Certificate', 'generate_employee_certificate', 1, 0, 0, 0, '2020-03-31 15:46:30');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (113, 21, 'ID Card Templete', 'id_card_templete', 1, 1, 1, 1, '2020-03-31 15:46:30');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (114, 21, 'Generate Student ID Card', 'generate_student_idcard', 1, 0, 0, 0, '2020-03-31 15:46:30');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (115, 21, 'Generate Employee ID Card', 'generate_employee_idcard', 1, 0, 0, 0, '2020-03-31 15:46:30');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (116, 21, 'Admit Card Templete', 'admit_card_templete', 1, 1, 1, 1, '2020-03-31 15:46:30');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (117, 21, 'Generate Admit card', 'generate_admit_card', 1, 0, 0, 0, '2020-03-31 15:46:30');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (118, 22, 'Frontend Setting', 'frontend_setting', 1, 1, 0, 0, '2019-09-11 09:24:07');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (119, 22, 'Frontend Menu', 'frontend_menu', 1, 1, 1, 1, '2019-09-11 10:03:39');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (120, 22, 'Frontend Section', 'frontend_section', 1, 1, 0, 0, '2019-09-11 10:26:11');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (121, 22, 'Manage Page', 'manage_page', 1, 1, 1, 1, '2019-09-11 11:54:08');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (122, 22, 'Frontend Slider', 'frontend_slider', 1, 1, 1, 1, '2019-09-11 12:12:31');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (123, 22, 'Frontend Features', 'frontend_features', 1, 1, 1, 1, '2019-09-11 12:47:51');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (124, 22, 'Frontend Testimonial', 'frontend_testimonial', 1, 1, 1, 1, '2019-09-11 12:54:30');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (125, 22, 'Frontend Services', 'frontend_services', 1, 1, 1, 1, '2019-09-11 13:01:44');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (126, 22, 'Frontend Faq', 'frontend_faq', 1, 1, 1, 1, '2019-09-11 13:06:16');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (127, 2, 'Online Admission', 'online_admission', 1, 1, 0, 1, '2019-09-11 13:06:16');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (128, 18, 'System Update', 'system_update', 0, 1, 0, 0, '2019-09-11 13:06:16');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (129, 19, 'Live Class Reports', 'live_class_reports', 1, 0, 0, 0, '2020-03-31 15:46:30');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (130, 16, 'Fees Revert', 'fees_revert', 0, 0, 0, 1, '2020-03-31 15:46:30');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (131, 22, 'Frontend Gallery', 'frontend_gallery', 1, 1, 1, 1, '2019-09-11 13:06:16');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (132, 22, 'Frontend Gallery Category', 'frontend_gallery_category', 1, 1, 1, 1, '2019-09-11 13:06:16');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (133, 6, 'Teacher Timetable', 'teacher_timetable', 1, 0, 0, 0, '2021-03-31 15:46:30');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (134, 18, 'Whatsapp Config', 'whatsapp_config', 1, 1, 1, 1, '2021-03-31 15:46:30');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (135, 18, 'System Student Field', 'system_student_field', 1, 0, 1, 0, '2021-03-31 15:46:30');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (136, 23, 'Online Exam', 'online_exam', 1, 1, 1, 1, '2021-03-31 15:46:30');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (137, 23, 'Question Bank', 'question_bank', 1, 1, 1, 1, '2021-03-31 15:46:30');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (138, 23, 'Add Questions', 'add_questions', 0, 1, 0, 0, '2021-03-31 15:46:30');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (139, 23, 'Question Group', 'question_group', 1, 1, 1, 1, '2021-03-31 15:46:30');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (140, 23, 'Exam Result', 'exam_result', 1, 0, 0, 0, '2021-03-31 15:46:30');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (141, 23, 'Position Generate', 'position_generate', 1, 1, 0, 0, '2021-03-31 15:46:30');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (142, 24, 'Postal Record', 'postal_record', 1, 1, 1, 1, '2021-03-31 15:46:30');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (143, 24, 'Call Log', 'call_log', 1, 1, 1, 1, '2021-03-31 15:46:30');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (144, 24, 'Visitor Log', 'visitor_log', 1, 1, 1, 1, '2021-03-31 15:46:30');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (145, 24, 'Complaint', 'complaint', 1, 1, 1, 1, '2021-03-31 15:46:30');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (146, 24, 'Enquiry', 'enquiry', 1, 1, 1, 1, '2021-03-31 15:46:30');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (147, 24, 'Follow Up', 'follow_up', 1, 1, 0, 1, '2021-03-31 15:46:30');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (148, 24, 'Config Reception', 'config_reception', 1, 1, 1, 1, '2021-03-31 15:46:30');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (149, 15, 'Student Birthday Wishes', 'student_birthday_wishes', 1, 0, 0, 0, '2021-03-31 15:46:30');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (150, 15, 'Staff Birthday Wishes', 'staff_birthday_wishes', 1, 0, 0, 0, '2021-03-31 15:46:30');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (151, 1, 'Student Birthday Wishes Widget', 'student_birthday_widget', 1, 0, 0, 0, '2021-03-31 13:22:05');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (152, 1, 'Staff Birthday Wishes Widget', 'staff_birthday_widget', 1, 0, 0, 0, '2021-03-31 13:22:05');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (153, 9, 'Progress Reports', 'progress_reports', 1, 0, 0, 0, '2021-03-21 13:12:38');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (154, 2, 'Disable Reason', 'disable_reason', 1, 1, 1, 1, '2021-03-21 13:12:38');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (155, 16, 'Offline Payments', 'offline_payments', 1, 0, 0, 0, '2023-03-23 13:12:38');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (156, 16, 'Offline Payments Type', 'offline_payments_type', 1, 1, 1, 1, '2023-03-23 13:12:38');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (157, 25, 'Product', 'product', 1, 1, 1, 1, '2023-06-14 01:21:42');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (158, 25, 'Product Category', 'product_category', 1, 1, 1, 1, '2023-06-14 01:21:42');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (159, 25, 'Product Supplier', 'product_supplier', 1, 1, 1, 1, '2023-06-14 01:21:42');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (160, 25, 'Product Unit', 'product_unit', 1, 1, 1, 1, '2023-06-14 01:21:42');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (161, 25, 'Product Purchase', 'product_purchase', 1, 1, 1, 1, '2023-06-14 01:21:42');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (162, 25, 'Purchase Payment', 'purchase_payment', 1, 1, 0, 0, '2023-06-14 01:21:42');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (163, 25, 'Product Store', 'product_store', 1, 1, 1, 1, '2023-06-14 01:21:42');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (164, 25, 'Product Sales', 'product_sales', 1, 1, 0, 1, '2023-06-14 01:21:42');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (165, 25, 'Sales Payment', 'sales_payment', 1, 0, 0, 0, '2023-06-21 13:05:10');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (166, 25, 'Product Issue', 'product_issue', 1, 1, 0, 1, '2023-06-14 01:21:42');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (167, 25, 'Inventory Report', 'inventory_report', 1, 0, 0, 0, '2023-06-27 09:56:45');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (168, 9, 'Generate Position', 'generate_position', 1, 0, 0, 0, '2023-08-10 21:08:29');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (169, 18, 'User Login Log', 'user_login_log', 1, 0, 0, 1, '2024-04-08 15:01:26');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (170, 26, 'Manage Alumni', 'manage_alumni', 1, 1, 1, 1, '2024-04-08 15:01:26');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (171, 26, 'Alumni Events', 'alumni_events', 1, 1, 1, 1, '2024-04-08 15:01:26');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (172, 27, 'Multi Class Student', 'multi_class', 1, 1, 0, 0, '2024-05-02 14:28:04');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (173, 22, 'Frontend News', 'frontend_news', 1, 1, 1, 1, '2024-05-05 14:45:48');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (174, 9, 'Marksheet Template', 'marksheet_template', 1, 1, 1, 1, '2024-05-10 11:59:53');


#
# TABLE STRUCTURE FOR: permission_modules
#

DROP TABLE IF EXISTS `permission_modules`;

CREATE TABLE `permission_modules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `prefix` varchar(50) NOT NULL,
  `system` tinyint(1) NOT NULL,
  `sorted` tinyint(10) NOT NULL,
  `in_module` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `in_module`, `created_at`) VALUES (1, 'Dashboard', 'dashboard', 1, 1, 0, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `in_module`, `created_at`) VALUES (2, 'Student', 'student', 1, 4, 0, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `in_module`, `created_at`) VALUES (3, 'Parents', 'parents', 1, 5, 0, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `in_module`, `created_at`) VALUES (4, 'Employee', 'employee', 1, 6, 0, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `in_module`, `created_at`) VALUES (5, 'Human Resource', 'human_resource', 1, 9, 1, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `in_module`, `created_at`) VALUES (6, 'Academic', 'academic', 1, 10, 0, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `in_module`, `created_at`) VALUES (7, 'Homework', 'homework', 1, 13, 1, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `in_module`, `created_at`) VALUES (8, 'Attachments Book', 'attachments_book', 1, 12, 1, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `in_module`, `created_at`) VALUES (9, 'Exam Master', 'exam_master', 1, 14, 0, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `in_module`, `created_at`) VALUES (10, 'Hostel', 'hostel', 1, 16, 1, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `in_module`, `created_at`) VALUES (11, 'Transport', 'transport', 1, 17, 1, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `in_module`, `created_at`) VALUES (12, 'Attendance', 'attendance', 1, 18, 1, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `in_module`, `created_at`) VALUES (13, 'Library', 'library', 1, 19, 1, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `in_module`, `created_at`) VALUES (14, 'Events', 'events', 1, 20, 1, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `in_module`, `created_at`) VALUES (15, 'Bulk Sms And Email', 'bulk_sms_and_email', 1, 21, 1, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `in_module`, `created_at`) VALUES (16, 'Student Accounting', 'student_accounting', 1, 22, 1, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `in_module`, `created_at`) VALUES (17, 'Office Accounting', 'office_accounting', 1, 23, 1, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `in_module`, `created_at`) VALUES (18, 'Settings', 'settings', 1, 24, 0, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `in_module`, `created_at`) VALUES (19, 'Live Class', 'live_class', 1, 11, 1, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `in_module`, `created_at`) VALUES (20, 'Certificate', 'certificate', 1, 8, 1, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `in_module`, `created_at`) VALUES (21, 'Card Management', 'card_management', 1, 7, 1, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `in_module`, `created_at`) VALUES (22, 'Website', 'website', 1, 2, 1, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `in_module`, `created_at`) VALUES (23, 'Online Exam', 'online_exam', 1, 15, 1, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `in_module`, `created_at`) VALUES (24, 'Reception', 'reception', 1, 3, 1, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `in_module`, `created_at`) VALUES (25, 'Inventory', 'inventory', 1, 3, 1, '2023-06-14 01:16:49');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `in_module`, `created_at`) VALUES (26, 'Alumni', 'alumni', 1, 24, 1, '2024-05-14 01:16:49');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `in_module`, `created_at`) VALUES (27, 'Multi Class', 'multi_class', 1, 25, 1, '2024-05-02 14:32:01');


#
# TABLE STRUCTURE FOR: postal_record
#

DROP TABLE IF EXISTS `postal_record`;

CREATE TABLE `postal_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sender_title` varchar(255) DEFAULT NULL,
  `receiver_title` varchar(255) DEFAULT NULL,
  `reference_no` varchar(255) DEFAULT NULL,
  `address` text NOT NULL,
  `date` date NOT NULL,
  `note` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `file` varchar(250) NOT NULL,
  `confidential` tinyint(1) NOT NULL DEFAULT 0,
  `created_by` int(11) NOT NULL,
  `type` tinyint(1) NOT NULL DEFAULT 1,
  `branch_id` int(11) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: product
#

DROP TABLE IF EXISTS `product`;

CREATE TABLE `product` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `code` varchar(50) NOT NULL,
  `category_id` int(11) NOT NULL,
  `purchase_unit_id` int(11) NOT NULL,
  `sales_unit_id` int(11) NOT NULL,
  `unit_ratio` varchar(20) DEFAULT '1',
  `purchase_price` decimal(18,2) NOT NULL DEFAULT 0.00,
  `sales_price` decimal(18,2) NOT NULL DEFAULT 0.00,
  `available_stock` varchar(11) NOT NULL DEFAULT '0',
  `photo` varchar(100) DEFAULT NULL,
  `remarks` text NOT NULL,
  `branch_id` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `product_rms_1` (`branch_id`),
  CONSTRAINT `product_rms_1` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `product` (`id`, `name`, `code`, `category_id`, `purchase_unit_id`, `sales_unit_id`, `unit_ratio`, `purchase_price`, `sales_price`, `available_stock`, `photo`, `remarks`, `branch_id`, `created_at`, `updated_at`) VALUES (1, 'Tie', 'T0001', 1, 1, 1, '1', '80.00', '150.00', '0', NULL, '', 1, '2024-12-27 11:52:16', '2024-12-27 11:52:16');
INSERT INTO `product` (`id`, `name`, `code`, `category_id`, `purchase_unit_id`, `sales_unit_id`, `unit_ratio`, `purchase_price`, `sales_price`, `available_stock`, `photo`, `remarks`, `branch_id`, `created_at`, `updated_at`) VALUES (2, 'ID CARD', '0002', 1, 1, 1, '1', '70.00', '100.00', '0', NULL, '', 1, '2024-12-27 11:54:19', '2024-12-27 11:54:19');


#
# TABLE STRUCTURE FOR: product_category
#

DROP TABLE IF EXISTS `product_category`;

CREATE TABLE `product_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `branch_id` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_category_rms_1` (`branch_id`),
  CONSTRAINT `product_category_rms_1` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `product_category` (`id`, `name`, `branch_id`, `created_at`, `updated_at`) VALUES (1, 'Stationary', 1, '2024-12-27 11:50:46', NULL);
INSERT INTO `product_category` (`id`, `name`, `branch_id`, `created_at`, `updated_at`) VALUES (2, 'Clothe', 1, '2024-12-27 11:53:39', NULL);


#
# TABLE STRUCTURE FOR: product_issues
#

DROP TABLE IF EXISTS `product_issues`;

CREATE TABLE `product_issues` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `date_of_issue` date NOT NULL,
  `due_date` date NOT NULL,
  `return_date` date DEFAULT NULL,
  `remarks` text NOT NULL,
  `prepared_by` int(11) DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 0,
  `branch_id` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `product_issues_rms_1` (`branch_id`),
  CONSTRAINT `product_issues_rms_1` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: product_issues_details
#

DROP TABLE IF EXISTS `product_issues_details`;

CREATE TABLE `product_issues_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `issues_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `quantity` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `product_issues_details_rms_1` (`product_id`),
  CONSTRAINT `product_issues_details_rms_1` FOREIGN KEY (`product_id`) REFERENCES `product` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: product_store
#

DROP TABLE IF EXISTS `product_store`;

CREATE TABLE `product_store` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `code` varchar(255) NOT NULL,
  `mobileno` varchar(255) DEFAULT NULL,
  `address` varchar(300) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `branch_id` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `product_store` (`id`, `name`, `code`, `mobileno`, `address`, `description`, `branch_id`, `created_at`) VALUES (1, 'General Store', '01', '0', '', '', 1, '2024-12-27 11:54:53');


#
# TABLE STRUCTURE FOR: product_supplier
#

DROP TABLE IF EXISTS `product_supplier`;

CREATE TABLE `product_supplier` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `address` text NOT NULL,
  `mobileno` varchar(30) NOT NULL,
  `email` varchar(100) NOT NULL,
  `company_name` varchar(200) NOT NULL,
  `product_list` mediumtext NOT NULL,
  `branch_id` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_supplier_rms_1` (`branch_id`),
  CONSTRAINT `product_supplier_rms_1` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: product_unit
#

DROP TABLE IF EXISTS `product_unit`;

CREATE TABLE `product_unit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `branch_id` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `product_unit` (`id`, `name`, `branch_id`, `created_at`, `updated_at`) VALUES (1, 'Pcs', 1, '2024-12-27 11:49:26', NULL);
INSERT INTO `product_unit` (`id`, `name`, `branch_id`, `created_at`, `updated_at`) VALUES (2, 'Rim', 1, '2024-12-27 11:49:32', NULL);
INSERT INTO `product_unit` (`id`, `name`, `branch_id`, `created_at`, `updated_at`) VALUES (3, 'Dozen', 1, '2024-12-27 11:49:38', NULL);
INSERT INTO `product_unit` (`id`, `name`, `branch_id`, `created_at`, `updated_at`) VALUES (4, 'Kg', 1, '2024-12-27 11:49:50', NULL);


#
# TABLE STRUCTURE FOR: promotion_history
#

DROP TABLE IF EXISTS `promotion_history`;

CREATE TABLE `promotion_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `pre_class` int(11) NOT NULL,
  `pre_section` int(11) NOT NULL,
  `pre_session` int(11) NOT NULL,
  `pro_class` int(11) NOT NULL,
  `pro_section` int(11) NOT NULL,
  `pro_session` int(11) NOT NULL,
  `prev_due` float NOT NULL DEFAULT 0,
  `is_leave` tinyint(4) NOT NULL DEFAULT 0,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `promotion_history_rms_1` (`student_id`),
  CONSTRAINT `promotion_history_rms_1` FOREIGN KEY (`student_id`) REFERENCES `student` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: purchase_bill
#

DROP TABLE IF EXISTS `purchase_bill`;

CREATE TABLE `purchase_bill` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bill_no` varchar(200) NOT NULL,
  `supplier_id` int(11) NOT NULL,
  `store_id` int(11) NOT NULL,
  `remarks` text NOT NULL,
  `total` decimal(18,2) NOT NULL DEFAULT 0.00,
  `discount` decimal(18,2) NOT NULL DEFAULT 0.00,
  `paid` decimal(18,2) NOT NULL DEFAULT 0.00,
  `due` decimal(18,2) NOT NULL DEFAULT 0.00,
  `payment_status` int(11) NOT NULL,
  `purchase_status` int(11) NOT NULL,
  `date` date DEFAULT NULL,
  `prepared_by` int(11) DEFAULT NULL,
  `modifier_id` int(11) DEFAULT NULL,
  `branch_id` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `purchase_bill_rms_1` (`branch_id`),
  CONSTRAINT `purchase_bill_rms_1` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: purchase_bill_details
#

DROP TABLE IF EXISTS `purchase_bill_details`;

CREATE TABLE `purchase_bill_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `purchase_bill_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `unit_price` decimal(18,2) NOT NULL DEFAULT 0.00,
  `quantity` varchar(20) NOT NULL,
  `discount` decimal(18,2) NOT NULL DEFAULT 0.00,
  `sub_total` decimal(18,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`),
  KEY `purchase_bill_details_rms_1` (`product_id`),
  CONSTRAINT `purchase_bill_details_rms_1` FOREIGN KEY (`product_id`) REFERENCES `product` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: purchase_payment_history
#

DROP TABLE IF EXISTS `purchase_payment_history`;

CREATE TABLE `purchase_payment_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `purchase_bill_id` varchar(11) NOT NULL,
  `payment_by` int(11) DEFAULT NULL,
  `amount` decimal(18,2) NOT NULL DEFAULT 0.00,
  `pay_via` varchar(25) NOT NULL,
  `remarks` text NOT NULL,
  `attach_orig_name` varchar(255) DEFAULT NULL,
  `attach_file_name` varchar(255) DEFAULT NULL,
  `paid_on` date DEFAULT NULL,
  `coll_type` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: question_group
#

DROP TABLE IF EXISTS `question_group`;

CREATE TABLE `question_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` longtext NOT NULL,
  `branch_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: questions
#

DROP TABLE IF EXISTS `questions`;

CREATE TABLE `questions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) NOT NULL,
  `level` tinyint(1) NOT NULL,
  `class_id` int(11) NOT NULL,
  `section_id` int(11) DEFAULT 0,
  `subject_id` int(11) NOT NULL DEFAULT 0,
  `group_id` int(11) NOT NULL,
  `question` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `opt_1` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `opt_2` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `opt_3` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `opt_4` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `answer` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `mark` float(10,2) NOT NULL DEFAULT 0.00,
  `branch_id` int(11) NOT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: questions_manage
#

DROP TABLE IF EXISTS `questions_manage`;

CREATE TABLE `questions_manage` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `question_id` int(11) DEFAULT NULL,
  `onlineexam_id` int(11) DEFAULT NULL,
  `marks` float(10,2) NOT NULL DEFAULT 0.00,
  `neg_marks` float(10,2) DEFAULT 0.00,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `onlineexam_id` (`onlineexam_id`),
  KEY `question_id` (`question_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: reset_password
#

DROP TABLE IF EXISTS `reset_password`;

CREATE TABLE `reset_password` (
  `key` longtext NOT NULL,
  `username` varchar(100) NOT NULL,
  `login_credential_id` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `reset_password` (`key`, `username`, `login_credential_id`, `created_at`) VALUES ('fcc5d87442921cee9d81bc83d4d028632f8dd6902478ad1a67d28693854c2e6c9c8b25017abff805ea643f78c8103e51832738c71d6e1d18c41fc0d5cf664843', 'info@elitedesign.com.bd', '1', '2025-01-10 16:15:36');


#
# TABLE STRUCTURE FOR: rm_sessions
#

DROP TABLE IF EXISTS `rm_sessions`;

CREATE TABLE `rm_sessions` (
  `id` varchar(40) NOT NULL,
  `ip_address` varchar(45) NOT NULL,
  `timestamp` int(10) unsigned NOT NULL DEFAULT 0,
  `data` blob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ci_sessions_timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('00gsaftfk21r8rot71avsvgjibbu5p7u', '216.244.66.199', 1736559244, '__ci_last_regenerate|i:1736559244;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('097trb2iloehp0ft1pamuf217v17h6qs', '205.169.39.12', 1736591318, '__ci_last_regenerate|i:1736591318;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0dos080mtt53hv9e4inf4nrgls2ohhe0', '85.208.96.206', 1736592104, '__ci_last_regenerate|i:1736592104;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0gg2d250vnm7bq8bli7bosaev59mk9b0', '185.191.171.12', 1736568982, '__ci_last_regenerate|i:1736568982;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0h8qvhte2satg400k7h1u8aa7shlacl4', '103.146.37.2', 1736604277, '__ci_last_regenerate|i:1736604277;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0ji6nvugos9i5ej3lrujsensg6cdioip', '85.208.96.202', 1736581676, '__ci_last_regenerate|i:1736581676;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0lokiqkd7g2de8hm5issgp9od6i564m6', '103.23.204.60', 1736607266, '__ci_last_regenerate|i:1736607265;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0qjob96tmhv1qqrg47n9cighp19raebl', '44.244.70.193', 1736578153, '__ci_last_regenerate|i:1736578151;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1egt0jndmtrq7evjq20e33acr7vqt2sc', '85.208.96.208', 1736579003, '__ci_last_regenerate|i:1736579003;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1j4fm9g3nskgstol2ngp4u34tovlikf4', '85.208.96.204', 1736565353, '__ci_last_regenerate|i:1736565353;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1n9kgvqnjmqnc5a3so4e2r7vccu0c559', '185.191.171.19', 1736586069, '__ci_last_regenerate|i:1736586069;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1p7pslibmthpdfchb721c6j3btb2ajk9', '185.191.171.14', 1736564010, '__ci_last_regenerate|i:1736564010;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1q4q5b49eh5fmbqu2sp6v5tbaq3esm6d', '85.208.96.208', 1736583209, '__ci_last_regenerate|i:1736583209;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2au5kn6539lpnq8qs5ibj5fivmq9tb7t', '85.208.96.209', 1736581915, '__ci_last_regenerate|i:1736581915;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2fg09klf8lniakg0i492ua1hdf14tebd', '185.191.171.12', 1736588727, '__ci_last_regenerate|i:1736588727;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2ktgjbitgddijski87o9146aeveignav', '185.191.171.2', 1736568979, '__ci_last_regenerate|i:1736568979;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2nk2inp6tjukb6ludktjn891aohob0l9', '216.244.66.199', 1736579979, '__ci_last_regenerate|i:1736579979;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2u2hm59ga8prdk5a15bnh04s24mo2n3k', '182.48.82.104', 1736594461, '__ci_last_regenerate|i:1736594461;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2vip2f6l6t5vs75eiq67rjm90moco15s', '34.248.137.227', 1736574708, '__ci_last_regenerate|i:1736574689;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('32bv7m4nrf52cr36jddglg946qi4v7j2', '47.128.112.57', 1736557712, '__ci_last_regenerate|i:1736557712;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('33kl8gqq5oor6t044dgdkmbnco403qsl', '103.131.145.159', 1736569904, '__ci_last_regenerate|i:1736569904;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('361pqsdikhk1m3rtv9bhi2p20atn4ssm', '85.208.96.211', 1736580707, '__ci_last_regenerate|i:1736580707;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('39loj5u8k70dhbgnubtglaedqqn32hfb', '185.191.171.1', 1736566857, '__ci_last_regenerate|i:1736566857;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3a5khtopgc1bkhp5tt9595sl05qsrj0u', '185.191.171.16', 1736568491, '__ci_last_regenerate|i:1736568491;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3blt4tkjhea5d6fq0t6uv9p2cefdrigc', '173.252.107.14', 1736591098, '__ci_last_regenerate|i:1736591098;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3c0g73h6vlb60b2emes2jfam5bccn5sd', '157.55.39.14', 1736586829, '__ci_last_regenerate|i:1736586829;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3fa12oe0ervt2q5dpu7her13akjoi475', '185.191.171.5', 1736592525, '__ci_last_regenerate|i:1736592525;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3ga60nkcir60q3n14etv6gpdk7oofl72', '185.191.171.3', 1736586969, '__ci_last_regenerate|i:1736586969;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3h5emnbd5olu6aoicn3lgcm1oje3igmr', '66.249.66.32', 1736584978, '__ci_last_regenerate|i:1736584978;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3jut04a4jci7h71t83m418959o972as3', '85.208.96.201', 1736587484, '__ci_last_regenerate|i:1736587484;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3nbp09kh5cbr86mnvmlgp0mkjhtur6rg', '85.208.96.211', 1736560672, '__ci_last_regenerate|i:1736560672;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3o5cumrakbm2sijc9gos7jit7ip9hdia', '185.191.171.16', 1736583935, '__ci_last_regenerate|i:1736583935;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3ou640tbqoa96jnbhs0h69g6mbe3rnll', '103.197.204.173', 1736597818, '__ci_last_regenerate|i:1736597818;name|s:12:\"Elite Design\";logger_photo|s:11:\"defualt.png\";loggedin_branch|N;loggedin_id|s:1:\"1\";loggedin_userid|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_type|s:5:\"staff\";set_lang|s:7:\"english\";is_rtl|b:0;set_session_id|s:1:\"6\";loggedin|b:1;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3qtfdi962vjgjgrupjeoir8fv7pcuq7o', '103.135.88.211', 1736559900, '__ci_last_regenerate|i:1736559900;name|s:12:\"Elite Design\";logger_photo|s:11:\"defualt.png\";loggedin_branch|N;loggedin_id|s:1:\"1\";loggedin_userid|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_type|s:5:\"staff\";set_lang|s:7:\"english\";is_rtl|b:0;set_session_id|s:1:\"6\";loggedin|b:1;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3sur0vge98mi0t98tli9haedmi8mu9bl', '85.208.96.202', 1736571207, '__ci_last_regenerate|i:1736571207;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4516k4o95onadq5k6s1t8gsggn249sf2', '185.191.171.12', 1736567026, '__ci_last_regenerate|i:1736567026;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('480cuqcf519h1e0lpeuadj59j5fdjr1u', '44.244.70.193', 1736578147, '__ci_last_regenerate|i:1736578145;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4aqca3dibimg0rn7q79heiluv63bhdgs', '185.191.171.3', 1736582817, '__ci_last_regenerate|i:1736582817;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4pf9cenrrklgk6i48jqr3qnl07cl7ide', '185.191.171.5', 1736583347, '__ci_last_regenerate|i:1736583347;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4pgmt5p8ahtvnnrcgn6i9csknku84clr', '103.51.52.4', 1736611766, '__ci_last_regenerate|i:1736611766;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4rpo8aug1l6dh65f3sr5u26danp13l8v', '85.208.96.210', 1736569367, '__ci_last_regenerate|i:1736569367;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('55h394ef1ddr39ig67u873fe0bsn6csf', '27.147.206.142', 1736599383, '__ci_last_regenerate|i:1736599383;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('59bk809lhjnrg1bu3vpcgkmpb3t1u4o0', '85.208.96.211', 1736555085, '__ci_last_regenerate|i:1736555085;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5e969fjvro1us8f4hkgas6pcrrc9o68v', '85.208.96.202', 1736581305, '__ci_last_regenerate|i:1736581305;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5jbdmgh1eimci5u97fmj2me5j9h3u3rs', '35.90.228.31', 1736578197, '__ci_last_regenerate|i:1736578195;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5p8luv6t0780ba9m3g8prg70e8cr11au', '185.191.171.8', 1736592597, '__ci_last_regenerate|i:1736592597;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5srhtb7gfgq6vdiu952ff9eke2f7964r', '185.191.171.3', 1736581214, '__ci_last_regenerate|i:1736581214;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5urgaf3k9jivc6olibl58ld4iol661db', '103.197.204.173', 1736597946, '__ci_last_regenerate|i:1736597920;name|s:12:\"Elite Design\";logger_photo|s:11:\"defualt.png\";loggedin_branch|N;loggedin_id|s:1:\"1\";loggedin_userid|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_type|s:5:\"staff\";set_lang|s:7:\"english\";is_rtl|b:0;set_session_id|s:1:\"6\";loggedin|b:1;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5vvse8uqusng8pokl6fa8ecpmjbh9big', '85.208.96.195', 1736592105, '__ci_last_regenerate|i:1736592105;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('617gv86f6657ifcb6vqnrqm1oupju3us', '85.208.96.212', 1736580695, '__ci_last_regenerate|i:1736580695;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6gb1hchvrja6mb7pau60e0v11tbifd87', '85.208.96.205', 1736576309, '__ci_last_regenerate|i:1736576309;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6i6docvll1hqf1u09k1vab43gcg360vn', '216.244.66.199', 1736568725, '__ci_last_regenerate|i:1736568725;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6lmmipkqeoc286ma57mcdrdur6j7ijtj', '185.191.171.12', 1736561940, '__ci_last_regenerate|i:1736561940;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6o0ue08higepbp57pppq682sc5sqvm2i', '185.191.171.7', 1736557206, '__ci_last_regenerate|i:1736557206;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6pmopphfu6n8phvl4pck7fpfpemug8jp', '185.191.171.5', 1736552729, '__ci_last_regenerate|i:1736552729;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6rsb7fa4bp98codbvforqeo093lndfff', '185.191.171.4', 1736589787, '__ci_last_regenerate|i:1736589787;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('70ncspqsef4qv17vhl86oph1cip6ov50', '185.191.171.8', 1736559171, '__ci_last_regenerate|i:1736559171;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7aa9f57blvnobj4949vmo5fq5campfpp', '185.191.171.3', 1736571475, '__ci_last_regenerate|i:1736571475;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7ecgeh517i9b1rtpn96cakjem8ssobmd', '185.191.171.8', 1736565817, '__ci_last_regenerate|i:1736565817;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7g0aomil44to4m3p3flbq3d81md2dns6', '85.208.96.200', 1736568573, '__ci_last_regenerate|i:1736568573;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7o5konh0tue72kd57q0omfldbnc1njmf', '85.208.96.208', 1736583936, '__ci_last_regenerate|i:1736583936;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7tuocrkonu0lal3u37769jsg775ps9f1', '173.252.79.1', 1736614904, '__ci_last_regenerate|i:1736614904;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7ukhajkdf7hci0rrpsm6o7c8tld8pqn0', '85.208.96.207', 1736570275, '__ci_last_regenerate|i:1736570275;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('82th7ff46bd2tcu25m3jjs156a45i6j3', '85.208.96.210', 1736566818, '__ci_last_regenerate|i:1736566818;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('84p5c5t9ka51flhq8a3haalrsrhd3ms3', '85.208.96.210', 1736582243, '__ci_last_regenerate|i:1736582243;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('87hu0kr4q4ho9rduir00g0qom06qgbk4', '58.145.184.240', 1736576832, '__ci_last_regenerate|i:1736576832;name|s:12:\"Elite Design\";logger_photo|s:11:\"defualt.png\";loggedin_branch|N;loggedin_id|s:1:\"1\";loggedin_userid|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_type|s:5:\"staff\";set_lang|s:7:\"english\";is_rtl|b:0;set_session_id|s:1:\"6\";loggedin|b:1;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8ail8d3imv0m28lhtpsu9pvo415ovgsu', '216.244.66.199', 1736607813, '__ci_last_regenerate|i:1736607813;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8i45eur9gdanj6dgo0er5im26vmb8eci', '85.208.96.206', 1736556619, '__ci_last_regenerate|i:1736556619;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8pudfnip89bfdlpljav9kpr2u8uu8vll', '85.208.96.212', 1736565477, '__ci_last_regenerate|i:1736565477;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8qcmoqh70mmkej4dgaiqm13j093fbo2d', '85.208.96.202', 1736570125, '__ci_last_regenerate|i:1736570125;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8u2ucimqbopp0el5v7s3u91c5nspel4a', '103.51.52.4', 1736610782, '__ci_last_regenerate|i:1736610782;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8uitr3vec9e9dbm1qspsb7k88o3b49n0', '85.208.96.193', 1736590541, '__ci_last_regenerate|i:1736590541;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8ut1paa7sp9ur3rqmp6h4b142rimnjln', '58.145.184.240', 1736579303, '__ci_last_regenerate|i:1736579303;name|s:12:\"Elite Design\";logger_photo|s:11:\"defualt.png\";loggedin_branch|N;loggedin_id|s:1:\"1\";loggedin_userid|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_type|s:5:\"staff\";set_lang|s:7:\"english\";is_rtl|b:0;set_session_id|s:1:\"6\";loggedin|b:1;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('91mnblfn6c2neseac2vd5icl4elqn5vj', '185.191.171.19', 1736595337, '__ci_last_regenerate|i:1736595337;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('95si5seujh9b739bgtn21uv5kvhip5dk', '103.7.121.125', 1736578450, '__ci_last_regenerate|i:1736578450;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9fc2f8dea3lvsb50lehs409dn8dbbcd0', '85.208.96.200', 1736554028, '__ci_last_regenerate|i:1736554028;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9fm4ucnnippg90cp6urveiiv77bquvkk', '103.51.52.4', 1736611766, '__ci_last_regenerate|i:1736611766;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9l7uofojp7bqq7sum4eph3d18fgm04s7', '185.191.171.15', 1736596056, '__ci_last_regenerate|i:1736596056;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9nsustdp6lp900ckssv22uv0iql8hl64', '103.23.204.60', 1736606986, '__ci_last_regenerate|i:1736606981;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9rifmgu5h3325eir6hfkke193ka5ralq', '103.138.250.202', 1736615408, '__ci_last_regenerate|i:1736615292;name|s:12:\"Elite Design\";logger_photo|s:11:\"defualt.png\";loggedin_branch|N;loggedin_id|s:1:\"1\";loggedin_userid|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_type|s:5:\"staff\";set_lang|s:7:\"english\";is_rtl|b:0;set_session_id|s:1:\"6\";loggedin|b:1;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a1825kpqsnofbu82q41u0imrgqh9h83e', '103.51.52.4', 1736594755, '__ci_last_regenerate|i:1736594755;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a6pp9qf5rq7fmf9q85mi14u0ailt73eg', '103.23.204.60', 1736602213, '__ci_last_regenerate|i:1736602213;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a8hg6od4putn0gr7gmr3q3el6lnkk16s', '85.208.96.211', 1736564837, '__ci_last_regenerate|i:1736564837;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('abnktvadkgs1vaf2ls75esnp5l2fvbs7', '185.191.171.7', 1736568511, '__ci_last_regenerate|i:1736568511;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('acnslt8igtvqlmd8u8rfi7i88i7b2tak', '85.208.96.194', 1736592783, '__ci_last_regenerate|i:1736592783;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('afdg7fumemt67528c85pu2da607tmte2', '85.208.96.211', 1736561469, '__ci_last_regenerate|i:1736561469;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ahlnksch7dgmoonugduvkva2opopmql8', '216.244.66.199', 1736613575, '__ci_last_regenerate|i:1736613575;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('amp7g8afrqpclkq3hqfd00m2nkjc3eln', '85.208.96.203', 1736553445, '__ci_last_regenerate|i:1736553445;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ap4girliu8ate0mfmvftle0e3g9hpbf3', '216.244.66.199', 1736561541, '__ci_last_regenerate|i:1736561541;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('apk7voo7cgq2vichr154s7anlj828944', '185.191.171.6', 1736576601, '__ci_last_regenerate|i:1736576601;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b46abv69eh2sjobla2bkqgrdt7hqviqf', '103.23.204.60', 1736599692, '__ci_last_regenerate|i:1736599692;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b6ga5b3r3k364qopeoov5dn9vpdt88d3', '103.131.145.159', 1736569904, '__ci_last_regenerate|i:1736569904;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ba72kn4uofn4l19n6jt9alkfigameg83', '85.208.96.194', 1736564943, '__ci_last_regenerate|i:1736564943;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bj5484kfp1eqg5shvequ9a6ct24rmni2', '85.208.96.200', 1736564552, '__ci_last_regenerate|i:1736564552;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bqpg1o8tkocconp4itbnm5in67jka08d', '66.249.66.33', 1736584977, '__ci_last_regenerate|i:1736584977;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bvi5vol19qpm5mp930lq62fvtv6dva3b', '185.191.171.7', 1736589252, '__ci_last_regenerate|i:1736589252;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c88gfbrqm9r20g7qfkdsetnm3fe3n200', '185.191.171.18', 1736592128, '__ci_last_regenerate|i:1736592128;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cb6g15ggpcoj49jgvn6n50o7d5704oca', '182.48.82.104', 1736571085, '__ci_last_regenerate|i:1736571003;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('clq1grec3o3msbtkeegd0hhd458lam6o', '35.90.228.31', 1736578203, '__ci_last_regenerate|i:1736578201;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cpodv47m4a4bq26g816gmmqn6muppv0u', '85.208.96.198', 1736597249, '__ci_last_regenerate|i:1736597249;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cptgrg5v957mv3oecp1f5gharc620mcd', '40.77.167.44', 1736586836, '__ci_last_regenerate|i:1736586836;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d1eornllblhp83383abi1qdsi24c69av', '85.208.96.207', 1736589433, '__ci_last_regenerate|i:1736589433;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d1fuco30pgulkck0l0mnifse66odqvf0', '185.191.171.11', 1736584958, '__ci_last_regenerate|i:1736584958;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d1hjh4skh8477n6q2ldm27he18ubltls', '85.208.96.195', 1736558285, '__ci_last_regenerate|i:1736558285;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d9jp203jq6mm9a3q2d0qvfbh9u10oucb', '182.48.82.104', 1736594133, '__ci_last_regenerate|i:1736594133;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ddnu3se9utgu6a7u53d78i78hnnjkuab', '35.90.228.31', 1736578213, '__ci_last_regenerate|i:1736578211;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('deno6v24f41geqqhmn5d2n3ddp6vl2g4', '58.145.184.240', 1736578079, '__ci_last_regenerate|i:1736578079;name|s:12:\"Elite Design\";logger_photo|s:11:\"defualt.png\";loggedin_branch|N;loggedin_id|s:1:\"1\";loggedin_userid|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_type|s:5:\"staff\";set_lang|s:7:\"english\";is_rtl|b:0;set_session_id|s:1:\"6\";loggedin|b:1;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dgapgscvggho9vr1eu174j190h54re06', '185.191.171.11', 1736592189, '__ci_last_regenerate|i:1736592189;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('di7n33v4bko8kic9l19p6kjcq3ev6jbr', '85.208.96.198', 1736557698, '__ci_last_regenerate|i:1736557698;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dk253gjdmojvarv58vf37ihmbja06nbq', '85.208.96.210', 1736558307, '__ci_last_regenerate|i:1736558307;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dk95v91fgsu63t6jmgev9qeej1c50jsm', '185.191.171.8', 1736578846, '__ci_last_regenerate|i:1736578846;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dtmvm9bb54m9uisg8m3r5oddq29p2v99', '216.244.66.199', 1736581412, '__ci_last_regenerate|i:1736581412;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dvpje8neobbum3702qhlqk3a2coed597', '85.208.96.211', 1736559928, '__ci_last_regenerate|i:1736559928;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('e0fnmfl6j7f3i3eurgradh8gelm88f3d', '185.191.171.10', 1736587432, '__ci_last_regenerate|i:1736587432;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('e2oj2fkv6oocil296nmbn87vn59f2i4d', '185.191.171.4', 1736596199, '__ci_last_regenerate|i:1736596199;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ebo8plu2c5dsgfi5koblpsv6ui3bfufa', '185.191.171.16', 1736572621, '__ci_last_regenerate|i:1736572621;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('eirq09qogapu97q1828pjgmvbmcb48mu', '185.191.171.9', 1736563723, '__ci_last_regenerate|i:1736563723;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ejb64arimvcc2l1iesafntdpjs96b9ct', '185.191.171.8', 1736561815, '__ci_last_regenerate|i:1736561815;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('emvokk0jrt057tlu9utk2kd442cvoim9', '103.254.86.241', 1736586112, '__ci_last_regenerate|i:1736586112;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('enguh0ena5san987mtq2pp383ekj64qg', '85.208.96.202', 1736572619, '__ci_last_regenerate|i:1736572619;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('eor0mvmgahh5bkuqjn4lbp9jfsu1he1t', '66.102.6.97', 1736594102, '__ci_last_regenerate|i:1736594102;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('esl8sfdcm8evi3jprdjgg7beq4sakrtt', '216.244.66.199', 1736611676, '__ci_last_regenerate|i:1736611676;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ettjgmgau8p776q9jmo6jis7n1hn2vd9', '185.191.171.12', 1736561669, '__ci_last_regenerate|i:1736561668;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('f8d50v7blu8m1je3eopj606qqd8mthm9', '85.208.96.209', 1736573379, '__ci_last_regenerate|i:1736573379;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('fac13vbausqhl67l0kd61k3b8m19ft7o', '66.102.6.97', 1736594103, '__ci_last_regenerate|i:1736594103;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('fl6kjl1j56l0cff6forbhq1bula1638b', '103.146.37.2', 1736604277, '__ci_last_regenerate|i:1736604277;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('fnqg2017p4m25ufbr73i5qlkjgkk9m27', '103.51.52.4', 1736595123, '__ci_last_regenerate|i:1736595122;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('fq4v6n8d79voegcfi2i4e2523jha3861', '85.208.96.204', 1736597632, '__ci_last_regenerate|i:1736597632;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('fvj7htm3bqc0qhibfcpe8jmjpq2qm0v3', '185.191.171.8', 1736573971, '__ci_last_regenerate|i:1736573971;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('g2kfg1743vpv62288nas7smldcn1qjgi', '85.208.96.199', 1736582143, '__ci_last_regenerate|i:1736582143;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('g3nmmggg1bk8lnmte5s48bvopc90suet', '185.191.171.3', 1736576311, '__ci_last_regenerate|i:1736576311;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('g7rns7m1d96tv3oe1mgq2k84iecfi3jf', '185.191.171.14', 1736576944, '__ci_last_regenerate|i:1736576944;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('gb89q80bvnq10d2pohcrl56ug11ii6b1', '185.191.171.2', 1736562285, '__ci_last_regenerate|i:1736562285;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('gbq852gtasuirv2j8alo1tumnrth7u7t', '85.208.96.212', 1736561467, '__ci_last_regenerate|i:1736561467;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('gcd3io3gb0e8gso5tuojoa3hbkkcuk1g', '203.31.169.35', 1736614542, '__ci_last_regenerate|i:1736614533;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ggrq2d7dh2sh5nsisii6i7gajml36cpu', '185.191.171.13', 1736554501, '__ci_last_regenerate|i:1736554501;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('gvtsqlpdq1pkvh34rd12f4icnj31u8e1', '185.191.171.6', 1736559785, '__ci_last_regenerate|i:1736559785;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('h10qa91fatcet89hnj7udrqurr1etae2', '185.191.171.6', 1736595192, '__ci_last_regenerate|i:1736595192;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('h5bj8dmp0bnep7ud3gjs274edluhdfj5', '185.191.171.17', 1736568073, '__ci_last_regenerate|i:1736568073;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('htraa8rg2969s7tbaf55ptuokdgmctml', '85.208.96.195', 1736588235, '__ci_last_regenerate|i:1736588234;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('hunao1me71hok9m7r0iahio4v3bdmjm4', '185.191.171.6', 1736573757, '__ci_last_regenerate|i:1736573757;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('i233mdktdvgrihl5v2lf8g1plo56kl06', '185.191.171.14', 1736587191, '__ci_last_regenerate|i:1736587191;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('i702enaea6nm47aqk3i32h13anf7sldj', '85.208.96.211', 1736590138, '__ci_last_regenerate|i:1736590138;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('i87u2221012r7lkvgvrpkkrvbijmvso4', '85.208.96.194', 1736586692, '__ci_last_regenerate|i:1736586692;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ic4qvt23dgcgrupa2i7v729bmfdbs59r', '185.191.171.12', 1736586596, '__ci_last_regenerate|i:1736586596;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ie49h7f0v5ki6eaiq8d7t4dlqdvi50su', '85.208.96.204', 1736580913, '__ci_last_regenerate|i:1736580913;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('igeus6br85squ1hsldv1ond1pkasjsb2', '185.191.171.2', 1736580832, '__ci_last_regenerate|i:1736580832;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('igqb5c15s0ioigg87v6qgbjtujk2b086', '173.252.87.9', 1736598675, '__ci_last_regenerate|i:1736598675;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('iqf5a5g13k6jl0vihlah1kvhh67sq207', '103.51.52.4', 1736594463, '__ci_last_regenerate|i:1736594186;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('irtbgdfssg18v9uqbvp9c9a3mcl8hpom', '185.191.171.7', 1736588559, '__ci_last_regenerate|i:1736588559;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('isdub7u54tv0p8ppnoivtr7rerutis78', '85.208.96.193', 1736590493, '__ci_last_regenerate|i:1736590493;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('isoivg7mugivh2f6ob6tkjsekn9akkkd', '216.244.66.199', 1736562134, '__ci_last_regenerate|i:1736562134;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('iug6hs9nk7um0b6f7oi7bl9qbk6votmt', '185.191.171.15', 1736594460, '__ci_last_regenerate|i:1736594460;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('j42mf20l46bc4l9idq7vrmuj1akhct59', '185.191.171.14', 1736564499, '__ci_last_regenerate|i:1736564499;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('j6hu45d0n7tmst60qd95c4h1lohadmq2', '185.191.171.12', 1736554030, '__ci_last_regenerate|i:1736554030;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('jh9lifld0qp8e8ked8c8q93k69849coa', '58.145.184.240', 1736579451, '__ci_last_regenerate|i:1736579303;name|s:12:\"Elite Design\";logger_photo|s:11:\"defualt.png\";loggedin_branch|N;loggedin_id|s:1:\"1\";loggedin_userid|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_type|s:5:\"staff\";set_lang|s:7:\"bengali\";is_rtl|b:0;set_session_id|s:1:\"6\";loggedin|b:1;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('jjrseh2sib86gvlnktk1pr60lri7mip9', '85.208.96.209', 1736596450, '__ci_last_regenerate|i:1736596450;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('jnub66d16autlckcnq0eho0h3bmmee9j', '51.8.102.216', 1736566933, '__ci_last_regenerate|i:1736566933;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('jpeus6q1jnnq66d17rjrc3r1pn4ocbs4', '216.244.66.199', 1736578806, '__ci_last_regenerate|i:1736578806;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('k74h6eb4hklcaat413ffqh67s3373uc3', '173.252.107.13', 1736598670, '__ci_last_regenerate|i:1736598670;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('k7ja51u358dequask0m0ab2rukc9uljb', '185.191.171.9', 1736576881, '__ci_last_regenerate|i:1736576881;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('k8o06390nbqfqvjl3tnrhm6l5l9rngrs', '85.208.96.201', 1736576115, '__ci_last_regenerate|i:1736576115;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('kgru8en693qk19pb376ij62o27qtsplp', '185.191.171.12', 1736563581, '__ci_last_regenerate|i:1736563581;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('kivrsnattc5avmqau4o7589f1ndrgudd', '216.244.66.199', 1736570649, '__ci_last_regenerate|i:1736570649;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('kmohbakn6kogi8ks5prdth8sn5r2f063', '185.191.171.1', 1736562017, '__ci_last_regenerate|i:1736562017;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ko7iop4ijr0mv7vbpdd5gkiimm1v78jv', '85.208.96.198', 1736554438, '__ci_last_regenerate|i:1736554438;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('l04tnqkuehhdl3lode0la54c89bf3lm7', '185.191.171.10', 1736580102, '__ci_last_regenerate|i:1736580102;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('l34hle1kdg2nvgh7subh3plbfafoojsm', '182.48.82.104', 1736594471, '__ci_last_regenerate|i:1736594461;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('l4q92eq4ca24qreptt40fq9a5a6mibre', '85.208.96.209', 1736579234, '__ci_last_regenerate|i:1736579234;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('l60bel0vc3k4s268st889373r825l4ho', '85.208.96.198', 1736554718, '__ci_last_regenerate|i:1736554718;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('l6fs49fbil0egklmepvvc787f1pavtue', '185.191.171.17', 1736565657, '__ci_last_regenerate|i:1736565657;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('l6glghhclp0ep9aj9prrvuu7gqsq6617', '185.191.171.19', 1736565933, '__ci_last_regenerate|i:1736565933;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('l6or2puo8sdeor8uq4na764kradle8gv', '216.244.66.199', 1736577137, '__ci_last_regenerate|i:1736577137;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('l8pvph1b9kpv28oro8ihqidpi2oreost', '85.208.96.206', 1736598285, '__ci_last_regenerate|i:1736598285;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('l8u54kjbb6pukp3jv07mh0617d0mi7r5', '216.244.66.199', 1736612547, '__ci_last_regenerate|i:1736612547;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('lfrmpsnab3v9or3har52f5qqc95fnb8n', '85.208.96.212', 1736586848, '__ci_last_regenerate|i:1736586848;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('lh9mk3urs92h84l56gf9esnop96hm6lp', '85.208.96.197', 1736589312, '__ci_last_regenerate|i:1736589312;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('livcbohrr42ep4n369ascdqhvvuottb9', '185.191.171.2', 1736595722, '__ci_last_regenerate|i:1736595722;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('lkbrj2egu76che61kvcar6bojh4cd3rq', '85.208.96.209', 1736568009, '__ci_last_regenerate|i:1736568009;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('lpb81bbn7ub46an02njlob21777r9fta', '185.191.171.1', 1736576319, '__ci_last_regenerate|i:1736576319;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('m9jhlcm8g7aqa98ni685h7n6htfd2ic7', '85.208.96.197', 1736557286, '__ci_last_regenerate|i:1736557286;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('mg9ahjoiq25658cj5kede3knd581gca9', '185.191.171.5', 1736583199, '__ci_last_regenerate|i:1736583199;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('mjkp2am0in7o7026bvjrrbmksg1hi0kq', '185.191.171.14', 1736558902, '__ci_last_regenerate|i:1736558902;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('mk6abnrf4ffhei2d6pmlirv2iuf2sjkd', '85.208.96.207', 1736565456, '__ci_last_regenerate|i:1736565456;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('moei5voo00jcn41ipantdh6ml2l5dlb9', '185.191.171.13', 1736584480, '__ci_last_regenerate|i:1736584480;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('mtf3nt0cch0v4sngbji9i3rqrckr2i3j', '85.208.96.210', 1736594197, '__ci_last_regenerate|i:1736594197;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('mtoa61255vohq5ln902dc27fkhqv4s4q', '103.254.86.241', 1736586312, '__ci_last_regenerate|i:1736586112;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('mvb0ugurviocs04und7k50hket5v6hvd', '185.191.171.3', 1736597153, '__ci_last_regenerate|i:1736597153;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('n17n17j6mk80vvkmpphi11jjuahvqk1a', '185.191.171.14', 1736574319, '__ci_last_regenerate|i:1736574319;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('n1jh6f52sq9715qdlikgqohk1dl7mk57', '85.208.96.193', 1736562634, '__ci_last_regenerate|i:1736562634;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ncamr3q9f7agd6bv1f478vvhn5id17i9', '216.244.66.199', 1736586321, '__ci_last_regenerate|i:1736586321;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ni43imgr6knu8jj0f726bs0e9kfthkfd', '103.146.37.2', 1736599949, '__ci_last_regenerate|i:1736599949;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('nl17jq78l98hu5vnjjumofa9ba321b92', '85.208.96.204', 1736554063, '__ci_last_regenerate|i:1736554063;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('nloj8rbr8e6ol5i7fgvu4uda8s63crru', '216.244.66.199', 1736564496, '__ci_last_regenerate|i:1736564496;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('nnsjle4a313dq2jnbdoduguphkqlhb52', '185.191.171.11', 1736558148, '__ci_last_regenerate|i:1736558148;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('nooks4ecojpk6muir5vnjcoqnpi091th', '85.208.96.201', 1736577892, '__ci_last_regenerate|i:1736577892;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('nrtuscpjng7iec36gne2oadiq3mgfvg6', '66.249.66.45', 1736589266, '__ci_last_regenerate|i:1736589266;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('o42mnh5m0nmpbvltqru95t73ig4idpmj', '85.208.96.199', 1736557938, '__ci_last_regenerate|i:1736557938;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('oagpihn0a8t43empt41n9in8vkjedi9g', '43.250.82.105', 1736594759, '__ci_last_regenerate|i:1736594759;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('oaiiblv0i9hhjrefl1hi0fhk1caugqak', '59.153.100.202', 1736614254, '__ci_last_regenerate|i:1736614219;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ofhaasqo3a5hvl636u7tjt93vdr5tiqa', '185.191.171.3', 1736590193, '__ci_last_regenerate|i:1736590193;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ogh06bj3bid37jhdjrhs802h11rf7j7m', '185.191.171.17', 1736595721, '__ci_last_regenerate|i:1736595721;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('oluns5qdljeoqusnap775o3qc23t0qfd', '205.169.39.25', 1736591244, '__ci_last_regenerate|i:1736591239;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('onoi4nvggm2324j0gpgh7qr9tlrbgbk2', '103.23.204.60', 1736602267, '__ci_last_regenerate|i:1736602267;name|s:12:\"Elite Design\";logger_photo|s:11:\"defualt.png\";loggedin_branch|N;loggedin_id|s:1:\"1\";loggedin_userid|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_type|s:5:\"staff\";set_lang|s:7:\"english\";is_rtl|b:0;set_session_id|s:1:\"6\";loggedin|b:1;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('oqtggnneigd72m7pg2p7cu5i6s0r5sf6', '35.90.228.31', 1736578209, '__ci_last_regenerate|i:1736578207;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('or49rm8ak8bh6mhkbt8vfqqorh8q1cof', '103.51.52.4', 1736594755, '__ci_last_regenerate|i:1736594755;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('p7kn0shqjd6c04dl6qab18eaiam6enjq', '185.191.171.14', 1736567482, '__ci_last_regenerate|i:1736567482;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('pcvqldd3tgeakfi5piu3r9naf3rnaqbk', '185.191.171.14', 1736565351, '__ci_last_regenerate|i:1736565351;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('pi7jq51svsbr9fas5bkscshfld35etco', '85.208.96.199', 1736593475, '__ci_last_regenerate|i:1736593475;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ppaeq1n8ouiuio23ja12hfk8ekq8arer', '185.191.171.14', 1736590658, '__ci_last_regenerate|i:1736590658;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('q2kpplo9hsir728m625f36admqrodmel', '85.208.96.199', 1736584983, '__ci_last_regenerate|i:1736584983;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('q303acgjggp7mp2i68o85m4pq0nuf3o1', '85.208.96.201', 1736598062, '__ci_last_regenerate|i:1736598062;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('q6bgclhk2f1pd8u4lvj0a2nap4ru6lvb', '185.191.171.18', 1736590152, '__ci_last_regenerate|i:1736590152;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('q8i9s9v9332f9mmnkuipulmarapj13ne', '85.208.96.211', 1736594614, '__ci_last_regenerate|i:1736594614;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('qiujhobjctpdavvgao6uqktdb952rnm9', '185.191.171.18', 1736560215, '__ci_last_regenerate|i:1736560215;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('qljbdtet0douu59qhmaqt2mje2f5736n', '185.191.171.18', 1736596967, '__ci_last_regenerate|i:1736596967;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('qo3kth3ikr56smhi4fjkcuc8pmrbg72d', '34.248.137.227', 1736574711, '__ci_last_regenerate|i:1736574711;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('qp8f81bclo98ap3lhmcvu9806jkegoem', '85.208.96.195', 1736558482, '__ci_last_regenerate|i:1736558482;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('qvbkk595q3s3mslkhc80atcm3u5227ta', '85.208.96.202', 1736552832, '__ci_last_regenerate|i:1736552832;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('r65ogg2j3ejo0jodeq9qh2mkk9ggjaik', '216.244.66.199', 1736582024, '__ci_last_regenerate|i:1736582024;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('rdnd5eilmmr1oh393vhhaaqlakdqgpp2', '182.48.82.104', 1736594944, '__ci_last_regenerate|i:1736594892;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('rmfe68sguhotqbbrakmn604r82h5888k', '216.244.66.199', 1736587219, '__ci_last_regenerate|i:1736587219;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('s3ngcj20j2ahp79g6k1fqlj83e2imgb4', '85.208.96.203', 1736593489, '__ci_last_regenerate|i:1736593489;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('s56gcppel3at89gao1cgufsj3grcidvm', '103.23.204.60', 1736602268, '__ci_last_regenerate|i:1736602267;name|s:12:\"Elite Design\";logger_photo|s:11:\"defualt.png\";loggedin_branch|N;loggedin_id|s:1:\"1\";loggedin_userid|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_type|s:5:\"staff\";set_lang|s:7:\"english\";is_rtl|b:0;set_session_id|s:1:\"6\";loggedin|b:1;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('se059reemlp821eme0sia52r41kf391n', '103.138.250.202', 1736615292, '__ci_last_regenerate|i:1736615292;name|s:12:\"Elite Design\";logger_photo|s:11:\"defualt.png\";loggedin_branch|N;loggedin_id|s:1:\"1\";loggedin_userid|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_type|s:5:\"staff\";set_lang|s:7:\"english\";is_rtl|b:0;set_session_id|s:1:\"6\";loggedin|b:1;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('sh3e6orsj5pfkmnhoidel6vu0bb0sle2', '185.191.171.15', 1736580104, '__ci_last_regenerate|i:1736580104;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('sj1obln3h3qp9hob7q4cld9aoh3e7ntj', '85.208.96.212', 1736587256, '__ci_last_regenerate|i:1736587256;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('sqvt9phtg1vdgn8tm10jcrgl4r0pqedo', '34.248.137.227', 1736574697, '__ci_last_regenerate|i:1736574697;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('srk76469i3n4nfboor0ieioft4dbh2dj', '185.191.171.17', 1736575781, '__ci_last_regenerate|i:1736575781;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('sth7fgrd3gdps9mc3nndok06fhq9422s', '185.191.171.8', 1736569234, '__ci_last_regenerate|i:1736569234;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('t4dhke2nsmstugpvu6g4b2vvmdqaa367', '216.244.66.199', 1736609757, '__ci_last_regenerate|i:1736609757;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ths1i6isc39fpc92oh4mtjq2cvqpm64q', '85.208.96.205', 1736592699, '__ci_last_regenerate|i:1736592699;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('tqv1n0fke3hm5oio2upqrb8dvi2m9hqi', '216.244.66.199', 1736555667, '__ci_last_regenerate|i:1736555667;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('tra5lhoogms58ask43n514nkb29gf6u8', '185.191.171.7', 1736581263, '__ci_last_regenerate|i:1736581263;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('tt64nju8km5cfa361kk8elso3oiqq56a', '85.208.96.205', 1736591181, '__ci_last_regenerate|i:1736591181;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('u3q4mai4uqs54mmm6uq63hf45iej753i', '185.191.171.9', 1736570417, '__ci_last_regenerate|i:1736570417;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('u568tfdt0hu8r74jg9iev3m7bvupr7n2', '185.191.171.14', 1736567242, '__ci_last_regenerate|i:1736567242;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('u6g3o5qoae7fkak7t8ovjagfa9o37uuo', '185.191.171.6', 1736580962, '__ci_last_regenerate|i:1736580962;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ucechmvkjuj1ki1vdtb4t13dpk5egir4', '185.191.171.10', 1736564138, '__ci_last_regenerate|i:1736564138;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ufefo1ue8k2fs8knm6ubp4p5j3tu4lbj', '185.191.171.15', 1736586239, '__ci_last_regenerate|i:1736586239;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ujm25b734mki7l86iav4m5sblmifbbgt', '85.208.96.212', 1736580449, '__ci_last_regenerate|i:1736580449;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('uknmesvr11efvji1iolfoq2tf373tei3', '216.244.66.199', 1736606969, '__ci_last_regenerate|i:1736606969;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('uq5l5fvndt77s7fso2sn4qm5vut1sorf', '185.191.171.9', 1736553681, '__ci_last_regenerate|i:1736553681;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('uvhhv8b92o5j3u30jvp2augpiefumvi2', '85.208.96.203', 1736554658, '__ci_last_regenerate|i:1736554658;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('v1cm7ijv1pathhir76a561rolce45leq', '185.191.171.8', 1736591674, '__ci_last_regenerate|i:1736591674;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('v6hk6uvseedgk6s732mj6b4a5ac1eu4q', '185.191.171.9', 1736563578, '__ci_last_regenerate|i:1736563578;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('vcp42ja30k06tvbpluh15qdohe518ege', '185.191.171.14', 1736590232, '__ci_last_regenerate|i:1736590232;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('veqqlnn90vcjo38hvl5gnse9at30jtfs', '185.191.171.4', 1736555557, '__ci_last_regenerate|i:1736555557;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('vk8o95klnnh9g58tnkbeafvgf8kdq2s1', '185.191.171.14', 1736557701, '__ci_last_regenerate|i:1736557701;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('vl5su4gml886a5drad94li6ermjm8k9r', '85.208.96.211', 1736588236, '__ci_last_regenerate|i:1736588236;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('vlg6qqmodtbq5qmplkg2jpd17vrrdrl7', '103.135.88.211', 1736560040, '__ci_last_regenerate|i:1736559900;name|s:12:\"Elite Design\";logger_photo|s:11:\"defualt.png\";loggedin_branch|N;loggedin_id|s:1:\"1\";loggedin_userid|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_type|s:5:\"staff\";set_lang|s:7:\"english\";is_rtl|b:0;set_session_id|s:1:\"6\";loggedin|b:1;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('vnqds49tcfrnp30msgcbk36fmpj59155', '185.191.171.13', 1736589298, '__ci_last_regenerate|i:1736589298;');
INSERT INTO `rm_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('vq0gg3uq66ml2de2luoeqn4v2se3u6kq', '185.191.171.4', 1736582599, '__ci_last_regenerate|i:1736582599;');


#
# TABLE STRUCTURE FOR: roles
#

DROP TABLE IF EXISTS `roles`;

CREATE TABLE `roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `prefix` varchar(50) DEFAULT NULL,
  `is_system` varchar(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `roles` (`id`, `name`, `prefix`, `is_system`) VALUES (1, 'Super Admin', 'superadmin', '1');
INSERT INTO `roles` (`id`, `name`, `prefix`, `is_system`) VALUES (2, 'Admin', 'admin', '1');
INSERT INTO `roles` (`id`, `name`, `prefix`, `is_system`) VALUES (3, 'Teacher', 'teacher', '1');
INSERT INTO `roles` (`id`, `name`, `prefix`, `is_system`) VALUES (4, 'Accountant', 'accountant', '1');
INSERT INTO `roles` (`id`, `name`, `prefix`, `is_system`) VALUES (5, 'Librarian', 'librarian', '1');
INSERT INTO `roles` (`id`, `name`, `prefix`, `is_system`) VALUES (6, 'Parent', 'parent', '1');
INSERT INTO `roles` (`id`, `name`, `prefix`, `is_system`) VALUES (7, 'Student', 'student', '1');
INSERT INTO `roles` (`id`, `name`, `prefix`, `is_system`) VALUES (8, 'Receptionist', 'receptionist', '1');
INSERT INTO `roles` (`id`, `name`, `prefix`, `is_system`) VALUES (9, 'Students', 'students', '0');


#
# TABLE STRUCTURE FOR: salary_template
#

DROP TABLE IF EXISTS `salary_template`;

CREATE TABLE `salary_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `basic_salary` decimal(18,2) NOT NULL,
  `overtime_salary` varchar(100) NOT NULL DEFAULT '0',
  `branch_id` tinyint(3) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `salary_template` (`id`, `name`, `basic_salary`, `overtime_salary`, `branch_id`) VALUES (1, '1', '5000.00', '0', 1);
INSERT INTO `salary_template` (`id`, `name`, `basic_salary`, `overtime_salary`, `branch_id`) VALUES (2, '2', '7000.00', '0', 1);


#
# TABLE STRUCTURE FOR: salary_template_details
#

DROP TABLE IF EXISTS `salary_template_details`;

CREATE TABLE `salary_template_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `salary_template_id` varchar(20) NOT NULL,
  `name` varchar(200) NOT NULL,
  `amount` decimal(18,2) NOT NULL DEFAULT 0.00,
  `type` tinyint(2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `salary_template_details` (`id`, `salary_template_id`, `name`, `amount`, `type`) VALUES (1, '2', 'Others Allowance', '3000.00', 1);


#
# TABLE STRUCTURE FOR: sales_bill
#

DROP TABLE IF EXISTS `sales_bill`;

CREATE TABLE `sales_bill` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bill_no` varchar(200) NOT NULL,
  `role_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `remarks` text NOT NULL,
  `total` decimal(18,2) NOT NULL DEFAULT 0.00,
  `discount` decimal(18,2) NOT NULL DEFAULT 0.00,
  `paid` decimal(18,2) NOT NULL DEFAULT 0.00,
  `due` decimal(18,2) NOT NULL DEFAULT 0.00,
  `payment_status` int(11) NOT NULL,
  `date` date DEFAULT NULL,
  `prepared_by` int(11) DEFAULT NULL,
  `modifier_id` int(11) DEFAULT NULL,
  `branch_id` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sales_bill_rms_1` (`branch_id`),
  CONSTRAINT `sales_bill_rms_1` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: sales_bill_details
#

DROP TABLE IF EXISTS `sales_bill_details`;

CREATE TABLE `sales_bill_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sales_bill_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `unit_price` decimal(18,2) NOT NULL DEFAULT 0.00,
  `quantity` varchar(20) NOT NULL,
  `discount` decimal(18,2) NOT NULL DEFAULT 0.00,
  `sub_total` decimal(18,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`),
  KEY `sales_bill_details_rms_1` (`product_id`),
  CONSTRAINT `sales_bill_details_rms_1` FOREIGN KEY (`product_id`) REFERENCES `product` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: sales_payment_history
#

DROP TABLE IF EXISTS `sales_payment_history`;

CREATE TABLE `sales_payment_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sales_bill_id` varchar(11) NOT NULL,
  `payment_by` int(11) DEFAULT NULL,
  `amount` decimal(18,2) NOT NULL DEFAULT 0.00,
  `pay_via` varchar(25) NOT NULL,
  `remarks` text NOT NULL,
  `attach_orig_name` varchar(255) DEFAULT NULL,
  `attach_file_name` varchar(255) DEFAULT NULL,
  `paid_on` date DEFAULT NULL,
  `coll_type` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: schoolyear
#

DROP TABLE IF EXISTS `schoolyear`;

CREATE TABLE `schoolyear` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `school_year` varchar(255) NOT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `schoolyear` (`id`, `school_year`, `created_by`, `created_at`, `updated_at`) VALUES (5, '2024-2025', 1, '2020-02-26 01:35:41', '2023-08-18 01:35:41');
INSERT INTO `schoolyear` (`id`, `school_year`, `created_by`, `created_at`, `updated_at`) VALUES (6, '2025-2026', 1, '2020-02-26 01:35:41', '2023-08-18 01:35:41');
INSERT INTO `schoolyear` (`id`, `school_year`, `created_by`, `created_at`, `updated_at`) VALUES (7, '2026-2027', 1, '2020-02-26 01:35:41', '2023-08-18 01:20:04');
INSERT INTO `schoolyear` (`id`, `school_year`, `created_by`, `created_at`, `updated_at`) VALUES (9, '2027-2028', 1, '2020-02-26 13:00:10', '2023-08-18 13:00:24');


#
# TABLE STRUCTURE FOR: section
#

DROP TABLE IF EXISTS `section`;

CREATE TABLE `section` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `capacity` varchar(20) DEFAULT NULL,
  `branch_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `section` (`id`, `name`, `capacity`, `branch_id`) VALUES (2, 'Science', '30', 1);
INSERT INTO `section` (`id`, `name`, `capacity`, `branch_id`) VALUES (3, 'Humanities', '30', 1);
INSERT INTO `section` (`id`, `name`, `capacity`, `branch_id`) VALUES (4, 'Business Studies', '30', 1);
INSERT INTO `section` (`id`, `name`, `capacity`, `branch_id`) VALUES (5, 'N/A', '50', 1);


#
# TABLE STRUCTURE FOR: sections_allocation
#

DROP TABLE IF EXISTS `sections_allocation`;

CREATE TABLE `sections_allocation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_id` int(11) NOT NULL,
  `section_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sections_allocation_rms_1` (`class_id`),
  KEY `sections_allocation_rms_2` (`section_id`),
  CONSTRAINT `sections_allocation_rms_1` FOREIGN KEY (`class_id`) REFERENCES `class` (`id`) ON DELETE CASCADE,
  CONSTRAINT `sections_allocation_rms_2` FOREIGN KEY (`section_id`) REFERENCES `section` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `sections_allocation` (`id`, `class_id`, `section_id`) VALUES (14, 12, 2);
INSERT INTO `sections_allocation` (`id`, `class_id`, `section_id`) VALUES (15, 12, 3);
INSERT INTO `sections_allocation` (`id`, `class_id`, `section_id`) VALUES (16, 12, 4);
INSERT INTO `sections_allocation` (`id`, `class_id`, `section_id`) VALUES (17, 13, 2);
INSERT INTO `sections_allocation` (`id`, `class_id`, `section_id`) VALUES (18, 13, 3);
INSERT INTO `sections_allocation` (`id`, `class_id`, `section_id`) VALUES (19, 13, 4);
INSERT INTO `sections_allocation` (`id`, `class_id`, `section_id`) VALUES (21, 2, 5);
INSERT INTO `sections_allocation` (`id`, `class_id`, `section_id`) VALUES (22, 3, 5);
INSERT INTO `sections_allocation` (`id`, `class_id`, `section_id`) VALUES (23, 4, 5);
INSERT INTO `sections_allocation` (`id`, `class_id`, `section_id`) VALUES (24, 5, 5);
INSERT INTO `sections_allocation` (`id`, `class_id`, `section_id`) VALUES (25, 6, 5);
INSERT INTO `sections_allocation` (`id`, `class_id`, `section_id`) VALUES (26, 7, 5);
INSERT INTO `sections_allocation` (`id`, `class_id`, `section_id`) VALUES (27, 8, 5);
INSERT INTO `sections_allocation` (`id`, `class_id`, `section_id`) VALUES (28, 9, 5);
INSERT INTO `sections_allocation` (`id`, `class_id`, `section_id`) VALUES (29, 10, 5);
INSERT INTO `sections_allocation` (`id`, `class_id`, `section_id`) VALUES (30, 11, 5);


#
# TABLE STRUCTURE FOR: sms_api
#

DROP TABLE IF EXISTS `sms_api`;

CREATE TABLE `sms_api` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `sms_api` (`id`, `name`) VALUES (1, 'twilio');
INSERT INTO `sms_api` (`id`, `name`) VALUES (2, 'clickatell');
INSERT INTO `sms_api` (`id`, `name`) VALUES (3, 'msg91');
INSERT INTO `sms_api` (`id`, `name`) VALUES (4, 'bulksms');
INSERT INTO `sms_api` (`id`, `name`) VALUES (5, 'textlocal');
INSERT INTO `sms_api` (`id`, `name`) VALUES (6, 'smscountry');
INSERT INTO `sms_api` (`id`, `name`) VALUES (7, 'bulksmsbd');
INSERT INTO `sms_api` (`id`, `name`) VALUES (8, 'customsms');


#
# TABLE STRUCTURE FOR: sms_credential
#

DROP TABLE IF EXISTS `sms_credential`;

CREATE TABLE `sms_credential` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sms_api_id` int(11) NOT NULL,
  `field_one` varchar(300) NOT NULL,
  `field_two` varchar(300) NOT NULL,
  `field_three` varchar(300) NOT NULL,
  `field_four` varchar(300) NOT NULL,
  `branch_id` int(11) NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: sms_template
#

DROP TABLE IF EXISTS `sms_template`;

CREATE TABLE `sms_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `tags` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `sms_template` (`id`, `name`, `tags`) VALUES (1, 'admission', '{name}, {class}, {section}, {admission_date}, {roll}, {register_no}');
INSERT INTO `sms_template` (`id`, `name`, `tags`) VALUES (2, 'fee_collection', '{name}, {class}, {section}, {admission_date}, {roll}, {register_no}, {paid_amount}, {paid_date} ');
INSERT INTO `sms_template` (`id`, `name`, `tags`) VALUES (3, 'attendance', '{name}, {class}, {section}, {admission_date}, {roll}, {register_no}');
INSERT INTO `sms_template` (`id`, `name`, `tags`) VALUES (4, 'exam_attendance', '{name}, {class}, {section}, {admission_date}, {roll}, {register_no}, {exam_name}, {term_name}, {subject}');
INSERT INTO `sms_template` (`id`, `name`, `tags`) VALUES (5, 'exam_results', '{name}, {class}, {section}, {admission_date}, {roll}, {register_no}, {exam_name}, {term_name}, {subject}, {marks}');
INSERT INTO `sms_template` (`id`, `name`, `tags`) VALUES (6, 'homework', '{name}, {class}, {section}, {admission_date}, {roll}, {register_no}, {subject}, {date_of_homework}, {date_of_submission}');
INSERT INTO `sms_template` (`id`, `name`, `tags`) VALUES (7, 'live_class', '{name}, {class}, {section}, {admission_date}, {roll}, {register_no}, {date_of_live_class}, {start_time}, {end_time}, {host_by}');
INSERT INTO `sms_template` (`id`, `name`, `tags`) VALUES (8, 'online_exam_publish', '{name}, {class}, {section}, {admission_date}, {roll}, {register_no}, {exam_title}, {start_time}, {end_time}, {time_duration}, {attempt}, {passing_mark}, {exam_fee}');
INSERT INTO `sms_template` (`id`, `name`, `tags`) VALUES (9, 'student_birthday_wishes', '{name}, {class}, {section}, {admission_date}, {roll}, {register_no}, {birthday}');
INSERT INTO `sms_template` (`id`, `name`, `tags`) VALUES (10, 'staff_birthday_wishes', '{name}, {birthday}, {joining_date}');
INSERT INTO `sms_template` (`id`, `name`, `tags`) VALUES (11, 'alumni_event', '{student_name}, {event_title}, {start_date}, {end_date}');


#
# TABLE STRUCTURE FOR: sms_template_details
#

DROP TABLE IF EXISTS `sms_template_details`;

CREATE TABLE `sms_template_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `template_id` int(11) NOT NULL,
  `dlt_template_id` varchar(255) DEFAULT NULL,
  `notify_student` tinyint(3) NOT NULL DEFAULT 1,
  `notify_parent` tinyint(3) NOT NULL DEFAULT 1,
  `template_body` longtext NOT NULL,
  `branch_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: staff
#

DROP TABLE IF EXISTS `staff`;

CREATE TABLE `staff` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` varchar(25) NOT NULL,
  `name` varchar(255) NOT NULL,
  `department` int(11) NOT NULL,
  `qualification` varchar(255) NOT NULL,
  `experience_details` varchar(255) DEFAULT NULL,
  `total_experience` varchar(255) DEFAULT NULL,
  `designation` int(11) NOT NULL,
  `joining_date` varchar(100) NOT NULL,
  `birthday` varchar(100) NOT NULL,
  `sex` varchar(20) NOT NULL,
  `religion` varchar(100) NOT NULL,
  `blood_group` varchar(20) NOT NULL,
  `present_address` text NOT NULL,
  `permanent_address` text NOT NULL,
  `mobileno` varchar(100) NOT NULL,
  `email` varchar(100) NOT NULL,
  `salary_template_id` int(11) DEFAULT 0,
  `branch_id` int(11) DEFAULT NULL,
  `photo` varchar(255) DEFAULT NULL,
  `facebook_url` varchar(255) DEFAULT NULL,
  `linkedin_url` varchar(255) DEFAULT NULL,
  `twitter_url` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `staff` (`id`, `staff_id`, `name`, `department`, `qualification`, `experience_details`, `total_experience`, `designation`, `joining_date`, `birthday`, `sex`, `religion`, `blood_group`, `present_address`, `permanent_address`, `mobileno`, `email`, `salary_template_id`, `branch_id`, `photo`, `facebook_url`, `linkedin_url`, `twitter_url`, `created_at`, `updated_at`) VALUES (1, '52b0a68', 'Elite Design', 0, '', NULL, NULL, 0, '2024-12-27', '1997-09-10', 'male', 'Islam', 'O+', 'হাউজঃ মুন্সি বাড়ি, নয়ার হাট স্কুল সংলগ্ন, বড়বাড়ি, লালমনির হাট।', 'হাউজঃ মুন্সি বাড়ি, নয়ার হাট স্কুল সংলগ্ন, বড়বাড়ি, লালমনির হাট।', '01775457008', 'info@elitedesign.com.bd', 0, NULL, 'defualt.png', 'https://www.facebook.com/official.elitedesign', 'https://www.facebook.com/official.elitedesign', 'https://www.facebook.com/official.elitedesign', '2024-12-27 13:31:06', NULL);
INSERT INTO `staff` (`id`, `staff_id`, `name`, `department`, `qualification`, `experience_details`, `total_experience`, `designation`, `joining_date`, `birthday`, `sex`, `religion`, `blood_group`, `present_address`, `permanent_address`, `mobileno`, `email`, `salary_template_id`, `branch_id`, `photo`, `facebook_url`, `linkedin_url`, `twitter_url`, `created_at`, `updated_at`) VALUES (3, 'a06df8b', 'Md Abdul Rashid', 2, 'BBA', '', '', 1, '2024-12-01', '', 'male', '', '', 'Beraiderchala, Gilaberaid\r\nSreepur, Gazipur.', 'Beraiderchala, Gilaberaid\r\nSreepur, Gazipur.', '01990561324', 'info@elitedesign.com.bd', 1, 1, '8a41b4a85a62cbc0f84818500d8502b4.png', '', '', '', '2024-12-27 17:22:00', NULL);
INSERT INTO `staff` (`id`, `staff_id`, `name`, `department`, `qualification`, `experience_details`, `total_experience`, `designation`, `joining_date`, `birthday`, `sex`, `religion`, `blood_group`, `present_address`, `permanent_address`, `mobileno`, `email`, `salary_template_id`, `branch_id`, `photo`, `facebook_url`, `linkedin_url`, `twitter_url`, `created_at`, `updated_at`) VALUES (4, 'fc552ae', 'Md Abul Kalam', 2, 'bbb', 'bbbb', 'bbb', 2, '2024-12-31', '2024-06-11', 'male', 'Islam', 'O+', 'Holding: 13/2033-02,Lotifpur Moddhopara,Bogura', 'Holding: 13/2033-02,Lotifpur Moddhopara,Bogura', '01775457008', 'kallam23@gmail.com', 0, 1, '1f292aa4baf4f5e5f69af0709aa03997.png', 'https://www.facebook.com/umart', 'sssss', 'https://www.twitter.com/umart', '2024-12-31 14:05:58', NULL);
INSERT INTO `staff` (`id`, `staff_id`, `name`, `department`, `qualification`, `experience_details`, `total_experience`, `designation`, `joining_date`, `birthday`, `sex`, `religion`, `blood_group`, `present_address`, `permanent_address`, `mobileno`, `email`, `salary_template_id`, `branch_id`, `photo`, `facebook_url`, `linkedin_url`, `twitter_url`, `created_at`, `updated_at`) VALUES (5, 'd4d53f7', 'Tushar Bormon', 2, 'BSC', '1 years Eprience', '1', 5, '2025-01-01', '2024-06-11', 'male', 'Hindu', 'O+', 'Holding: 13/2033-02,Lotifpur Moddhopara,Bogura', 'Holding: 13/2033-02,Lotifpur Moddhopara,Bogura', '01954578083', 'bormon@gmail.com', 0, 1, '254f5187dd91e8f6c08d5ed331c8dac9.jpg', 'https://www.facebook.com/umart', 'https://www.twitter.com/umart', 'https://www.twitter.com/umart', '2025-01-02 01:10:50', NULL);
INSERT INTO `staff` (`id`, `staff_id`, `name`, `department`, `qualification`, `experience_details`, `total_experience`, `designation`, `joining_date`, `birthday`, `sex`, `religion`, `blood_group`, `present_address`, `permanent_address`, `mobileno`, `email`, `salary_template_id`, `branch_id`, `photo`, `facebook_url`, `linkedin_url`, `twitter_url`, `created_at`, `updated_at`) VALUES (6, '2caf400', 'Rasheda Khatun', 2, 'Bsc', '1 years', '1', 6, '2025-01-01', '2024-06-11', 'female', 'Islam', 'O+', 'Holding: 13/2033-02,Lotifpur Moddhopara,Bogura', 'Holding: 13/2033-02,Lotifpur Moddhopara,Bogura', '01775457007', 'rasheda@elitedesign.com.bd', 0, 1, '0a97380737af24821f285683902d2477.jpeg', 'https://www.facebook.com/umart', 'https://www.twitter.com/umart', 'https://www.twitter.com/umart', '2025-01-02 01:13:11', NULL);


#
# TABLE STRUCTURE FOR: staff_attendance
#

DROP TABLE IF EXISTS `staff_attendance`;

CREATE TABLE `staff_attendance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) NOT NULL,
  `status` varchar(11) DEFAULT NULL COMMENT 'P=Present, A=Absent, H=Holiday, L=Late',
  `remark` varchar(255) NOT NULL,
  `date` date DEFAULT NULL,
  `branch_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staff_attendance_rms_1` (`branch_id`),
  KEY `staff_attendance_rms_2` (`staff_id`),
  CONSTRAINT `staff_attendance_rms_1` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE,
  CONSTRAINT `staff_attendance_rms_2` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: staff_bank_account
#

DROP TABLE IF EXISTS `staff_bank_account`;

CREATE TABLE `staff_bank_account` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) NOT NULL,
  `bank_name` varchar(200) NOT NULL,
  `holder_name` varchar(255) NOT NULL,
  `bank_branch` varchar(255) NOT NULL,
  `bank_address` varchar(255) NOT NULL,
  `ifsc_code` varchar(200) NOT NULL,
  `account_no` varchar(200) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: staff_department
#

DROP TABLE IF EXISTS `staff_department`;

CREATE TABLE `staff_department` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` longtext NOT NULL,
  `branch_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `staff_department` (`id`, `name`, `branch_id`, `created_at`, `updated_at`) VALUES (2, 'Administrator', 1, '2024-12-27 14:16:31', NULL);


#
# TABLE STRUCTURE FOR: staff_designation
#

DROP TABLE IF EXISTS `staff_designation`;

CREATE TABLE `staff_designation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` longtext NOT NULL,
  `branch_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `staff_designation` (`id`, `name`, `branch_id`, `created_at`, `updated_at`) VALUES (1, 'Asst. Teacher (Bangla)', 1, '2024-12-27 14:08:00', NULL);
INSERT INTO `staff_designation` (`id`, `name`, `branch_id`, `created_at`, `updated_at`) VALUES (2, 'Head Teacher', 1, '2024-12-27 14:16:06', NULL);
INSERT INTO `staff_designation` (`id`, `name`, `branch_id`, `created_at`, `updated_at`) VALUES (3, 'Peon', 1, '2024-12-27 17:04:38', NULL);
INSERT INTO `staff_designation` (`id`, `name`, `branch_id`, `created_at`, `updated_at`) VALUES (4, 'Asst. Head Teacher', 1, '2024-12-27 17:05:04', NULL);
INSERT INTO `staff_designation` (`id`, `name`, `branch_id`, `created_at`, `updated_at`) VALUES (5, 'ICT Teacher', 1, '2024-12-27 17:05:13', NULL);
INSERT INTO `staff_designation` (`id`, `name`, `branch_id`, `created_at`, `updated_at`) VALUES (6, 'Asst. Teacher (English)', 1, '2024-12-27 17:05:40', NULL);
INSERT INTO `staff_designation` (`id`, `name`, `branch_id`, `created_at`, `updated_at`) VALUES (7, 'Asst. Teacher (Math)', 1, '2024-12-27 17:05:46', NULL);
INSERT INTO `staff_designation` (`id`, `name`, `branch_id`, `created_at`, `updated_at`) VALUES (8, 'Asst. Teacher', 1, '2024-12-27 17:05:53', NULL);


#
# TABLE STRUCTURE FOR: staff_documents
#

DROP TABLE IF EXISTS `staff_documents`;

CREATE TABLE `staff_documents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `category_id` varchar(20) NOT NULL,
  `remarks` text NOT NULL,
  `file_name` varchar(255) NOT NULL,
  `enc_name` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: staff_privileges
#

DROP TABLE IF EXISTS `staff_privileges`;

CREATE TABLE `staff_privileges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role_id` int(11) NOT NULL,
  `permission_id` int(11) NOT NULL,
  `is_add` tinyint(1) NOT NULL,
  `is_edit` tinyint(1) NOT NULL,
  `is_view` tinyint(1) NOT NULL,
  `is_delete` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=988 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (1, 3, 1, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (2, 3, 2, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (3, 3, 3, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (4, 3, 4, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (5, 3, 5, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (6, 3, 30, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (7, 3, 7, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (8, 3, 8, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (9, 3, 6, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (10, 3, 9, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (11, 3, 10, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (12, 3, 11, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (13, 3, 12, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (14, 3, 13, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (15, 3, 14, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (16, 3, 15, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (17, 3, 16, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (18, 3, 17, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (20, 3, 19, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (21, 3, 20, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (22, 3, 21, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (23, 3, 22, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (24, 3, 23, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (25, 3, 24, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (26, 3, 25, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (27, 3, 26, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (28, 3, 27, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (29, 3, 28, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (30, 3, 29, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (31, 3, 32, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (32, 3, 31, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (33, 3, 33, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (34, 3, 34, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (35, 3, 35, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (36, 3, 36, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (37, 3, 37, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (38, 3, 38, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (39, 3, 39, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (40, 3, 77, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (41, 3, 78, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (42, 3, 79, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (43, 3, 40, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (44, 3, 41, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (45, 3, 42, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (46, 3, 43, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (47, 3, 44, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (48, 3, 45, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (49, 3, 46, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (50, 3, 47, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (51, 3, 48, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (52, 3, 49, 1, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (53, 3, 50, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (54, 3, 51, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (55, 3, 52, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (56, 3, 53, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (57, 3, 54, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (58, 3, 55, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (59, 3, 56, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (60, 3, 57, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (61, 3, 58, 1, 0, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (62, 3, 59, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (63, 3, 60, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (64, 3, 61, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (65, 3, 62, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (66, 3, 80, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (67, 3, 69, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (68, 3, 70, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (69, 3, 71, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (70, 3, 72, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (71, 3, 73, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (72, 3, 74, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (73, 3, 75, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (74, 3, 76, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (75, 3, 63, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (76, 3, 64, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (77, 3, 65, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (78, 3, 66, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (79, 3, 67, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (80, 3, 68, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (81, 3, 81, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (82, 3, 82, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (83, 3, 83, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (84, 3, 84, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (85, 3, 85, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (86, 3, 86, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (87, 3, 87, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (88, 2, 1, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (89, 2, 2, 1, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (90, 2, 3, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (91, 2, 4, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (92, 2, 5, 1, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (93, 2, 30, 1, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (94, 2, 7, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (95, 2, 8, 1, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (96, 2, 6, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (97, 2, 9, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (98, 2, 10, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (99, 2, 11, 1, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (100, 2, 12, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (101, 2, 13, 1, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (102, 2, 14, 1, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (103, 2, 15, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (104, 2, 16, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (105, 2, 17, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (107, 2, 19, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (108, 2, 20, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (109, 2, 21, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (110, 2, 22, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (111, 2, 23, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (112, 2, 24, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (113, 2, 25, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (114, 2, 26, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (115, 2, 27, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (116, 2, 28, 1, 0, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (117, 2, 29, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (118, 2, 32, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (119, 2, 31, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (120, 2, 33, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (121, 2, 34, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (122, 2, 35, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (123, 2, 36, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (124, 2, 37, 1, 0, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (125, 2, 38, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (126, 2, 39, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (127, 2, 77, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (128, 2, 78, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (129, 2, 79, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (130, 2, 40, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (131, 2, 41, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (132, 2, 42, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (133, 2, 43, 0, 0, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (134, 2, 44, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (135, 2, 45, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (136, 2, 46, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (137, 2, 47, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (138, 2, 48, 0, 0, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (139, 2, 49, 1, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (140, 2, 50, 1, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (141, 2, 51, 1, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (142, 2, 52, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (143, 2, 53, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (144, 2, 54, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (145, 2, 55, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (146, 2, 56, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (147, 2, 57, 1, 0, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (148, 2, 58, 1, 0, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (149, 2, 59, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (150, 2, 60, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (151, 2, 61, 1, 0, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (152, 2, 62, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (153, 2, 80, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (154, 2, 69, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (155, 2, 70, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (156, 2, 71, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (157, 2, 72, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (158, 2, 73, 1, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (159, 2, 74, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (160, 2, 75, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (161, 2, 76, 0, 0, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (162, 2, 63, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (163, 2, 64, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (164, 2, 65, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (165, 2, 66, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (166, 2, 67, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (167, 2, 68, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (168, 2, 81, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (169, 2, 82, 1, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (170, 2, 83, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (171, 2, 84, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (172, 2, 85, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (173, 2, 86, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (174, 2, 87, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (175, 7, 1, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (176, 7, 2, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (177, 7, 3, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (178, 7, 4, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (179, 7, 5, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (180, 7, 30, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (181, 7, 7, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (182, 7, 8, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (183, 7, 6, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (184, 7, 9, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (185, 7, 10, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (186, 7, 11, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (187, 7, 12, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (188, 7, 13, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (189, 7, 14, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (190, 7, 15, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (191, 7, 16, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (192, 7, 17, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (194, 7, 19, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (195, 7, 20, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (196, 7, 21, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (197, 7, 22, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (198, 7, 23, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (199, 7, 24, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (200, 7, 25, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (201, 7, 26, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (202, 7, 27, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (203, 7, 28, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (204, 7, 29, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (205, 7, 32, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (206, 7, 31, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (207, 7, 33, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (208, 7, 34, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (209, 7, 35, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (210, 7, 36, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (211, 7, 37, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (212, 7, 38, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (213, 7, 39, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (214, 7, 77, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (215, 7, 78, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (216, 7, 79, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (217, 7, 40, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (218, 7, 41, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (219, 7, 42, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (220, 7, 43, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (221, 7, 44, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (222, 7, 45, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (223, 7, 46, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (224, 7, 47, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (225, 7, 48, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (226, 7, 49, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (227, 7, 50, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (228, 7, 51, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (229, 7, 52, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (230, 7, 53, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (231, 7, 54, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (232, 7, 55, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (233, 7, 56, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (234, 7, 57, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (235, 7, 58, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (236, 7, 59, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (237, 7, 60, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (238, 7, 61, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (239, 7, 62, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (240, 7, 80, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (241, 7, 69, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (242, 7, 70, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (243, 7, 71, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (244, 7, 72, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (245, 7, 73, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (246, 7, 74, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (247, 7, 75, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (248, 7, 76, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (249, 7, 63, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (250, 7, 64, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (251, 7, 65, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (252, 7, 66, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (253, 7, 67, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (254, 7, 68, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (255, 7, 81, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (256, 7, 82, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (257, 7, 83, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (258, 7, 84, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (259, 7, 85, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (260, 7, 86, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (261, 7, 87, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (262, 88, 88, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (263, 88, 88, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (264, 89, 89, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (265, 90, 90, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (266, 2, 88, 1, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (267, 2, 89, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (268, 90, 90, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (269, 2, 90, 0, 1, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (270, 91, 91, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (271, 92, 92, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (272, 2, 91, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (273, 2, 92, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (274, 93, 93, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (275, 94, 94, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (276, 95, 95, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (277, 96, 96, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (278, 2, 93, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (279, 2, 94, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (280, 2, 95, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (281, 2, 96, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (282, 97, 97, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (283, 98, 98, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (284, 2, 97, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (285, 2, 98, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (286, 99, 99, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (287, 100, 100, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (288, 101, 101, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (289, 102, 102, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (290, 2, 99, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (291, 2, 100, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (292, 2, 101, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (293, 2, 102, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (294, 103, 103, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (295, 2, 103, 0, 1, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (296, 3, 91, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (297, 3, 92, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (298, 3, 93, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (299, 3, 94, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (300, 3, 95, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (301, 3, 96, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (302, 3, 97, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (303, 3, 98, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (304, 3, 99, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (305, 3, 100, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (306, 3, 101, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (307, 3, 102, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (308, 3, 88, 1, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (309, 3, 89, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (310, 3, 90, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (311, 3, 103, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (312, 4, 91, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (313, 4, 92, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (314, 4, 93, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (315, 4, 94, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (316, 4, 95, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (317, 4, 96, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (318, 4, 97, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (319, 4, 98, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (320, 4, 99, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (321, 4, 100, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (322, 4, 101, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (323, 4, 102, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (324, 4, 1, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (325, 4, 2, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (326, 4, 3, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (327, 4, 4, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (328, 4, 5, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (329, 4, 30, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (330, 4, 7, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (331, 4, 8, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (332, 4, 6, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (333, 4, 9, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (334, 4, 10, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (335, 4, 11, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (336, 4, 12, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (337, 4, 13, 1, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (338, 4, 14, 1, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (339, 4, 15, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (340, 4, 16, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (341, 4, 17, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (343, 4, 19, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (344, 4, 20, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (345, 4, 21, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (346, 4, 22, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (347, 4, 23, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (348, 4, 24, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (349, 4, 25, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (350, 4, 26, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (351, 4, 27, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (352, 4, 28, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (353, 4, 29, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (354, 4, 32, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (355, 4, 88, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (356, 4, 89, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (357, 4, 31, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (358, 4, 33, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (359, 4, 34, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (360, 4, 35, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (361, 4, 36, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (362, 4, 37, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (363, 4, 38, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (364, 4, 39, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (365, 4, 77, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (366, 4, 78, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (367, 4, 79, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (368, 4, 40, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (369, 4, 41, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (370, 4, 42, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (371, 4, 43, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (372, 4, 44, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (373, 4, 45, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (374, 4, 46, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (375, 4, 47, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (376, 4, 48, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (377, 4, 49, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (378, 4, 50, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (379, 4, 51, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (380, 4, 52, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (381, 4, 53, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (382, 4, 54, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (383, 4, 55, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (384, 4, 56, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (385, 4, 57, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (386, 4, 58, 1, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (387, 4, 59, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (388, 4, 60, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (389, 4, 61, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (390, 4, 62, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (391, 4, 80, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (392, 4, 69, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (393, 4, 70, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (394, 4, 71, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (395, 4, 72, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (396, 4, 73, 1, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (397, 4, 74, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (398, 4, 75, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (399, 4, 76, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (400, 4, 63, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (401, 4, 64, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (402, 4, 65, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (403, 4, 66, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (404, 4, 67, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (405, 4, 68, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (406, 4, 81, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (407, 4, 82, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (408, 4, 83, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (409, 4, 84, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (410, 4, 85, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (411, 4, 86, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (412, 4, 87, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (413, 4, 90, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (414, 4, 103, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (415, 5, 91, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (416, 5, 92, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (417, 5, 93, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (418, 5, 94, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (419, 5, 95, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (420, 5, 96, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (421, 5, 97, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (422, 5, 98, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (423, 5, 99, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (424, 5, 100, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (425, 5, 101, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (426, 5, 102, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (427, 5, 1, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (428, 5, 2, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (429, 5, 3, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (430, 5, 4, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (431, 5, 5, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (432, 5, 30, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (433, 5, 7, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (434, 5, 8, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (435, 5, 6, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (436, 5, 9, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (437, 5, 10, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (438, 5, 11, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (439, 5, 12, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (440, 5, 13, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (441, 5, 14, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (442, 5, 15, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (443, 5, 16, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (444, 5, 17, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (446, 5, 19, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (447, 5, 20, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (448, 5, 21, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (449, 5, 22, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (450, 5, 23, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (451, 5, 24, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (452, 5, 25, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (453, 5, 26, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (454, 5, 27, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (455, 5, 28, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (456, 5, 29, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (457, 5, 32, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (458, 5, 88, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (459, 5, 89, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (460, 5, 31, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (461, 5, 33, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (462, 5, 34, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (463, 5, 35, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (464, 5, 36, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (465, 5, 37, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (466, 5, 38, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (467, 5, 39, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (468, 5, 77, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (469, 5, 78, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (470, 5, 79, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (471, 5, 40, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (472, 5, 41, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (473, 5, 42, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (474, 5, 43, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (475, 5, 44, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (476, 5, 45, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (477, 5, 46, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (478, 5, 47, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (479, 5, 48, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (480, 5, 49, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (481, 5, 50, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (482, 5, 51, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (483, 5, 52, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (484, 5, 53, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (485, 5, 54, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (486, 5, 55, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (487, 5, 56, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (488, 5, 57, 1, 0, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (489, 5, 58, 1, 0, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (490, 5, 59, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (491, 5, 60, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (492, 5, 61, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (493, 5, 62, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (494, 5, 80, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (495, 5, 69, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (496, 5, 70, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (497, 5, 71, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (498, 5, 72, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (499, 5, 73, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (500, 5, 74, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (501, 5, 75, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (502, 5, 76, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (503, 5, 63, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (504, 5, 64, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (505, 5, 65, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (506, 5, 66, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (507, 5, 67, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (508, 5, 68, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (509, 5, 81, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (510, 5, 82, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (511, 5, 83, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (512, 5, 84, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (513, 5, 85, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (514, 5, 86, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (515, 5, 87, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (516, 5, 90, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (517, 5, 103, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (518, 104, 104, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (519, 2, 104, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (520, 4, 104, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (521, 2, 18, 1, 0, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (522, 2, 105, 0, 1, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (523, 2, 106, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (524, 2, 107, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (525, 2, 109, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (526, 2, 108, 0, 1, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (527, 3, 18, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (528, 3, 107, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (529, 3, 109, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (530, 3, 104, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (531, 3, 105, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (532, 3, 106, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (533, 3, 108, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (534, 2, 110, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (535, 2, 111, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (536, 2, 112, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (537, 2, 113, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (538, 2, 114, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (539, 2, 115, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (540, 2, 116, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (541, 2, 117, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (542, 3, 110, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (543, 3, 111, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (544, 3, 112, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (545, 3, 113, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (546, 3, 114, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (547, 3, 115, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (548, 3, 116, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (549, 3, 117, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (550, 2, 127, 1, 0, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (551, 2, 118, 1, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (552, 2, 119, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (553, 2, 120, 1, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (554, 2, 121, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (555, 2, 122, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (556, 2, 123, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (557, 2, 124, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (558, 2, 125, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (559, 2, 126, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (560, 3, 118, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (561, 3, 119, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (562, 3, 120, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (563, 3, 121, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (564, 3, 122, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (565, 3, 123, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (566, 3, 124, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (567, 3, 125, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (568, 3, 126, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (569, 3, 127, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (570, 3, 128, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (571, 2, 129, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (572, 2, 128, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (573, 2, 131, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (574, 2, 132, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (575, 2, 130, 0, 0, 0, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (576, 4, 118, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (577, 4, 119, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (578, 4, 120, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (579, 4, 121, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (580, 4, 122, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (581, 4, 123, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (582, 4, 124, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (583, 4, 125, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (584, 4, 126, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (585, 4, 131, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (586, 4, 132, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (587, 4, 127, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (588, 4, 113, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (589, 4, 114, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (590, 4, 115, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (591, 4, 116, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (592, 4, 117, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (593, 4, 110, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (594, 4, 111, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (595, 4, 112, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (596, 4, 18, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (597, 4, 107, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (598, 4, 109, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (599, 4, 129, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (600, 4, 130, 0, 0, 0, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (601, 4, 105, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (602, 4, 106, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (603, 4, 108, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (604, 4, 128, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (605, 2, 131, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (606, 2, 132, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (607, 2, 133, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (608, 3, 133, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (609, 2, 134, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (610, 2, 136, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (611, 2, 137, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (612, 2, 138, 1, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (613, 2, 139, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (614, 2, 140, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (615, 2, 135, 0, 1, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (616, 3, 131, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (617, 3, 132, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (618, 3, 129, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (619, 3, 130, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (620, 3, 136, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (621, 3, 137, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (622, 3, 138, 1, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (623, 3, 139, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (624, 3, 140, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (625, 3, 134, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (626, 3, 135, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (627, 2, 141, 1, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (628, 2, 142, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (629, 2, 143, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (630, 2, 144, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (631, 2, 145, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (632, 2, 146, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (633, 2, 147, 1, 0, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (634, 2, 148, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (635, 2, 149, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (636, 2, 150, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (637, 2, 151, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (638, 2, 152, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (639, 2, 153, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (640, 8, 91, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (641, 8, 92, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (642, 8, 93, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (643, 8, 94, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (644, 8, 95, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (645, 8, 96, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (646, 8, 97, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (647, 8, 98, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (648, 8, 99, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (649, 8, 100, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (650, 8, 101, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (651, 8, 102, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (652, 8, 151, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (653, 8, 152, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (654, 8, 118, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (655, 8, 119, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (656, 8, 120, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (657, 8, 121, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (658, 8, 122, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (659, 8, 123, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (660, 8, 124, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (661, 8, 125, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (662, 8, 126, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (663, 8, 131, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (664, 8, 132, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (665, 8, 1, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (666, 8, 2, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (667, 8, 3, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (668, 8, 4, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (669, 8, 5, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (670, 8, 30, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (671, 8, 127, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (672, 8, 7, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (673, 8, 8, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (674, 8, 6, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (675, 8, 9, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (676, 8, 10, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (677, 8, 11, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (678, 8, 113, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (679, 8, 114, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (680, 8, 115, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (681, 8, 116, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (682, 8, 117, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (683, 8, 110, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (684, 8, 111, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (685, 8, 112, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (686, 8, 12, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (687, 8, 13, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (688, 8, 14, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (689, 8, 15, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (690, 8, 16, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (691, 8, 17, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (692, 8, 18, 1, 0, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (693, 8, 19, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (694, 8, 20, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (695, 8, 21, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (696, 8, 22, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (697, 8, 107, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (698, 8, 23, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (699, 8, 24, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (700, 8, 25, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (701, 8, 26, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (702, 8, 27, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (703, 8, 28, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (704, 8, 29, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (705, 8, 133, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (706, 8, 109, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (707, 8, 129, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (708, 8, 31, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (709, 8, 33, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (710, 8, 32, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (711, 8, 88, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (712, 8, 89, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (713, 8, 34, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (714, 8, 35, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (715, 8, 36, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (716, 8, 37, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (717, 8, 38, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (718, 8, 39, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (719, 8, 77, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (720, 8, 78, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (721, 8, 79, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (722, 8, 153, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (723, 8, 40, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (724, 8, 41, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (725, 8, 42, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (726, 8, 43, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (727, 8, 44, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (728, 8, 45, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (729, 8, 46, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (730, 8, 47, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (731, 8, 48, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (732, 8, 49, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (733, 8, 50, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (734, 8, 51, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (735, 8, 52, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (736, 8, 53, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (737, 8, 54, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (738, 8, 55, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (739, 8, 56, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (740, 8, 57, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (741, 8, 58, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (742, 8, 59, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (743, 8, 60, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (744, 8, 61, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (745, 8, 62, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (746, 8, 80, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (747, 8, 149, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (748, 8, 150, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (749, 8, 69, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (750, 8, 70, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (751, 8, 71, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (752, 8, 72, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (753, 8, 73, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (754, 8, 74, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (755, 8, 75, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (756, 8, 76, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (757, 8, 104, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (758, 8, 130, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (759, 8, 63, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (760, 8, 64, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (761, 8, 65, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (762, 8, 66, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (763, 8, 67, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (764, 8, 68, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (765, 8, 136, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (766, 8, 137, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (767, 8, 138, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (768, 8, 139, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (769, 8, 140, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (770, 8, 141, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (771, 8, 142, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (772, 8, 143, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (773, 8, 144, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (774, 8, 145, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (775, 8, 146, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (776, 8, 147, 1, 0, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (777, 8, 148, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (778, 8, 81, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (779, 8, 82, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (780, 8, 83, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (781, 8, 84, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (782, 8, 85, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (783, 8, 86, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (784, 8, 87, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (785, 8, 90, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (786, 8, 103, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (787, 8, 105, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (788, 8, 106, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (789, 8, 108, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (790, 8, 128, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (791, 8, 134, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (792, 8, 135, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (793, 2, 157, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (794, 2, 158, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (795, 2, 159, 1, 1, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (796, 2, 160, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (797, 2, 161, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (798, 2, 162, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (799, 2, 163, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (800, 2, 164, 1, 0, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (801, 2, 165, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (802, 2, 166, 1, 0, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (803, 2, 167, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (804, 2, 168, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (805, 2, 173, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (806, 2, 154, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (807, 2, 174, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (808, 2, 155, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (809, 2, 156, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (810, 2, 169, 0, 0, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (811, 2, 170, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (812, 2, 171, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (813, 2, 172, 1, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (814, 9, 91, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (815, 9, 92, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (816, 9, 93, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (817, 9, 94, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (818, 9, 95, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (819, 9, 96, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (820, 9, 97, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (821, 9, 98, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (822, 9, 99, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (823, 9, 100, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (824, 9, 101, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (825, 9, 102, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (826, 9, 151, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (827, 9, 152, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (828, 9, 118, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (829, 9, 119, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (830, 9, 120, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (831, 9, 121, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (832, 9, 122, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (833, 9, 123, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (834, 9, 124, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (835, 9, 125, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (836, 9, 126, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (837, 9, 131, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (838, 9, 132, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (839, 9, 173, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (840, 9, 142, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (841, 9, 143, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (842, 9, 144, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (843, 9, 145, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (844, 9, 146, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (845, 9, 147, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (846, 9, 148, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (847, 9, 157, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (848, 9, 158, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (849, 9, 159, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (850, 9, 160, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (851, 9, 161, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (852, 9, 162, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (853, 9, 163, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (854, 9, 164, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (855, 9, 165, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (856, 9, 166, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (857, 9, 167, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (858, 9, 1, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (859, 9, 2, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (860, 9, 3, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (861, 9, 4, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (862, 9, 5, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (863, 9, 30, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (864, 9, 127, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (865, 9, 154, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (866, 9, 7, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (867, 9, 8, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (868, 9, 6, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (869, 9, 9, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (870, 9, 10, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (871, 9, 11, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (872, 9, 113, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (873, 9, 114, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (874, 9, 115, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (875, 9, 116, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (876, 9, 117, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (877, 9, 110, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (878, 9, 111, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (879, 9, 112, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (880, 9, 12, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (881, 9, 13, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (882, 9, 14, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (883, 9, 15, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (884, 9, 16, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (885, 9, 17, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (886, 9, 18, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (887, 9, 19, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (888, 9, 20, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (889, 9, 21, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (890, 9, 22, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (891, 9, 107, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (892, 9, 23, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (893, 9, 24, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (894, 9, 25, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (895, 9, 26, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (896, 9, 27, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (897, 9, 28, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (898, 9, 29, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (899, 9, 133, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (900, 9, 109, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (901, 9, 129, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (902, 9, 31, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (903, 9, 33, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (904, 9, 32, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (905, 9, 88, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (906, 9, 89, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (907, 9, 34, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (908, 9, 35, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (909, 9, 36, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (910, 9, 37, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (911, 9, 38, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (912, 9, 39, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (913, 9, 77, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (914, 9, 78, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (915, 9, 79, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (916, 9, 153, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (917, 9, 168, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (918, 9, 174, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (919, 9, 136, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (920, 9, 137, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (921, 9, 138, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (922, 9, 139, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (923, 9, 140, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (924, 9, 141, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (925, 9, 40, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (926, 9, 41, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (927, 9, 42, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (928, 9, 43, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (929, 9, 44, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (930, 9, 45, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (931, 9, 46, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (932, 9, 47, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (933, 9, 48, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (934, 9, 49, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (935, 9, 50, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (936, 9, 51, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (937, 9, 52, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (938, 9, 53, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (939, 9, 54, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (940, 9, 55, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (941, 9, 56, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (942, 9, 57, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (943, 9, 58, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (944, 9, 59, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (945, 9, 60, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (946, 9, 61, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (947, 9, 62, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (948, 9, 80, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (949, 9, 149, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (950, 9, 150, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (951, 9, 69, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (952, 9, 70, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (953, 9, 71, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (954, 9, 72, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (955, 9, 73, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (956, 9, 74, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (957, 9, 75, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (958, 9, 76, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (959, 9, 104, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (960, 9, 130, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (961, 9, 155, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (962, 9, 156, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (963, 9, 63, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (964, 9, 64, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (965, 9, 65, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (966, 9, 66, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (967, 9, 67, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (968, 9, 68, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (969, 9, 81, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (970, 9, 82, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (971, 9, 83, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (972, 9, 84, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (973, 9, 85, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (974, 9, 86, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (975, 9, 87, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (976, 9, 90, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (977, 9, 103, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (978, 9, 105, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (979, 9, 106, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (980, 9, 108, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (981, 9, 128, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (982, 9, 134, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (983, 9, 135, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (984, 9, 169, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (985, 9, 170, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (986, 9, 171, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (987, 9, 172, 0, 0, 0, 0);


#
# TABLE STRUCTURE FOR: student
#

DROP TABLE IF EXISTS `student`;

CREATE TABLE `student` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `register_no` varchar(100) DEFAULT NULL,
  `admission_date` varchar(100) DEFAULT NULL,
  `first_name` varchar(255) DEFAULT NULL,
  `last_name` varchar(255) DEFAULT NULL,
  `gender` varchar(20) DEFAULT NULL,
  `birthday` varchar(100) DEFAULT NULL,
  `religion` varchar(100) DEFAULT NULL,
  `caste` varchar(100) DEFAULT NULL,
  `blood_group` varchar(100) DEFAULT NULL,
  `mother_tongue` varchar(100) DEFAULT NULL,
  `current_address` text DEFAULT NULL,
  `permanent_address` text DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  `mobileno` varchar(100) DEFAULT NULL,
  `category_id` int(11) NOT NULL DEFAULT 0,
  `email` varchar(100) DEFAULT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `route_id` int(11) NOT NULL DEFAULT 0,
  `vehicle_id` int(11) NOT NULL DEFAULT 0,
  `hostel_id` int(11) NOT NULL DEFAULT 0,
  `room_id` int(11) NOT NULL DEFAULT 0,
  `previous_details` text DEFAULT NULL,
  `photo` varchar(100) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=328 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (56, '240001', '1969-12-31', 'MD.', 'ABDULLAH', 'MALE', '1969-12-31', 'ISLAM', '', '', '', '', '', '', '', '', 0, '7/25/2024 0:00', 56, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:19:37', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (57, '240002', '1969-12-31', 'MIHAN', 'KHAN', 'MALE', '1969-12-31', 'ISLAM', '', '', '', '', '', '', '', '', 0, '7/25/2024 0:00', 57, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:19:37', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (58, '240003', '1969-12-31', 'MAHMUDUL HASAN', 'MIRAZ', 'MALE', '1969-12-31', 'ISLAM', '', '', '', '', '', '', '', '', 0, '7/29/2024 0:00', 58, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:19:37', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (59, '240004', '1969-12-31', 'RAFSIN MAHMUD', 'MAHIM', 'MALE', '1969-12-31', 'ISLAM', '', '', '', '', '', '', '', '', 0, '7/29/2024 0:00', 59, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:19:37', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (60, '240005', '1969-12-31', 'JISAN', '', 'MALE', '1969-12-31', 'ISLAM', '', '', '', '', '', '', '', '', 0, '7/29/2024 0:00', 60, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:19:37', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (61, '240006', '1969-12-31', 'KHANDOKAR', 'TAJBIR', 'MALE', '1969-12-31', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 61, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:19:38', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (62, '240007', '1969-12-31', 'MAISHA', 'MONI', 'FEMALE', '1969-12-31', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 62, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:19:38', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (63, '240008', '1969-12-31', 'SAIF', 'AHSAN', 'MALE', '1969-12-31', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 63, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:19:38', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (64, '240009', '1969-12-31', 'ANISHA', '', 'FEMALE', '1969-12-31', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 64, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:19:38', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (65, '240010', '1969-12-31', 'ANNIKA', '', 'FEMALE', '1969-12-31', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 65, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:19:38', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (66, '240011', '1969-12-31', 'JANOKI', 'BISWAS', 'FEMALE', '1969-12-31', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 66, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:19:38', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (67, '240012', '1969-12-31', 'APURBA CHANDRA', 'BISWAS', 'MALE', '1969-12-31', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 67, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:19:38', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (68, '240013', '1969-12-31', 'TANBIA', 'JAHAN', 'FEMALE', '1969-12-31', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 68, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:19:38', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (69, '240014', '1969-12-31', 'ABRAR', 'FAIYAZ', 'MALE', '1969-12-31', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 69, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:19:39', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (70, '240015', '1969-12-31', 'JANNATUL FERDAUS', 'MAWA', 'FEMALE', '1969-12-31', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 70, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:19:39', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (71, '240016', '1969-12-31', 'TANHA', 'AKTER', 'FEMALE', '1969-12-31', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 71, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:19:39', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (72, '240017', '1969-12-31', 'SIMI', '', 'FEMALE', '1969-12-31', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 72, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:19:39', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (73, '240018', '1969-12-31', 'MAIMUNA', 'BUSHRA', 'FEMALE', '1969-12-31', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 73, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:19:39', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (74, '240019', '1969-12-31', 'MAIMUNA AKTER', 'MORIOM', 'FEMALE', '1969-12-31', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 74, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:19:39', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (75, '240021', '1969-12-31', 'MONTAHA', '', 'FEMALE', '1969-12-31', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 75, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:19:39', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (76, '240022', '1969-12-31', 'HASAN', '', 'MALE', '1969-12-31', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 76, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:19:39', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (77, '240024', '1969-12-31', 'ISMAT JAHAN', 'AFIYA', 'FEMALE', '1969-12-31', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 77, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:19:39', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (78, '240025', '1969-12-31', 'SAFWAN', '', 'MALE', '1969-12-31', 'ISLAM', '', '', '', '', '', '', '', '', 0, '5/11/2024 0:00', 78, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:19:40', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (79, '240026', '1969-12-31', 'FARIA AKTER', 'NEHA', 'FEMALE', '1969-12-31', 'ISLAM', '', '', '', '', '', '', '', '', 0, '5/11/2024 0:00', 79, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:19:40', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (80, '240027', '1969-12-31', 'ABRAR', 'HASAN', 'MALE', '1969-12-31', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 80, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:19:40', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (81, '240028', '1969-12-31', 'SAMIA', 'AKTER', 'FEMALE', '1969-12-31', 'ISLAM', '', '', '', '', '', '', '', '', 0, '5/11/2024 0:00', 81, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:19:40', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (82, '240029', '1969-12-31', 'ABDUR RAHMAN', 'ADIL', 'MALE', '1969-12-31', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 82, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:19:40', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (83, '240030', '1969-12-31', 'SHOAIB', '', 'MALE', '1969-12-31', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 83, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:19:40', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (84, '240031', '1969-12-31', 'RIFAT', '', 'MALE', '1969-12-31', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 84, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:19:40', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (85, '240032', '1969-12-31', 'YASIN', '', 'MALE', '1969-12-31', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 85, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:19:40', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (86, '240033', '1969-12-31', 'NEEL', '', 'MALE', '1969-12-31', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 86, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:19:41', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (87, '240034', '1969-12-31', 'ARIYAN', '', 'MALE', '1969-12-31', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 87, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:19:41', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (88, '240035', '1969-12-31', 'JIM', '', 'MALE', '1969-12-31', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 88, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:19:41', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (89, '240036', '1969-12-31', 'SUDIPTO', 'DEY', 'MALE', '1969-12-31', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 89, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:19:41', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (90, '240037', '1969-12-31', 'MOBASSHIRA', '', 'FEMALE', '1969-12-31', 'ISLAM', '', '', '', '', '', '', '', '', 0, '5/11/2024 0:00', 90, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:19:41', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (91, '240038', '1969-12-31', 'MIZAN', '', 'MALE', '1969-12-31', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 91, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:19:41', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (92, '240039', '1969-12-31', 'YEASIN ARAFAT', 'RAMIM', 'MALE', '1969-12-31', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 92, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:19:41', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (93, '240041', '1969-12-31', 'MOKARRIM', 'HOSSEN', 'MALE', '1969-12-31', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 93, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:19:41', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (94, '240042', '1969-12-31', 'MINHA', '', 'FEMALE', '1969-12-31', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 94, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:19:42', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (95, '240043', '1969-12-31', 'TANVIR AL', 'RAFI', 'MALE', '1969-12-31', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 95, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:19:42', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (96, '240044', '1969-12-31', 'HAMIM', '', 'MALE', '1969-12-31', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 96, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:19:42', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (97, '240045', '1969-12-31', 'ESHA', 'MUKTER', 'FEMALE', '1969-12-31', 'ISLAM', '', '', '', '', '', '', '', '', 0, '5/11/2024 0:00', 97, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:19:42', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (98, '240046', '1969-12-31', 'BILLAL', 'HOSSAIN', 'MALE', '1969-12-31', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 98, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:19:42', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (99, '240047', '1969-12-31', 'MINHAJ', '', 'MALE', '1969-12-31', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 99, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:19:42', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (100, '240048', '1969-12-31', 'FATEMA', '', 'FEMALE', '1969-12-31', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 100, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:19:42', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (101, '240020', '1970-01-01', 'ABIDA', 'SINHA', 'MALE', '2020-03-14', 'ISLAM', '', '', '', '', 'vill: Kachihara Post: Kachihar,6712 , Thana : Kazipur , Dist: Sirajganj', '', '', '', 0, '', 101, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:22:37', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (102, '240023', '1970-01-01', 'RAIYAN HASAN', 'ADIB', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 102, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:22:37', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (103, '240040', '1970-01-01', 'RAMIM', '', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 103, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:22:37', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (104, '240049', '1970-01-01', 'ANISHA', '', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 104, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:24:24', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (105, '240050', '1970-01-01', 'HUSAIN AHMED', 'LABIB', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '5/11/2024 0:00', 105, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:24:25', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (106, '240051', '1970-01-01', 'SAYON AHMED', 'SIHAN', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '5/11/2024 0:00', 106, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:24:25', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (107, '240052', '1970-01-01', 'RAWZATUL', 'JANANT', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '7/29/2024 0:00', 107, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:24:25', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (108, '240053', '1970-01-01', 'MD. ANIK', '', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '9/26/2024 0:00', 108, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:24:25', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (109, '240054', '1970-01-01', 'MD. SAFIUL HASAN', 'IMRAN', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 109, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:24:25', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (110, '240055', '1970-01-01', 'ANAN', 'ANRAR', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 110, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:24:25', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (111, '240056', '1970-01-01', 'NUSRAT JAHAN', 'HIMU', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 111, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:24:25', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (112, '240057', '1970-01-01', 'NUSRAT JAHAN', 'MOON', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 112, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:24:25', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (113, '240058', '1970-01-01', 'MARUFA', 'AKTER', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 113, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:24:26', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (114, '240059', '1970-01-01', 'TANHA', '', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 114, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:24:26', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (115, '240060', '1970-01-01', 'SALMAN', 'FARSI', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 115, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:24:26', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (116, '240061', '1970-01-01', 'AYESHA', 'AKTER', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 116, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:24:26', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (117, '240062', '1970-01-01', 'AYESHA NUJHAT', 'NAZA', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 117, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:24:26', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (118, '240063', '1970-01-01', 'AL', 'RAFI', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 118, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:24:26', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (119, '240064', '1970-01-01', 'NISA', '', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 119, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:24:26', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (120, '240065', '1970-01-01', 'SALMAN', 'FARSI', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 120, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:24:26', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (121, '240066', '1970-01-01', 'LIZA', '', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 121, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:24:27', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (122, '240067', '1970-01-01', 'ATIKA AKTER', 'SHIMU', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 122, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:24:27', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (123, '240068', '1970-01-01', 'ISMAIL', '', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 123, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:24:27', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (124, '240069', '1970-01-01', 'MUSAID', '', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 124, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:24:27', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (125, '240070', '1970-01-01', 'MODINA', '', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 125, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:24:27', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (126, '240071', '1970-01-01', 'JUNAID', '', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 126, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:24:27', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (127, '240072', '1970-01-01', 'SHOUROV', '', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 127, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:24:27', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (128, '240073', '1970-01-01', 'PUSHPITA', '', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 128, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:24:27', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (129, '240074', '1970-01-01', 'TANISHA', '', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 129, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:24:27', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (130, '240075', '1970-01-01', 'SUMAIYA', '', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 130, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:24:28', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (131, '240076', '1970-01-01', 'JUNAYED', '', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 131, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:24:28', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (132, '240077', '1970-01-01', 'JONAKI', '', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 132, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:24:28', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (133, '240078', '1970-01-01', 'ASHRAFUL HASAN', 'JISHAN', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 133, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:24:28', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (134, '240079', '1970-01-01', 'DIP', '', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 134, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:24:28', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (135, '240080', '1970-01-01', 'ARAFAT', 'SANI', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 135, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:24:28', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (136, '240081', '1970-01-01', 'SAYED', 'HASAN', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 136, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:24:28', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (137, '240082', '1970-01-01', 'MAHIM', '', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '5/11/2024 0:00', 137, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:24:28', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (138, '240083', '1970-01-01', 'ASHIK', 'MOLLA', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '9/17/2024 0:00', 138, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:24:29', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (139, '240084', '1970-01-01', 'JIHAD', '', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '5/11/2024 0:00', 139, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:26:08', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (140, '240085', '1970-01-01', 'SHARMIN JAHAN', 'TASMIA', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '7/16/2024 0:00', 140, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:26:08', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (141, '240086', '1970-01-01', 'MD. YASIN', 'ARAFAT', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '7/16/2024 0:00', 141, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:26:08', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (142, '240087', '1970-01-01', 'NABIHA', '', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '7/16/2024 0:00', 142, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:26:08', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (143, '240088', '1970-01-01', 'TANISHA', '', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '9/26/2024 0:00', 143, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:26:08', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (144, '240089', '1970-01-01', 'TABASSUM', '', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 144, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:26:08', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (145, '240090', '1970-01-01', 'MEHEDI HASAN', 'JOY', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 145, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:26:08', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (146, '240091', '1970-01-01', 'SAIMA', '', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 146, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:26:08', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (147, '240092', '1970-01-01', 'SHAKIB', 'HASAN', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 147, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:26:09', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (148, '240093', '1970-01-01', 'SADIA', 'AKTER', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 148, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:26:09', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (149, '240094', '1970-01-01', 'SAKIBUL HASAN', 'HAMIM', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 149, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:26:09', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (150, '240095', '1970-01-01', 'MD.', 'EBRAHIM', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 150, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:26:09', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (151, '240096', '1970-01-01', 'ANISHA', '', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 151, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:26:09', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (152, '240097', '1970-01-01', 'JANNATUL', 'FERDOUSI', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 152, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:26:09', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (153, '240098', '1970-01-01', 'HABIBA', '', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 153, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:26:09', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (154, '240099', '1970-01-01', 'MAHIM', '', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 154, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:26:09', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (155, '240100', '1970-01-01', 'JUNAYED AHMED', 'HAMIM', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 155, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:26:10', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (156, '240101', '1970-01-01', 'SOMAYA AKTER', 'KABITA', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 156, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:26:10', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (157, '240102', '1970-01-01', 'ABDULLAH AL', 'MAMUN', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 157, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:26:10', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (158, '240103', '1970-01-01', 'MAHMUDA AKTER', 'MIM', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 158, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:26:10', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (159, '240104', '1970-01-01', 'MAHI', '', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 159, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:26:10', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (160, '240105', '1970-01-01', 'SHANJIDA', '', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 160, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:26:10', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (161, '240106', '1970-01-01', 'BITHI', '', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 161, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:26:10', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (162, '240107', '1970-01-01', 'TANZILA', '', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 162, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:26:10', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (163, '240108', '1970-01-01', 'RUMANA', '', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 163, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:26:11', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (164, '240109', '1970-01-01', 'MITHILA', '', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 164, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:26:11', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (165, '240110', '1970-01-01', 'ALIF', '', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 165, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:26:11', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (166, '240111', '1970-01-01', 'PUJA', 'BISWAS', 'FEMALE', '1970-01-01', 'HINDU', '', '', '', '', '', '', '', '', 0, '', 166, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:26:11', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (167, '240112', '1970-01-01', 'JUI', '', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 167, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:26:11', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (168, '240113', '1970-01-01', 'ASHA', 'MONI', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 168, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:26:11', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (169, '240114', '1970-01-01', 'WAZID', '', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 169, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:26:11', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (170, '240115', '1970-01-01', 'TANVIR', 'ISLAM', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 170, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:26:11', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (171, '240116', '1970-01-01', 'HALIMA', 'MEHZABIN', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 171, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:26:12', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (172, '240117', '1970-01-01', 'HALIMA', '', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 172, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:26:12', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (173, '240118', '1970-01-01', 'HALIMATUS', 'SADIA', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 173, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:26:12', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (174, '240119', '1970-01-01', 'SHADIN', '', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '5/11/2024 0:00', 174, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:26:12', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (175, '240120', '1970-01-01', 'MONISHA', '', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 175, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:26:12', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (176, '240121', '1970-01-01', 'SUHANA', '', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '5/11/2024 0:00', 176, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:26:12', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (177, '240122', '1970-01-01', 'NONDINI', '', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 177, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:26:12', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (178, '240123', '1970-01-01', 'RUMANA', '', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 178, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:26:12', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (179, '240124', '1970-01-01', 'AFRAH AL', 'NUSRAT', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '5/11/2024 0:00', 179, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:28:14', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (180, '240125', '1970-01-01', 'TOUA MONI', '', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '9/17/2024 0:00', 180, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:28:14', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (181, '240126', '1970-01-01', 'NABIHA SHUHILA', 'ARSHIYA', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '9/17/2024 0:00', 181, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:28:14', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (182, '240127', '1970-01-01', 'NAIMA JANNATUN', 'MEEM', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 182, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:28:14', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (183, '240128', '1970-01-01', 'SATHI', 'AKTER', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '9/26/2024 0:00', 183, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:28:14', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (184, '240129', '1970-01-01', 'SHARAFINA', 'ZONAIRA', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 184, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:28:15', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (185, '240130', '1970-01-01', 'MAHIBA', 'ARIYA', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 185, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:28:15', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (186, '240131', '1970-01-01', 'RAMISHA', '', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 186, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:28:15', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (187, '240132', '1970-01-01', 'AFSANA', 'MIMI', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 187, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:28:15', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (188, '240133', '1970-01-01', 'ABDULLAH AL', 'SAAD', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 188, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:28:15', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (189, '240134', '1970-01-01', 'ABID', 'HASAN', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 189, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:28:15', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (190, '240135', '1970-01-01', 'RIYAN', '', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 190, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:28:15', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (191, '240136', '1970-01-01', 'SADIYA', 'MIM', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 191, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:28:15', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (192, '240137', '1970-01-01', 'NAIMA AKTER', 'NAJNIN', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 192, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:28:15', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (193, '240138', '1970-01-01', 'SADIA', 'AKTER', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 193, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:28:16', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (194, '240139', '1970-01-01', 'SADEK', 'AHMED', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 194, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:28:16', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (195, '240140', '1970-01-01', 'SADIKUL', 'ISLAM', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 195, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:28:16', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (196, '240141', '1970-01-01', 'JANNATUL', '', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '5/11/2024 0:00', 196, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:28:16', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (197, '240142', '1970-01-01', 'HASIB', '', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 197, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:28:16', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (198, '240143', '1970-01-01', 'SHANTA', 'MONI', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 198, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:28:16', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (199, '240144', '1970-01-01', 'JAHIDUL', 'ISLAM', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 199, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:28:16', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (200, '240145', '1970-01-01', 'JAHID', 'HASAN', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 200, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:28:17', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (201, '240146', '1970-01-01', 'MORIOM', '', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 201, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:28:17', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (202, '240147', '1970-01-01', 'MARIA', '', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 202, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:28:17', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (203, '240148', '1970-01-01', 'ROJA', '', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 203, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:28:17', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (204, '240149', '1970-01-01', 'JIBON', '', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 204, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:28:17', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (205, '240150', '1970-01-01', 'NAYON', '', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 205, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:28:17', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (206, '240151', '1970-01-01', 'AFRIN', 'NAHAR', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 206, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:30:01', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (207, '240152', '1970-01-01', 'NUSRAT', 'JAHAN', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 207, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:30:01', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (208, '240153', '1970-01-01', 'AIRAH AHMED', 'ABRI', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 208, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:30:02', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (209, '240154', '1970-01-01', 'JANNATI AKTER', 'NUHA', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 209, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:30:02', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (210, '240155', '1970-01-01', 'MORIOM AKTER', 'MARIA', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '5/11/2024 0:00', 210, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:30:02', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (211, '240156', '1970-01-01', 'SADMAN', 'AHMED', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 211, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:30:02', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (212, '240157', '1970-01-01', 'RIMI', '', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 212, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:30:02', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (213, '240158', '1970-01-01', 'RUHAD', 'ISLAM', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 213, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:30:02', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (214, '240159', '1970-01-01', 'ABID', 'MAHMUD', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 214, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:30:03', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (215, '240160', '1970-01-01', 'SORNA AKTER', 'SADIA', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 215, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:30:03', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (216, '240161', '1970-01-01', 'MUSTAFIZUR RAHMAN', 'TAMIM', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 216, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:30:03', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (217, '240162', '1970-01-01', 'KAWSER UDDIN', 'LAM', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 217, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:30:03', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (218, '240163', '1970-01-01', 'HAFSA AKTER', 'PKHI', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 218, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:30:03', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (219, '240164', '1970-01-01', 'ROMAN', 'ISLAM', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 219, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:30:04', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (220, '240165', '1970-01-01', 'HABIB', '', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 220, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:30:04', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (221, '240166', '1970-01-01', 'SOMAYA', '', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 221, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:30:04', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (222, '240167', '1970-01-01', 'SADID AHMED', 'EBAD', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 222, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:30:04', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (223, '240168', '1970-01-01', 'JANNATUL', 'FERDOUS', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 223, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:30:04', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (224, '240169', '1970-01-01', 'LISA MONI', '', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 224, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:31:46', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (225, '240170', '1970-01-01', 'SABBAHAT', 'NASHRAH', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 225, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:31:46', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (226, '240171', '1970-01-01', 'FUAD AL', 'MUSTAKIM', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '9/17/2024 0:00', 226, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:31:47', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (227, '240172', '1970-01-01', 'MOKTA', 'AKTER', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 227, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:31:47', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (228, '240173', '1970-01-01', 'MD. TAHMIDUL ISLAM', 'MISHON', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 228, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:31:47', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (229, '240174', '1970-01-01', 'JOBAYER', 'HOSSEN', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 229, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:31:47', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (230, '240175', '1970-01-01', 'MASHRUFA AKTER', 'TANIA', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 230, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:31:47', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (231, '240176', '1970-01-01', 'MINHAZUR RAHMAN', 'JUNAYED', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 231, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:31:47', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (232, '240177', '1970-01-01', 'LAMIA', 'JAMAN', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 232, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:31:47', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (233, '240178', '1970-01-01', 'ALI', 'AZGAR', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 233, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:31:47', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (234, '240179', '1970-01-01', 'JANNATUL FERDOUS', 'LAMIA', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 234, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:31:48', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (235, '240180', '1970-01-01', 'AKHI ASMAN', 'MEGHLA', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 235, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:31:48', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (236, '240181', '1970-01-01', 'SURIYA', '', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 236, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:31:48', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (237, '240182', '1970-01-01', 'SELIM', '', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 237, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:31:48', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (238, '240183', '1970-01-01', 'SHAKIB', '', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 238, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:31:48', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (239, '240184', '1970-01-01', 'MAHIRA', 'ISHAL', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', 'Vangnahati, Sreepur, Gazipur.', '', '', '', 0, '', 239, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:33:06', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (240, '240185', '1970-01-01', 'SHUVA SULTANA', 'SUMI', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 240, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:33:06', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (241, '240186', '1970-01-01', 'NUSRAT JAHAN', 'MORIOM', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '9/26/2024 0:00', 241, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:33:06', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (242, '240187', '1970-01-01', 'TAHMINA SULTANA', 'JERIN', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '9/26/2024 0:00', 242, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:33:06', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (243, '240188', '1970-01-01', 'ALIFA AKTER', 'CHOITY', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '9/26/2024 0:00', 243, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:33:06', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (244, '240189', '1970-01-01', 'RAKIBUL', 'ISLAM', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '5/11/2024 0:00', 244, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:33:06', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (245, '240190', '1970-01-01', 'RIYA AKTER', 'TABASSSUM', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 245, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:33:07', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (246, '240191', '1970-01-01', 'MINHAJ', '', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 246, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:33:07', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (247, '240192', '1970-01-01', 'TAHMINA SULTANA', 'AHONA', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 247, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:33:07', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (248, '240193', '1970-01-01', 'MASUM', 'AHMED', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 248, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:33:07', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (249, '240194', '1970-01-01', 'MD. MUSHA', 'MUKTAR', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 249, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:33:07', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (250, '240195', '1970-01-01', 'RAMANA', '', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 250, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:33:07', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (251, '240196', '1970-01-01', 'AYSHA SIDDIKA', 'BABLI', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 251, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:34:24', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (252, '240197', '1970-01-01', 'MD.', 'RAKIBUL', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 252, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:34:25', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (253, '240198', '1970-01-01', 'YEAMIN', '', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 253, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:34:25', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (254, '240199', '1970-01-01', 'PRIONTI', '', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '5/11/2024 0:00', 254, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:34:25', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (255, '240200', '1970-01-01', 'HIMA MONI', '', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '9/17/2024 0:00', 255, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:34:25', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (256, '240201', '1970-01-01', 'TANIA', '', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 256, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:34:25', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (257, '240202', '1970-01-01', 'ROTON', '', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 257, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:34:25', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (258, '240203', '1970-01-01', 'MASUM', '', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 258, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:34:25', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (259, '240204', '1970-01-01', 'FARJANA', 'AKTER', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 259, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:35:33', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (260, '240205', '1970-01-01', 'AHNAF ISLAM', 'ANAS', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 260, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:35:33', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (261, '240206', '1970-01-01', 'SINTHIYA AKTER', 'TANJILA', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 261, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:35:33', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (262, '240207', '1970-01-01', 'JANNATUL', 'RATNA', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 262, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:35:34', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (263, '240208', '1970-01-01', 'JONAKI', '', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 263, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:35:34', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (264, '240209', '1970-01-01', 'MARIYA', 'MAHI', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 264, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:35:34', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (265, '240210', '1970-01-01', 'OMOR', 'FARUK', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 265, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:35:34', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (266, '240211', '1970-01-01', 'SAMIUL', 'BASHIR', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 266, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:35:34', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (267, '240212', '1970-01-01', 'MS. RAFIYA', 'KHATON', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 267, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:35:34', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (268, '240213', '1970-01-01', 'MAHMUDA', 'AKTER', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 268, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:35:34', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (269, '240214', '1970-01-01', 'RAKIBUL', 'ISLAM', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '5/11/2024 0:00', 269, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:35:34', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (270, '240215', '1970-01-01', 'SOHAN', '', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 270, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:35:35', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (271, '240216', '1970-01-01', 'MORIOM', 'AKTER', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 271, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:35:35', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (272, '240217', '1970-01-01', 'YEASIN', '', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 272, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:35:35', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (273, '240218', '1970-01-01', 'SAMIYA', '', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 273, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:35:35', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (274, '240219', '1970-01-01', 'ISTIAK', 'ISLAM', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 274, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:35:35', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (275, '240220', '1970-01-01', 'SHAHADAT HOSEN', 'EDUL', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '5/11/2024 0:00', 275, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:35:35', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (276, '240221', '1970-01-01', 'MONIRA AKTER', 'MISHU', 'female', '1970-01-01', 'ISLAM', NULL, '', NULL, '', '', '', NULL, '', 2, NULL, 276, 0, 0, 0, 0, '{\"school_name\":\"\",\"qualification\":\"\",\"remarks\":\"\"}', '046a5d4f85384ec987747f05cdd31854.jpg', '2024-12-27 17:37:15', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (277, '240222', '1970-01-01', 'MS. ESHITA', 'KHATUN', 'female', '1970-01-01', 'ISLAM', NULL, '', NULL, '', '', '', NULL, '', 2, NULL, 277, 0, 0, 0, 0, '{\"school_name\":\"\",\"qualification\":\"\",\"remarks\":\"\"}', '518ca4f11751e95afaa98267fa3be584.jpg', '2024-12-27 17:37:15', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (278, '240223', '1970-01-01', 'SADYA AKTER', 'SIMI', 'female', '1970-01-01', 'ISLAM', NULL, '', NULL, '', '', '', NULL, '', 2, NULL, 278, 0, 0, 0, 0, '{\"school_name\":\"\",\"qualification\":\"\",\"remarks\":\"\"}', '8b3b2d584d0a80a2c19affe773b5a56b.jpg', '2024-12-27 17:37:15', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (279, '240224', '1970-01-01', 'JAHID', 'HASAN', 'male', '1970-01-01', 'ISLAM', NULL, '', NULL, '', '', '', NULL, '', 2, NULL, 279, 0, 0, 0, 0, '{\"school_name\":\"\",\"qualification\":\"\",\"remarks\":\"\"}', '68e5aaa2dc236c3befe08aa09b1703e2.jpg', '2024-12-27 17:37:15', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (280, '240225', '1970-01-01', 'JAKIR', 'HOSSEN', 'male', '1970-01-01', 'ISLAM', NULL, '', NULL, '', '', '', NULL, '', 2, NULL, 280, 0, 0, 0, 0, '{\"school_name\":\"\",\"qualification\":\"\",\"remarks\":\"\"}', '7c7b6ab1649f09b88078f60091f52e69.jpg', '2024-12-27 17:37:15', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (281, '240226', '1970-01-01', 'UTTAM', 'BISHWAS', 'male', '1970-01-01', 'HINDU', NULL, '', NULL, '', '', '', NULL, '', 2, NULL, 281, 0, 0, 0, 0, '{\"school_name\":\"\",\"qualification\":\"\",\"remarks\":\"\"}', '7fd1ca98401a7afd788b007bcf5954f1.jpg', '2024-12-27 17:37:15', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (282, '240227', '1970-01-01', 'TANJILA', 'AKTER', 'female', '1970-01-01', 'ISLAM', NULL, '', NULL, '', '', '', NULL, '', 2, NULL, 282, 0, 0, 0, 0, '{\"school_name\":\"\",\"qualification\":\"\",\"remarks\":\"\"}', '1fa15d9e45053dbcd5366d4a257d8470.jpg', '2024-12-27 17:37:15', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (283, '240228', '1970-01-01', 'SANJIDA', 'AKTER', 'female', '1970-01-01', 'ISLAM', NULL, '', NULL, '', '', '', NULL, '', 2, NULL, 283, 0, 0, 0, 0, '{\"school_name\":\"\",\"qualification\":\"\",\"remarks\":\"\"}', 'ebe4e9759f30f9b0529d7e73c7b0239c.jpg', '2024-12-27 17:37:15', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (284, '240229', '1970-01-01', 'SHARIN SHAMIM', 'MAYSHA', 'female', '1970-01-01', 'ISLAM', NULL, '', NULL, '', '', '', NULL, '', 2, NULL, 284, 0, 0, 0, 0, '{\"school_name\":\"\",\"qualification\":\"\",\"remarks\":\"\"}', 'ebef6ab1dd4b7774fdfdb9b49996c021.jpg', '2024-12-27 17:40:00', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (285, '240230', '1970-01-01', 'TAHSIBA TANHA', 'TONU', 'female', '1970-01-01', 'ISLAM', NULL, '', NULL, '', '', '', NULL, '', 2, NULL, 285, 0, 0, 0, 0, '{\"school_name\":\"\",\"qualification\":\"\",\"remarks\":\"\"}', 'c289eb1cd68addf5594717c44e794a04.jpg', '2024-12-27 17:40:00', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (286, '240231', '1970-01-01', 'MD. TANVIR', 'AHMED', 'male', '1970-01-01', 'ISLAM', NULL, '', NULL, '', '', '', NULL, '', 2, NULL, 286, 0, 0, 0, 0, '{\"school_name\":\"\",\"qualification\":\"\",\"remarks\":\"\"}', 'f08e1305ee0c6d1f9ac85e9729e78509.jpg', '2024-12-27 17:40:00', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (287, '240232', '1970-01-01', 'SUMAIYA TABASSUM', 'SNEHA', 'female', '1970-01-01', 'ISLAM', NULL, '', NULL, '', '', '', NULL, '', 2, NULL, 287, 0, 0, 0, 0, '{\"school_name\":\"\",\"qualification\":\"\",\"remarks\":\"\"}', 'c42d8e6f186f347f57b780e417e0dee1.jpg', '2024-12-27 17:40:01', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (288, '240233', '1970-01-01', 'MD. ABU', 'BAKKAR', 'male', '1970-01-01', 'ISLAM', NULL, '', NULL, '', '', '', NULL, '', 2, NULL, 288, 0, 0, 0, 0, '{\"school_name\":\"\",\"qualification\":\"\",\"remarks\":\"\"}', '69b156babae06205e5c4d03fd55f46d5.jpg', '2024-12-27 17:40:01', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (289, '240234', '1970-01-01', 'NADIA', 'AKTER', 'female', '1970-01-01', 'ISLAM', NULL, '', NULL, '', '', '', NULL, '', 2, NULL, 289, 0, 0, 0, 0, '{\"school_name\":\"\",\"qualification\":\"\",\"remarks\":\"\"}', 'b7dc9e539197198cddd27bfbcda54136.jpg', '2024-12-27 17:40:01', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (290, '240235', '1970-01-01', 'HOSSAIN MOHAMMAD', 'SHELIM', 'male', '1970-01-01', 'ISLAM', NULL, '', NULL, '', '', '', NULL, '', 2, NULL, 290, 0, 0, 0, 0, '{\"school_name\":\"\",\"qualification\":\"\",\"remarks\":\"\"}', 'fd6314fae91be04d604da44804a18b08.jpg', '2024-12-27 17:40:01', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (291, '240236', '1970-01-01', 'RAKIBUL', 'HASAN', 'male', '1970-01-01', 'ISLAM', NULL, '', NULL, '', '', '', NULL, '', 2, NULL, 291, 0, 0, 0, 0, '{\"school_name\":\"\",\"qualification\":\"\",\"remarks\":\"\"}', '983a82d6735b96b067a9f4f438288bc8.jpg', '2024-12-27 17:40:01', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (292, '240237', '1970-01-01', 'SHAJ HOSSEN', 'KHAN', 'male', '1970-01-01', 'ISLAM', NULL, '', NULL, '', '', '', NULL, '', 2, NULL, 292, 0, 0, 0, 0, '{\"school_name\":\"\",\"qualification\":\"\",\"remarks\":\"\"}', '7add1f39b79385d391da9dd769cb9226.jpg', '2024-12-27 17:40:01', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (293, '240238', '1970-01-01', 'SOHAN HOSSEN', 'KHAN', 'male', '1970-01-01', 'ISLAM', NULL, '', NULL, '', '', '', NULL, '', 2, NULL, 293, 0, 0, 0, 0, '{\"school_name\":\"\",\"qualification\":\"\",\"remarks\":\"\"}', 'd80c98669c356844313ab22db9644fef.jpg', '2024-12-27 17:40:01', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (294, '240239', '1970-01-01', 'ABULLAH AL', 'RIFAT', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 294, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:40:01', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (295, '240240', '1970-01-01', 'ATIK HASAN', 'EMON', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 295, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:40:02', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (296, '240241', '1970-01-01', 'ASHIFA', 'AKTER', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 296, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:40:02', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (297, '240242', '1970-01-01', 'ATIKA AMIN', 'NEYOTI', 'female', '', 'ISLAM', NULL, '', NULL, '', '', '', NULL, '', 2, NULL, 287, 0, 0, 0, 0, '{\"school_name\":\"\",\"qualification\":\"\",\"remarks\":\"\"}', '353d552a45b37bec28d08a4d6160d73d.png', '2024-12-27 17:49:35', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (298, '240243', '1970-01-01', 'ANISHA', 'ATKER', 'female', '1970-01-01', 'ISLAM', NULL, '', NULL, '', '', '', NULL, '', 2, NULL, 286, 0, 0, 0, 0, '{\"school_name\":\"\",\"qualification\":\"\",\"remarks\":\"\"}', 'eb2a83a2c91cde392bd9e950e89f854d.png', '2024-12-27 17:49:35', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (299, '240244', '1970-01-01', 'ADIBA', 'AFNIN', 'female', '1970-01-01', 'ISLAM', NULL, '', NULL, '', '', '', NULL, '', 2, NULL, 299, 0, 0, 0, 0, '{\"school_name\":\"\",\"qualification\":\"\",\"remarks\":\"\"}', '8e28df5861d33b01bdedab990cb89a1e.png', '2024-12-27 17:49:35', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (300, '240245', '1970-01-01', 'JAHIDUL HASAN', 'IMRAN', 'male', '1970-01-01', 'ISLAM', NULL, '', NULL, '', '', '', NULL, '', 2, NULL, 300, 0, 0, 0, 0, '{\"school_name\":\"\",\"qualification\":\"\",\"remarks\":\"\"}', '644ffaea51ab66f071a686e7b47b5643.png', '2024-12-27 17:49:35', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (301, '240246', '1970-01-01', 'PARVEZ', 'MIA', 'MALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '12/4/2024 0:00', 301, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:51:08', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (302, '240247', '1970-01-01', 'PRIANKA', 'BISHWAS', 'FEMALE', '1970-01-01', 'ISLAM', '', '', '', '', '', '', '', '', 0, '', 302, 0, 0, 0, 0, NULL, 'defualt.png', '2024-12-27 17:52:18', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (303, '2004048', '2025-01-02', 'Md Abu', 'Sayed', 'male', '1995-08-17', 'Islam', NULL, 'O+', NULL, '', '', '', NULL, '01775457009', 1, NULL, 303, 0, 0, 0, 0, '{\"school_name\":\"Nayar Hat High School\",\"qualification\":\"SSC\",\"remarks\":\"Good\"}', 'defualt.png', '2025-01-02 23:26:28', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (304, '2004049', '2025-01-02', 'Md Nayeem', 'Hossain', 'male', '1995-07-17', 'Islam', NULL, 'O+', NULL, 'ffgffd', '', 'Dhaka', NULL, '01775457066', 1, NULL, 303, 0, 0, 0, 0, '{\"school_name\":\"\",\"qualification\":\"\",\"remarks\":\"\"}', 'defualt.png', '2025-01-02 23:29:00', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (305, '2004050', '2025-01-02', 'MD MIJANUR', 'ISLAM', 'male', '1925-01-28', 'Islam', NULL, 'O+', NULL, 'ffgffd', '', 'Dhaka', NULL, '01775457019', 1, NULL, 303, 0, 0, 0, 0, '{\"school_name\":\"\",\"qualification\":\"\",\"remarks\":\"\"}', 'defualt.png', '2025-01-02 23:39:39', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (306, '2004051', '2025-01-02', 'Md mojnu', 'ISLAM', 'male', '1923-07-10', 'Islam', NULL, 'B-', NULL, '35/3/1', '', 'Dhaka', NULL, '01911111483', 1, NULL, 303, 0, 0, 0, 0, '{\"school_name\":\"\",\"qualification\":\"\",\"remarks\":\"\"}', 'defualt.png', '2025-01-02 23:43:24', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (307, '2004052', '2025-01-02', 'Md Raju', 'ISLAM', 'male', '1923-06-11', 'Islam', NULL, 'A-', NULL, '35/3/1', '', 'Dhaka', NULL, '01911111484', 1, NULL, 303, 0, 0, 0, 0, '{\"school_name\":\"\",\"qualification\":\"\",\"remarks\":\"\"}', 'defualt.png', '2025-01-02 23:47:09', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (308, '2000406', '2025-01-02', 'Md mahadi', 'hassan', 'male', '1923-07-09', 'Islam', NULL, 'B+', NULL, 'ffgffd', '', 'Dhaka', NULL, '01767562870', 1, NULL, 303, 0, 0, 0, 0, '{\"school_name\":\"\",\"qualification\":\"\",\"remarks\":\"\"}', 'defualt.png', '2025-01-02 23:51:45', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (309, '2000407', '2025-01-02', 'Md Alamin', 'ahmed', 'male', '1924-03-04', 'Islam', NULL, 'B-', NULL, '35/3/1', '', 'Dhaka', NULL, '01307309914', 1, NULL, 303, 0, 0, 0, 0, '{\"school_name\":\"\",\"qualification\":\"\",\"remarks\":\"\"}', 'defualt.png', '2025-01-02 23:55:50', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (310, '2000408', '2025-01-02', 'Md Rabiul', 'lslam', 'male', '1923-03-04', 'Islam', NULL, 'B-', NULL, '35/3/1', '', 'Dhaka', NULL, '017309915', 1, NULL, 303, 0, 0, 0, 0, '{\"school_name\":\"\",\"qualification\":\"\",\"remarks\":\"\"}', 'defualt.png', '2025-01-02 23:59:31', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (311, '2000409', '2025-01-02', 'Md  Nabim', 'ISLAM', 'male', '1924-03-04', 'Islam', NULL, 'B+', NULL, '35/3/1', '', 'Dhaka', NULL, '01307309916', 1, NULL, 303, 0, 0, 0, 0, '{\"school_name\":\"\",\"qualification\":\"\",\"remarks\":\"\"}', 'defualt.png', '2025-01-03 00:02:45', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (312, '2000410', '2025-01-03', 'Md Shakil', 'ahmed', 'male', '1923-07-16', 'Islam', NULL, 'B+', NULL, '35/3/1', '', 'Dhaka', NULL, '01307309917', 1, NULL, 303, 0, 0, 0, 0, '{\"school_name\":\"\",\"qualification\":\"\",\"remarks\":\"\"}', 'defualt.png', '2025-01-03 00:05:36', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (313, '2000411', '2025-01-03', 'MD Mamun', 'Hassan', 'male', '1924-03-03', 'Islam', NULL, 'A+', NULL, 'Holding: 13/2033-02,Lotifpur Moddhopara,Bogura', '', 'Dhaka', NULL, '01954578011', 1, NULL, 303, 0, 0, 0, 0, '{\"school_name\":\"\",\"qualification\":\"\",\"remarks\":\"\"}', 'defualt.png', '2025-01-03 00:13:00', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (314, '2000412', '2025-01-03', 'MD Ariful', 'Hassan', 'male', '1924-01-28', 'Islam', NULL, 'A+', NULL, 'Holding: 13/2033-02,Lotifpur Moddhopara,Bogura', '', 'Dhaka', NULL, '0195457914', 1, NULL, 303, 0, 0, 0, 0, '{\"school_name\":\"\",\"qualification\":\"\",\"remarks\":\"\"}', 'defualt.png', '2025-01-03 00:17:00', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (315, '2000042', '2025-01-03', 'MD Raihan', 'ahmed', 'male', '1924-02-04', 'Islam', NULL, 'B+', NULL, '35/3/1', '', 'Dhaka', NULL, '01767522870', 1, NULL, 303, 0, 0, 0, 0, '{\"school_name\":\"\",\"qualification\":\"\",\"remarks\":\"\"}', 'defualt.png', '2025-01-03 00:21:14', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (316, '2000005', '2025-01-03', 'MD  Sagor', 'ahmed', 'male', '1924-01-27', 'Islam', NULL, 'A-', NULL, 'Holding: 13/2033-02,Lotifpur Moddhopara,Bogura', '', 'Dhaka', NULL, '01954578070', 1, NULL, 303, 0, 0, 0, 0, '{\"school_name\":\"\",\"qualification\":\"\",\"remarks\":\"\"}', 'defualt.png', '2025-01-03 00:24:37', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (317, '2000006', '2025-01-03', 'MD Riaj', 'Khan', 'male', '2019-12-30', 'Islam', NULL, 'A-', NULL, 'Holding: 13/2033-02,Lotifpur Moddhopara,Bogura', '', 'Dhaka', NULL, '01954578060', 1, NULL, 303, 0, 0, 0, 0, '{\"school_name\":\"\",\"qualification\":\"\",\"remarks\":\"\"}', 'defualt.png', '2025-01-03 00:27:12', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (318, '2000007', '2025-01-03', 'MD mamunur', 'ISLAM', 'male', '2019-12-31', 'Islam', NULL, 'A+', NULL, '35/3/1', '', 'Dhaka', NULL, '01767852870', 1, NULL, 303, 0, 0, 0, 0, '{\"school_name\":\"\",\"qualification\":\"\",\"remarks\":\"\"}', 'defualt.png', '2025-01-03 00:29:44', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (319, '2000008', '2025-01-03', 'MD Azgar', 'Hossain', 'male', '2019-12-31', 'Islam', NULL, 'B-', NULL, '35/3/1', '', 'Dhaka', NULL, '01911111493', 1, NULL, 303, 0, 0, 0, 0, '{\"school_name\":\"\",\"qualification\":\"\",\"remarks\":\"\"}', 'defualt.png', '2025-01-03 00:32:34', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (320, '2000009', '2025-01-03', 'MD Saiful', 'ISLAM', 'male', '2018-12-31', 'Islam', NULL, 'A+', NULL, 'ffgffd', '', 'Dhaka', NULL, '01775457456', 1, NULL, 303, 0, 0, 0, 0, '{\"school_name\":\"\",\"qualification\":\"\",\"remarks\":\"\"}', 'defualt.png', '2025-01-03 00:35:16', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (321, '2000010', '2025-01-03', 'MDFaruk', 'ISLAM', 'male', '2018-12-31', 'Islam', NULL, 'A-', NULL, 'Holding: 13/2033-02,Lotifpur Moddhopara,Bogura', '', 'Dhaka', NULL, '01954572635', 1, NULL, 303, 0, 0, 0, 0, '{\"school_name\":\"\",\"qualification\":\"\",\"remarks\":\"\"}', 'defualt.png', '2025-01-03 00:37:25', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (322, '2000011', '2025-01-03', 'MD  Alamin', 'Hossain', 'male', '2018-12-31', 'Islam', NULL, 'B-', NULL, 'Holding: 13/2033-02,Lotifpur Moddhopara,Bogura', '', 'Dhaka', NULL, '01954578453', 1, NULL, 303, 0, 0, 0, 0, '{\"school_name\":\"\",\"qualification\":\"\",\"remarks\":\"\"}', 'defualt.png', '2025-01-03 00:40:14', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (323, '2000012', '2025-01-03', 'MD Tanvir', 'ISLAM', 'male', '2019-01-07', 'Islam', NULL, 'B-', NULL, 'ffgffd', '', 'Dhaka', NULL, '01775456789', 1, NULL, 303, 0, 0, 0, 0, '{\"school_name\":\"\",\"qualification\":\"\",\"remarks\":\"\"}', 'defualt.png', '2025-01-03 00:43:28', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (324, '2000002', '2025-01-03', 'MD Sakib', 'ISLAM', 'male', '', 'Islam', NULL, 'A-', NULL, 'Holding: 13/2033-02,Lotifpur Moddhopara,Bogura', '', 'Dhaka', NULL, '01954578078', 1, NULL, 303, 0, 0, 0, 0, '{\"school_name\":\"\",\"qualification\":\"\",\"remarks\":\"\"}', 'defualt.png', '2025-01-03 00:45:47', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (325, '2000001', '2025-01-03', 'MD Alamgir', 'Hossain', 'male', '2019-06-04', 'Islam', NULL, 'B+', NULL, '35/3/1', '', 'Dhaka', NULL, '01911111455', 1, NULL, 303, 0, 0, 0, 0, '{\"school_name\":\"\",\"qualification\":\"\",\"remarks\":\"\"}', 'defualt.png', '2025-01-03 00:48:17', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (326, '125684', '2025-01-03', 'MD Maidul', 'ISLAM', 'male', '2018-12-31', 'Islam', NULL, 'B+', NULL, 'ffgffd', '', 'Dhaka', NULL, '01911111483', 1, NULL, 303, 0, 0, 0, 0, '{\"school_name\":\"\",\"qualification\":\"\",\"remarks\":\"\"}', 'defualt.png', '2025-01-03 00:54:34', NULL);
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `route_id`, `vehicle_id`, `hostel_id`, `room_id`, `previous_details`, `photo`, `created_at`, `updated_at`) VALUES (327, '2015685', '2025-01-03', 'MD Abdur', 'ISLAM', 'male', '2018-12-31', 'Islam', NULL, 'B+', NULL, '35/3/1', '', 'Dhaka', NULL, '01911114679', 1, NULL, 303, 0, 0, 0, 0, '{\"school_name\":\"\",\"qualification\":\"\",\"remarks\":\"\"}', 'defualt.png', '2025-01-03 00:57:16', NULL);


#
# TABLE STRUCTURE FOR: student_admission_fields
#

DROP TABLE IF EXISTS `student_admission_fields`;

CREATE TABLE `student_admission_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fields_id` int(11) NOT NULL,
  `status` tinyint(4) NOT NULL DEFAULT 1,
  `required` tinyint(4) NOT NULL DEFAULT 0,
  `branch_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `student_admission_fields` (`id`, `fields_id`, `status`, `required`, `branch_id`) VALUES (1, 1, 1, 0, 1);
INSERT INTO `student_admission_fields` (`id`, `fields_id`, `status`, `required`, `branch_id`) VALUES (2, 2, 1, 1, 1);
INSERT INTO `student_admission_fields` (`id`, `fields_id`, `status`, `required`, `branch_id`) VALUES (3, 3, 1, 0, 1);
INSERT INTO `student_admission_fields` (`id`, `fields_id`, `status`, `required`, `branch_id`) VALUES (4, 4, 1, 0, 1);
INSERT INTO `student_admission_fields` (`id`, `fields_id`, `status`, `required`, `branch_id`) VALUES (5, 5, 1, 1, 1);
INSERT INTO `student_admission_fields` (`id`, `fields_id`, `status`, `required`, `branch_id`) VALUES (6, 6, 1, 1, 1);
INSERT INTO `student_admission_fields` (`id`, `fields_id`, `status`, `required`, `branch_id`) VALUES (7, 8, 1, 0, 1);
INSERT INTO `student_admission_fields` (`id`, `fields_id`, `status`, `required`, `branch_id`) VALUES (8, 9, 0, 0, 1);
INSERT INTO `student_admission_fields` (`id`, `fields_id`, `status`, `required`, `branch_id`) VALUES (9, 10, 1, 0, 1);
INSERT INTO `student_admission_fields` (`id`, `fields_id`, `status`, `required`, `branch_id`) VALUES (10, 11, 0, 0, 1);
INSERT INTO `student_admission_fields` (`id`, `fields_id`, `status`, `required`, `branch_id`) VALUES (11, 12, 1, 0, 1);
INSERT INTO `student_admission_fields` (`id`, `fields_id`, `status`, `required`, `branch_id`) VALUES (12, 13, 1, 0, 1);
INSERT INTO `student_admission_fields` (`id`, `fields_id`, `status`, `required`, `branch_id`) VALUES (13, 14, 1, 0, 1);
INSERT INTO `student_admission_fields` (`id`, `fields_id`, `status`, `required`, `branch_id`) VALUES (14, 15, 0, 0, 1);
INSERT INTO `student_admission_fields` (`id`, `fields_id`, `status`, `required`, `branch_id`) VALUES (15, 16, 0, 0, 1);
INSERT INTO `student_admission_fields` (`id`, `fields_id`, `status`, `required`, `branch_id`) VALUES (16, 17, 1, 0, 1);
INSERT INTO `student_admission_fields` (`id`, `fields_id`, `status`, `required`, `branch_id`) VALUES (17, 18, 1, 0, 1);
INSERT INTO `student_admission_fields` (`id`, `fields_id`, `status`, `required`, `branch_id`) VALUES (18, 19, 1, 0, 1);
INSERT INTO `student_admission_fields` (`id`, `fields_id`, `status`, `required`, `branch_id`) VALUES (19, 20, 1, 1, 1);
INSERT INTO `student_admission_fields` (`id`, `fields_id`, `status`, `required`, `branch_id`) VALUES (20, 21, 1, 0, 1);
INSERT INTO `student_admission_fields` (`id`, `fields_id`, `status`, `required`, `branch_id`) VALUES (21, 22, 1, 0, 1);
INSERT INTO `student_admission_fields` (`id`, `fields_id`, `status`, `required`, `branch_id`) VALUES (22, 23, 1, 0, 1);
INSERT INTO `student_admission_fields` (`id`, `fields_id`, `status`, `required`, `branch_id`) VALUES (23, 24, 1, 0, 1);
INSERT INTO `student_admission_fields` (`id`, `fields_id`, `status`, `required`, `branch_id`) VALUES (24, 25, 1, 0, 1);
INSERT INTO `student_admission_fields` (`id`, `fields_id`, `status`, `required`, `branch_id`) VALUES (25, 26, 1, 0, 1);
INSERT INTO `student_admission_fields` (`id`, `fields_id`, `status`, `required`, `branch_id`) VALUES (26, 27, 1, 0, 1);
INSERT INTO `student_admission_fields` (`id`, `fields_id`, `status`, `required`, `branch_id`) VALUES (27, 28, 1, 1, 1);
INSERT INTO `student_admission_fields` (`id`, `fields_id`, `status`, `required`, `branch_id`) VALUES (28, 29, 1, 0, 1);
INSERT INTO `student_admission_fields` (`id`, `fields_id`, `status`, `required`, `branch_id`) VALUES (29, 30, 1, 0, 1);
INSERT INTO `student_admission_fields` (`id`, `fields_id`, `status`, `required`, `branch_id`) VALUES (30, 32, 0, 0, 1);
INSERT INTO `student_admission_fields` (`id`, `fields_id`, `status`, `required`, `branch_id`) VALUES (31, 33, 0, 0, 1);


#
# TABLE STRUCTURE FOR: student_attendance
#

DROP TABLE IF EXISTS `student_attendance`;

CREATE TABLE `student_attendance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `enroll_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `status` varchar(4) DEFAULT NULL COMMENT 'P=Present, A=Absent, H=Holiday, L=Late',
  `remark` text DEFAULT NULL,
  `branch_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `student_attendance_rms_1` (`branch_id`),
  KEY `student_attendance_rms_2` (`enroll_id`),
  CONSTRAINT `student_attendance_rms_1` FOREIGN KEY (`branch_id`) REFERENCES `branch` (`id`) ON DELETE CASCADE,
  CONSTRAINT `student_attendance_rms_2` FOREIGN KEY (`enroll_id`) REFERENCES `enroll` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: student_category
#

DROP TABLE IF EXISTS `student_category`;

CREATE TABLE `student_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `branch_id` int(11) NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `student_category` (`id`, `branch_id`, `name`) VALUES (1, 1, 'Normal');
INSERT INTO `student_category` (`id`, `branch_id`, `name`) VALUES (2, 1, 'Special');


#
# TABLE STRUCTURE FOR: student_documents
#

DROP TABLE IF EXISTS `student_documents`;

CREATE TABLE `student_documents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `type` varchar(100) NOT NULL,
  `remarks` text NOT NULL,
  `file_name` varchar(255) NOT NULL,
  `enc_name` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: student_fields
#

DROP TABLE IF EXISTS `student_fields`;

CREATE TABLE `student_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `prefix` varchar(255) NOT NULL,
  `default_status` tinyint(1) NOT NULL DEFAULT 1,
  `default_required` tinyint(4) NOT NULL DEFAULT 1,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `student_fields` (`id`, `prefix`, `default_status`, `default_required`, `created_at`) VALUES (1, 'roll', 1, 0, '2022-04-25 20:27:04');
INSERT INTO `student_fields` (`id`, `prefix`, `default_status`, `default_required`, `created_at`) VALUES (2, 'last_name', 1, 1, '2022-04-25 20:27:04');
INSERT INTO `student_fields` (`id`, `prefix`, `default_status`, `default_required`, `created_at`) VALUES (3, 'gender', 1, 0, '2022-04-25 20:27:04');
INSERT INTO `student_fields` (`id`, `prefix`, `default_status`, `default_required`, `created_at`) VALUES (4, 'birthday', 1, 0, '2022-04-25 20:27:04');
INSERT INTO `student_fields` (`id`, `prefix`, `default_status`, `default_required`, `created_at`) VALUES (5, 'admission_date', 1, 1, '2022-04-25 20:27:04');
INSERT INTO `student_fields` (`id`, `prefix`, `default_status`, `default_required`, `created_at`) VALUES (6, 'category', 1, 1, '2022-04-25 20:27:04');
INSERT INTO `student_fields` (`id`, `prefix`, `default_status`, `default_required`, `created_at`) VALUES (7, 'section', 1, 1, '2022-04-25 20:27:04');
INSERT INTO `student_fields` (`id`, `prefix`, `default_status`, `de